/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.duw;

import java.util.ArrayList;
import java.util.Arrays;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.AddDuwBoardSlotCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.duw.InterPiuLinkCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.SyncRefInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.RbsUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDeviceBoardRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCabinet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGpsSyncRef;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTimingUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTuSyncRef;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public class DuwRI
extends AbstractDeviceBoardRI {
    public static final String name = "DUW";
    private static final String WIZARD_SWALLOC_ROLE_DUW = "Main_DUW";
    private static final String WIZARD_REPERTOIRE_RBS_APC_MAIN1 = "RBS_APC_MAIN1";
    private static final String WIZARD_REPERTOIRE_RBS_DU_MAIN = "RBS_DU_Main";
    public static final String WIZARD_REPERTOIRE_REDUNDANCY = "CPP_Control_Common_Redundancy_R6K";
    private static final int PIUGROUP_NUMBER = 1;
    private static final boolean waitForAutoConfiguration = false;
    private final String ldn;
    private final InterPiuLinkCableRI interPiulink;
    private final boolean isRedundant;
    private BemMo[] tuSyncRefMOs;
    private BemMo[] gpsSyncRefMOs;
    private final boolean supportSystemAvailable;

    public DuwRI(Rbs rbs, int n, MoInstance moInstance, boolean bl, InterPiuLinkCableRI interPiuLinkCableRI, boolean bl2) throws BemException {
        this(rbs, n, moInstance, bl, null, interPiuLinkCableRI, bl2);
    }

    private DuwRI(Rbs rbs, int n, MoInstance moInstance, boolean bl, String string, InterPiuLinkCableRI interPiuLinkCableRI, boolean bl2) throws BemException {
        super(name, rbs, n, MimPlugInUnit.MOTYPENAME, moInstance, false);
        this.isRedundant = bl;
        SingleChildMoi singleChildMoi = new SingleChildMoi(this.slotMoi, MimPlugInUnit.MOTYPENAME, "1");
        this.ldn = singleChildMoi.getLdn();
        this.interPiulink = interPiuLinkCableRI;
        this.supportSystemAvailable = bl2;
        super.addRepertoiresToInstall(this.supportSystemAvailable ? WIZARD_REPERTOIRE_RBS_APC_MAIN1 : WIZARD_REPERTOIRE_RBS_DU_MAIN);
        super.setRoleForSwAllocation(WIZARD_SWALLOC_ROLE_DUW);
    }

    public void install(String string) throws BemException {
        String string2 = this.rbs.getRbsStep();
        if (string2.equals("STEP_CABINET")) {
            this.installCabinetWiz(string);
        }
        if (string2.equals("STEP_EXPANSION")) {
            this.installModifyWiz(string);
        }
        if (string.equals("EcPortCreationPhase")) {
            super.installEcPort(name);
        }
        if (string.equals("DeviceBoardParametersSettingPhase")) {
            if (!RbsInfo.isRbs6000Type(this.rbs.getRbsType())) {
                return;
            }
            this.setPositionRefForPlugInUnitMo();
        }
    }

    private void setPositionRefForPlugInUnitMo() throws BemException {
        if (!super.isExisting(this.ldn)) {
            return;
        }
        BemMo bemMo = this.rbs.getMoHandler().getMo(this.ldn);
        String string = this.getPositionRefLdnIfExisting(this.ldn);
        if (!super.isExisting(string)) {
            return;
        }
        BemMo bemMo2 = this.rbs.getMoHandler().getMo(string);
        if (bemMo != null && bemMo2 != null) {
            super.setAttribute(bemMo, "positionRef", (Object)bemMo2);
        }
    }

    private String getPositionRefLdnIfExisting(String string) throws BemException {
        String string2 = BemLdn.LDN_CABINET;
        if (string.equals(BemLdn.LDN_PRIMARY_DUW_PIU)) {
            string2 = BemLdn.LDN_CABINET;
        } else if (string.equals(BemLdn.LDN_SECONDARY_DUW_PIU)) {
            if (this.isAddDuwConfigured()) {
                String string3 = "AddDuwBoardcabinetNumber";
                IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string3);
                String string4 = integerParameter.getValue();
                string2 = BemLdn.LDN_EQUIPMENT + "," + MimCabinet.MOTYPENAME + "=" + string4;
            } else {
                BemMo bemMo;
                BemMo bemMo2;
                EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
                string2 = DuwUtil.isDualBoxConfiguration(this.rbs.getRbsType()) || DuwUtil.isCascadingSupport(this.rbs.getRbsType()) && RbsUtil.isRbsInSupCascadingMode(ecPortCustomerParameterProvider) ? BemLdn.LDN_CABINET2 : (DuwUtil.isCascadingSupport(this.rbs.getRbsType()) && !RbsUtil.isRbsInSupCascadingMode(ecPortCustomerParameterProvider) ? BemLdn.LDN_CABINET : (null == (bemMo2 = (BemMo)(bemMo = this.rbs.getMoHandler().getMo(string)).getAttribute("positionRef")) || null == bemMo2.getDN() || "".equals(bemMo2.getDN()) ? BemLdn.LDN_CABINET : bemMo2.getDN()));
            }
        }
        return string2;
    }

    private boolean isAddDuwConfigured() throws BemException {
        if (!this.rbs.isModifyWiz()) {
            return false;
        }
        String string = "AddDuwBoardcabinetNumber";
        if (!this.rbs.isParameterSupported(string)) {
            return false;
        }
        IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string);
        return null != integerParameter && !integerParameter.getValue().equals("##UNDEFINED");
    }

    private void installModifyWiz(String string) throws BemException {
        String string2;
        AddDuwBoardSlotCustomerParameter addDuwBoardSlotCustomerParameter;
        if (string.equals("DeviceBoardCreationPhase")) {
            String string3 = "AddDuwBoardslot";
            AddDuwBoardSlotCustomerParameter addDuwBoardSlotCustomerParameter2 = (AddDuwBoardSlotCustomerParameter)this.rbs.getCustomerParameterObject(string3);
            if (addDuwBoardSlotCustomerParameter2.getValue().equals("2")) {
                BemLog.log(7, "DUW install() adding repertoire FTC, startprograms and add slot to SW allocation For DUW if not already in CV" + this.ldn);
                super.addRepToSwAllocationIfExisting(WIZARD_REPERTOIRE_REDUNDANCY);
                super.addSlotToSwAllocation();
                if (super.isExisting(this.ldn)) {
                    BemLog.log(7, "DUW install() reconfigure Program prepare " + this.ldn);
                    super.reconfigureProgramPrepare();
                    super.startImmediateActionOnProgramMos();
                    if (this.ldn.equals(DuwUtil.getSecondaryDuwPiuLdn())) {
                        super.setPiuGroupNumberAttribute(new Integer(1));
                    }
                }
            }
        } else if (string.equals("UnlockPhase") && (addDuwBoardSlotCustomerParameter = (AddDuwBoardSlotCustomerParameter)this.rbs.getCustomerParameterObject(string2 = "AddDuwBoardslot")).getValue().equals("2") && super.isExisting(this.ldn)) {
            BemLog.log(7, "DUW install() Unlocking Pluginunit for DUW " + this.ldn);
            this.unlockDeviceBoard();
        }
    }

    private void installCabinetWiz(String string) throws BemException {
        if (string.equals("DeviceBoardCreationPhase")) {
            if (this.isRedundant && DuwUtil.hasDualDuws()) {
                BemLog.log(7, "DUW install() adding repertoire FTC, startprograms and add slot to SW allocation For DUW if not already in CV. LDN = " + this.ldn);
                super.addRepToSwAllocationIfExisting(WIZARD_REPERTOIRE_REDUNDANCY);
                BemLog.log(7, "DUW install() adding slot to SW allocation For DUW if not already in CV. LDN = " + this.ldn);
                super.addSlotToSwAllocation();
                if (this.ldn.equals(DuwUtil.getSecondaryDuwPiuLdn())) {
                    BemLog.log(7, "DUW Set piuGroupNumber 1 on slot=1 before setting PiuGroupNumber to 1 for DUW. LDN = " + this.ldn);
                    BemMo bemMo = this.getMo(DuwUtil.getPrimaryDuwPiuLdn());
                    if (this.isExisting(bemMo)) {
                        this.setAttribute(bemMo, "piuGroupNumber", (Object)new Integer(1));
                    }
                    BemLog.log(7, "DUW install() setting PiuGroupNumber to 1 for DUW. LDN = " + this.ldn);
                    super.setPiuGroupNumberAttribute(new Integer(1));
                }
                if (super.isExisting(this.ldn)) {
                    BemLog.log(7, "DUW install() reconfigure Program prepare LDN = " + this.ldn);
                    super.reconfigureProgramPrepare();
                    super.startImmediateActionOnProgramMos();
                    BemLog.log(7, "DUW install() Unlocking Pluginunit for DUW. LDN = " + this.ldn);
                    super.unlockDeviceBoard();
                }
            } else {
                BemLog.log(7, "DUW install() adding slot to SW allocation For DUW if not already in CV" + this.ldn);
                super.addSlotToSwAllocation();
                if (this.supportSystemAvailable) {
                    BemLog.log(7, "DUW install() adding Repertoire to SwAllocation" + this.ldn);
                    super.addRepToSwAllocationIfExisting(WIZARD_REPERTOIRE_RBS_APC_MAIN1);
                    String string2 = super.getPiuMoi().getLdn();
                    if (this.isExisting(string2)) {
                        BemMo bemMo = (BemMo)this.getAttribute(this.getMo(string2), "piuType");
                        super.installPiuTypeIfNeeded(bemMo, false);
                    }
                    if (super.isExisting(this.ldn)) {
                        BemLog.log(7, "DUW install() reconfigure Program prepare LDN = " + this.ldn);
                        super.reconfigureProgramPrepare();
                        super.startImmediateActionOnProgramMos();
                        BemLog.log(7, "DUW install() Unlocking Pluginunit for DUW. LDN = " + this.ldn);
                        super.unlockDeviceBoard();
                    }
                }
            }
        } else if (string.equals("BasicCVCleanupPhase") && this.ldn.equals(DuwUtil.getSecondaryDuwPiuLdn()) && !DuwUtil.hasDualDuws() && this.interPiulink.checkIfOperStateDisabled()) {
            BemLog.log(7, "DUW install() Remove slot 2 from SW alloc for DUW");
            super.removeSlotFromSwAllocation();
        }
    }

    public void uninstall(String string) throws BemException {
        String string2 = this.rbs.getRbsStep();
        if (string2.equals("STEP_CABINET")) {
            super.removeSlotFromSwAllocation();
        }
    }

    protected void unlock(String string) throws BemException {
        BemMo bemMo = super.getMo(this.ldn);
        if (bemMo.isExisting()) {
            BemLog.log(7, "DUW unlock() MO is existing " + this.ldn);
            Integer n = (Integer)super.getAttribute(bemMo, string);
            if (n != null && n == 0) {
                BemLog.log(7, "DUW unlock() MO was locked - unlock ");
                super.setAttribute(bemMo, string, (Object)new Integer(1));
            } else {
                BemLog.log(7, "DUW unlock() MO was already unlocked ");
            }
        }
    }

    protected SyncRefInfo[] getTuSynchRefs() throws BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BemMo[] bemMoArray = null;
        BemMo bemMo = super.getMo(this.getLdn());
        bemMoArray = super.getChildren(bemMo, 2, MimTuSyncRef.MOTYPENAME, "");
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                arrayList.add(bemMoArray[i].getDN());
            }
        }
        if (arrayList.size() == 0) {
            return new SyncRefInfo[0];
        }
        Object[] objectArray = null;
        objectArray = arrayList.toArray(new String[0]);
        Arrays.sort(objectArray);
        ArrayList<SyncRefInfo> arrayList2 = new ArrayList<SyncRefInfo>();
        int n = 6;
        for (int i = 0; i < objectArray.length; ++i) {
            SyncRefInfo syncRefInfo = new SyncRefInfo((String)objectArray[i], n, name);
            arrayList2.add(syncRefInfo);
        }
        return arrayList2.toArray(new SyncRefInfo[0]);
    }

    protected SyncRefInfo[] getGpsSynchRefs() throws BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BemMo[] bemMoArray = null;
        BemMo bemMo = super.getMo(this.getLdn());
        bemMoArray = super.getChildren(bemMo, 2, MimGpsSyncRef.MOTYPENAME, "");
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                arrayList.add(bemMoArray[i].getDN());
            }
        }
        if (arrayList.size() == 0) {
            return new SyncRefInfo[0];
        }
        Object[] objectArray = null;
        objectArray = arrayList.toArray(new String[0]);
        Arrays.sort(objectArray);
        ArrayList<SyncRefInfo> arrayList2 = new ArrayList<SyncRefInfo>();
        int n = 5;
        for (int i = 0; i < objectArray.length; ++i) {
            SyncRefInfo syncRefInfo = new SyncRefInfo((String)objectArray[i], n, name);
            arrayList2.add(syncRefInfo);
        }
        return arrayList2.toArray(new SyncRefInfo[0]);
    }

    protected Integer getPiuGroupNumberAttribute() {
        return new Integer(1);
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.getLdn());
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        String string = String.valueOf(this.getSlotNo()) + ":" + name;
        return string;
    }

    public String[] getTuSynchRefLdns() throws BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[]{};
        BemMo[] bemMoArray = this.getTuSyncRefMOs();
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                arrayList.add(bemMoArray[i].getDN());
            }
        }
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public String[] getGpsSynchRefLdns() throws BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[]{};
        BemMo[] bemMoArray = this.getGpsSyncRefMOs();
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                arrayList.add(bemMoArray[i].getDN());
            }
        }
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    private BemMo[] getTuSyncRefMOs() throws BemException {
        SingleChildMoi singleChildMoi;
        String string;
        BemMo bemMo;
        boolean bl;
        if (this.tuSyncRefMOs == null && (bl = this.isExisting(bemMo = this.getMo(string = (singleChildMoi = new SingleChildMoi(this.piuMoi, MimTimingUnit.MOTYPENAME, "1")).getLdn())))) {
            this.tuSyncRefMOs = this.getChildren(bemMo, 1, MimTuSyncRef.MOTYPENAME, "");
        }
        return this.tuSyncRefMOs;
    }

    private BemMo[] getGpsSyncRefMOs() throws BemException {
        SingleChildMoi singleChildMoi;
        String string;
        BemMo bemMo;
        boolean bl;
        if (this.gpsSyncRefMOs == null && (bl = this.isExisting(bemMo = this.getMo(string = (singleChildMoi = new SingleChildMoi(this.piuMoi, MimTimingUnit.MOTYPENAME, "1")).getLdn())))) {
            this.gpsSyncRefMOs = this.getChildren(bemMo, 1, MimGpsSyncRef.MOTYPENAME, "");
        }
        return this.gpsSyncRefMOs;
    }
}

