/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.resource;

import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimNodeBFunction;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class NodeBFunctionRI
extends AbstractResourceItem {
    public static final String NAME = MimNodeBFunction.MOTYPENAME;
    private static final String[] MY_INSTALLATION_PHASES = new String[]{"CarrierAllocationModeModifyPhase"};
    private String nodeBFunctionLdn = "";
    private MoHandler theMoHandler;
    private BemMo nodeBFunctionMo;

    public NodeBFunctionRI(Rbs rbs) throws BemException {
        super(NAME, rbs, MY_INSTALLATION_PHASES);
        this.theMoHandler = rbs.getMoHandler();
        this.createLdn();
        this.nodeBFunctionMo = this.theMoHandler.getMo(this.nodeBFunctionLdn);
    }

    private void createLdn() throws BemException {
        this.nodeBFunctionLdn = this.rbs.getNodeBFunctionMoi().getLdn();
    }

    public String getName() {
        return NAME;
    }

    public String getDisplayName() {
        return NAME + ": " + this.nodeBFunctionLdn;
    }

    public String getLdn() {
        return this.nodeBFunctionLdn;
    }

    public void install(String string) throws BemException {
    }

    public void uninstall(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            try {
                if (this.needConvertToFlexible()) {
                    NalNameValue[] nalNameValueArray = new NalNameValue[]{};
                    this.theMoHandler.action(this.nodeBFunctionMo, "convertToFlexibleCarrierMapping", nalNameValueArray);
                }
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException(moHandlerException.getAction(), (Throwable)moHandlerException);
            }
        }
    }

    private boolean needConvertToFlexible() throws BemException {
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("carrierAllocationMode");
        return null != customerParameter && customerParameter.getValue().equals("Flexible") && customerParameter.hasValueChanged();
    }
}

