/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.resource;

import java.text.MessageFormat;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;

public class ControlPortRI
extends AbstractResourceItem {
    public static final String name = "ControlPort";
    private static final String[] myInstallationPhases = new String[]{"ExternalAlarmCreationPhase"};
    private static final String[] pseudos = new String[]{"equipmentName", "normallyOpen"};
    private static final String[] attributeNames = new String[]{"equipmentName", "normallyOpen"};
    private String ldn;
    private String prefix;
    private String type;
    private String equipmentName = null;
    private Boolean normallyOpen = null;

    public ControlPortRI(Rbs rbs, String string, String string2, int n) {
        super(name, rbs, myInstallationPhases);
        this.type = string2;
        this.ldn = string;
        BemMo bemMo = this.getMo(string);
        String string3 = bemMo.getId();
        String string4 = MessageFormat.format("CAB{0}_", new Integer(n)) + string2 + name + "{0}_";
        this.prefix = MessageFormat.format(string4, string3);
    }

    public void install(String string) throws BemException {
        if (myInstallationPhases[0].equals(string)) {
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "equipmentName");
            this.equipmentName = (String)customerParameterServer.getValueMom();
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "normallyOpen");
            this.normallyOpen = (Boolean)customerParameterServer.getValueMom();
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("equipmentName", this.equipmentName));
            vector.add(Nal.getFactory().getNameValue("normallyOpen", this.normallyOpen));
            this.verifyAttributes();
            BemMo bemMo = this.getMo(this.ldn);
            if (bemMo.isExisting()) {
                Vector vector2 = this.getLoadedValues();
                if (vector2 != null) {
                    for (int i = 0; i < vector2.size(); ++i) {
                        if (vector2.elementAt(i).toString().endsWith(vector.elementAt(i).toString())) continue;
                        this.setControlPortAttributes(bemMo, vector);
                        break;
                    }
                }
            } else if (this.rbs.getRbsStep().equals("STEP_SITE")) {
                int n = this.prefix.indexOf(name);
                String string2 = this.prefix.substring(0, n);
                throw new BemException("ControlPortRI.install error, " + string2 + " does not exist.");
            }
        }
    }

    public boolean isInstalled(String string) throws BemException {
        boolean bl = true;
        BemMoImpl bemMoImpl = new BemMoImpl(string);
        if (this.isExisting(bemMoImpl)) {
            Integer n = (Integer)this.getAttribute(bemMoImpl, "administrativeState");
            if (n == 0) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private void setControlPortAttributes(BemMo bemMo, Vector vector) throws BemException {
        if (vector != null && !vector.isEmpty()) {
            this.lockPort(bemMo);
            this.setAttributes(bemMo, vector);
            this.unlockPort(bemMo);
        }
    }

    private void lockPort(BemMo bemMo) throws BemException {
        Integer n = (Integer)this.getAttribute(bemMo, "administrativeState");
        if (n == 1) {
            this.setAttribute(bemMo, "administrativeState", (Object)new Integer(0));
        }
    }

    private void unlockPort(BemMo bemMo) throws BemException {
        Integer n = (Integer)this.getAttribute(bemMo, "administrativeState");
        if (n == 0) {
            this.setAttribute(bemMo, "administrativeState", (Object)new Integer(1));
        }
    }

    public void setLoadedValues() throws BemException {
        Object object;
        BemMo bemMo = this.getMo(this.ldn);
        for (int i = 0; i < pseudos.length; ++i) {
            object = this.prefix + pseudos[i];
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject((String)object);
            Object object2 = this.getAttribute(bemMo, attributeNames[i]);
            customerParameterServer.setLoadedValue(object2);
        }
        String string = this.prefix + "externalAlarmUnit";
        object = this.rbs.getCustomerParameterServerObject(string);
        object.setLoadedValue(this.type);
    }

    private Vector getLoadedValues() throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        BemMo bemMo = this.getMo(this.ldn);
        Object object = this.getAttribute(bemMo, "equipmentName");
        vector.add(Nal.getFactory().getNameValue("equipmentName", object));
        object = this.getAttribute(bemMo, "normallyOpen");
        vector.add(Nal.getFactory().getNameValue("normallyOpen", object));
        return vector;
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "ControlPort: " + this.getLdn();
    }

    private void verifyAttributes() throws BemException {
        if (this.equipmentName == null) {
            throw new BemException("ControlPortRI.verifyAttributes() equipmentName is null for\n" + this.getDisplayName());
        }
        if (this.normallyOpen == null) {
            throw new BemException("ControlPortRI.verifyAttributes() normallyOpen is null for\n" + this.getDisplayName());
        }
    }

    public String getPrefix() {
        return this.prefix;
    }
}

