/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.BatteryManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.BatteryTypeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ChargingModeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ClimateManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.IntegerConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.MultiplePowerSystemConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerDistributionManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSupplyManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSystemUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.SharedBatteryConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.SupportSystemManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.TestModeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.BatteryTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateRegulationSystem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateSystem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ConfigureBatteryBackupParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ConfigurePowerSupplyParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.MultiplePowerSystemParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.NoOfBfuParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.NoOfPduParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.NoOfPsuParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.SmokeDetectorParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.SupportSystemControlParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.HwGroupRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.help.RDNHelper;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.PowerSupplyProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractHwUnitWithEcPortRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimBatteryBackup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCabinet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPowerSupply;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public abstract class AbstractPowerSystemCI
extends AbstractConfigurationItem
implements CustomerParameterListener,
PowerSupplyProvider {
    public static final String name = "PowerSystemCI";
    private HashMap psuMap = new HashMap();
    private HashMap pduMap = new HashMap();
    private HashMap bfuMap = new HashMap();
    public static final Integer mimBfuNumberSupportParallelBfu = new Integer(2);
    private HashMap powerSupplyManager = new HashMap();
    private HashMap powerDistributionManager = new HashMap();
    private HashMap batteryManager = new HashMap();
    private ClimateManager climateManager;
    private SupportSystemManager supportSystemManager;
    protected HashMap optionalEquipmentcabinetNoParam = new HashMap();
    protected HashMap noPsuCustParamList = new HashMap();
    protected HashMap noPduCustParamList = new HashMap();
    protected HashMap noBfuCustParamList = new HashMap();
    protected HashMap confPowerSupplyCustParam = new HashMap();
    protected HashMap multiplePowerSystemCustParam = new HashMap();
    protected HashMap batteryTypeParam = new HashMap();
    protected HashMap confBatteryBackupCustParam = new HashMap();
    protected SupportSystemControlParameter supportSystemControlCustParam;
    protected HashMap climateSystemCustParam = new HashMap();
    protected ClimateRegulationSystem climateRegulationSystemCustParam;
    protected HashMap smokeDetectorParam = new HashMap();
    protected HashMap cabinetNumberParam = new HashMap();
    protected HashMap sharedCabinetIdentifierParam = new HashMap();
    protected HashMap delCabinetNumberParam = new HashMap();
    protected HashMap cabEcBusNoParam = new HashMap();
    protected HashMap cabClimateSystemParam = new HashMap();
    protected HashMap cabinetTypeParam = new HashMap();
    protected IntegerParameter[] ecBusNoParam = new IntegerParameter[7];
    protected IntegerParameter[] ecBusconnectorUnitNumberParam = new IntegerParameter[7];
    protected IntegerParameter[] ModEcBusNoParam = new IntegerParameter[7];
    protected IntegerParameter[] ModEcBusconnectorUnitNumberParam = new IntegerParameter[7];
    protected HashMap sharedBatteryParam = new HashMap();
    protected HashMap chargingModeParam = new HashMap();
    protected HashMap testModeParam = new HashMap();
    protected HashMap minimumStateOfHealthParam = new HashMap();
    protected HashMap minimumBackupTimeParam = new HashMap();
    protected HashMap testStartDayParam = new HashMap();
    protected HashMap testStartTimeParam = new HashMap();
    protected HashMap batteryInstallationDateParam = new HashMap();
    protected HashMap testStartMonthParam = new HashMap();
    protected HashMap valueChargingVoltageParameter = new HashMap();
    protected HashMap valueTempCompVoltageSlopParameter = new HashMap();
    protected HashMap valueNominalTempParameter = new HashMap();
    protected HashMap valueTempCompMinVoltageParameter = new HashMap();
    protected HashMap valueTempCompMaxVoltageParameter = new HashMap();
    protected HashMap valueIncreasedChargeVoltageParameter = new HashMap();
    protected HashMap valueBoostChargeTimeParameter = new HashMap();
    protected HashMap valueBoostChargeTriggerVoltageParameter = new HashMap();
    protected HashMap valueEqualizeChargeTimeParameter = new HashMap();
    protected HashMap valueEqualizeChargeCyclicIntervalParameter = new HashMap();
    protected HashMap valueIntermittentChargeConnectVoltageParameter = new HashMap();
    protected HashMap valueIntermittentChargeConnectTimeParameter = new HashMap();
    protected HashMap valueIntermittentChargeDisconnectTimeParameter = new HashMap();
    private Vector hwGroupIdParams = new Vector();
    private Vector hwGroupPositionInfoParams = new Vector();
    private Vector hwGroupMois = new Vector();
    private Vector hwGroupRIs = new Vector();
    private Map hwGroupIdToIndex = new HashMap();
    private int noOfHwGroups = 0;
    private HashMap restMultiplePowerSystem = new HashMap();
    private HashMap restMultiplePowerSystemOptional = new HashMap();
    private HashMap restOptional = new HashMap();
    private HashMap restNoPsu = new HashMap();
    private HashMap psuRange = new HashMap();
    private HashMap pduRange = new HashMap();
    private HashMap restNoPdu = new HashMap();
    private HashMap restNoBfu = new HashMap();
    private HashMap bfuRange = new HashMap();
    protected HashMap restRangeNoOfBfu = new HashMap();
    private ParameterRestriction[] restEcBusNumber = new ParameterRestriction[7];
    private HashMap restBatteryNoDelete = new HashMap();
    private HashMap restBatteryTypeOptional = new HashMap();
    private HashMap restBatteryIgnored = new HashMap();
    private HashMap restPowSupplyModifyPsu = new HashMap();
    private HashMap restPowSupplyNoDelete = new HashMap();
    private HashMap restPowerSupplyIgnored = new HashMap();
    private HashMap restSmokeDetectorIgnored = new HashMap();
    private HashMap restBatteryType = new HashMap();
    private HashMap restBatteryInstallationDate = new HashMap();
    private HashMap restMinimumStateOfHealth = new HashMap();
    private HashMap restMinimumBackupTime = new HashMap();
    private HashMap restBatteryBackupAttributes = new HashMap();
    private HashMap restClimateSystem = new HashMap();
    private HashMap restClimateRegulationSystem = new HashMap();
    private HashMap restTestModeRelatedCPs = new HashMap();
    private HashMap restChargingModeRelatedCPs = new HashMap();
    private boolean isOpen = false;

    public AbstractPowerSystemCI(Rbs rbs) {
        super(rbs);
    }

    public boolean open() throws BemException {
        try {
            if (this.isOpen) {
                throw new BemException("AbstractPowerSystemCI.open(): Already open");
            }
            ConfigurationItem configurationItem = this.rbs.getConfigItem("CabinetBasicCI");
            if (configurationItem != null && this.isDuwV2In6601() && !configurationItem.isOpen()) {
                this.rbs.openConfigurationItem("CabinetBasicCI");
            }
            RDNHelper.getInstance().initRDNHelper();
            this.initializeRestrictions();
            this.initializeResourceManagers();
            this.updateHWPostfixList();
            this.createAllRIs();
            this.createAllCustomerParameters();
            this.setDefaultParameterValues();
            this.updateLoadedValues();
            this.setCustomerParameterRestrictions();
            this.setCustomerParameterListeners();
            this.initialiseResourceForHwGroups();
            this.isOpen = true;
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException("AbstractPowerSystemCI.open() got exception=" + exception.toString());
        }
        return true;
    }

    void initializeRestrictions() {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            this.restOptional.put(new Integer(i), new ParameterRestriction("", 2));
            this.restNoPsu.put(new Integer(i), new ParameterRestriction("PSUs are not needed when no power supply is selected", 1));
            this.restNoPdu.put(new Integer(i), new ParameterRestriction("PDUs are not needed", 1));
            this.restNoBfu.put(new Integer(i), new ParameterRestriction("BFUs are not needed", 1));
            this.restBatteryNoDelete.put(new Integer(i), new ParameterRestriction("Cannot delete an existing battery", 0));
            this.restBatteryTypeOptional.put(new Integer(i), new ParameterRestriction("", 2));
            this.restBatteryIgnored.put(new Integer(i), new ParameterRestriction("Battery Backup is only allowed when Support System Control is chosen", 1));
            this.restMultiplePowerSystemOptional.put(new Integer(i), new ParameterRestriction("", 2));
            this.restMultiplePowerSystem.put(new Integer(i), new ParameterRestriction("", 1));
            this.restPowSupplyModifyPsu.put(new Integer(i), new ParameterRestriction("\nNo power supply system was installed at cabinet or site configuration - \n not allowed to modify no of PSUs", 0));
            this.restPowSupplyNoDelete.put(new Integer(i), new ParameterRestriction("Cannot delete an existing power supply", 0));
            this.restPowerSupplyIgnored.put(new Integer(i), new ParameterRestriction("Power Supply is only allowed when Support System Control is chosen", 1));
            this.restSmokeDetectorIgnored.put(new Integer(i), new ParameterRestriction("Smoke Detector is only allowed when Support System Control is chosen", 1));
            this.restBatteryType.put(new Integer(i), new ParameterRestriction("Cannot configure battery type when no battery", 1));
            this.restBatteryInstallationDate.put(new Integer(i), new ParameterRestriction("Cannot configure battery Installation date when no battery", 1));
            this.restMinimumStateOfHealth.put(new Integer(i), new ParameterRestriction("Cannot configure Minimum state of health when shared battery is Yes", 1));
            this.restMinimumBackupTime.put(new Integer(i), new ParameterRestriction("Cannot config Minimum backup time when shared battery is No", 1));
            this.restEcBusNumber[i] = new ParameterRestriction("EcbusNumber is only allowed when Support System Control is true", 1);
            this.restBatteryBackupAttributes.put(new Integer(i), new ParameterRestriction("Attributes of battery backup are not allowed because battery backup is not configured", 1));
            this.restClimateSystem.put(new Integer(i), new ParameterRestriction("Climate system is only needed when Support System Control is chosen", 1));
            this.restClimateRegulationSystem.put(new Integer(i), new ParameterRestriction("Climate regulation system is only needed when Support System Control is chosen", 1));
            this.restTestModeRelatedCPs.put(new Integer(i), new ParameterRestriction("Attributes test mode related are not supported when test mode is not configured", 1));
            this.restChargingModeRelatedCPs.put(new Integer(i), new ParameterRestriction("Attributes charging mode related are not supported when charging mode is not user defined", 1));
        }
    }

    void initializeResourceManagers() throws BemException {
        this.supportSystemManager = this.getSupportSystemManager();
        this.powerSupplyManager.put(new Integer(0), this.getPowerSupplyManager());
        this.powerDistributionManager.put(new Integer(0), this.getPowerDistributionManager());
        this.batteryManager.put(new Integer(0), this.getBatteryManager());
        this.climateManager = this.getClimateManager();
        int[] nArray = new int[]{1};
        IntegerRange integerRange = new IntegerRange(new Integer(1), new Integer(1));
        boolean bl = true;
        int[] nArray2 = new int[]{2, 3, 4, 5, 6};
        IntegerRange integerRange2 = new IntegerRange(new Integer(1), new Integer(5));
        boolean bl2 = true;
        int[] nArray3 = new int[]{7, 8, 9, 10};
        IntegerRange integerRange3 = new IntegerRange(new Integer(0), new Integer(4));
        boolean bl3 = true;
        for (int i = 1; i < this.rbs.getNoOfCabinets(); ++i) {
            int n = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
            if (this.rbs.getCabinetTypeParams().length == 0 || this.rbs.getCabinetTypeParams()[i] == null || !this.rbs.getCabinetTypeParams()[i].equals("RBS6601W")) continue;
            this.batteryManager.put(new Integer(i), new BatteryManager(this.rbs, nArray, integerRange, bl, n));
            this.powerSupplyManager.put(new Integer(i), new PowerSupplyManager(this.rbs, nArray2, integerRange2, bl2, n));
            this.powerDistributionManager.put(new Integer(i), new PowerDistributionManager(this.rbs, nArray3, integerRange3, bl3, n));
        }
    }

    private void createAllRIs() throws BemException {
        this.supportSystemManager.createAllRIs();
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            if (null != this.batteryManager.get(new Integer(i))) {
                ((BatteryManager)this.batteryManager.get(new Integer(i))).createAllRIs();
            }
            if (null != this.powerDistributionManager.get(new Integer(i))) {
                ((PowerDistributionManager)this.powerDistributionManager.get(new Integer(i))).createAllRIs();
            }
            if (null == (PowerSupplyManager)this.powerSupplyManager.get(new Integer(i))) continue;
            ((PowerSupplyManager)this.powerSupplyManager.get(new Integer(i))).createAllRIs();
        }
        this.climateManager.createAllRIs();
    }

    private void createAllCustomerParameters() throws BemException {
        HashMap<Integer, YesNoCustomerParameter> hashMap;
        String string;
        int n;
        int n2;
        for (n2 = 0; n2 < this.rbs.getNoOfCabinets(); ++n2) {
            int n3;
            NoOfBfuParameter noOfBfuParameter;
            n = Integer.parseInt(this.rbs.getCabinetNumberList().get(n2).toString());
            string = MessageFormat.format("CAB{0}_", new Integer(n));
            if (n2 == 0) {
                this.noPsuCustParamList.put(new Integer(n2), new NoOfPsuParameter(string + "noOfPsu", this.getNoOfPsuRange()));
                this.noPduCustParamList.put(new Integer(n2), new NoOfPduParameter(string + "noOfPdu", this.getNoOfPduRange()));
                this.noBfuCustParamList.put(new Integer(n2), new NoOfBfuParameter(string + "noOfBfu", this.getNoOfBfuRange()));
                hashMap = (NoOfPsuParameter)this.noPsuCustParamList.get(new Integer(n2));
                NoOfPduParameter noOfPduParameter = (NoOfPduParameter)this.noPduCustParamList.get(new Integer(n2));
                noOfBfuParameter = (NoOfBfuParameter)this.noBfuCustParamList.get(new Integer(n2));
                if (((BatteryManager)this.batteryManager.get(new Integer(n2))).isBatterySupported()) {
                    noOfBfuParameter.setDefaultValue("1");
                    noOfBfuParameter.addCustomerParameterListener(new NumberOfBfuListener(n2));
                }
                this.addParameter((CustomerParameter)((Object)hashMap));
                this.addParameter(noOfPduParameter);
                this.addParameter(noOfBfuParameter);
            } else if (this.rbs.getCabinetTypeParams().length != 0 && this.rbs.getCabinetTypeParams()[n2] != null && this.rbs.getCabinetTypeParams()[n2].equals("RBS6601W")) {
                this.noPsuCustParamList.put(new Integer(n2), new NoOfPsuParameter(string + "noOfPsu", PowerSystemUtil.getNoOfAPCRange("PSU", "RBS6601W")));
                this.noPduCustParamList.put(new Integer(n2), new NoOfPduParameter(string + "noOfPdu", PowerSystemUtil.getNoOfAPCRange("PDU", "RBS6601W")));
                this.noBfuCustParamList.put(new Integer(n2), new NoOfBfuParameter(string + "noOfBfu", PowerSystemUtil.getNoOfAPCRange("BFU", "RBS6601W")));
                hashMap = (NoOfPsuParameter)this.noPsuCustParamList.get(new Integer(n2));
                NoOfPduParameter noOfPduParameter = (NoOfPduParameter)this.noPduCustParamList.get(new Integer(n2));
                noOfBfuParameter = (NoOfBfuParameter)this.noBfuCustParamList.get(new Integer(n2));
                if (((BatteryManager)this.batteryManager.get(new Integer(n2))).isBatterySupported()) {
                    noOfBfuParameter.setDefaultValue("1");
                    noOfBfuParameter.addCustomerParameterListener(new NumberOfBfuListener(n2));
                }
                this.addParameter((CustomerParameter)((Object)hashMap));
                this.addParameter(noOfPduParameter);
                this.addParameter(noOfBfuParameter);
            }
            this.multiplePowerSystemCustParam.put(new Integer(n2), new MultiplePowerSystemParameter(string + "multiplePowerSystem"));
            ((MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(new Integer(n2))).setDefaultValue(MimPowerSupply.DEFAULT_MULTIPLEPOWERSYSTEM.toString().toUpperCase());
            ((MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(new Integer(n2))).setMomConverter(new MultiplePowerSystemConversion());
            this.addParameter((MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(new Integer(n2)));
            this.optionalEquipmentcabinetNoParam.put(new Integer(n2), new IntegerParameter(string + "cabinetNumber", new IntegerRange(1, Integer.parseInt(this.rbs.getCabinetNumberList().get(n2).toString()))));
            this.confBatteryBackupCustParam.put(new Integer(n2), new ConfigureBatteryBackupParameter(string + "configureBatteryBackup"));
            this.confPowerSupplyCustParam.put(new Integer(n2), new ConfigurePowerSupplyParameter(string + "configurePowerSupply"));
            this.batteryTypeParam.put(new Integer(n2), new BatteryTypeParameter(string + "batteryType"));
            ((BatteryTypeParameter)this.batteryTypeParam.get(new Integer(n2))).setMomConverter(new BatteryTypeConversion());
            ((BatteryTypeParameter)this.batteryTypeParam.get(new Integer(n2))).setDefaultValue("TYPE01");
            this.chargingModeParam.put(new Integer(n2), new Enumeration(string + "chargingMode", new String[]{"AUTOMATIC", "USER_DEFINED"}));
            ((Enumeration)this.chargingModeParam.get(new Integer(n2))).setMomConverter(new ChargingModeConversion());
            ((Enumeration)this.chargingModeParam.get(new Integer(n2))).setDefaultValue("AUTOMATIC");
            this.sharedBatteryParam.put(new Integer(n2), new TrueFalseCustomerParameter(string + "sharedBattery"));
            ((TrueFalseCustomerParameter)this.sharedBatteryParam.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_SHAREDBATTERY.toString().toUpperCase());
            ((TrueFalseCustomerParameter)this.sharedBatteryParam.get(new Integer(n2))).setMomConverter(new SharedBatteryConversion());
            this.testModeParam.put(new Integer(n2), new Enumeration(string + "testMode", new String[]{"AUTOMATIC", "CONFIGURED", "DISABLED"}));
            ((Enumeration)this.testModeParam.get(new Integer(n2))).setMomConverter(new TestModeConversion());
            ((Enumeration)this.testModeParam.get(new Integer(n2))).setDefaultValue("DISABLED");
            this.minimumStateOfHealthParam.put(new Integer(n2), new IntegerParameter(string + "minimumStateOfHealth", new IntegerRange(MimBatteryBackup.MIN_MINIMUMSTATEOFHEALTH, MimBatteryBackup.MAX_MINIMUMSTATEOFHEALTH)));
            ((IntegerParameter)this.minimumStateOfHealthParam.get(new Integer(n2))).setMomConverter(new IntegerConversion("minimumStateOfHealth"));
            ((IntegerParameter)this.minimumStateOfHealthParam.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_MINIMUMSTATEOFHEALTH.toString());
            this.minimumBackupTimeParam.put(new Integer(n2), new IntegerParameter(string + "minimumBackupTime", new IntegerRange(MimBatteryBackup.MIN_MINIMUMBACKUPTIME, MimBatteryBackup.MAX_MINIMUMBACKUPTIME)));
            ((IntegerParameter)this.minimumBackupTimeParam.get(new Integer(n2))).setMomConverter(new IntegerConversion("minimumBackupTime"));
            ((IntegerParameter)this.minimumBackupTimeParam.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_MINIMUMBACKUPTIME.toString());
            this.testStartDayParam.put(new Integer(n2), new IntegerParameter(string + "testStartDay", new IntegerRange(MimBatteryBackup.MIN_TESTSTARTDAY, MimBatteryBackup.MAX_TESTSTARTDAY)));
            ((IntegerParameter)this.testStartDayParam.get(new Integer(n2))).setMomConverter(new IntegerConversion("testStartDay"));
            ((IntegerParameter)this.testStartDayParam.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_TESTSTARTDAY.toString());
            this.testStartTimeParam.put(new Integer(n2), new StringParameter(string + "testStartTime", new StringRange(MimBatteryBackup.MINLEN_TESTSTARTTIME, MimBatteryBackup.MAXLEN_TESTSTARTTIME)));
            ((StringParameter)this.testStartTimeParam.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_TESTSTARTTIME);
            this.batteryInstallationDateParam.put(new Integer(n2), new StringParameter(string + "batteryInstallationDate", new StringRange(MimBatteryBackup.MINLEN_BATTERYINSTALLATIONDATE, MimBatteryBackup.MAXLEN_BATTERYINSTALLATIONDATE)));
            ((StringParameter)this.batteryInstallationDateParam.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_BATTERYINSTALLATIONDATE);
            this.smokeDetectorParam.put(new Integer(n2), new SmokeDetectorParameter(string + "smokeDetector"));
            if (n2 == 0) {
                ((SmokeDetectorParameter)this.smokeDetectorParam.get(new Integer(n2))).setDefaultValue("FALSE");
            }
            this.valueChargingVoltageParameter.put(new Integer(n2), new IntegerParameter(string + "chargingVoltage", new IntegerRange(MimBatteryBackup.MIN_CHARGINGVOLTAGE, MimBatteryBackup.MAX_CHARGINGVOLTAGE)));
            ((IntegerParameter)this.valueChargingVoltageParameter.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_CHARGINGVOLTAGE.toString());
            ((IntegerParameter)this.valueChargingVoltageParameter.get(new Integer(n2))).setMomConverter(new IntegerConversion("chargingVoltage"));
            this.valueTempCompVoltageSlopParameter.put(new Integer(n2), new IntegerParameter(string + "tempCompVoltageSlope", new IntegerRange(MimBatteryBackup.MIN_TEMPCOMPVOLTAGESLOPE, MimBatteryBackup.MAX_TEMPCOMPVOLTAGESLOPE)));
            ((IntegerParameter)this.valueTempCompVoltageSlopParameter.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_TEMPCOMPVOLTAGESLOPE.toString());
            ((IntegerParameter)this.valueTempCompVoltageSlopParameter.get(new Integer(n2))).setMomConverter(new IntegerConversion("tempCompVoltageSlope"));
            this.valueNominalTempParameter.put(new Integer(n2), new IntegerParameter(string + "nominalTemp", new IntegerRange(MimBatteryBackup.MIN_NOMINALTEMP, MimBatteryBackup.MAX_NOMINALTEMP)));
            ((IntegerParameter)this.valueNominalTempParameter.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_NOMINALTEMP.toString());
            ((IntegerParameter)this.valueNominalTempParameter.get(new Integer(n2))).setMomConverter(new IntegerConversion("nominalTemp"));
            this.valueTempCompMinVoltageParameter.put(new Integer(n2), new IntegerParameter(string + "tempCompMinVoltage", new IntegerRange(MimBatteryBackup.MIN_TEMPCOMPMINVOLTAGE, MimBatteryBackup.MAX_TEMPCOMPMINVOLTAGE)));
            ((IntegerParameter)this.valueTempCompMinVoltageParameter.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_TEMPCOMPMINVOLTAGE.toString());
            ((IntegerParameter)this.valueTempCompMinVoltageParameter.get(new Integer(n2))).setMomConverter(new IntegerConversion("tempCompMinVoltage"));
            this.valueTempCompMaxVoltageParameter.put(new Integer(n2), new IntegerParameter(string + "tempCompMaxVoltage", new IntegerRange(MimBatteryBackup.MIN_TEMPCOMPMAXVOLTAGE, MimBatteryBackup.MAX_TEMPCOMPMAXVOLTAGE)));
            ((IntegerParameter)this.valueTempCompMaxVoltageParameter.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_TEMPCOMPMAXVOLTAGE.toString());
            ((IntegerParameter)this.valueTempCompMaxVoltageParameter.get(new Integer(n2))).setMomConverter(new IntegerConversion("tempCompMaxVoltage"));
            this.valueIncreasedChargeVoltageParameter.put(new Integer(n2), new IntegerParameter(string + "increasedChargeVoltage", new IntegerRange(MimBatteryBackup.MIN_INCREASEDCHARGEVOLTAGE, MimBatteryBackup.MAX_INCREASEDCHARGEVOLTAGE)));
            ((IntegerParameter)this.valueIncreasedChargeVoltageParameter.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_INCREASEDCHARGEVOLTAGE.toString());
            ((IntegerParameter)this.valueIncreasedChargeVoltageParameter.get(new Integer(n2))).setMomConverter(new IntegerConversion("increasedChargeVoltage"));
            this.valueBoostChargeTimeParameter.put(new Integer(n2), new IntegerParameter(string + "boostChargeTime", new IntegerRange(MimBatteryBackup.MIN_BOOSTCHARGETIME, MimBatteryBackup.MAX_BOOSTCHARGETIME)));
            ((IntegerParameter)this.valueBoostChargeTimeParameter.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_BOOSTCHARGETIME.toString());
            ((IntegerParameter)this.valueBoostChargeTimeParameter.get(new Integer(n2))).setMomConverter(new IntegerConversion("boostChargeTime"));
            this.valueBoostChargeTriggerVoltageParameter.put(new Integer(n2), new IntegerParameter(string + "boostChargeTriggerVoltage", new IntegerRange(MimBatteryBackup.MIN_BOOSTCHARGETRIGGERVOLTAGE, MimBatteryBackup.MAX_BOOSTCHARGETRIGGERVOLTAGE)));
            ((IntegerParameter)this.valueBoostChargeTriggerVoltageParameter.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_BOOSTCHARGETRIGGERVOLTAGE.toString());
            ((IntegerParameter)this.valueBoostChargeTriggerVoltageParameter.get(new Integer(n2))).setMomConverter(new IntegerConversion("boostChargeTriggerVoltage"));
            this.valueEqualizeChargeTimeParameter.put(new Integer(n2), new IntegerParameter(string + "equalizeChargeTime", new IntegerRange(MimBatteryBackup.MIN_EQUALIZECHARGETIME, MimBatteryBackup.MAX_EQUALIZECHARGETIME)));
            ((IntegerParameter)this.valueEqualizeChargeTimeParameter.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_EQUALIZECHARGETIME.toString());
            ((IntegerParameter)this.valueEqualizeChargeTimeParameter.get(new Integer(n2))).setMomConverter(new IntegerConversion("equalizeChargeTime"));
            this.valueEqualizeChargeCyclicIntervalParameter.put(new Integer(n2), new IntegerParameter(string + "equalizeChargeCyclicInterval", new IntegerRange(MimBatteryBackup.MIN_EQUALIZECHARGECYCLICINTERVAL, MimBatteryBackup.MAX_EQUALIZECHARGECYCLICINTERVAL)));
            ((IntegerParameter)this.valueEqualizeChargeCyclicIntervalParameter.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_EQUALIZECHARGECYCLICINTERVAL.toString());
            ((IntegerParameter)this.valueEqualizeChargeCyclicIntervalParameter.get(new Integer(n2))).setMomConverter(new IntegerConversion("equalizeChargeCyclicInterval"));
            this.valueIntermittentChargeConnectVoltageParameter.put(new Integer(n2), new IntegerParameter(string + "intermittentChargeConnectVoltage", new IntegerRange(MimBatteryBackup.MIN_INTERMITTENTCHARGECONNECTVOLTAGE, MimBatteryBackup.MAX_INTERMITTENTCHARGECONNECTVOLTAGE)));
            ((IntegerParameter)this.valueIntermittentChargeConnectVoltageParameter.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_INTERMITTENTCHARGECONNECTVOLTAGE.toString());
            ((IntegerParameter)this.valueIntermittentChargeConnectVoltageParameter.get(new Integer(n2))).setMomConverter(new IntegerConversion("intermittentChargeConnectVoltage"));
            this.valueIntermittentChargeConnectTimeParameter.put(new Integer(n2), new IntegerParameter(string + "intermittentChargeConnectTime", new IntegerRange(MimBatteryBackup.MIN_INTERMITTENTCHARGECONNECTTIME, MimBatteryBackup.MAX_INTERMITTENTCHARGECONNECTTIME)));
            ((IntegerParameter)this.valueIntermittentChargeConnectTimeParameter.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_INTERMITTENTCHARGECONNECTTIME.toString());
            ((IntegerParameter)this.valueIntermittentChargeConnectTimeParameter.get(new Integer(n2))).setMomConverter(new IntegerConversion("intermittentChargeConnectTime"));
            this.valueIntermittentChargeDisconnectTimeParameter.put(new Integer(n2), new IntegerParameter(string + "intermittentChargeDisconnectTime", new IntegerRange(MimBatteryBackup.MIN_INTERMITTENTCHARGEDISCONNECTTIME, MimBatteryBackup.MAX_INTERMITTENTCHARGEDISCONNECTTIME)));
            ((IntegerParameter)this.valueIntermittentChargeDisconnectTimeParameter.get(new Integer(n2))).setDefaultValue(MimBatteryBackup.DEFAULT_INTERMITTENTCHARGEDISCONNECTTIME.toString());
            ((IntegerParameter)this.valueIntermittentChargeDisconnectTimeParameter.get(new Integer(n2))).setMomConverter(new IntegerConversion("intermittentChargeDisconnectTime"));
            this.climateSystemCustParam.put(new Integer(n2), new ClimateSystem(string + "climateSystem"));
            hashMap = new HashMap<Integer, YesNoCustomerParameter>();
            for (n3 = 0; n3 < 12; ++n3) {
                int n4 = n3 + 1;
                hashMap.put(new Integer(n3), new YesNoCustomerParameter(string + "testStartMonths" + n4));
            }
            this.testStartMonthParam.put(new Integer(n2), hashMap);
            for (n3 = 0; n3 < 12; ++n3) {
                int n5 = n3 + 1;
                if (n5 == 3 || n5 == 9) {
                    ((YesNoCustomerParameter)((HashMap)this.testStartMonthParam.get(new Integer(n2))).get(new Integer(n3))).setDefaultValue("YES");
                } else {
                    ((YesNoCustomerParameter)((HashMap)this.testStartMonthParam.get(new Integer(n2))).get(new Integer(n3))).setDefaultValue("NO");
                }
                this.addParameter((YesNoCustomerParameter)((HashMap)this.testStartMonthParam.get(new Integer(n2))).get(new Integer(n3)));
            }
            this.addParameter((BatteryTypeParameter)this.batteryTypeParam.get(new Integer(n2)));
            this.addParameter((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(n2)));
            this.addParameter((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(n2)));
            this.addParameter((Enumeration)this.chargingModeParam.get(new Integer(n2)));
            this.addParameter((TrueFalseCustomerParameter)this.sharedBatteryParam.get(new Integer(n2)));
            this.addParameter((Enumeration)this.testModeParam.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.minimumStateOfHealthParam.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.minimumBackupTimeParam.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.testStartDayParam.get(new Integer(n2)));
            this.addParameter((StringParameter)this.testStartTimeParam.get(new Integer(n2)));
            this.addParameter((StringParameter)this.batteryInstallationDateParam.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.valueChargingVoltageParameter.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.valueTempCompVoltageSlopParameter.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.valueNominalTempParameter.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.valueTempCompMinVoltageParameter.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.valueTempCompMaxVoltageParameter.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.valueIncreasedChargeVoltageParameter.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.valueBoostChargeTimeParameter.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.valueBoostChargeTriggerVoltageParameter.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.valueEqualizeChargeTimeParameter.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.valueEqualizeChargeCyclicIntervalParameter.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.valueIntermittentChargeConnectVoltageParameter.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.valueIntermittentChargeConnectTimeParameter.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.valueIntermittentChargeDisconnectTimeParameter.get(new Integer(n2)));
            this.cabinetNumberParam.put(new Integer(n2), new IntegerParameter(string + "cabinetNumber", new IntegerRange(1, n)));
            ((IntegerParameter)this.cabinetNumberParam.get(new Integer(n2))).setDefaultValue("##UNDEFINED");
            this.sharedCabinetIdentifierParam.put(new Integer(n2), new StringParameter(string + "sharedCabinetIdentifier", new StringRange(MimCabinet.MINLEN_SHAREDCABINETIDENTIFIER, MimCabinet.MAXLEN_SHAREDCABINETIDENTIFIER)));
            ((StringParameter)this.sharedCabinetIdentifierParam.get(new Integer(n2))).setDefaultValue("");
            this.cabEcBusNoParam.put(new Integer(n2), new IntegerParameter(string + "ecBusNumber", new IntegerRange(1, 7)));
            ((IntegerParameter)this.cabEcBusNoParam.get(new Integer(n2))).setDefaultValue("##UNDEFINED");
            this.cabinetTypeParam.put(new Integer(n2), new Enumeration(string + "cabinetType", new EnumeratedRange(new String[]{"RBS6601W"})));
            ((Enumeration)this.cabinetTypeParam.get(new Integer(n2))).setDefaultValue("##UNDEFINED");
            this.addParameter((IntegerParameter)this.cabinetNumberParam.get(new Integer(n2)));
            this.addParameter((StringParameter)this.sharedCabinetIdentifierParam.get(new Integer(n2)));
            this.addParameter((Enumeration)this.cabinetTypeParam.get(new Integer(n2)));
            this.addParameter((IntegerParameter)this.cabEcBusNoParam.get(new Integer(n2)));
            this.addParameter((SmokeDetectorParameter)this.smokeDetectorParam.get(new Integer(n2)));
            this.addParameter((ClimateSystem)this.climateSystemCustParam.get(new Integer(n2)));
            string = MessageFormat.format("DCAB{0}_", new Integer(n));
            this.delCabinetNumberParam.put(new Integer(n2), new IntegerParameter(string + "cabinetNumber", new IntegerRange(2, 7)));
            ((IntegerParameter)this.delCabinetNumberParam.get(new Integer(n2))).setDefaultValue("##UNDEFINED");
            this.addParameter((IntegerParameter)this.delCabinetNumberParam.get(new Integer(n2)));
        }
        for (n2 = 0; n2 < 7; ++n2) {
            n = n2 + 1;
            string = MessageFormat.format("EcBus{0}_", new Integer(n));
            this.ecBusNoParam[n2] = new IntegerParameter(string + "ecBusNumber", new IntegerRange(2, 7));
            this.ecBusNoParam[n2].setDefaultValue("##UNDEFINED");
            this.ecBusconnectorUnitNumberParam[n2] = new IntegerParameter(string + "connectorUnitNumber", new IntegerRange(1, this.rbs.getMaxNumberOfSectors()));
            this.ecBusconnectorUnitNumberParam[n2].setDefaultValue("##UNDEFINED");
            this.addParameter(this.ecBusNoParam[n2]);
            this.addParameter(this.ecBusconnectorUnitNumberParam[n2]);
            hashMap = MessageFormat.format("ModEcBus{0}_", new Integer(n));
            this.ModEcBusNoParam[n2] = new IntegerParameter((String)((Object)hashMap) + "ecBusNumber", new IntegerRange(2, 7));
            this.ModEcBusNoParam[n2].setDefaultValue("##UNDEFINED");
            this.ModEcBusconnectorUnitNumberParam[n2] = new IntegerParameter((String)((Object)hashMap) + "connectorUnitNumber", new IntegerRange(1, this.rbs.getMaxNumberOfSectors()));
            this.ModEcBusconnectorUnitNumberParam[n2].setDefaultValue("##UNDEFINED");
            this.addParameter(this.ModEcBusNoParam[n2]);
            this.addParameter(this.ModEcBusconnectorUnitNumberParam[n2]);
        }
        this.supportSystemControlCustParam = new SupportSystemControlParameter();
        this.climateRegulationSystemCustParam = new ClimateRegulationSystem();
        this.addParameter(this.climateRegulationSystemCustParam);
        this.addParameter(this.supportSystemControlCustParam);
    }

    private void updateLoadedValues() throws BemException, MoHandlerException {
        this.updateLoadedEquipmentSupportFunctionValues();
        this.updateHubPosition();
        this.updateLoadedPowerSupplyValues();
        this.updateLoadedPowerDistributionValues();
        this.updateLoadedBatteryValues();
        this.updateLoadedClimateValues();
    }

    private void updateHubPosition() throws BemException {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            if (null != this.batteryManager.get(new Integer(i))) {
                ((BatteryManager)this.batteryManager.get(new Integer(i))).updateBoards("BFU");
            }
            if (null != this.powerDistributionManager.get(new Integer(i))) {
                ((PowerDistributionManager)this.powerDistributionManager.get(new Integer(i))).updateBoards("PDU");
            }
            if (null == (PowerSupplyManager)this.powerSupplyManager.get(new Integer(i))) continue;
            ((PowerSupplyManager)this.powerSupplyManager.get(new Integer(i))).updateBoards("PSU");
        }
        this.climateManager.updateBoards("CLU");
        this.climateManager.updateBoards("SCU");
        this.climateManager.updateBoards("SUP");
    }

    private void updateHWPostfixList() throws MoHandlerException, BemException {
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        RDNHelper rDNHelper = RDNHelper.getInstance();
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            int n;
            Object[] objectArray;
            this.psuMap.put(new Integer(i), new ArrayList());
            this.bfuMap.put(new Integer(i), new ArrayList());
            this.pduMap.put(new Integer(i), new ArrayList());
            int n2 = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
            MoInstance moInstance = this.rbs.getMoiRefs().getEquipmentMoi();
            String string = new FixedRdnMoi(moInstance, MimCabinet.MOTYPENAME, String.valueOf(n2)).getLdn();
            BemMo bemMo = moHandlerImpl.getMo(string);
            if (bemMo.isExisting() && (objectArray = (Object[])moHandlerImpl.getAttribute(bemMo, "reservedBy")) != null && objectArray.length > 0 && objectArray instanceof BemMo[]) {
                BemMo[] bemMoArray = (BemMo[])objectArray;
                for (int j = objectArray.length - 1; j >= 0; --j) {
                    int n3;
                    BemMo bemMo2 = bemMoArray[j];
                    if (!bemMo2.getType().equals(MimHwUnit.MOTYPENAME)) continue;
                    if (bemMo2.getLastRDN().indexOf("PDU") > -1) {
                        n3 = bemMo2.getLastRDN().indexOf("-") + 1;
                        ((ArrayList)this.pduMap.get(new Integer(i))).add(bemMo2.getLastRDN().substring(n3));
                        continue;
                    }
                    if (bemMo2.getLastRDN().indexOf("PSU") > -1) {
                        n3 = bemMo2.getLastRDN().indexOf("-") + 1;
                        ((ArrayList)this.psuMap.get(new Integer(i))).add(bemMo2.getLastRDN().substring(n3));
                        continue;
                    }
                    if (bemMo2.getLastRDN().indexOf("BFU") <= -1) continue;
                    n3 = bemMo2.getLastRDN().indexOf("-") + 1;
                    ((ArrayList)this.bfuMap.get(new Integer(i))).add(bemMo2.getLastRDN().substring(n3));
                }
            }
            for (n = 0; n < ((ArrayList)this.pduMap.get(new Integer(i))).size(); ++n) {
                rDNHelper.getPduRdnList().add(((ArrayList)this.pduMap.get(new Integer(i))).get(n));
            }
            for (n = 0; n < ((ArrayList)this.psuMap.get(new Integer(i))).size(); ++n) {
                rDNHelper.getPsuRdnList().add(((ArrayList)this.psuMap.get(new Integer(i))).get(n));
            }
            for (n = 0; n < ((ArrayList)this.bfuMap.get(new Integer(i))).size(); ++n) {
                rDNHelper.getBfuRdnList().add(((ArrayList)this.bfuMap.get(new Integer(i))).get(n));
            }
        }
    }

    private void updateLoadedEquipmentSupportFunctionValues() throws BemException {
        boolean bl = this.supportSystemManager.isSupportSystemControlInstalled();
        if (bl) {
            String string = this.supportSystemManager.getLoadedValue();
            this.supportSystemControlCustParam.setLoadedValue(string);
        } else {
            this.supportSystemControlCustParam.setLoadedValue("TRUE");
        }
    }

    private void updateLoadedClimateValues() throws BemException {
        this.climateManager.updateLoadedValues();
    }

    private void updateLoadedBatteryValues() throws BemException {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            BatteryManager batteryManager = (BatteryManager)this.batteryManager.get(new Integer(i));
            if (null == batteryManager) continue;
            boolean bl = batteryManager.isBatteryBackupInstalled();
            if (bl) {
                ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(i))).setLoadedValue("YES");
                Integer n = batteryManager.getBatteryType();
                ((BatteryTypeParameter)this.batteryTypeParam.get(new Integer(i))).setLoadedValue(n);
                ((StringParameter)this.batteryInstallationDateParam.get(new Integer(i))).setLoadedValue(batteryManager.getbatteryInstallationDate());
                Integer n2 = batteryManager.getChargingMode();
                ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryNoDelete.get(new Integer(i)));
                int n3 = ((ArrayList)this.bfuMap.get(new Integer(i))).size();
                if (n3 > 0) {
                    ((NoOfBfuParameter)this.noBfuCustParamList.get(new Integer(i))).setLoadedValue(String.valueOf(n3));
                }
                Integer n4 = batteryManager.getTestMode();
                Boolean bl2 = batteryManager.getSharedBattery();
                ((Enumeration)this.chargingModeParam.get(new Integer(i))).setLoadedValue(n2);
                ((Enumeration)this.testModeParam.get(new Integer(i))).setLoadedValue(n4);
                ((TrueFalseCustomerParameter)this.sharedBatteryParam.get(new Integer(i))).setLoadedValue(bl2);
                if (n4 == 1) {
                    if (bl2.booleanValue()) {
                        ((IntegerParameter)this.minimumBackupTimeParam.get(new Integer(i))).setLoadedValue(batteryManager.getMinimumBackupTime());
                    } else {
                        ((IntegerParameter)this.minimumStateOfHealthParam.get(new Integer(i))).setLoadedValue(batteryManager.getMinimumStateOfHealth());
                    }
                    ((IntegerParameter)this.testStartDayParam.get(new Integer(i))).setLoadedValue(batteryManager.getTestStartDay());
                    ((StringParameter)this.testStartTimeParam.get(new Integer(i))).setLoadedValue(batteryManager.getTestStartTime());
                    int[] nArray = batteryManager.getTestStartMonths();
                    for (int j = 0; j < 12; ++j) {
                        int n5 = j + 1;
                        boolean bl3 = false;
                        for (int k = 0; k < nArray.length; ++k) {
                            if (nArray[k] != n5) continue;
                            bl3 = true;
                            break;
                        }
                        ((YesNoCustomerParameter)((HashMap)this.testStartMonthParam.get(new Integer(i))).get(new Integer(j))).setLoadedValue(bl3 ? "YES" : "NO");
                    }
                }
                if (n2 != 1) continue;
                ((IntegerParameter)this.valueChargingVoltageParameter.get(new Integer(i))).setLoadedValue(batteryManager.getChargingVoltage());
                ((IntegerParameter)this.valueTempCompVoltageSlopParameter.get(new Integer(i))).setLoadedValue(batteryManager.getTempCompVoltageSlop());
                ((IntegerParameter)this.valueNominalTempParameter.get(new Integer(i))).setLoadedValue(batteryManager.getNominalTemp());
                ((IntegerParameter)this.valueTempCompMinVoltageParameter.get(new Integer(i))).setLoadedValue(batteryManager.getTempCompMinVoltage());
                ((IntegerParameter)this.valueTempCompMaxVoltageParameter.get(new Integer(i))).setLoadedValue(batteryManager.getTempCompMaxVoltage());
                ((IntegerParameter)this.valueIncreasedChargeVoltageParameter.get(new Integer(i))).setLoadedValue(batteryManager.getIncreasedChargeVoltage());
                ((IntegerParameter)this.valueBoostChargeTimeParameter.get(new Integer(i))).setLoadedValue(batteryManager.getBoostChargeTime());
                ((IntegerParameter)this.valueBoostChargeTriggerVoltageParameter.get(new Integer(i))).setLoadedValue(batteryManager.getBoostChargeTriggerVoltage());
                ((IntegerParameter)this.valueEqualizeChargeTimeParameter.get(new Integer(i))).setLoadedValue(batteryManager.getEqualizeChargeTime());
                ((IntegerParameter)this.valueEqualizeChargeCyclicIntervalParameter.get(new Integer(i))).setLoadedValue(batteryManager.getEqualizeChargeCyclicInterval());
                ((IntegerParameter)this.valueIntermittentChargeConnectVoltageParameter.get(new Integer(i))).setLoadedValue(batteryManager.getIntermittentChargeConnectVoltage());
                ((IntegerParameter)this.valueIntermittentChargeConnectTimeParameter.get(new Integer(i))).setLoadedValue(batteryManager.getIntermittentChargeConnectTime());
                ((IntegerParameter)this.valueIntermittentChargeDisconnectTimeParameter.get(new Integer(i))).setLoadedValue(batteryManager.getIntermittentChargeDisconnectTime());
                continue;
            }
            ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(i))).setLoadedValue("NO");
            if (batteryManager.isBatterySupported()) continue;
            ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryIgnored.get(new Integer(i)));
        }
    }

    private void updateLoadedPowerSupplyValues() throws BemException {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            Comparable<Boolean> comparable;
            if (null == (PowerSupplyManager)this.powerSupplyManager.get(new Integer(i))) continue;
            boolean bl = ((PowerSupplyManager)this.powerSupplyManager.get(new Integer(i))).isPowerSupplyInstalled();
            if (bl) {
                comparable = (Boolean)((PowerSupplyManager)this.powerSupplyManager.get(new Integer(i))).getAttributeValue("multiplePowerSystem");
                ((MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(new Integer(i))).setLoadedValue(comparable);
                int n = ((ArrayList)this.psuMap.get(new Integer(i))).size();
                if (n > 0) {
                    NoOfPsuParameter noOfPsuParameter = (NoOfPsuParameter)this.noPsuCustParamList.get(new Integer(i));
                    noOfPsuParameter.setLoadedValue(String.valueOf(n));
                    ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i))).setLoadedValue("YES");
                    ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restPowSupplyNoDelete.get(new Integer(i)));
                    continue;
                }
                ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i))).setLoadedValue("NO");
                continue;
            }
            ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i))).setLoadedValue("NO");
            if (((PowerSupplyManager)this.powerSupplyManager.get(new Integer(i))).isPowerSupplySupported()) continue;
            ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restPowerSupplyIgnored.get(new Integer(i)));
            comparable = (NoOfPsuParameter)this.noPsuCustParamList.get(new Integer(i));
            ((CustomerParameterImpl)comparable).addRestriction((ParameterRestriction)this.restNoPsu.get(new Integer(i)));
        }
    }

    private void updateLoadedPowerDistributionValues() throws BemException {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            if (null == this.powerDistributionManager.get(new Integer(i))) continue;
            boolean bl = ((PowerDistributionManager)this.powerDistributionManager.get(new Integer(i))).isPowerDistributionInstalled();
            if (bl) {
                int n = ((ArrayList)this.pduMap.get(new Integer(i))).size();
                ((NoOfPduParameter)this.noPduCustParamList.get(new Integer(i))).setLoadedValue(String.valueOf(n));
                continue;
            }
            if (((PowerDistributionManager)this.powerDistributionManager.get(new Integer(i))).isPowerDistributionSupported()) continue;
            ((NoOfPduParameter)this.noPduCustParamList.get(new Integer(i))).addRestriction((ParameterRestriction)this.restNoPdu.get(new Integer(i)));
        }
    }

    public void setCustomerParameterRestrictions() throws BemException {
        Comparable comparable;
        int n;
        Object object;
        EnumeratedRange enumeratedRange = this.climateManager.getClimateSystemRange();
        Iterator iterator = this.climateSystemCustParam.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            ((ClimateSystem)object.getValue()).addRestriction(new ParameterRestriction("Allowed Range:" + enumeratedRange.toString(), enumeratedRange, true));
        }
        object = this.climateManager.getClimateRegulationSystemRange();
        this.climateRegulationSystemCustParam.addRestriction(new ParameterRestriction("Allowed Range:" + enumeratedRange.toString(), (ParameterRange)object, true));
        if (this.supportSystemControlCustParam.getBooleanValue()) {
            this.climateRegulationSystemCustParam.removeRestriction((ParameterRestriction)this.restClimateRegulationSystem.get(new Integer(0)));
            for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
                comparable = (NoOfPsuParameter)this.noPsuCustParamList.get(new Integer(n));
                ((ClimateSystem)this.climateSystemCustParam.get(new Integer(n))).removeRestriction((ParameterRestriction)this.restClimateSystem.get(new Integer(n)));
                ((IntegerParameter)this.cabEcBusNoParam.get(new Integer(n))).removeRestriction(this.restEcBusNumber[n]);
                if (null != this.noPduCustParamList.get(new Integer(n))) {
                    ((NoOfPduParameter)this.noPduCustParamList.get(new Integer(n))).removeRestriction((ParameterRestriction)this.restNoPdu.get(new Integer(n)));
                    ((NoOfPduParameter)this.noPduCustParamList.get(new Integer(n))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(n)));
                }
                if (null != comparable) {
                    ((CustomerParameterImpl)comparable).removeRestriction((ParameterRestriction)this.restNoPsu.get(new Integer(n)));
                    ((CustomerParameterImpl)comparable).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(n)));
                }
                if (null != (ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(n))) {
                    ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(n))).removeRestriction((ParameterRestriction)this.restPowerSupplyIgnored.get(new Integer(n)));
                    ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(n))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(n)));
                }
                if (null != this.confBatteryBackupCustParam.get(new Integer(n))) {
                    ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(n))).removeRestriction((ParameterRestriction)this.restBatteryIgnored.get(new Integer(n)));
                    ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(n))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(n)));
                }
                if (null == this.smokeDetectorParam) continue;
                ((SmokeDetectorParameter)this.smokeDetectorParam.get(new Integer(n))).removeRestriction((ParameterRestriction)this.restSmokeDetectorIgnored.get(new Integer(n)));
            }
        } else {
            this.climateRegulationSystemCustParam.addRestriction((ParameterRestriction)this.restClimateRegulationSystem.get(new Integer(0)));
            for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
                comparable = (NoOfPsuParameter)this.noPsuCustParamList.get(new Integer(n));
                ((ClimateSystem)this.climateSystemCustParam.get(new Integer(n))).addRestriction((ParameterRestriction)this.restClimateSystem.get(new Integer(n)));
                ((IntegerParameter)this.cabEcBusNoParam.get(new Integer(n))).addRestriction(this.restEcBusNumber[n]);
                if (null != this.noPduCustParamList.get(new Integer(n))) {
                    ((NoOfPduParameter)this.noPduCustParamList.get(new Integer(n))).addRestriction((ParameterRestriction)this.restNoPdu.get(new Integer(n)));
                    ((NoOfPduParameter)this.noPduCustParamList.get(new Integer(n))).removeRestriction((ParameterRestriction)this.restOptional.get(new Integer(n)));
                }
                if (null != comparable) {
                    ((CustomerParameterImpl)comparable).addRestriction((ParameterRestriction)this.restNoPsu.get(new Integer(n)));
                    ((CustomerParameterImpl)comparable).removeRestriction((ParameterRestriction)this.restOptional.get(new Integer(n)));
                }
                if (null != (ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(n))) {
                    ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(n))).removeRestriction((ParameterRestriction)this.restOptional.get(new Integer(n)));
                    ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(n))).addRestriction((ParameterRestriction)this.restPowerSupplyIgnored.get(new Integer(n)));
                }
                if (null != this.confBatteryBackupCustParam.get(new Integer(n))) {
                    ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(n))).removeRestriction((ParameterRestriction)this.restOptional.get(new Integer(n)));
                    ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(n))).addRestriction((ParameterRestriction)this.restBatteryIgnored.get(new Integer(n)));
                }
                if (null == this.smokeDetectorParam.get(new Integer(n))) continue;
                ((SmokeDetectorParameter)this.smokeDetectorParam.get(new Integer(n))).addRestriction((ParameterRestriction)this.restSmokeDetectorIgnored.get(new Integer(n)));
            }
        }
        this.addRestrictionsForBatteryBackupCPs();
        this.addRestrictionForStateOfHealthParam();
        this.addRestrictionForMinimumBackupTime();
        this.addRestrictionsForTestModeRelatedCPs();
        this.addRestrictionForChargingModeRelatedCPs();
        for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
            this.setRestrictionsForBatteryBackupCPs(this.supportSystemControlCustParam.getBooleanValue(), n);
        }
        for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
            if (null != (PowerSupplyManager)this.powerSupplyManager.get(new Integer(n))) {
                this.psuRange.put(new Integer(n), ((PowerSupplyManager)this.powerSupplyManager.get(new Integer(n))).getPsuRange());
            }
            if (null != this.powerDistributionManager.get(new Integer(n))) {
                this.pduRange.put(new Integer(n), ((PowerDistributionManager)this.powerDistributionManager.get(new Integer(n))).getPduRange());
            }
            if (this.psuRange.get(new Integer(n)) != null) {
                comparable = (NoOfPsuParameter)this.noPsuCustParamList.get(new Integer(n));
                ((CustomerParameterImpl)comparable).addRestriction((ParameterRestriction)this.restPowSupplyModifyPsu.get(new Integer(n)));
                ((ParameterRestriction)this.restPowSupplyModifyPsu.get(new Integer(n))).setActive(false);
                if ("NO".equals(((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(n))).getValue())) {
                    ((CustomerParameterImpl)comparable).addRestriction((ParameterRestriction)this.restNoPsu.get(new Integer(n)));
                    if (this.getRbs().getRbsStep().equals("STEP_EXPANSION")) {
                        ((ParameterRestriction)this.restPowSupplyModifyPsu.get(new Integer(n))).setActive(true);
                        ((CustomerParameterImpl)comparable).setLoadedValue("0");
                        ((CustomerParameterImpl)comparable).setDefaultValue("0");
                        ((CustomerParameterImpl)comparable).setValue("0");
                    }
                } else {
                    ((CustomerParameterImpl)comparable).removeRestriction((ParameterRestriction)this.restNoPsu.get(new Integer(n)));
                    ((ParameterRestriction)this.restPowSupplyModifyPsu.get(new Integer(n))).setActive(false);
                }
                Integer n2 = this.rbs.isSiteWiz() ? new Integer(((ArrayList)this.psuMap.get(new Integer(n))).size()) : ((IntegerRange)this.psuRange.get(new Integer(n))).getMinValue();
                this.psuRange.put(new Integer(n), new IntegerRange(n2, ((IntegerRange)this.psuRange.get(new Integer(n))).getMaxValue()));
                ((CustomerParameterImpl)comparable).addRestriction(new ParameterRestriction("Cannot delete existing PSUs", (IntegerRange)this.psuRange.get(new Integer(n)), true));
            }
            if (this.pduRange.get(new Integer(n)) == null) continue;
            comparable = this.rbs.isSiteWiz() ? new Integer(((ArrayList)this.pduMap.get(new Integer(n))).size()) : ((IntegerRange)this.pduRange.get(new Integer(n))).getMinValue();
            this.pduRange.put(new Integer(n), new IntegerRange((Integer)comparable, ((IntegerRange)this.pduRange.get(new Integer(n))).getMaxValue()));
            ((NoOfPduParameter)this.noPduCustParamList.get(new Integer(n))).addRestriction(new ParameterRestriction("Cannot delete existing PDUs", (IntegerRange)this.pduRange.get(new Integer(n)), true));
        }
    }

    private void addRestrictionsForBatteryBackupCPs() throws BemException {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            if (null != this.batteryTypeParam.get(new Integer(i))) {
                ((BatteryTypeParameter)this.batteryTypeParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryType.get(new Integer(i)));
                ((BatteryTypeParameter)this.batteryTypeParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryTypeOptional.get(new Integer(i)));
            }
            ((MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restMultiplePowerSystem.get(new Integer(i)));
            ((MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restMultiplePowerSystemOptional.get(new Integer(i)));
            if (null != this.batteryInstallationDateParam.get(new Integer(i))) {
                ((StringParameter)this.batteryInstallationDateParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryInstallationDate.get(new Integer(i)));
                ((StringParameter)this.batteryInstallationDateParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryTypeOptional.get(new Integer(i)));
                ((StringParameter)this.batteryInstallationDateParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            }
            if (null != this.batteryManager.get(new Integer(i))) {
                IntegerRange integerRange = ((BatteryManager)this.batteryManager.get(new Integer(i))).getBfuRange();
                this.bfuRange.put(new Integer(i), integerRange);
                this.restRangeNoOfBfu.put(new Integer(i), new ParameterRestriction("Cannot delete existing BFUs", (IntegerRange)this.bfuRange.get(new Integer(i)), true));
                ((ParameterRestriction)this.restRangeNoOfBfu.get(new Integer(i))).setRange(integerRange, true);
            }
            if (null != this.noBfuCustParamList.get(new Integer(i))) {
                ((NoOfBfuParameter)this.noBfuCustParamList.get(new Integer(i))).addRestriction((ParameterRestriction)this.restRangeNoOfBfu.get(new Integer(i)));
                ((NoOfBfuParameter)this.noBfuCustParamList.get(new Integer(i))).addRestriction((ParameterRestriction)this.restNoBfu.get(new Integer(i)));
                ((NoOfBfuParameter)this.noBfuCustParamList.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            }
            ((TrueFalseCustomerParameter)this.sharedBatteryParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryBackupAttributes.get(new Integer(i)));
            ((Enumeration)this.chargingModeParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryBackupAttributes.get(new Integer(i)));
            ((Enumeration)this.testModeParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryBackupAttributes.get(new Integer(i)));
            ((IntegerParameter)this.minimumBackupTimeParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryBackupAttributes.get(new Integer(i)));
            ((IntegerParameter)this.minimumStateOfHealthParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryBackupAttributes.get(new Integer(i)));
            ((IntegerParameter)this.testStartDayParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryBackupAttributes.get(new Integer(i)));
            ((StringParameter)this.testStartTimeParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryBackupAttributes.get(new Integer(i)));
            ((TrueFalseCustomerParameter)this.sharedBatteryParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((Enumeration)this.chargingModeParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((Enumeration)this.testModeParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.minimumBackupTimeParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.minimumStateOfHealthParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.testStartDayParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((StringParameter)this.testStartTimeParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            for (int j = 0; j < 12; ++j) {
                ((YesNoCustomerParameter)((HashMap)this.testStartMonthParam.get(new Integer(i))).get(new Integer(j))).addRestriction((ParameterRestriction)this.restBatteryBackupAttributes.get(new Integer(i)));
                ((YesNoCustomerParameter)((HashMap)this.testStartMonthParam.get(new Integer(i))).get(new Integer(j))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            }
        }
    }

    private void setRestrictionsForBatteryBackupCPs(boolean bl, int n) {
        if (!bl) {
            ((ParameterRestriction)this.restBatteryType.get(new Integer(n))).setActive(true);
            ((ParameterRestriction)this.restBatteryTypeOptional.get(new Integer(n))).setActive(true);
            ((ParameterRestriction)this.restBatteryInstallationDate.get(new Integer(n))).setActive(true);
            ((ParameterRestriction)this.restNoBfu.get(new Integer(n))).setActive(true);
            ((ParameterRestriction)this.restBatteryBackupAttributes.get(new Integer(n))).setActive(true);
        } else if (this.confBatteryBackupCustParam.get(new Integer(n)) != null && ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(n))).getValue().equals("YES")) {
            ((ParameterRestriction)this.restBatteryType.get(new Integer(n))).setActive(false);
            ((ParameterRestriction)this.restBatteryTypeOptional.get(new Integer(n))).setActive(true);
            ((ParameterRestriction)this.restBatteryInstallationDate.get(new Integer(n))).setActive(false);
            ((ParameterRestriction)this.restRangeNoOfBfu.get(new Integer(n))).setActive(true);
            ((ParameterRestriction)this.restNoBfu.get(new Integer(n))).setActive(false);
            ((ParameterRestriction)this.restBatteryBackupAttributes.get(new Integer(n))).setActive(false);
            this.setRestrictionForSharedBattery(n);
            this.setRestrictionForTestMode(n);
            this.setRestrictionForChargingMode(n);
        } else {
            ((ParameterRestriction)this.restBatteryType.get(new Integer(n))).setActive(true);
            ((ParameterRestriction)this.restBatteryTypeOptional.get(new Integer(n))).setActive(false);
            ((ParameterRestriction)this.restBatteryInstallationDate.get(new Integer(n))).setActive(true);
            if (null != this.restRangeNoOfBfu.get(new Integer(n))) {
                ((ParameterRestriction)this.restRangeNoOfBfu.get(new Integer(n))).setActive(false);
            }
            ((ParameterRestriction)this.restNoBfu.get(new Integer(n))).setActive(true);
            ((ParameterRestriction)this.restBatteryBackupAttributes.get(new Integer(n))).setActive(true);
        }
    }

    private void addRestrictionForStateOfHealthParam() {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            ((IntegerParameter)this.minimumStateOfHealthParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restMinimumStateOfHealth.get(new Integer(i)));
        }
    }

    private void setRestrictionForSharedBattery(int n) {
        if (((TrueFalseCustomerParameter)this.sharedBatteryParam.get(new Integer(n))).getValue().equals("TRUE")) {
            ((ParameterRestriction)this.restMinimumStateOfHealth.get(new Integer(n))).setActive(true);
            ((ParameterRestriction)this.restMinimumBackupTime.get(new Integer(n))).setActive(false);
        } else {
            ((ParameterRestriction)this.restMinimumStateOfHealth.get(new Integer(n))).setActive(false);
            ((ParameterRestriction)this.restMinimumBackupTime.get(new Integer(n))).setActive(true);
        }
    }

    private void setRestrictionForTestMode(int n) {
        Enumeration enumeration = (Enumeration)this.testModeParam.get(new Integer(n));
        if ((Integer)enumeration.getValueMom() == 1) {
            ((ParameterRestriction)this.restTestModeRelatedCPs.get(new Integer(n))).setActive(false);
        } else {
            ((ParameterRestriction)this.restTestModeRelatedCPs.get(new Integer(n))).setActive(true);
        }
    }

    private void setRestrictionForChargingMode(int n) {
        Enumeration enumeration = (Enumeration)this.chargingModeParam.get(new Integer(n));
        if ((Integer)enumeration.getValueMom() == 1) {
            ((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(n))).setActive(false);
        } else {
            ((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(n))).setActive(true);
        }
    }

    private void addRestrictionsForTestModeRelatedCPs() {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            ((IntegerParameter)this.testStartDayParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restTestModeRelatedCPs.get(new Integer(i)));
            ((StringParameter)this.testStartTimeParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restTestModeRelatedCPs.get(new Integer(i)));
            for (int j = 0; j < 12; ++j) {
                ((YesNoCustomerParameter)((HashMap)this.testStartMonthParam.get(new Integer(i))).get(new Integer(j))).addRestriction((ParameterRestriction)this.restTestModeRelatedCPs.get(new Integer(i)));
            }
            ((IntegerParameter)this.minimumBackupTimeParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restTestModeRelatedCPs.get(new Integer(i)));
            ((IntegerParameter)this.minimumStateOfHealthParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restTestModeRelatedCPs.get(new Integer(i)));
        }
    }

    private void addRestrictionForChargingModeRelatedCPs() {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            ((IntegerParameter)this.valueChargingVoltageParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.valueTempCompVoltageSlopParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.valueNominalTempParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.valueTempCompMinVoltageParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.valueTempCompMaxVoltageParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.valueIncreasedChargeVoltageParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.valueBoostChargeTimeParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.valueBoostChargeTriggerVoltageParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.valueEqualizeChargeTimeParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.valueEqualizeChargeCyclicIntervalParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.valueIntermittentChargeConnectVoltageParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.valueIntermittentChargeConnectTimeParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.valueIntermittentChargeDisconnectTimeParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
            ((IntegerParameter)this.valueChargingVoltageParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(i)));
            ((IntegerParameter)this.valueTempCompVoltageSlopParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(i)));
            ((IntegerParameter)this.valueNominalTempParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(i)));
            ((IntegerParameter)this.valueTempCompMinVoltageParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(i)));
            ((IntegerParameter)this.valueTempCompMaxVoltageParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(i)));
            ((IntegerParameter)this.valueIncreasedChargeVoltageParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(i)));
            ((IntegerParameter)this.valueBoostChargeTimeParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(i)));
            ((IntegerParameter)this.valueBoostChargeTriggerVoltageParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(i)));
            ((IntegerParameter)this.valueEqualizeChargeTimeParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(i)));
            ((IntegerParameter)this.valueEqualizeChargeCyclicIntervalParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(i)));
            ((IntegerParameter)this.valueIntermittentChargeConnectVoltageParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(i)));
            ((IntegerParameter)this.valueIntermittentChargeConnectTimeParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(i)));
            ((IntegerParameter)this.valueIntermittentChargeDisconnectTimeParameter.get(new Integer(i))).addRestriction((ParameterRestriction)this.restChargingModeRelatedCPs.get(new Integer(i)));
        }
    }

    private void addRestrictionForMinimumBackupTime() {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            ((IntegerParameter)this.minimumBackupTimeParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restMinimumBackupTime.get(new Integer(i)));
        }
    }

    protected void setCustomerParameterListeners() {
        this.supportSystemControlCustParam.addCustomerParameterListener(this);
        this.climateRegulationSystemCustParam.addCustomerParameterListener(this);
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            ((MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(new Integer(i))).addCustomerParameterListener(this);
            ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i))).addCustomerParameterListener(this);
            ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(i))).addCustomerParameterListener(this);
            ((BatteryTypeParameter)this.batteryTypeParam.get(new Integer(i))).addCustomerParameterListener(this);
            ((TrueFalseCustomerParameter)this.sharedBatteryParam.get(new Integer(i))).addCustomerParameterListener(this);
            ((Enumeration)this.testModeParam.get(new Integer(i))).addCustomerParameterListener(this);
            ((Enumeration)this.chargingModeParam.get(new Integer(i))).addCustomerParameterListener(this);
            ((ClimateSystem)this.climateSystemCustParam.get(new Integer(i))).addCustomerParameterListener(this);
            ((SmokeDetectorParameter)this.smokeDetectorParam.get(new Integer(i))).addCustomerParameterListener(this);
        }
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isValueChanged()) {
            String string = customerParameter.getName();
            for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
                String string2;
                NoOfPsuParameter noOfPsuParameter = (NoOfPsuParameter)this.noPsuCustParamList.get(new Integer(i));
                NoOfPduParameter noOfPduParameter = (NoOfPduParameter)this.noPduCustParamList.get(new Integer(i));
                if ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i)) != null && string.equalsIgnoreCase(((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i))).getName())) {
                    string2 = ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i))).getValue();
                    if ("YES".equalsIgnoreCase(string2)) {
                        if (this.rbs.getRbsStep().equals("STEP_EXPANSION")) {
                            ((ParameterRestriction)this.restPowSupplyModifyPsu.get(new Integer(i))).setActive(false);
                        }
                        if (noOfPsuParameter == null) continue;
                        noOfPsuParameter.removeRestriction((ParameterRestriction)this.restNoPsu.get(new Integer(i)));
                        noOfPsuParameter.addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
                        continue;
                    }
                    if (this.rbs.getRbsStep().equals("STEP_EXPANSION")) {
                        ((ParameterRestriction)this.restPowSupplyModifyPsu.get(new Integer(i))).setActive(true);
                    }
                    if (noOfPsuParameter == null) continue;
                    noOfPsuParameter.addRestriction((ParameterRestriction)this.restNoPsu.get(new Integer(i)));
                    noOfPsuParameter.removeRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
                    continue;
                }
                if (this.supportSystemControlCustParam != null && string.equalsIgnoreCase(this.supportSystemControlCustParam.getName())) {
                    string2 = this.supportSystemControlCustParam.getValue();
                    if ("FALSE".equalsIgnoreCase(string2)) {
                        if (this.climateSystemCustParam.get(new Integer(i)) != null) {
                            ((ClimateSystem)this.climateSystemCustParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restClimateSystem.get(new Integer(i)));
                        }
                        this.climateRegulationSystemCustParam.addRestriction((ParameterRestriction)this.restClimateRegulationSystem.get(new Integer(i)));
                        if ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i)) != null) {
                            ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restPowerSupplyIgnored.get(new Integer(i)));
                        }
                        if (this.smokeDetectorParam.get(new Integer(i)) != null) {
                            ((SmokeDetectorParameter)this.smokeDetectorParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restSmokeDetectorIgnored.get(new Integer(i)));
                        }
                        if (this.confBatteryBackupCustParam.get(new Integer(i)) != null) {
                            ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restBatteryIgnored.get(new Integer(i)));
                        }
                        if (noOfPduParameter != null) {
                            noOfPduParameter.addRestriction((ParameterRestriction)this.restNoPdu.get(new Integer(i)));
                            noOfPduParameter.removeRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
                        }
                        if (noOfPsuParameter != null) {
                            noOfPsuParameter.addRestriction((ParameterRestriction)this.restNoPsu.get(new Integer(i)));
                            noOfPsuParameter.removeRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
                        }
                        if ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i)) != null) {
                            ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i))).removeRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
                        }
                        if (this.confBatteryBackupCustParam.get(new Integer(i)) != null) {
                            ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(i))).removeRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
                        }
                        this.setRestrictionsForBatteryBackupCPs(false, i);
                        continue;
                    }
                    if (this.climateSystemCustParam.get(new Integer(i)) != null) {
                        ((ClimateSystem)this.climateSystemCustParam.get(new Integer(i))).removeRestriction((ParameterRestriction)this.restClimateSystem.get(new Integer(i)));
                    }
                    this.climateRegulationSystemCustParam.removeRestriction((ParameterRestriction)this.restClimateRegulationSystem.get(new Integer(i)));
                    if ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i)) != null) {
                        ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i))).removeRestriction((ParameterRestriction)this.restPowerSupplyIgnored.get(new Integer(i)));
                    }
                    if (this.smokeDetectorParam.get(new Integer(i)) != null) {
                        ((SmokeDetectorParameter)this.smokeDetectorParam.get(new Integer(i))).removeRestriction((ParameterRestriction)this.restSmokeDetectorIgnored.get(new Integer(i)));
                    }
                    if (this.confBatteryBackupCustParam.get(new Integer(i)) != null) {
                        ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(i))).removeRestriction((ParameterRestriction)this.restBatteryIgnored.get(new Integer(i)));
                    }
                    if (noOfPduParameter != null) {
                        noOfPduParameter.removeRestriction((ParameterRestriction)this.restNoPdu.get(new Integer(i)));
                        noOfPduParameter.addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
                    }
                    if (noOfPsuParameter != null) {
                        noOfPsuParameter.removeRestriction((ParameterRestriction)this.restNoPsu.get(new Integer(i)));
                        noOfPsuParameter.addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
                    }
                    if ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i)) != null) {
                        ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
                    }
                    if (this.confBatteryBackupCustParam.get(new Integer(i)) != null) {
                        ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(i))).addRestriction((ParameterRestriction)this.restOptional.get(new Integer(i)));
                    }
                    this.setRestrictionsForBatteryBackupCPs(true, i);
                    continue;
                }
                if (this.confBatteryBackupCustParam.get(new Integer(i)) != null && string.equalsIgnoreCase(((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(i))).getName())) {
                    this.setRestrictionsForBatteryBackupCPs(this.supportSystemControlCustParam.getBooleanValue(), i);
                    continue;
                }
                if (this.sharedBatteryParam.get(new Integer(i)) != null && string.equalsIgnoreCase(((TrueFalseCustomerParameter)this.sharedBatteryParam.get(new Integer(i))).getName())) {
                    this.setRestrictionForSharedBattery(i);
                    continue;
                }
                if (this.testModeParam.get(new Integer(i)) != null && string.equalsIgnoreCase(((Enumeration)this.testModeParam.get(new Integer(i))).getName())) {
                    this.setRestrictionForTestMode(i);
                    continue;
                }
                if (this.chargingModeParam.get(new Integer(i)) == null || !string.equalsIgnoreCase(((Enumeration)this.chargingModeParam.get(new Integer(i))).getName())) continue;
                this.setRestrictionForChargingMode(i);
            }
        }
    }

    public List getRIsToUninstall() throws BemException {
        if (!this.isOpen) {
            throw new BemException("getRIsToBeUnInstalled : CI not open");
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = null;
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            int n;
            String string;
            NoOfPsuParameter noOfPsuParameter = (NoOfPsuParameter)this.noPsuCustParamList.get(new Integer(i));
            NoOfBfuParameter noOfBfuParameter = (NoOfBfuParameter)this.noBfuCustParamList.get(new Integer(i));
            NoOfPduParameter noOfPduParameter = (NoOfPduParameter)this.noPduCustParamList.get(new Integer(i));
            if (null != (PowerSupplyManager)this.powerSupplyManager.get(new Integer(i)) && noOfPsuParameter.getValue() != "##UNDEFINED") {
                string = noOfPsuParameter.getValue();
                n = Integer.parseInt(string);
                arrayList2 = ((PowerSupplyManager)this.powerSupplyManager.get(new Integer(i))).getRIsToUninstall(n, (ArrayList)this.psuMap.get(new Integer(i)));
                arrayList.addAll(arrayList2);
            }
            if (null != this.batteryManager.get(new Integer(i)) && ((BatteryManager)this.batteryManager.get(new Integer(i))).isBatterySupported() && noOfBfuParameter.getValue() != "##UNDEFINED") {
                string = noOfBfuParameter.getValue();
                n = Integer.parseInt(string);
                arrayList2 = ((BatteryManager)this.batteryManager.get(new Integer(i))).getRIsToUninstall(n, (ArrayList)this.bfuMap.get(new Integer(i)));
                arrayList.addAll(arrayList2);
            }
            if (null == this.powerDistributionManager.get(new Integer(i)) || noOfPduParameter.getValue() == "##UNDEFINED") continue;
            string = noOfPduParameter.getValue();
            n = Integer.parseInt(string);
            arrayList2 = ((PowerDistributionManager)this.powerDistributionManager.get(new Integer(i))).getRIsToUninstall(n, (ArrayList)this.pduMap.get(new Integer(i)));
            arrayList.addAll(arrayList2);
        }
        if (this.hasSupportControlUnit()) {
            arrayList2 = this.climateManager.getRIsToBeUnInstalled();
            arrayList.addAll(arrayList2);
        }
        arrayList.addAll(this.supportSystemManager.getRIsToUninstall());
        arrayList.addAll(this.hwGroupRIs);
        return arrayList;
    }

    public ArrayList getNeededRIs() throws BemException {
        if (!this.isOpen) {
            throw new BemException("getRIsToBeInstalled: CI not open");
        }
        ArrayList arrayList = new ArrayList();
        this.checkConsistency();
        arrayList.addAll(this.supportSystemManager.getRIsToBeInstalled());
        String string = this.supportSystemControlCustParam.getValue();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        if (string.equalsIgnoreCase("TRUE")) {
            ArrayList arrayList2;
            String string2;
            if (((PowerSupplyManager)this.powerSupplyManager.get(new Integer(0))).isPowerSupplySupported()) {
                string2 = ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(0))).getValue();
                bl = string2.equalsIgnoreCase("YES");
                String string3 = ((NoOfPsuParameter)this.noPsuCustParamList.get(new Integer(0))).getValue();
                n = Integer.parseInt(string3);
                arrayList2 = ((PowerSupplyManager)this.powerSupplyManager.get(new Integer(0))).getRIsToBeInstalled(bl, n, (ArrayList)this.psuMap.get(new Integer(0)));
                arrayList.addAll(arrayList2);
            }
            if (((PowerDistributionManager)this.powerDistributionManager.get(new Integer(0))).isPowerDistributionSupported()) {
                string2 = ((NoOfPduParameter)this.noPduCustParamList.get(new Integer(0))).getValue();
                n2 = Integer.parseInt(string2);
                arrayList2 = ((PowerDistributionManager)this.powerDistributionManager.get(new Integer(0))).getRIsToBeInstalled(true, n2, (ArrayList)this.pduMap.get(new Integer(0)));
                arrayList.addAll(arrayList2);
            }
            if (((BatteryManager)this.batteryManager.get(new Integer(0))).isBatterySupported()) {
                string2 = ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(0))).getValue();
                bl2 = string2.equalsIgnoreCase("YES");
                int n3 = Integer.parseInt(((NoOfBfuParameter)this.noBfuCustParamList.get(new Integer(0))).getValue());
                arrayList2 = ((BatteryManager)this.batteryManager.get(new Integer(0))).getRIsToBeInstalled(bl2, n3, (ArrayList)this.bfuMap.get(new Integer(0)));
                arrayList.addAll(arrayList2);
            }
        }
        if (string.equalsIgnoreCase("TRUE") && !DuwUtil.hasDualDuws()) {
            this.getAPCRIs4MultiCab(arrayList, "PSU");
            this.getAPCRIs4MultiCab(arrayList, "PDU");
            this.getAPCRIs4MultiCab(arrayList, "BFU");
        }
        this.climateManager.setBatteryInfoForClimate(((BatteryManager)this.batteryManager.get(new Integer(0))).isBatterySupported(), bl2);
        arrayList.addAll(this.climateManager.getRIsToBeInstalled());
        arrayList.addAll(this.hwGroupRIs);
        return arrayList;
    }

    private void getAPCRIs4MultiCab(ArrayList arrayList, String string) throws BemException {
        block4: {
            block5: {
                block3: {
                    if (!string.equals("PSU")) break block3;
                    boolean bl = false;
                    for (int i = 1; i < this.rbs.getNoOfCabinets(); ++i) {
                        NoOfPsuParameter noOfPsuParameter;
                        String string2 = this.rbs.getCabinetNumberList().get(i).toString();
                        if (PowerSystemUtil.isContainDelCabinetCp(this.rbs, Integer.parseInt(string2)) || (noOfPsuParameter = (NoOfPsuParameter)this.noPsuCustParamList.get(new Integer(i))) == null || noOfPsuParameter.getValue().equals("0") || noOfPsuParameter.getValue().equals("##UNDEFINED") || !((PowerSupplyManager)this.powerSupplyManager.get(new Integer(i))).isPowerSupplySupported()) continue;
                        String string3 = ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(i))).getValue();
                        bl = string3.equalsIgnoreCase("YES");
                        String string4 = noOfPsuParameter.getValue();
                        int n = Integer.parseInt(string4);
                        ArrayList arrayList2 = ((PowerSupplyManager)this.powerSupplyManager.get(new Integer(i))).getRIsToBeInstalled(bl, n, (ArrayList)this.psuMap.get(new Integer(i)));
                        this.setUnitInfo4MulCab(arrayList2, string2);
                        arrayList.addAll(arrayList2);
                    }
                    break block4;
                }
                if (!string.equals("PDU")) break block5;
                for (int i = 1; i < this.rbs.getNoOfCabinets(); ++i) {
                    String string5 = this.rbs.getCabinetNumberList().get(i).toString();
                    if (PowerSystemUtil.isContainDelCabinetCp(this.rbs, Integer.parseInt(string5)) || this.noPduCustParamList.get(new Integer(i)) == null || ((NoOfPduParameter)this.noPduCustParamList.get(new Integer(i))).getValue().equals("##UNDEFINED") || !((PowerDistributionManager)this.powerDistributionManager.get(new Integer(i))).isPowerDistributionSupported()) continue;
                    String string6 = ((NoOfPduParameter)this.noPduCustParamList.get(new Integer(i))).getValue();
                    int n = Integer.parseInt(string6);
                    ArrayList arrayList3 = ((PowerDistributionManager)this.powerDistributionManager.get(new Integer(i))).getRIsToBeInstalled(true, n, (ArrayList)this.pduMap.get(new Integer(i)));
                    this.setUnitInfo4MulCab(arrayList3, string5);
                    arrayList.addAll(arrayList3);
                }
                break block4;
            }
            if (!string.equals("BFU")) break block4;
            boolean bl = false;
            for (int i = 1; i < this.rbs.getNoOfCabinets(); ++i) {
                String string7 = this.rbs.getCabinetNumberList().get(i).toString();
                if (PowerSystemUtil.isContainDelCabinetCp(this.rbs, Integer.parseInt(string7)) || this.noBfuCustParamList.get(new Integer(i)) == null || ((NoOfBfuParameter)this.noBfuCustParamList.get(new Integer(i))).getValue().equals("##UNDEFINED") || !((BatteryManager)this.batteryManager.get(new Integer(i))).isBatterySupported()) continue;
                String string8 = ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(i))).getValue();
                bl = string8.equalsIgnoreCase("YES");
                int n = Integer.parseInt(((NoOfBfuParameter)this.noBfuCustParamList.get(new Integer(i))).getValue());
                ArrayList arrayList4 = ((BatteryManager)this.batteryManager.get(new Integer(i))).getRIsToBeInstalled(bl, n, (ArrayList)this.bfuMap.get(new Integer(i)));
                this.setUnitInfo4MulCab(arrayList4, string7);
                arrayList.addAll(arrayList4);
            }
        }
    }

    private void setUnitInfo4MulCab(ArrayList arrayList, String string) throws BemException {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ResourceItem resourceItem = (ResourceItem)iterator.next();
            if (!(resourceItem instanceof AbstractHwUnitWithEcPortRI)) continue;
            ((AbstractHwUnitWithEcPortRI)resourceItem).setUnitNumbe4MulCab(string);
            String string2 = MessageFormat.format("CAB{0}_", Integer.valueOf(string));
            IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "ecBusNumber");
            ((AbstractHwUnitWithEcPortRI)resourceItem).setEcBusNo4MulCab(integerParameter.getValue());
        }
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        boolean bl = true;
        if (serviceValue.getValue("noOfPsu") == null || serviceValue.getValue("noOfPdu") == null) {
            return false;
        }
        try {
            this.open();
            this.checkConsistency();
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException("AbstractPowerSystemCI.open(sv) got exception=" + exception.toString());
        }
        return bl;
    }

    public final String getName() {
        return name;
    }

    private IntegerRange getNoOfPsuRange() {
        int n = ((PowerSupplyManager)this.powerSupplyManager.get(new Integer(0))).getNumberOfPsus();
        return new IntegerRange(new Integer(1), new Integer(n));
    }

    protected IntegerRange getNoOfPduRange() {
        int n = ((PowerDistributionManager)this.powerDistributionManager.get(new Integer(0))).getNumberOfPdus();
        return new IntegerRange(new Integer(1), new Integer(n));
    }

    protected IntegerRange getNoOfPduRange4Cabinet6601() {
        int[] nArray = new int[]{7, 8, 9, 10};
        IntegerRange integerRange = new IntegerRange(new Integer(0), new Integer(4));
        boolean bl = true;
        PowerDistributionManager powerDistributionManager = new PowerDistributionManager(this.rbs, nArray, integerRange, bl);
        int n = powerDistributionManager.getNumberOfPdus();
        return new IntegerRange(new Integer(1), new Integer(n));
    }

    private IntegerRange getNoOfBfuRange() {
        int n = ((BatteryManager)this.batteryManager.get(new Integer(0))).getNumberOfBfus();
        return new IntegerRange(new Integer(1), new Integer(n));
    }

    protected abstract void setDefaultParameterValues() throws BemException;

    protected abstract SupportSystemManager getSupportSystemManager() throws BemException;

    protected abstract PowerSupplyManager getPowerSupplyManager() throws BemException;

    protected abstract PowerDistributionManager getPowerDistributionManager() throws BemException;

    protected abstract BatteryManager getBatteryManager() throws BemException;

    protected abstract ClimateManager getClimateManager() throws BemException;

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        int n;
        this.checkCabinetCustomerParameter(serviceValue);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.climateRegulationSystemCustParam.getName());
        for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
            arrayList.add(((MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(new Integer(n))).getName());
            arrayList.add(((ClimateSystem)this.climateSystemCustParam.get(new Integer(n))).getName());
            arrayList.add(((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(new Integer(n))).getName());
            arrayList.add(((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(new Integer(n))).getName());
            arrayList.add(((Enumeration)this.chargingModeParam.get(new Integer(n))).getName());
            arrayList.add(((BatteryTypeParameter)this.batteryTypeParam.get(new Integer(n))).getName());
            arrayList.add(((TrueFalseCustomerParameter)this.sharedBatteryParam.get(new Integer(n))).getName());
            arrayList.add(((Enumeration)this.testModeParam.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.minimumBackupTimeParam.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.minimumStateOfHealthParam.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.testStartDayParam.get(new Integer(n))).getName());
            arrayList.add(((StringParameter)this.testStartTimeParam.get(new Integer(n))).getName());
            arrayList.add(((StringParameter)this.batteryInstallationDateParam.get(new Integer(n))).getName());
            arrayList.add(((SmokeDetectorParameter)this.smokeDetectorParam.get(new Integer(n))).getName());
            for (int i = 0; i < 12; ++i) {
                arrayList.add(((YesNoCustomerParameter)((HashMap)this.testStartMonthParam.get(new Integer(n))).get(new Integer(i))).getName());
            }
            arrayList.add(((IntegerParameter)this.valueChargingVoltageParameter.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.valueTempCompVoltageSlopParameter.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.valueNominalTempParameter.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.valueTempCompMinVoltageParameter.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.valueTempCompMaxVoltageParameter.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.valueIncreasedChargeVoltageParameter.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.valueBoostChargeTimeParameter.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.valueBoostChargeTriggerVoltageParameter.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.valueEqualizeChargeTimeParameter.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.valueEqualizeChargeCyclicIntervalParameter.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.valueIntermittentChargeConnectVoltageParameter.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.valueIntermittentChargeConnectTimeParameter.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.valueIntermittentChargeDisconnectTimeParameter.get(new Integer(n))).getName());
            NoOfPsuParameter noOfPsuParameter = (NoOfPsuParameter)this.noPsuCustParamList.get(new Integer(n));
            if (noOfPsuParameter != null) {
                arrayList.add(noOfPsuParameter.getName());
            }
            if (this.noPduCustParamList.get(new Integer(n)) != null) {
                arrayList.add(((NoOfPduParameter)this.noPduCustParamList.get(new Integer(n))).getName());
            }
            if (this.noBfuCustParamList.get(new Integer(n)) != null) {
                arrayList.add(((NoOfBfuParameter)this.noBfuCustParamList.get(new Integer(n))).getName());
            }
            arrayList.add(((IntegerParameter)this.optionalEquipmentcabinetNoParam.get(new Integer(n))).getName());
        }
        arrayList.add(this.supportSystemControlCustParam.getName());
        for (n = 0; n < 7; ++n) {
            arrayList.add(this.ecBusconnectorUnitNumberParam[n].getName());
            arrayList.add(this.ecBusNoParam[n].getName());
            arrayList.add(this.ModEcBusNoParam[n].getName());
            arrayList.add(this.ModEcBusconnectorUnitNumberParam[n].getName());
            arrayList.add(this.ModEcBusNoParam[n].getName());
            arrayList.add(this.ModEcBusconnectorUnitNumberParam[n].getName());
        }
        for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
            arrayList.add(((IntegerParameter)this.cabinetNumberParam.get(new Integer(n))).getName());
            arrayList.add(((StringParameter)this.sharedCabinetIdentifierParam.get(new Integer(n))).getName());
            arrayList.add(((IntegerParameter)this.cabEcBusNoParam.get(new Integer(n))).getName());
            arrayList.add(((Enumeration)this.cabinetTypeParam.get(new Integer(n))).getName());
        }
        for (n = 1; n < this.rbs.getNoOfCabinets(); ++n) {
            arrayList.add(((IntegerParameter)this.delCabinetNumberParam.get(new Integer(n))).getName());
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        super.setCustomerParametersFromSV(stringArray, serviceValue);
        this.setCustomerParametersForHwGroupFromSV(serviceValue);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public ConfigurationCheckReport checkConfiguration() {
        return null;
    }

    public boolean isConfPowerSupplySupported() {
        return this.psuRange != null;
    }

    public boolean isConfPowerDistributionSupported() {
        return this.pduRange != null;
    }

    public boolean hasSupportControlUnit() {
        boolean bl = this.climateManager.hasSupportControlUnit();
        return bl;
    }

    public boolean isSupportSystemAvailable() {
        boolean bl = this.supportSystemManager.isSupportSystemAvailable();
        return bl;
    }

    void createParameters() throws Exception {
        this.createAllCustomerParameters();
    }

    void setManager(Object object) {
        if (object instanceof BatteryManager) {
            this.batteryManager.put(new Integer(0), (BatteryManager)object);
        } else if (object instanceof ClimateManager) {
            this.climateManager = (ClimateManager)object;
        } else if (object instanceof PowerDistributionManager) {
            this.powerDistributionManager.put(new Integer(0), (PowerDistributionManager)object);
        } else if (object instanceof PowerSupplyManager) {
            this.powerSupplyManager.put(new Integer(0), (PowerSupplyManager)object);
        } else if (object instanceof SupportSystemManager) {
            this.supportSystemManager = (SupportSystemManager)object;
        }
    }

    void setOpen() {
        this.isOpen = true;
    }

    void setPsuRange(IntegerRange integerRange) {
        this.psuRange.put(new Integer(0), integerRange);
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            int n = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
            String string = MessageFormat.format("CAB{0}_", new Integer(n));
            YesNoCustomerParameter yesNoCustomerParameter = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject(string + "configureBatteryBackup");
            if (!yesNoCustomerParameter.getValue().equalsIgnoreCase("YES")) continue;
            this.checkTestStartTimeFormat(n);
            this.checkTestStartMonthsAndDay(n);
            this.checkChargingMode(n);
            this.checkBatteryInstallationDate(n);
            this.checkMultiplePowerSystem(n);
        }
    }

    private void checkCabinetCustomerParameter(ServiceValue serviceValue) throws BemException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.getCabinetOfRbs(arrayList, arrayList2, "CAB{0}_");
        this.getCabinetOfServiceValueAndValidate(arrayList, arrayList2, serviceValue);
        this.checkEcBusConsistency(serviceValue);
    }

    private void checkEcBusConsistency(ServiceValue serviceValue) throws BemException {
        for (int i = 1; i < this.rbs.getNoOfCabinets(); ++i) {
            String string;
            String string2;
            int n = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
            String string3 = MessageFormat.format("EcBus{0}_", new Integer(n));
            String string4 = serviceValue.getValue(string3 + "ecBusNumber");
            if (string4 != null) {
                boolean bl = false;
                string2 = serviceValue.getAttribute(string3 + "ecBusNumber").getServiceName();
                IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string3 + "ecBusNumber");
                if (null != integerParameter && !integerParameter.getValue().equals("##UNDEFINED")) {
                    bl = true;
                }
                if (string2 != null && bl && (string2.equals("EcBus") || string2.equals("AddEcBus"))) {
                    throw new BemException("Ecbus_" + string4 + " has existed, can not be added!");
                }
            }
            if ((string2 = serviceValue.getValue((string = MessageFormat.format("ModEcBus{0}_", new Integer(n))) + "ecBusNumber")) == null) continue;
            boolean bl = false;
            String string5 = serviceValue.getAttribute(string + "ecBusNumber").getServiceName();
            IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string3 + "ecBusNumber");
            if (null != integerParameter && !integerParameter.getValue().equals("##UNDEFINED")) {
                bl = true;
            }
            if (string5 == null || bl || !string5.equals("ModifyEcBus")) continue;
            throw new BemException("Ecbus_" + string2 + " has not existed, can not be modified!");
        }
    }

    private void getCabinetOfRbs(List arrayList, List arrayList2, String string) throws BemException {
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
        }
        if (null == arrayList2) {
            arrayList2 = new ArrayList<String>();
        }
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            StringParameter stringParameter;
            int n = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
            String string2 = MessageFormat.format(string, new Integer(n));
            IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "cabinetNumber");
            if (null != integerParameter && !integerParameter.getValue().equals("##UNDEFINED")) {
                arrayList.add(integerParameter.getValue());
            }
            if (null == (stringParameter = (StringParameter)this.rbs.getCustomerParameterObject(string2 + "sharedCabinetIdentifier")) || stringParameter.getValue().equals("")) continue;
            arrayList2.add(stringParameter.getValue());
        }
    }

    private void getCabinetOfServiceValueAndValidate(List list, List list2, ServiceValue serviceValue) throws BemException {
        int n;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        if (list2.size() == 0) {
            for (n = 0; n < list.size(); ++n) {
                hashMap.put((String)list.get(n), "");
            }
        } else {
            for (n = 0; n < list.size(); ++n) {
                hashMap.put((String)list.get(n), (String)list2.get(n));
            }
        }
        for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
            String string;
            String string2;
            int n2 = Integer.parseInt(this.rbs.getCabinetNumberList().get(n).toString());
            String string3 = MessageFormat.format("CAB{0}_", new Integer(n2));
            String string4 = serviceValue.getValue(string3 + "cabinetNumber");
            String string5 = serviceValue.getValue(string3 + "sharedCabinetIdentifier");
            if (null != string4) {
                string2 = serviceValue.getAttribute(string3 + "cabinetNumber").getServiceName();
                string = string5 == null ? "" : string5;
                boolean bl = false;
                if ("AddCabinet".equals(string2)) {
                    arrayList.add(string4);
                    if (hashMap.containsKey(string4)) {
                        throw new BemException("Cabinet_" + string4 + " has existed, can not be added!");
                    }
                } else if ("ModifyCabinet".equals(string2)) {
                    arrayList3.add(string4);
                    if (!hashMap.containsKey(string4)) {
                        throw new BemException("Cabinet_" + string4 + " has not existed, can not be modified!");
                    }
                    if (string5 == null) {
                        bl = true;
                    }
                }
                if (!bl) {
                    hashMap.put(string4, string);
                }
            }
            if (null != string5 && !"".equals(string5)) {
                string2 = serviceValue.getAttribute(string3 + "cabinetNumber").getServiceName();
                if ("AddCabinet".equals(string2)) {
                    arrayList2.add(string5);
                } else if ("ModifyCabinet".equals(string2)) {
                    arrayList4.add(string5);
                }
            }
            if (null == (string = serviceValue.getValue((string2 = MessageFormat.format("DCAB{0}_", new Integer(n2))) + "cabinetNumber"))) continue;
            arrayList5.add(string);
            if (!hashMap.containsKey(string)) {
                throw new BemException("Cabinet_" + string + " has not existed, can not be deleted!");
            }
            hashMap.remove(string);
        }
        this.checkSharedId(hashMap);
        this.checkCabinetList(serviceValue, arrayList, arrayList3, arrayList4, arrayList5);
    }

    private void checkSharedId(Map map) throws BemException {
        Collection collection = map.values();
        Iterator iterator = collection.iterator();
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if ("".equals(string)) {
                ++n;
                continue;
            }
            if (hashSet.add(string)) continue;
            throw new BemException("SharedCabinetIdentifier must be all empty or all configured different value!");
        }
        if (n != 0 && n != map.size()) {
            throw new BemException("SharedCabinetIdentifier must be all empty or all configured different value!");
        }
    }

    private void checkCabinetList(ServiceValue serviceValue, List list, List list2, List list3, List list4) throws BemException {
        String string = ((TrueFalseCustomerParameter)this.rbs.getCustomerParameterObject("supportSystemControl")).getValue();
        if (serviceValue.getValue("supportSystemControl") != null) {
            string = serviceValue.getValue("supportSystemControl");
        }
        if (!list2.isEmpty()) {
            for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
                String string2;
                String string3;
                int n = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
                String string4 = MessageFormat.format("CAB{0}_", new Integer(n));
                if (string.equalsIgnoreCase("TRUE")) {
                    if (!list2.contains(Integer.toString(n)) || (string3 = serviceValue.getValue(string4 + "ecBusNumber")) == null) continue;
                    string2 = MessageFormat.format("EcBus{0}_", Integer.valueOf(string3));
                    String string5 = serviceValue.getValue(string2 + "connectorUnitNumber");
                    if (string5 != null) {
                        String string6 = this.climateManager.getSectorNumber(string5);
                        String string7 = MessageFormat.format("S{0}_", string6);
                        String string8 = serviceValue.getValue(string7 + "deleteSector");
                        String string9 = serviceValue.getValue(string7 + "cabinetNumber");
                        boolean bl = false;
                        boolean bl2 = false;
                        if (string8 != null && !string8.equals("")) {
                            bl = true;
                        }
                        if (string9 != null && string9.equals(String.valueOf(i + 1))) {
                            bl2 = true;
                        }
                        if (bl2 || !bl && this.climateManager.isIruInCabinet(i, string5)) continue;
                        throw new BemException("ecBusNumber can not be modified. ecBusConnectorRef IRU of EcBus " + string3 + " is not in cabinet " + n + ".");
                    }
                    if (this.climateManager.isIruInCabinet(i, Integer.valueOf(string3) - 1)) continue;
                    throw new BemException("ecBusNumber can not be modified. ecBusConnectorRef IRU of EcBus " + string3 + " is not in cabinet " + n + ".");
                }
                string3 = serviceValue.getValue(string4 + "climateSystem");
                string2 = serviceValue.getValue(string4 + "smokeDetector");
                if (null == string3 && null == string2) continue;
                throw new BemException("supportSystemControl is false, climateSystem and smokeDetector can not be modified!");
            }
        }
        if (!list4.isEmpty()) {
            this.isDelCabinetUseByRUorDU(list4);
        }
    }

    private void isDelCabinetUseByRUorDU(List list) throws BemException {
        if (null != list) {
            Iterator iterator = list.iterator();
            MoInstance moInstance = this.rbs.getMoiRefs().getEquipmentMoi();
            while (iterator.hasNext()) {
                Object[] objectArray;
                String string = (String)iterator.next();
                String string2 = new FixedRdnMoi(moInstance, MimCabinet.MOTYPENAME, String.valueOf(string)).getLdn();
                BemMo bemMo = this.rbs.getMoHandler().getMo(string2);
                if (null == bemMo || !bemMo.isExisting()) continue;
                try {
                    objectArray = (Object[])this.getRbs().getMoHandler().getAttribute(bemMo, "reservedBy");
                }
                catch (MoHandlerException moHandlerException) {
                    throw new BemException(moHandlerException);
                }
                if (objectArray == null || objectArray.length <= 0 || !(objectArray instanceof BemMo[])) continue;
                BemMo[] bemMoArray = (BemMo[])objectArray;
                for (int i = 0; i < bemMoArray.length; ++i) {
                    if (!bemMoArray[i].getType().equals(MimPlugInUnit.MOTYPENAME) && !bemMoArray[i].getType().equals(MimAuxPlugInUnit.MOTYPENAME)) continue;
                    throw new BemException("Cabinet_" + string + " can not be deleted, " + bemMoArray[i].getDN() + " is used now!");
                }
            }
        }
    }

    public void checkChargingMode(int n) throws BemException {
        if (((BatteryTypeParameter)this.batteryTypeParam.get(new Integer(n - 1))).getValue().equals("UNKNOWN") && ((Enumeration)this.chargingModeParam.get(new Integer(n - 1))).getValue().equals("AUTOMATIC")) {
            throw new BemException("batteryType = UNKNOWN is valid only when chargingMode = USER_DEFINED");
        }
    }

    public void checkConsistency(List list) throws CustomerParameterException, BemException {
        super.checkConsistency(list);
        this.checkConsistency();
    }

    private boolean isLeapYear(String string) {
        int n = Integer.parseInt(string);
        return n % 100 == 0 && n % 400 == 0 || n % 100 != 0 && n % 4 == 0;
    }

    private boolean checkStringDateFormat(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        int n2 = 0;
        string2 = string;
        string3 = string2.substring(0, 4);
        string4 = string2.substring(4, 6);
        string5 = string2.substring(6, 8);
        n = Integer.parseInt(string5);
        n2 = Integer.parseInt(string4);
        if (n2 > 12 || n2 < 1) {
            return false;
        }
        return !(string4.equals("01") || string4.equals("03") || string4.equals("05") || string4.equals("07") || string4.equals("08") || string4.equals("10") || string4.equals("12") ? n > 31 || n < 1 : (string4.equals("02") ? (this.isLeapYear(string3) ? n > 29 || n < 1 : n > 28 || n < 1) : !(!string4.equals("04") && !string4.equals("06") && !string4.equals("09") && !string4.equals("11") || n <= 30 && n >= 1)));
    }

    private void checkBatteryInstallationDate(int n) throws BemException {
        String string = MessageFormat.format("CAB{0}_", new Integer(n));
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string + "batteryInstallationDate");
        String string2 = (String)customerParameterServer.getValueMom();
        if (string2.equals(MimBatteryBackup.DEFAULT_BATTERYINSTALLATIONDATE)) {
            return;
        }
        if (!this.checkStringDateFormat(string2)) {
            throw new BemException("batteryInstallationDate: " + string2 + " is not valid");
        }
        int n2 = Integer.parseInt(string2.substring(0, 4));
        int n3 = Integer.parseInt(string2.substring(4, 6));
        int n4 = Integer.parseInt(string2.substring(6, 8));
        Calendar calendar = Calendar.getInstance();
        int n5 = calendar.get(1);
        int n6 = calendar.get(2) + 1;
        int n7 = calendar.get(5);
        if (n2 > n5 || n2 == n5 && n3 > n6 || n2 == n5 && n3 == n6 && n4 > n7) {
            throw new BemException("batteryInstallationDate " + string2 + " must not be a future date. " + "Current system date is: " + n5 + n6 + n7);
        }
    }

    private boolean checkTimeFormat(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        int n2 = 0;
        string2 = string;
        string3 = string2.substring(0, 2);
        string4 = string2.substring(3, 5);
        n = Integer.parseInt(string3);
        n2 = Integer.parseInt(string4);
        if (n > 23 || n2 > 59) {
            return false;
        }
        return string2.subSequence(2, 3).equals(":");
    }

    private void checkTestStartTimeFormat(int n) throws BemException {
        String string = MessageFormat.format("CAB{0}_", new Integer(n));
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string + "testStartTime");
        String string2 = (String)customerParameterServer.getValueMom();
        if (!this.checkTimeFormat(string2)) {
            throw new BemException("testStartTime: " + string2 + " is invalid.");
        }
    }

    private void checkTestStartMonthsAndDay(int n) throws BemException {
        String string = MessageFormat.format("CAB{0}_", new Integer(n));
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string + "testStartDay");
        int n2 = (Integer)customerParameterServer.getValueMom();
        int n3 = Calendar.getInstance().get(1);
        YesNoCustomerParameter yesNoCustomerParameter = (YesNoCustomerParameter)this.rbs.getCustomerParameterServerObject(string + "testStartMonths" + 2);
        if (yesNoCustomerParameter.getValue().equalsIgnoreCase("YES") && (n3 % 4 == 0 && n2 > 29 || n3 % 4 != 0 && n2 > 28)) {
            throw new BemException("Feb " + n2 + " is an invalid date");
        }
        if (n2 > 30) {
            YesNoCustomerParameter yesNoCustomerParameter2 = (YesNoCustomerParameter)this.rbs.getCustomerParameterServerObject(string + "testStartMonths" + 4);
            YesNoCustomerParameter yesNoCustomerParameter3 = (YesNoCustomerParameter)this.rbs.getCustomerParameterServerObject(string + "testStartMonths" + 6);
            YesNoCustomerParameter yesNoCustomerParameter4 = (YesNoCustomerParameter)this.rbs.getCustomerParameterServerObject(string + "testStartMonths" + 9);
            YesNoCustomerParameter yesNoCustomerParameter5 = (YesNoCustomerParameter)this.rbs.getCustomerParameterServerObject(string + "testStartMonths" + 11);
            if (yesNoCustomerParameter2.getValue().equalsIgnoreCase("YES") || yesNoCustomerParameter3.getValue().equalsIgnoreCase("YES") || yesNoCustomerParameter4.getValue().equalsIgnoreCase("YES") || yesNoCustomerParameter5.getValue().equalsIgnoreCase("YES")) {
                throw new BemException((yesNoCustomerParameter2.getValue().equalsIgnoreCase("YES") ? "Apr " + n2 + " " : "") + (yesNoCustomerParameter3.getValue().equalsIgnoreCase("YES") ? "Jun " + n2 + " " : "") + (yesNoCustomerParameter4.getValue().equalsIgnoreCase("YES") ? "Sep " + n2 + " " : "") + (yesNoCustomerParameter5.getValue().equalsIgnoreCase("YES") ? "Nov " + n2 + " " : "") + "is invalid date. ");
            }
        }
    }

    private void checkMultiplePowerSystem(int n) throws BemException {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            int n2 = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
            if (n2 != n) continue;
            String string = ((MultiplePowerSystemParameter)this.multiplePowerSystemCustParam.get(new Integer(i))).getValue();
            if (RbsInfo.RBS_6110W.NAME.equals(this.rbs.getRbsType()) || RbsInfo.RBS_6120W.NAME.equals(this.rbs.getRbsType()) || RbsInfo.RBS_6131W.NAME.equals(this.rbs.getRbsType())) {
                Integer n3 = new Integer(((NoOfBfuParameter)this.noBfuCustParamList.get(new Integer(i))).getValue());
                if (n3.compareTo(mimBfuNumberSupportParallelBfu) >= 0 || !string.equalsIgnoreCase("FALSE")) continue;
                throw new BemException("MultiplePowerSystem can not be " + string + " when BFU number < 2 ,your current BFU number is " + n3);
            }
            if (!string.equalsIgnoreCase("FALSE")) continue;
            throw new BemException("MultiplePowerSystem can not be " + string + " when RBS type is " + this.rbs.getRbsType());
        }
    }

    private boolean isDuwV2In6601() throws BemException {
        return DuwUtil.isDualDuwAndPrimaryIsV2() && RbsInfo.RBS_6601W.NAME.equals(this.rbs.getRbsType());
    }

    private void setCustomerParametersForHwGroup(String string, String string2) {
        Integer n = (Integer)this.hwGroupIdToIndex.get(string);
        if (null == n) {
            return;
        }
        StringParameter stringParameter = null;
        if (null != string) {
            stringParameter = (StringParameter)this.hwGroupIdParams.get(n);
            stringParameter.setValue(string);
        }
        if (null != string2) {
            stringParameter = (StringParameter)this.hwGroupPositionInfoParams.get(n);
            stringParameter.setValue(string2);
        }
    }

    protected void setCustomerParametersForHwGroupFromSV(ServiceValue serviceValue) throws BemException {
        String string;
        String string2;
        Vector vector = serviceValue.getAllAttributes();
        for (int i = 0; i < vector.size() && null != serviceValue.getAttribute(string2 = (string = PrefixUtil.getHwGroupPrefix(i)) + "hwGroupId"); ++i) {
            String string3 = serviceValue.getValue(string2);
            string2 = string + "positionInformation";
            String string4 = serviceValue.getValue(string2);
            this.createHwGroupResources(string3);
            this.setCustomerParametersForHwGroup(string3, string4);
        }
    }

    private void createHwGroupCP(int n) {
        StringRange stringRange = new StringRange(new Integer(1), new Integer(Integer.MAX_VALUE));
        StringRange stringRange2 = new StringRange(MimHwGroup.MINLEN_POSITIONINFORMATION, MimHwGroup.MAXLEN_POSITIONINFORMATION);
        ParameterRestriction parameterRestriction = new ParameterRestriction("", 3);
        ParameterRestriction parameterRestriction2 = new ParameterRestriction("", 2);
        String string = PrefixUtil.getHwGroupPrefix(n);
        String string2 = string + "hwGroupId";
        StringParameter stringParameter = new StringParameter(string2, stringRange);
        stringParameter.addRestriction(parameterRestriction);
        this.addParameter(stringParameter);
        this.hwGroupIdParams.add(stringParameter);
        string2 = string + "positionInformation";
        StringParameter stringParameter2 = new StringParameter(string2, stringRange2);
        stringParameter2.addRestriction(parameterRestriction2);
        stringParameter2.setDefaultValue(MimHwGroup.DEFAULT_POSITIONINFORMATION);
        this.addParameter(stringParameter2);
        this.hwGroupPositionInfoParams.add(stringParameter2);
    }

    private void createHwGroupMoi(String string) {
        if (null == string || string.length() <= 0) {
            return;
        }
        this.hwGroupMois.add(new FixedRdnMoi(this.rbs.getEquipmentMoi(), MimHwGroup.MOTYPENAME, string));
    }

    private void createHwGroupRI(int n) throws BemException {
        MoInstance moInstance = (MoInstance)this.hwGroupMois.get(n);
        HwGroupRI hwGroupRI = new HwGroupRI(this.rbs, moInstance.getLdn(), n);
        hwGroupRI.setLoadedValues();
        this.hwGroupRIs.add(hwGroupRI);
    }

    protected void createHwGroupResources(String string) throws BemException {
        if (null == string || string.length() <= 0 || this.hwGroupIdToIndex.containsKey(string)) {
            return;
        }
        int n = this.noOfHwGroups;
        this.hwGroupIdToIndex.put(string, new Integer(n));
        this.noOfHwGroups = n + 1;
        this.createHwGroupCP(n);
        this.createHwGroupMoi(string);
        this.createHwGroupRI(n);
    }

    protected void initialiseResourceForHwGroups() throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(this.rbs.getEquipmentMoi().getLdn());
        try {
            BemMo[] bemMoArray = moHandler.getChildren(bemMo, 1, MimHwGroup.MOTYPENAME, "");
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo2 = bemMoArray[i];
                String string = bemMo2.getId();
                this.createHwGroupResources(string);
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(this.getClass() + ".initialiseResourceForHwGroups()", (Throwable)moHandlerException);
        }
    }

    public int getNumberOfHwGroup() throws BemException {
        return this.noOfHwGroups;
    }

    private class NumberOfBfuListener
    implements CustomerParameterListener {
        int index;

        public NumberOfBfuListener(int n) {
            this.index = n;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            String string = customerParameter.getName();
            if (parameterEvent.isValueChanged() && string.equalsIgnoreCase(((NoOfBfuParameter)AbstractPowerSystemCI.this.noBfuCustParamList.get(new Integer(this.index))).getName())) {
                if (RbsInfo.RBS_6110W.NAME.equals(AbstractPowerSystemCI.this.rbs.getRbsType()) || RbsInfo.RBS_6120W.NAME.equals(AbstractPowerSystemCI.this.rbs.getRbsType()) || RbsInfo.RBS_6131W.NAME.equals(AbstractPowerSystemCI.this.rbs.getRbsType())) {
                    ((ParameterRestriction)AbstractPowerSystemCI.this.restMultiplePowerSystem.get(new Integer(this.index))).setActive(false);
                    ((ParameterRestriction)AbstractPowerSystemCI.this.restMultiplePowerSystemOptional.get(new Integer(this.index))).setActive(true);
                } else {
                    ((ParameterRestriction)AbstractPowerSystemCI.this.restMultiplePowerSystem.get(new Integer(this.index))).setActive(true);
                    ((ParameterRestriction)AbstractPowerSystemCI.this.restMultiplePowerSystemOptional.get(new Integer(this.index))).setActive(false);
                }
            }
        }
    }
}

