/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.AbstractEtmRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.resource.DuwBasedAtmRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.resource.DuwBasedIpRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExchangeTerminal;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExchangeTerminalIp;
import se.ericsson.wcdma.rbs.bem.common.moi.LdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class EtmBoardDuwCI
extends AbstractConfigurationItem
implements CustomerParameterListener,
EtmBoardProvider {
    public static final String name = "EtmBoardCI";
    private boolean isOpen = false;
    private final ArrayList etmBoardListenerList = new ArrayList();
    private static final String PRIMARY_DUW_SLOT_NUMBER = DuwUtil.getSlotNumberForPrimaryDuw();

    public EtmBoardDuwCI(Rbs rbs) {
        super(rbs);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            throw new BemException("AbstractEtmBoardCI.open(): Already open");
        }
        this.isOpen = true;
        return this.isOpen;
    }

    protected void setupEtmTypes(String[] stringArray) {
    }

    public String[] getAllSupportedSlots() {
        return new String[]{PRIMARY_DUW_SLOT_NUMBER};
    }

    public String getTypeForExistingBoard(String string) throws BemException {
        if (!string.equals(PRIMARY_DUW_SLOT_NUMBER)) {
            throw new BemException("Slot number " + string + " is not valid for ET configuration with DUW");
        }
        return EtmBoardProvider.ETM_TYPE_MAPING.DUW.PSEUDO;
    }

    public MoInstance getExchangeTerminalMoi(String string) throws BemException {
        String string2 = null;
        if (!string.equals(PRIMARY_DUW_SLOT_NUMBER)) {
            throw new BemException("Not valid Etb slot. slot=" + string + " should be " + PRIMARY_DUW_SLOT_NUMBER);
        }
        string2 = DuwUtil.getPrimaryExchangeTerminalLdn();
        LdnMoi ldnMoi = new LdnMoi(string2);
        return ldnMoi;
    }

    public String[] getSupportedEtmBoardTypesForAtm() {
        return new String[]{MimExchangeTerminal.MOTYPENAME};
    }

    public String getDisplayTypeFromEtmType(String string) {
        return null;
    }

    public String[] getSupportedEtmBoardTypesForIp() {
        return new String[]{MimExchangeTerminalIp.MOTYPENAME};
    }

    public void addEtmBoardListener(EtmBoardListener etmBoardListener) {
        this.etmBoardListenerList.add(etmBoardListener);
    }

    public ArrayList getNeededRIs() throws BemException {
        ArrayList arrayList = new ArrayList();
        if (!this.isOpen) {
            throw new BemException("EtmBoardCI is not open");
        }
        return arrayList;
    }

    public void setCustomerParameters(ServiceValue serviceValue) {
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
    }

    public String getName() {
        return name;
    }

    public List getEtmCapableBoards() {
        ArrayList<AbstractEtmRI> arrayList = new ArrayList<AbstractEtmRI>();
        int n = 1;
        Rbs rbs = super.getRbs();
        DuwBasedAtmRI duwBasedAtmRI = new DuwBasedAtmRI(rbs, n);
        DuwBasedIpRI duwBasedIpRI = new DuwBasedIpRI(rbs, n);
        arrayList.add(duwBasedAtmRI);
        arrayList.add(duwBasedIpRI);
        return arrayList;
    }

    public MoInstance getExchangeTerminalIpMoi() {
        return new LdnMoi(DuwUtil.getPrimaryExchangeTerminalIpLdn());
    }

    public String[] getAllPossibleEtmBoards() {
        return null;
    }

    public String[] getAllPossibleEtmBoardsForSlot(String string) {
        return null;
    }
}

