/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.AtmIpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.AtmSubnetMaskParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAtmLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpOam;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class IpAtmLinkRI
extends AbstractResourceItem {
    public static final String NAME = "IpAtmLink";
    private static final String[] myInstallationPhases = new String[]{"IpAtmLinkCreationPhase", "IpAtmLinkDeletionPhase"};
    private static final int DEFAULT = 0;
    private static final int REDUNDANT = 1;
    private static final String IPADDRESS = "ipAddress";
    private static final String SUBNETMASK = "subnetMask";
    private static final String AAL5TPVCCTPID = "aal5TpVccTpId";
    private int linkId = 0;
    private final String[] rdnId = new String[]{"1", "2"};
    private final int[] METRIC_DEFAULT_VALUE = new int[]{100, 110};
    private String linkLdn;
    private MoInstance linkMoi;
    private AtmIpAddressParameter atmIpAddrParam = null;
    private AtmSubnetMaskParameter atmSubMaskParam = null;
    private String loadedAal5TpVccTpId = null;
    private String aal5TpVccTpId = null;

    public IpAtmLinkRI(Rbs rbs, AtmIpAddressParameter atmIpAddressParameter, AtmSubnetMaskParameter atmSubnetMaskParameter, int n) throws BemException {
        super(NAME, rbs, myInstallationPhases);
        this.atmIpAddrParam = atmIpAddressParameter;
        this.atmIpAddrParam.setDefaultValue("");
        this.atmSubMaskParam = atmSubnetMaskParameter;
        this.atmSubMaskParam.setDefaultValue("255.255.255.252");
        this.linkId = n;
        SingleChildMoi singleChildMoi = new SingleChildMoi(rbs.getRootMoi(), MimIpOam.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimIp.MOTYPENAME, "1");
        if (n != 0 && n != 1) {
            throw new BemException("Faulty link id: " + n);
        }
        this.linkMoi = new FixedRdnMoi(singleChildMoi2, MimIpAtmLink.MOTYPENAME, this.rdnId[n]);
        this.linkLdn = this.linkMoi.getLdn();
        this.readAllAttributes();
    }

    private void readAllAttributes() throws BemException {
        if (this.isExisting()) {
            BemMo bemMo = (BemMo)this.getAttribute(this.getMo(this.linkLdn), AAL5TPVCCTPID);
            this.aal5TpVccTpId = this.loadedAal5TpVccTpId = bemMo.getDN();
            this.atmIpAddrParam.setLoadedValue((String)this.getAttribute(this.getMo(this.linkLdn), IPADDRESS));
            this.atmSubMaskParam.setLoadedValue((String)this.getAttribute(this.getMo(this.linkLdn), SUBNETMASK));
        }
    }

    public String getLdn() {
        return this.linkLdn;
    }

    public MoInstance getIpAtmLinkMoi() {
        return this.linkMoi;
    }

    public boolean isExisting() throws BemException {
        return super.isExisting(this.linkLdn);
    }

    public String getLoadedAal5TpVccTpId() {
        return this.loadedAal5TpVccTpId;
    }

    public void setAal5TpVccTpId(String string) {
        this.aal5TpVccTpId = string;
    }

    public void install(String string) throws BemException {
        if (string.equals("IpAtmLinkCreationPhase")) {
            if (!this.isExisting()) {
                this.createIpAtmLink();
            } else {
                this.changeAttributes();
            }
        }
    }

    private void createIpAtmLink() throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue(IPADDRESS, this.atmIpAddrParam.getValue()));
        vector.add(Nal.getFactory().getNameValue(SUBNETMASK, this.atmSubMaskParam.getValue()));
        vector.add(Nal.getFactory().getNameValue("metric", new Integer(this.METRIC_DEFAULT_VALUE[this.linkId])));
        vector.add(Nal.getFactory().getNameValue(AAL5TPVCCTPID, this.getMo(this.aal5TpVccTpId)));
        this.createMoIfNotExisting(this.linkLdn, vector);
    }

    private void changeAttributes() throws BemException {
        if (this.isIpAddressOrSubnetMaskChanged()) {
            String string = this.atmIpAddrParam.getValue();
            String string2 = this.atmSubMaskParam.getValue();
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue(IPADDRESS, string), Nal.getFactory().getNameValue(SUBNETMASK, string2)};
            BemMo bemMo = this.getMo(this.linkLdn);
            this.action(bemMo, "assignIpAddress", nalNameValueArray);
        }
    }

    public boolean isIpAddressOrSubnetMaskChanged() throws BemException {
        boolean bl = false;
        if (this.isExisting()) {
            String string = this.atmIpAddrParam.getLoadedValue();
            String string2 = this.atmSubMaskParam.getLoadedValue();
            String string3 = this.atmIpAddrParam.getValue();
            String string4 = this.atmSubMaskParam.getValue();
            bl = !string3.equals(string) || !string4.equals(string2);
        }
        return bl;
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("IpAtmLinkDeletionPhase")) {
            this.deleteMoIfNotExisting(this.linkLdn);
        }
    }

    public String getDisplayName() {
        return this.getName();
    }
}

