/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply;

import java.util.Calendar;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimBattery;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class BatteryRI
extends AbstractResourceItem {
    public static final String name = "BATTERY";
    private static final String[] myInstallationPhases = new String[]{"PowerSystemCreationPhase"};
    private String ldn = null;
    private Integer batteryCapacity = MimBattery.DEFAULT_BATTERYCAPACITYDEFAULTVALUE;
    private static final String FREE_TEXT1 = "Battery Installed";

    public BatteryRI(Rbs rbs, MoInstance moInstance) throws BemException {
        super(name, rbs, myInstallationPhases);
        this.setupMoi(moInstance);
    }

    public void setupMoi(MoInstance moInstance) throws BemException {
        String string = "1";
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimBattery.MOTYPENAME, string);
        this.ldn = singleChildMoi.getLdn();
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "BATTERY: " + this.getLdn();
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.ldn);
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("batteryCapacityDefaultValue", this.batteryCapacity));
            vector.add(Nal.getFactory().getNameValue("freeText1", FREE_TEXT1));
            Calendar calendar = Calendar.getInstance();
            int n = calendar.get(1);
            int n2 = calendar.get(2) + 1;
            int n3 = calendar.get(5);
            String string2 = "" + n + "-" + n2 + "-" + n3;
            vector.add(Nal.getFactory().getNameValue("freeDate1", string2));
            super.createMoIfNotExisting(this.ldn, vector);
            String string3 = "CAB1_batteryCapacity";
            CustomerParameter customerParameter = this.getRbs().getCustomerParameterObject(string3);
            if (customerParameter.hasValueChanged()) {
                String string4 = customerParameter.getValue();
                this.setBatteryCapacity(string4);
            }
        }
    }

    public void setBatteryCapacity(String string) throws BemException {
        if (string.equals("##UNDEFINED")) {
            return;
        }
        Integer n = new Integer(string);
        try {
            this.batteryCapacity = n;
            if (this.isInstalled()) {
                MoHandler moHandler = this.getRbs().getMoHandler();
                BemMo bemMo = moHandler.getMo(this.ldn);
                moHandler.setAttribute(bemMo, "batteryCapacityDefaultValue", n);
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string2 = moHandlerException.getAction();
            String string3 = moHandlerException.getLdn();
            String string4 = moHandlerException.getAdditionalInfo();
            throw new BemException(string2, "BatteryRI setBatteryCapacity()", string3, string4, moHandlerException);
        }
    }

    public String getBatteryCapacity() throws BemException {
        String string = this.batteryCapacity.toString();
        try {
            if (this.isInstalled()) {
                MoHandler moHandler = this.getRbs().getMoHandler();
                BemMo bemMo = moHandler.getMo(this.ldn);
                Integer n = (Integer)moHandler.getAttribute(bemMo, "batteryCapacityDefaultValue");
                string = n.toString();
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string2 = moHandlerException.getAction();
            String string3 = moHandlerException.getLdn();
            String string4 = moHandlerException.getAdditionalInfo();
            throw new BemException(string2, "BatteryRI getBatteryCapacity()", string3, string4, moHandlerException);
        }
        return string;
    }
}

