/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.AccuNpuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.AccuSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;

public class AccuManager {
    private Rbs rbs;
    private boolean isAccuSupported;
    private String cabinetPosition;
    private String subrackPosition;
    private ArrayList listOfRIs;
    private AccuNpuRI accuNpuRI;
    private AccuSubrackRI accuSubrackRI;

    public AccuManager(Rbs rbs, boolean bl, String string, String string2) throws BemException {
        this.cabinetPosition = string;
        this.subrackPosition = string2;
        this.rbs = rbs;
        this.isAccuSupported = bl;
        this.listOfRIs = new ArrayList(0);
        this.createRIs();
    }

    private void createRIs() throws BemException {
        MoInstance moInstance = this.rbs.getEquipmentMoi();
        if (this.isAccuSupported) {
            this.accuSubrackRI = new AccuSubrackRI(this.rbs, this.cabinetPosition, this.subrackPosition, moInstance);
            MoInstance moInstance2 = this.accuSubrackRI.getMoi();
            this.accuNpuRI = new AccuNpuRI(this.rbs, moInstance2);
            this.listOfRIs.add(this.accuSubrackRI);
            this.listOfRIs.add(this.accuNpuRI);
        }
    }

    public ArrayList getRIsToBeInstalled() {
        return this.listOfRIs;
    }

    public boolean isAccuSupported() {
        return this.isAccuSupported;
    }
}

