/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.check.ReportEntry;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.BatteryCapacityParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.BatteryRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.ConfigureBatteryBackupParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.ConfigurePowerSupplyParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.NoOfPsuParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.PowerSupplySystemRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.BfSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.BfuFilterSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.BfuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.CluRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.FcuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.PowerSupplySubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.PsuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.PowerSupplyProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsData;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRbsSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimBattery;
import se.ericsson.wcdma.rbs.bem.common.mim.MimBfuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimFcuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPsuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSlot;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.ChildWithAttributeValues;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public abstract class AbstractPowerSupplyCI
extends AbstractConfigurationItem
implements CustomerParameterListener,
PowerSupplyProvider {
    public static final String name = "PowerSystemCI";
    protected RbsData rbsData = null;
    protected Integer[] cabinetParameters = null;
    protected boolean fcuConfigurable = false;
    protected ChildWithAttributeValues auxpiuFcuMoi;
    protected MoInstance equipmentMoi;
    protected SingleChildMoi fcuMoi;
    protected int[] psuSlots = new int[0];
    protected int bfuSlot = -1;
    protected PowerSupplySubrackRI powerSupplySubrackRI = null;
    protected TreeMap psuRIs = new TreeMap();
    protected BfuRI bfuRI = null;
    protected FcuRI fcuRI = null;
    protected CluRI cluRI;
    protected BfSubrackRI bfSubrackRI = null;
    protected BfuFilterSubrackRI bfuSubrackRI = null;
    protected PowerSupplySystemRI powerSupplySystemRI = null;
    protected BatteryRI batteryRI = null;
    protected NoOfPsuParameter noPsuCustParam = null;
    protected ConfigurePowerSupplyParameter confPowerSupplyCustParam = null;
    protected ConfigureBatteryBackupParameter confBatteryBackupCustParam = null;
    protected BatteryCapacityParameter batteryCapacityCustParam = null;
    protected ParameterRestriction restMandatory = new ParameterRestriction("", 3);
    protected ParameterRestriction restOptional = new ParameterRestriction("", 2);
    protected ParameterRestriction restIgnored = new ParameterRestriction("", 1);
    protected ParameterRestriction restNoPsu = new ParameterRestriction("PSUs are not needed when no power supply is selected", 1);
    protected IntegerRange psuRange = this.getPsuRange();
    protected ParameterRestriction restRangeNoOfPsu = new ParameterRestriction("Cannot delete existing PSUs", this.psuRange, true);
    protected String[] allowedValueYes = new String[]{"YES"};
    protected EnumeratedRange allowedRangeYes = new EnumeratedRange(this.allowedValueYes);
    protected ParameterRestriction restIntPowSupplyMandatory = new ParameterRestriction("Internal power supply is mandatory for this RBS type", this.allowedRangeYes, true);
    protected ParameterRestriction restIntPowSupplyNoDelete = new ParameterRestriction("Cannot delete an existing power supply", 0);
    protected String[] allowedValueNo = new String[]{"NO"};
    protected EnumeratedRange allowedRangeNo = new EnumeratedRange(this.allowedValueNo);
    protected ParameterRestriction restExtPowerNoSupport = new ParameterRestriction("External power supply is not supported for this RBS type", this.allowedRangeNo, true);
    protected ParameterRestriction restExtPowerNoDelete = new ParameterRestriction("Cannot delete an existing power supply", 0);
    protected ParameterRestriction restBatteryNoDelete = new ParameterRestriction("Cannot delete an existing battery", 0);
    protected ParameterRestriction restBatteryIgnored = new ParameterRestriction("Battery not supported", 1);
    protected ParameterRestriction restBatteryNoSupport = new ParameterRestriction("Configuration of Battery not supported", this.allowedRangeNo, true);
    protected ParameterRestriction restConfBatteryNoSupport = new ParameterRestriction("Configuration of Battery not supported, when Configure Power Supply = NO", this.allowedRangeNo, true);
    protected ParameterRestriction restBatteryCapacityIgnored = new ParameterRestriction("Battery Capacity read only", 1);
    protected ParameterRestriction restBatteryCapacityDefaultRange = new ParameterRestriction("Range for BatteryCapacity", new IntegerRange(MimBattery.MIN_BATTERYCAPACITYDEFAULTVALUE, MimBattery.MAX_BATTERYCAPACITYDEFAULTVALUE), true);
    private int auHubType = 1;
    private boolean isOpen = false;
    private boolean createPowerSupply = true;

    public AbstractPowerSupplyCI(Rbs rbs) {
        super(rbs);
    }

    public AbstractPowerSupplyCI(Rbs rbs, boolean bl) {
        super(rbs);
        this.createPowerSupply = false;
    }

    public AbstractPowerSupplyCI(Rbs rbs, int n) {
        super(rbs);
        this.auHubType = n;
    }

    protected void setPsuSlots(int[] nArray) {
        this.psuSlots = nArray;
    }

    protected void setBfuSlot(int n) {
        this.bfuSlot = n;
    }

    public boolean open() throws BemException {
        boolean bl = true;
        try {
            if (this.isOpen) {
                throw new BemException("AbstractPowerSupplyCI.open(): Already open");
            }
            this.initializeMoiResources();
            this.createAllRIs();
            this.createAllCustomerParameters();
            this.setDefaultParameterValues();
            this.updateLoadedValues();
            this.setCustomerParameterRestrictions();
            this.setCustomerParameterListeners();
            this.isOpen = true;
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException("AbstractPowerSupplyCI.open() got exception=" + exception.toString());
        }
        return bl;
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        boolean bl = true;
        if (serviceValue.getValue("noOfPsu") == null) {
            return false;
        }
        try {
            this.open();
            this.checkConsistency();
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException("AbstractPowerSupplyCI.open(sv) got exception=" + exception.toString());
        }
        return bl;
    }

    public void setCustomerParameterRestrictions() throws BemException {
        String string = this.confPowerSupplyCustParam.getValue();
        if (this.isConfPowerSupplySupported()) {
            if (string.equals("NO")) {
                this.noPsuCustParam.addRestriction(this.restNoPsu);
                this.confBatteryBackupCustParam.addRestriction(this.restConfBatteryNoSupport);
            } else {
                this.noPsuCustParam.removeRestriction(this.restNoPsu);
                this.confBatteryBackupCustParam.removeRestriction(this.restConfBatteryNoSupport);
            }
            int n = this.countInstalledPsus(this.psuRIs);
            if (n > 0) {
                Integer n2 = this.getPsuRange().getMaxValue();
                Integer n3 = this.getPsuRange().getMinValue();
                String string2 = super.getRbs().getRbsStep();
                if (string2.equals("STEP_SITE")) {
                    n3 = new Integer(n);
                }
                IntegerRange integerRange = new IntegerRange(n3, n2);
                this.restRangeNoOfPsu.setRange(integerRange, true);
                this.noPsuCustParam.addRestriction(this.restRangeNoOfPsu);
            }
            this.batteryCapacityCustParam.addRestriction(this.restBatteryCapacityDefaultRange);
        } else {
            this.noPsuCustParam.addRestriction(this.restIgnored);
            this.confPowerSupplyCustParam.addRestriction(this.restIgnored);
            this.confBatteryBackupCustParam.addRestriction(this.restIgnored);
            this.batteryCapacityCustParam.addRestriction(this.restIgnored);
        }
    }

    public String getName() {
        return name;
    }

    private void createAllCustomerParameters() throws BemException {
        this.confPowerSupplyCustParam = new ConfigurePowerSupplyParameter();
        String string = this.getRbs().getRbsStep();
        String string2 = "CAB1_configureBatteryBackup";
        String string3 = "CAB1_batteryCapacity";
        String string4 = "CAB1_noOfPsu";
        if (string.equals("STEP_SITE")) {
            string3 = "CAB1_batteryCapacity";
            string4 = "CAB1_noOfPsu";
        } else if (string.equals("STEP_EXPANSION")) {
            string4 = "CAB1_noOfPsu";
        }
        this.confBatteryBackupCustParam = new ConfigureBatteryBackupParameter(string2);
        this.batteryCapacityCustParam = new BatteryCapacityParameter(string3);
        IntegerRange integerRange = this.getNoOfPsuRange();
        this.noPsuCustParam = new NoOfPsuParameter(string4, integerRange);
        this.addParameter(this.noPsuCustParam);
        this.addParameter(this.confPowerSupplyCustParam);
        this.addParameter(this.confBatteryBackupCustParam);
        this.addParameter(this.batteryCapacityCustParam);
    }

    private IntegerRange getNoOfPsuRange() {
        int n;
        int n2 = n = this.psuSlots.length;
        return new IntegerRange(new Integer(1), new Integer(n2));
    }

    protected abstract void setDefaultParameterValues() throws BemException;

    protected abstract IntegerRange getPsuRange();

    protected abstract boolean isInternalPowerSupplyMandatory();

    protected abstract String getPowerSubrackPosition();

    protected abstract String getPowerSubrackCabinetPosition();

    protected void setCustomerParameterListeners() {
        this.confPowerSupplyCustParam.addCustomerParameterListener(this);
        this.confBatteryBackupCustParam.addCustomerParameterListener(this);
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isValueChanged()) {
            String string = customerParameter.getName();
            String string2 = this.confPowerSupplyCustParam.getValue();
            boolean bl = string2.equalsIgnoreCase("YES");
            if (string.equalsIgnoreCase(this.confPowerSupplyCustParam.getName())) {
                String string3 = this.confBatteryBackupCustParam.getValue();
                boolean bl2 = string3.equalsIgnoreCase("YES");
                if (bl) {
                    this.noPsuCustParam.removeRestriction(this.restNoPsu);
                    this.confBatteryBackupCustParam.removeRestriction(this.restConfBatteryNoSupport);
                    if (bl2) {
                        this.restBatteryCapacityIgnored.setActive(false);
                    } else {
                        this.restBatteryCapacityIgnored.setActive(true);
                    }
                } else {
                    this.noPsuCustParam.addRestriction(this.restNoPsu);
                    this.confBatteryBackupCustParam.addRestriction(this.restConfBatteryNoSupport);
                }
            } else if (string.equalsIgnoreCase(this.confBatteryBackupCustParam.getName())) {
                String string4 = customerParameter.getValue();
                boolean bl3 = string4.equalsIgnoreCase("YES");
                if (bl3) {
                    this.restBatteryCapacityIgnored.setActive(false);
                } else {
                    this.restBatteryCapacityIgnored.setActive(true);
                }
            }
        }
    }

    protected void updateBoards(int n) throws BemException {
        int n2;
        int n3;
        if (this.bfuRI != null) {
            n3 = this.bfuRI.getHubPosition();
            n2 = this.lookupHubPos(15, n3, n, 0);
            this.bfuRI.setHubPosition(n2);
        }
        if (this.cluRI != null) {
            n3 = this.cluRI.getHubPosition();
            n2 = this.lookupHubPos(16, n3, n, 0);
            this.cluRI.setHubPosition(n2);
        }
        for (int i = 0; i < this.psuSlots.length; ++i) {
            PsuRI psuRI = (PsuRI)this.psuRIs.get(new Integer(this.psuSlots[i]));
            if (psuRI == null) continue;
            n3 = psuRI.getHubPosition();
            n2 = this.lookupHubPos(14, n3, n, i + 1);
            psuRI.setHubPosition(n2);
        }
        if (this.fcuRI != null) {
            n3 = this.fcuRI.getHubPosition();
            n2 = this.lookupHubPos(13, n3, n, 0);
            this.fcuRI.setHubPosition(n2);
        }
        this.updateMoi(n);
    }

    protected void updateMoi(int n) throws BemException {
        block12: {
            block11: {
                MoInstance moInstance;
                if (n != 1) break block11;
                if (this.bfuRI != null && this.bfuSlot > 0) {
                    if (this.bfSubrackRI != null) {
                        this.bfuRI.updateMoi(this.bfSubrackRI.getMoiSlot(this.bfuSlot));
                    } else if (this.bfuSubrackRI != null) {
                        this.bfuRI.updateMoi(this.bfuSubrackRI.getMoiSlot(this.bfuSlot));
                    } else {
                        moInstance = this.powerSupplySubrackRI.getMoiSlot(this.bfuSlot);
                        this.bfuRI.updateMoi(moInstance);
                    }
                }
                for (int i = 0; i < this.psuSlots.length; ++i) {
                    moInstance = this.powerSupplySubrackRI.getMoiSlot(this.psuSlots[i]);
                    PsuRI psuRI = (PsuRI)this.psuRIs.get(new Integer(this.psuSlots[i]));
                    if (psuRI == null) continue;
                    psuRI.updateMoi(moInstance);
                }
                break block12;
            }
            if (n != 2) break block12;
            MoInstance moInstance = this.powerSupplySubrackRI.getMoiPsSubrack();
            if (this.bfuRI != null) {
                if (this.bfSubrackRI != null) {
                    this.bfuRI.updateMoi(this.bfSubrackRI.getMoiBfSubrack());
                } else {
                    this.bfuRI.changeMoi(moInstance);
                }
            }
            for (int i = 0; i < this.psuSlots.length; ++i) {
                PsuRI psuRI;
                if (this.bfuSubrackRI != null) {
                    psuRI = (PsuRI)this.psuRIs.get(new Integer(this.psuSlots[i]));
                    if (psuRI == null) continue;
                    psuRI.updateMoi(moInstance, this.bfuSlot);
                    continue;
                }
                psuRI = (PsuRI)this.psuRIs.get(new Integer(this.psuSlots[i]));
                if (psuRI == null) continue;
                psuRI.updateMoi(moInstance);
            }
        }
    }

    private int lookupHubPos(int n, int n2, int n3, int n4) {
        int n5 = n2;
        if (n3 == 1) {
            if (n == 15) {
                n5 = 24;
            } else if (n == 16) {
                n5 = 23;
            } else if (n == 13) {
                n5 = 30;
            } else if (n == 14 && n4 > 0) {
                switch (n4) {
                    case 1: {
                        n5 = 33;
                        break;
                    }
                    case 2: {
                        n5 = 34;
                        break;
                    }
                    case 3: {
                        n5 = 20;
                        break;
                    }
                    case 4: {
                        n5 = 21;
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (n3 == 2) {
            if (n == 15) {
                n5 = 12;
            } else if (n == 16) {
                n5 = 8;
            } else if (n == 13) {
                n5 = 0;
            } else if (n == 14 && n4 > 0) {
                switch (n4) {
                    case 1: {
                        n5 = 2;
                        break;
                    }
                    case 2: {
                        n5 = 10;
                        break;
                    }
                    case 3: {
                        n5 = 3;
                        break;
                    }
                    case 4: {
                        n5 = 11;
                        break;
                    }
                }
            }
        }
        return n5;
    }

    protected void initializeMoiResources() {
        Rbs rbs = this.getRbs();
        this.equipmentMoi = rbs.getEquipmentMoi();
        this.auxpiuFcuMoi = new ChildWithAttributeValues(this.equipmentMoi, MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(13), "2");
        this.fcuMoi = new SingleChildMoi(this.auxpiuFcuMoi, MimFcuDeviceGroup.MOTYPENAME, "1");
    }

    private void createAllRIs() throws BemException {
        this.createPowerSupplySystemRI(this.equipmentMoi);
        this.createPsSubrackRIs(this.equipmentMoi);
        this.createPsuRIs();
        this.createBfSubrackRI(this.equipmentMoi);
        this.createBfuRIs();
        this.createBatteryRI(this.equipmentMoi);
        this.createCluRI();
        this.createFcuRI();
    }

    protected void createFcuRI() throws BemException {
        if (this.fcuConfigurable) {
            this.rbsData = this.getRbs().getRbsData();
            this.rbsData.setFcuConfigurable(this.fcuConfigurable);
            this.rbsData.setFcuCabinetParameters(this.cabinetParameters);
            this.fcuRI = new FcuRI(super.getRbs(), this.cabinetParameters, this.fcuMoi.getLdn());
        }
    }

    protected void createPowerSupplySystemRI(MoInstance moInstance) throws BemException {
        this.powerSupplySystemRI = new PowerSupplySystemRI(this.getRbs(), moInstance);
    }

    protected void createPsSubrackRIs(MoInstance moInstance) throws BemException {
        this.powerSupplySubrackRI = new PowerSupplySubrackRI(this.getRbs(), this.getPowerSubrackCabinetPosition(), this.getPowerSubrackPosition(), moInstance);
    }

    protected void createPsuRIs() throws BemException {
        for (int i = 0; i < this.psuSlots.length; ++i) {
            Integer n = new Integer(this.psuSlots[i]);
            int n2 = n;
            MoInstance moInstance = this.powerSupplySubrackRI.getMoiSlot(n2);
            PsuRI psuRI = new PsuRI(this.getRbs(), this.psuSlots[i], moInstance);
            this.psuRIs.put(n, psuRI);
        }
    }

    protected abstract void createBfSubrackRI(MoInstance var1) throws BemException;

    protected abstract AbstractRbsSubrackRI getBfSubrackRI();

    protected abstract void createBfuRIs() throws BemException;

    protected void createCluRI() throws BemException {
        this.cluRI = null;
    }

    protected void createBatteryRI(MoInstance moInstance) throws BemException {
        this.batteryRI = new BatteryRI(this.getRbs(), moInstance);
    }

    public ArrayList getNeededRIs() throws BemException {
        ArrayList arrayList = this.getRIsToBeInstalled();
        return arrayList;
    }

    public ArrayList getRIsToBeInstalled() throws BemException {
        Object object;
        ArrayList<FcuRI> arrayList = new ArrayList<FcuRI>();
        if (!this.isOpen) {
            throw new BemException("getRIsToBeInstalled : CI not open");
        }
        this.checkConsistency();
        boolean bl = false;
        String string = null;
        String string2 = this.confBatteryBackupCustParam.getValue();
        bl = string2.equalsIgnoreCase("YES");
        if (bl) {
            string = this.batteryCapacityCustParam.getValue();
        }
        int n = 0;
        boolean bl2 = false;
        String string3 = this.confPowerSupplyCustParam.getValue();
        bl2 = string3.equalsIgnoreCase("YES");
        if (bl2) {
            object = this.noPsuCustParam.getValue();
            n = Integer.parseInt((String)object);
        }
        if (this.isConfPowerSupplySupported()) {
            object = this.getNeededPowerSupplySystemRIs(bl2, n, bl, string);
            arrayList.addAll((Collection<FcuRI>)object);
            object = this.getNeededPsSubrackRIs(bl2, n, bl, string);
            arrayList.addAll((Collection<FcuRI>)object);
            object = this.getNeededPsuRIs(bl2, n, bl, string);
            arrayList.addAll((Collection<FcuRI>)object);
            object = this.getNeededBfSubrackRIs();
            arrayList.addAll((Collection<FcuRI>)object);
            object = this.getNeededBfuRIs(bl2, bl);
            arrayList.addAll((Collection<FcuRI>)object);
            object = this.getNeededBatteryRIs(bl, string);
            arrayList.addAll((Collection<FcuRI>)object);
        }
        if (this.fcuConfigurable) {
            arrayList.add(this.fcuRI);
        }
        return arrayList;
    }

    public List getRIsToUninstall() throws BemException {
        ArrayList arrayList = new ArrayList();
        if (!this.isOpen) {
            throw new BemException("getRIsToBeUnInstalled : CI not open");
        }
        if (this.isConfPowerSupplySupported()) {
            String string = this.noPsuCustParam.getValue();
            int n = Integer.parseInt(string);
            int n2 = this.countInstalledPsus(this.psuRIs);
            int n3 = n2 - n;
            if (n3 > 0) {
                arrayList = this.getPsuRIsToBeUnInstalled(n3);
            }
        }
        return arrayList;
    }

    public ArrayList getPsuRIsToBeUnInstalled(int n) throws BemException {
        int n2;
        ArrayList<PsuRI> arrayList = new ArrayList<PsuRI>();
        Set set = this.psuRIs.keySet();
        Object[] objectArray = set.toArray();
        for (int i = n2 = objectArray.length - 1; i > 0; --i) {
            PsuRI psuRI = (PsuRI)this.psuRIs.get(objectArray[i]);
            if (n <= 0 || !psuRI.isInstalled()) continue;
            arrayList.add(psuRI);
            --n;
        }
        return arrayList;
    }

    protected ArrayList getNeededPowerSupplySystemRIs(boolean bl, int n, boolean bl2, String string) {
        ArrayList<PowerSupplySystemRI> arrayList = new ArrayList<PowerSupplySystemRI>();
        if (bl && this.createPowerSupply) {
            arrayList.add(this.powerSupplySystemRI);
        }
        return arrayList;
    }

    protected ArrayList getNeededPsSubrackRIs(boolean bl, int n, boolean bl2, String string) {
        ArrayList<PowerSupplySubrackRI> arrayList = new ArrayList<PowerSupplySubrackRI>();
        if (n > 0 && bl) {
            if (this.auHubType == 2) {
                this.powerSupplySubrackRI.setNoOfSlots(0);
            }
            arrayList.add(this.powerSupplySubrackRI);
        }
        return arrayList;
    }

    protected ArrayList getNeededPsuRIs(boolean bl, int n, boolean bl2, String string) {
        ArrayList<PsuRI> arrayList = new ArrayList<PsuRI>();
        TreeMap treeMap = null;
        if (bl) {
            treeMap = this.psuRIs;
        }
        if (treeMap != null) {
            Set set = treeMap.entrySet();
            Iterator iterator = set.iterator();
            for (int i = 0; i < n; ++i) {
                if (!iterator.hasNext()) continue;
                Map.Entry entry = iterator.next();
                PsuRI psuRI = (PsuRI)entry.getValue();
                arrayList.add(psuRI);
            }
        }
        return arrayList;
    }

    protected ArrayList getNeededBfSubrackRIs() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    protected ArrayList getNeededBfuRIs(boolean bl, boolean bl2) {
        ArrayList<BfuRI> arrayList = new ArrayList<BfuRI>();
        if (bl2 && bl) {
            arrayList.add(this.bfuRI);
        }
        return arrayList;
    }

    protected ArrayList getNeededBatteryRIs(boolean bl, String string) throws BemException {
        ArrayList<BatteryRI> arrayList = new ArrayList<BatteryRI>();
        if (bl) {
            arrayList.add(this.batteryRI);
        }
        return arrayList;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        String[] stringArray = new String[]{this.confBatteryBackupCustParam.getName(), this.batteryCapacityCustParam.getName(), this.confPowerSupplyCustParam.getName(), this.noPsuCustParam.getName()};
        super.setCustomerParametersFromSV(stringArray, serviceValue);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    protected void updateLoadedValues() throws BemException {
        this.updateBoards(this.auHubType);
        this.updateLoadedPowerSupplyValues();
        this.updateLoadedBatteryValues();
    }

    protected void updateLoadedPowerSupplyValues() throws BemException {
        boolean bl = this.powerSupplySubrackRI.isInstalled();
        if (bl) {
            this.confPowerSupplyCustParam.setLoadedValue("YES");
            int n = this.countInstalledPsus(this.psuRIs);
            this.noPsuCustParam.setLoadedValue(String.valueOf(n));
            this.confPowerSupplyCustParam.addRestriction(this.restIntPowSupplyNoDelete);
        } else {
            this.confPowerSupplyCustParam.setLoadedValue("NO");
            boolean bl2 = this.isInternalPowerSupplyMandatory();
            if (bl2) {
                this.confPowerSupplyCustParam.addRestriction(this.restIntPowSupplyMandatory);
                this.noPsuCustParam.removeRestriction(this.restNoPsu);
            } else {
                this.confPowerSupplyCustParam.addRestriction(this.restOptional);
            }
        }
    }

    protected void updateAuHubType() throws BemException {
        String string = this.powerSupplySubrackRI.getLdn();
        Rbs rbs = this.getRbs();
        MoHandler moHandler = rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(string);
        try {
            BemMo bemMo2;
            if (moHandler.isExisting(bemMo)) {
                BemMo[] bemMoArray = moHandler.getChildren(bemMo, 1, MimRbsSlot.MOTYPENAME, "");
                this.auHubType = bemMoArray.length == 0 ? 2 : 1;
            } else if (this.fcuRI != null && moHandler.isExisting(bemMo2 = moHandler.getMo(string = this.fcuRI.getLdn()))) {
                BemMo bemMo3 = bemMo2.getParent();
                Integer n = (Integer)moHandler.getAttribute(bemMo3, "hubPosition");
                if (n == 30) {
                    this.auHubType = 1;
                } else if (n == 0) {
                    this.auHubType = 2;
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string2 = moHandlerException.getAction();
            String string3 = moHandlerException.getAdditionalInfo();
            throw new BemException(string2, "updateAuHubType", string, string3, moHandlerException);
        }
    }

    protected void updateLoadedBatteryValues() throws BemException {
        boolean bl = this.batteryRI.isInstalled();
        if (bl) {
            this.confBatteryBackupCustParam.setLoadedValue("YES");
            String string = this.batteryRI.getBatteryCapacity();
            this.batteryCapacityCustParam.setLoadedValue(string);
            this.confBatteryBackupCustParam.addRestriction(this.restBatteryNoDelete);
        } else {
            this.confBatteryBackupCustParam.setLoadedValue("NO");
            this.batteryCapacityCustParam.addRestriction(this.restBatteryCapacityIgnored);
            if (!this.hasInternalBatteryBackup()) {
                this.confBatteryBackupCustParam.addRestriction(this.restBatteryNoSupport);
            }
        }
    }

    private int countInstalledPsus(TreeMap treeMap) throws BemException {
        int n = 0;
        Set set = treeMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            PsuRI psuRI = (PsuRI)entry.getValue();
            boolean bl = psuRI.isInstalled();
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    protected abstract boolean hasInternalBatteryBackup();

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        ConfigurationCheckReport configurationCheckReport = new ConfigurationCheckReport();
        if (!this.isInternalPowerSupplyMandatory()) {
            return null;
        }
        configurationCheckReport = this.checkConfigurationForBoardType("psu", configurationCheckReport);
        configurationCheckReport = this.checkConfigurationForBoardType("bfu", configurationCheckReport);
        return configurationCheckReport;
    }

    public ConfigurationCheckReport checkConfigurationForBoardType(String string, ConfigurationCheckReport configurationCheckReport) throws BemException {
        int n;
        BemMo[] bemMoArray;
        List<String> list;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        ReportEntry reportEntry = null;
        if (string.equals("bfu")) {
            stringBuffer.append("BFU in slots: ");
            stringArray = new String[]{Integer.toString(this.bfuSlot)};
            stringBuffer.append(stringArray[0]).append(", ");
            list = Arrays.asList(stringArray);
            bemMoArray = this.getConfiguredMos(MimBfuDeviceGroup.MOTYPENAME);
        } else if (string.equals("psu")) {
            stringBuffer.append("PSU in slots: ");
            stringArray = new String[this.psuSlots.length];
            for (n = 0; n < this.psuSlots.length; ++n) {
                stringArray[n] = Integer.toString(this.psuSlots[n]);
                stringBuffer.append(stringArray[n]).append(", ");
            }
            list = Arrays.asList(stringArray);
            bemMoArray = this.getConfiguredMos(MimPsuDeviceGroup.MOTYPENAME);
        } else {
            return null;
        }
        for (n = 0; n < bemMoArray.length; ++n) {
            String string2 = bemMoArray[n].getParent().getParent().getId();
            String string3 = bemMoArray[n].getParent().getParent().getDN();
            if (list.contains(string2)) continue;
            String string4 = bemMoArray[n].getType() + " in slot " + string2;
            reportEntry = new ReportEntry("Error", string3, string4, stringBuffer.toString(), "Not a valid slot for the board type in Power Supply Subrack");
            configurationCheckReport.addReportEntry(reportEntry);
        }
        return configurationCheckReport;
    }

    public BemMo[] getConfiguredMos(String string) throws BemException {
        BemMo[] bemMoArray;
        String string2 = this.powerSupplySubrackRI.getLdn();
        Rbs rbs = this.getRbs();
        MoHandler moHandler = rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(string2);
        try {
            bemMoArray = moHandler.getChildren(bemMo, 3, string, "");
        }
        catch (MoHandlerException moHandlerException) {
            String string3 = moHandlerException.getAction();
            String string4 = moHandlerException.getAdditionalInfo();
            throw new BemException(string3, "checkConfiguration", string2, string4, moHandlerException);
        }
        return bemMoArray;
    }

    public boolean isConfPowerSupplySupported() {
        return this.psuRange != null;
    }

    public boolean hasSupportControlUnit() {
        return false;
    }

    public boolean isSupportSystemAvailable() {
        return false;
    }

    public int getNumberOfHwGroup() throws BemException {
        throw new BemException("getNumberOfHwGroup() not implemented for AbstractPowerSupplyCI");
    }
}

