/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.AbstractConfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.AtfProviderInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.ObifRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;

public class ConfigurationMainRemote
extends AbstractConfiguration {
    public static final String name = "Configuration Main-Remote";
    private static final String OUTPUT_POWER = "NORMAL";
    private static final int NO_OF_TX_BRANCHES = 1;
    private Rbs rbs;
    protected ObifRI obifRI;
    private String createSector;
    AtfProviderInfo[] atfReferences = null;

    public ConfigurationMainRemote(Rbs rbs, int n, int n2, MoInstance moInstance, int n3) throws BemException {
        super(name, n, n2, OUTPUT_POWER, 1);
        this.rbs = rbs;
        this.createSector = "YES";
        this.createResourceItems(moInstance, n3);
    }

    private void createResourceItems(MoInstance moInstance, int n) throws BemException {
        this.obifRI = new ObifRI(this.rbs, n, moInstance);
    }

    public List getResourceItems() throws BemException {
        ArrayList<ObifRI> arrayList = new ArrayList<ObifRI>();
        arrayList.add(this.obifRI);
        return arrayList;
    }

    public boolean isInstalled() throws BemException {
        boolean bl = this.obifRI.isInstalled();
        return bl;
    }

    public String getTerminationObject(String string) throws BemException {
        return this.obifRI.getPiuLdn();
    }

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        ArrayList arrayList = new ArrayList();
        return new ConfigurationCheckReport(arrayList);
    }

    public AtfProviderInfo[] getAtfProviderInfo() {
        if (this.atfReferences != null) {
            return this.atfReferences;
        }
        this.atfReferences = new AtfProviderInfo[]{new AtfProviderInfo(AtfProvider.ALL_CONTROLLERS_OF_RRU_INDEXED_BY_SECTOR[this.getSectorNo()], this.obifRI.getPiuLdn())};
        return this.atfReferences;
    }

    public String getCreateSector() {
        return this.createSector;
    }
}

