/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.atfmgmt;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class RadioEquipmentAtfNameManager {
    public static final String SECTOR_NUMBER_DELIMITER = ":_";
    public static final String RD_NUMBER_DELIMITER = "_:";
    private int startingSectorNumber;
    private String[] primaryPortConnectedAtfRoles;
    private String[] secondaryPortConnectedAtfRoles;
    private static final String PRIMARY_CPRI_LINK__ATF_ROLE_PREFIX = "ATF_ROLE_PRIMARY_CPRI_LINK_CONTROLLED_FOR_SECTOR_NUMBER_:_";
    private static final String SECONDARY_CPRI_LINK_ATF_ROLE_PREFIX = "ATF_ROLE_SECONDARY_CPRI_LINK_CONTROLLED_FOR_SECTOR_NUMBER_:_";
    private String[] arfRolesForRDs;
    public static final String ATF_ROLE_PREFIX_FOR_RD_SECTORNUMBER = "AFT_ROLE_CONTROLLE_RD_FOR_SECTOR_NUMBER_:_";

    public RadioEquipmentAtfNameManager(int n, int n2) {
        this.startingSectorNumber = n2;
        this.saveAtfRoles(n);
    }

    private void saveAtfRoles(int n) {
        this.primaryPortConnectedAtfRoles = new String[n];
        this.secondaryPortConnectedAtfRoles = new String[n];
        this.arfRolesForRDs = new String[n];
        this.saveAtfRoles(n, this.primaryPortConnectedAtfRoles, PRIMARY_CPRI_LINK__ATF_ROLE_PREFIX);
        this.saveAtfRoles(n, this.secondaryPortConnectedAtfRoles, SECONDARY_CPRI_LINK_ATF_ROLE_PREFIX);
        this.saveAtfRolesForRDs(n, this.arfRolesForRDs);
    }

    private void saveAtfRoles(int n, String[] stringArray, String string) {
        for (int i = 0; i < n; ++i) {
            String string2;
            int n2 = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            stringArray[i] = string2 = string + n2;
        }
    }

    private void saveAtfRolesForRDs(int n, String[] stringArray) {
        for (int i = 0; i < n; ++i) {
            String string;
            int n2 = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            stringArray[i] = string = ATF_ROLE_PREFIX_FOR_RD_SECTORNUMBER + n2;
        }
    }

    public String getAtfRole(int n) {
        return this.getAtfRole(n, false);
    }

    public String getAtfRole(int n, boolean bl) {
        String string = "";
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        string = bl ? this.secondaryPortConnectedAtfRoles[n2] : this.primaryPortConnectedAtfRoles[n2];
        return string;
    }

    boolean isAtfRoleSupported(String string) {
        boolean bl = BemUtil.isStringInArray(string, this.primaryPortConnectedAtfRoles);
        if (!bl) {
            bl = BemUtil.isStringInArray(string, this.secondaryPortConnectedAtfRoles);
        }
        if (!bl) {
            bl = BemUtil.isStringInArray(string, this.arfRolesForRDs);
        }
        return bl;
    }

    static boolean isRoleForSecondaruPortId(String string) {
        boolean bl = string.startsWith(SECONDARY_CPRI_LINK_ATF_ROLE_PREFIX);
        return bl;
    }

    public String getAtfRoleForRD(int n) {
        String string = "";
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        string = this.arfRolesForRDs[n2];
        return string;
    }
}

