/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.check.ReportEntry;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AntennaSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EquippedSectorRadioInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.AbstractRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ConfigurationGroupParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DigitalCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DigitalCableSetParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FuSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.PrimaryPortIdParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioBuildingBlockParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioIfTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioInterfaceBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RfCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RfCableSetParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuifRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.Ruw8USubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuwSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.SectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.SectorSequenceNumberParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.AbstractCableSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet10;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet7;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet8;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet9;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.RbsCableSets;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.custparam.CarrierAllocationModeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.AbstractRadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.Configurations;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB3;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.SectorCapability;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.Reconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.ObifRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProviderImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDeviceBoardRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOpticalInterfaceLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public abstract class GenericRadioEquipmentCI
extends AbstractRadioEquipmentCI {
    private static final String RECONFIGURATION_NOT_SUPPORTED_RESTRICTION = "The type of reconfiguration is not supported";
    private static final String CONFIGURATION_NOT_SUPPORTED_RESTRICTION = "The type of configuration is not supported";
    private static final String PRECONDITIONS_NOT_MET_RESTRICTION = "The preconditions for reconfiguration are not met: ";
    private static final String NO_CONFIGURED_SECTORS_ERROR_MESSAGE = "At least one sector must be configured";
    private static final String NO_CONFIGURED_SECTORS_OBIF_MACRO_CABINET_ERROR_MESSAGE = "At least one sectors 1-6 must be configured";
    private static final String BASE_BAND_POOL_OBIF_MACRO_ERROR_MESSAGE = "Base Band Pool settings must be set with RUIF in Base Band Pool 1 and\nOBIF in Base Band Pool 2 to configure sector 7-12";
    private static final String NOT_POSSIBLE_TO_DELETE_SECTOR = "Not possible to delete sector ";
    private static final String PRIMARY_PORT_ID_NOT_SUPPORTED_RESTRICTION = "Primary Port Id not supported";
    private static final String SECTOR_SEQUENCE_NOT_SUPPORTED_RESTRICTION = "Sector sequence number not supported";
    private static final int NO_OF_SECTORS_PER_BASE_BAND_POOL = 6;
    private boolean isOpen = false;
    private String VALUE_NO = "NO";
    private String VALUE_YES = "YES";
    private String NO_CONF = "";
    private String OBIF = "OBIF";
    private String RUIF = "RUIF";
    private String DUI_O = "DUI_O";
    private String DUI_E = "DUI_E";
    private String XCU = "XCU";
    private String ALL1 = "ALL1";
    private String AB3 = "AB3";
    private String ABC2 = "ABC2";
    private String A6 = "A6";
    private Integer ALL1_CPRI2 = new Integer(4);
    private static String FU_IN_BATTERY_SHELF = "FU_In_Battery_Shelf";
    private static String FU_IN_CDU_SHELF = "FU_In_CDU_Shelf";
    private static String INTERNAL = "Internal";
    private static String EXTERNAL = "External";
    private String[] poolNumberServiceNames;
    private String[] radioIfTypeServiceNames;
    private String[] configGroupServiceNames;
    private String[] primaryPortIdServiceNames;
    private String[] sectorSequenceServiceNames;
    private String[] radioBuildingBlockServiceNames;
    private String[] createSectorServiceNames;
    private String[] noOfCarriersServiceNames;
    private String[] rfCableSetServiceNames;
    private String[] digitalCableSetServiceNames;
    private int maxNoOfSectors;
    private int maxNoOfCarriers;
    private int maxNumberOfBaseBandPools = 2;
    private RadioBuildingBlockParameter[] radioBuildingBlockParameters;
    private YesNoCustomerParameter[] createSectorParameters;
    private ConfigurationGroupParameter configGroupParameter;
    private ConfigurationGroupParameter[] configGroupParameters;
    private PrimaryPortIdParameter[] primaryPortIdParameters;
    private SectorSequenceNumberParameter[] sectorSequenceParameters;
    private CarrierAllocationModeParameter carrierAllocationMode;
    private ParameterRestriction[] rbbPreconditionReconfRestriction;
    private ParameterRestriction[] deleteSectorRestriction;
    private ParameterRestriction[] createSectorRestriction;
    private ParameterRestriction rfCableRestriction;
    private ParameterRestriction digitalCableRestriction;
    private ParameterRestriction[] supportedPortIdRangeRestriction;
    private ParameterRestriction[] supportedSectorSequenceRangeRestriction;
    private ParameterRestriction[] notSupportedIgnoreRestrictions;
    private ParameterRestriction notSupportedIgnoreRestriction;
    private ParameterRestriction[] supportedConfGroupRangeRestriction;
    private IntegerParameter[] poolNumberParameters;
    private RadioIfTypeParameter[] radioIfTypeParameters;
    private RfCableSetParameter[] rfCableSetParameters;
    private DigitalCableSetParameter[] digitalCableSetParameters;
    private SectorRI[] sectors;
    private int noOfExistingSectors;
    protected RuifRI[] ruif = new RuifRI[2];
    protected ObifRI obif;
    protected RadioInterfaceBoard radioInterfaceBoard;
    protected RuwSubrackRI ruwSubrack;
    protected Ruw8USubrackRI ruwSubrack1;
    protected RuSubrackRI ruSubrack;
    protected FuSubrackRI fuSubrack;
    protected List listOfRus;
    protected List listOfFus;
    protected RadioBuildingBlock[] radioBuildingBlocks;
    private RadioBuildingBlock[] loadedRadioBuildingBlocks;
    private Configurations sectorCapabilityMgr = new Configurations();
    private Map installedRadioBuildingBlocks = new HashMap();
    int[][] portAndSequence;
    private Map installedPortAndSequence = new HashMap();
    private RbsCableSets cableSets;
    private AtfProviderImpl myAtfProvider;
    private boolean cableSet;
    protected MoInstance hubSubrackMoi = null;
    public static final int MAX_NUMBER_OF_SECTORS_FOR_TX_DIVERSITY = 3;
    private List rbbNeedUiniteSector = new ArrayList();
    private static final Comparator COMPARE = new Comparator(){

        public int compare(Object object, Object object2) {
            Integer n = (Integer)object;
            Integer n2 = (Integer)object2;
            if (n < n2) {
                return -1;
            }
            if (n.intValue() == n2.intValue()) {
                return 0;
            }
            return 1;
        }
    };

    public GenericRadioEquipmentCI(Rbs rbs, int n, int n2, int n3, boolean bl) {
        super(rbs);
        this.maxNoOfSectors = n;
        this.maxNoOfCarriers = n3;
        this.cableSet = bl;
        this.initServiceNames();
        rbs.registerProvider(this);
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            return true;
        }
        this.isOpen = true;
        super.open();
        this.initMoi();
        this.createRadioInterfaceBoard();
        this.createSubracks();
        this.createRadioBuildingBlocks();
        this.createCustomerParameters();
        this.cableSets = this.getRbsCableSets();
        this.initiateCustomerParameters();
        this.createSectors();
        this.updateLoadedValues();
        this.updateRestrictions();
        this.updateCableRestrictions();
        this.updateLoadedSectors();
        this.updateCableParams();
        return true;
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        boolean bl = false;
        bl = super.open(serviceValue);
        if (!bl) {
            for (int i = 0; i < this.maxNoOfSectors; ++i) {
                String string = serviceValue.getValue(this.radioIfTypeServiceNames[0]);
                String string2 = serviceValue.getValue(this.radioIfTypeServiceNames[1]);
                String string3 = serviceValue.getValue(this.radioBuildingBlockServiceNames[i]);
                String string4 = serviceValue.getValue(this.createSectorServiceNames[i]);
                String string5 = serviceValue.getValue(this.noOfCarriersServiceNames[i]);
                String string6 = serviceValue.getValue(this.configGroupServiceNames[i]);
                String string7 = serviceValue.getValue(this.primaryPortIdServiceNames[i]);
                String string8 = serviceValue.getValue(this.sectorSequenceServiceNames[i]);
                if (string3 == null && string5 == null && string4 == null && string == null && string2 == null && string6 == null && string7 == null && string8 == null) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            return false;
        }
        this.open();
        return true;
    }

    private void initServiceNames() {
        String string;
        int n;
        this.createSectorServiceNames = new String[this.maxNoOfSectors];
        this.digitalCableSetServiceNames = new String[this.maxNoOfSectors];
        this.noOfCarriersServiceNames = new String[this.maxNoOfSectors];
        this.configGroupServiceNames = new String[this.maxNoOfSectors];
        this.primaryPortIdServiceNames = new String[this.maxNoOfSectors];
        this.radioBuildingBlockServiceNames = new String[this.maxNoOfSectors];
        this.rfCableSetServiceNames = new String[this.maxNoOfSectors];
        this.sectorSequenceServiceNames = new String[this.maxNoOfSectors];
        this.radioIfTypeServiceNames = new String[this.maxNumberOfBaseBandPools + 1];
        this.poolNumberServiceNames = new String[this.maxNumberOfBaseBandPools + 1];
        for (n = 1; n <= this.maxNoOfSectors; ++n) {
            string = MessageFormat.format("S{0}_", new Integer(n));
            this.createSectorServiceNames[n - 1] = string + "createSector";
            this.digitalCableSetServiceNames[n - 1] = string + "digitalCablesSet";
            this.noOfCarriersServiceNames[n - 1] = string + "numberOfCarriers";
            this.configGroupServiceNames[n - 1] = string + "configurationGroup";
            this.primaryPortIdServiceNames[n - 1] = string + "primaryPortId";
            this.radioBuildingBlockServiceNames[n - 1] = string + "radioBuildingBlock";
            this.rfCableSetServiceNames[n - 1] = string + "rfCablesSet";
            this.sectorSequenceServiceNames[n - 1] = string + "sectorSequenceNumber";
        }
        for (n = 0; n < this.maxNumberOfBaseBandPools; ++n) {
            string = String.valueOf(n + 1);
            this.radioIfTypeServiceNames[n] = string + "radioIfType";
            this.poolNumberServiceNames[n] = string + "poolNumber";
        }
        this.radioIfTypeServiceNames[this.maxNumberOfBaseBandPools] = "radioIfType";
        this.poolNumberServiceNames[this.maxNumberOfBaseBandPools] = "poolNumber";
    }

    public ArrayList getNeededRIs() throws BemException {
        Object object;
        int n;
        if (!this.isOpen) {
            throw new BemException("RadioEquipmentCI is not open.");
        }
        this.checkConsistency();
        ArrayList arrayList = super.getNeededRIs();
        int[] nArray = this.getEquippedSectors();
        if (this.isRadioIfTypeRuif(0) || this.isRadioIfTypeXcu(0)) {
            int n2 = this.getNumberOfDuwSlots();
            for (n = 0; n < n2; ++n) {
                if (n != 0 && this.rbsWithRuifAndObif()) continue;
                arrayList.addAll(this.getRadioInterfaceRIs(n));
            }
            if (this.fuSubrack != null) {
                arrayList.add(this.fuSubrack);
            } else if (this.listOfFus != null) {
                for (n = 0; n < this.listOfFus.size(); ++n) {
                    if (this.radioBuildingBlockParameters[n].getValue().equals(this.NO_CONF)) continue;
                    arrayList.add(this.listOfFus.get(n));
                }
            }
            if (this.ruSubrack != null) {
                arrayList.add(this.ruSubrack);
            } else if (this.listOfRus != null) {
                for (n = 0; n < this.listOfRus.size(); ++n) {
                    if (this.radioBuildingBlockParameters[n].getValue().equals(this.NO_CONF)) continue;
                    arrayList.add(this.listOfRus.get(n));
                }
            }
            if (this.ruwSubrack != null) {
                arrayList.add(this.ruwSubrack);
            }
        }
        if (this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1)) {
            Integer n3 = this.getConfigurationGroupValue();
            this.obif.setConfigurationGroup(n3);
            arrayList.add(this.obif);
            if (this.obif.isInstalled()) {
                this.updateOil();
            }
        }
        if (this.ruwSubrack1 != null) {
            arrayList.add(this.ruwSubrack1);
        }
        AntennaSystemProvider antennaSystemProvider = null;
        try {
            antennaSystemProvider = this.rbs.getAntennaSystemProvider();
        }
        catch (Exception exception) {
            throw new BemException("getAntennaSystemProvider", "AntennaSystemCI", (Throwable)exception);
        }
        for (n = 0; n < nArray.length; ++n) {
            int n4 = nArray[n];
            object = antennaSystemProvider.getBand(n4);
            if (object == null || ((String)object).equals("0") || ((String)object).equals("##UNDEFINED")) continue;
            int n5 = Integer.parseInt((String)object);
            this.setBand(n4, n5);
        }
        for (n = 0; n < this.maxNoOfSectors; ++n) {
            List list = new ArrayList();
            if (this.radioBuildingBlocks[n] == null) continue;
            if ((this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1) && n > 5) && !"STEP_CABINET".equals(this.rbs.getRbsStep())) {
                if (this.radioBuildingBlocks[n].getName().equals("RRB02")) {
                    this.radioBuildingBlocks[n].createTrDevice();
                }
                list = this.radioBuildingBlocks[n].getResourceItems();
            }
            if ((this.isRadioIfTypeRuif(0) || this.isRadioIfTypeXcu(0)) && n < 6) {
                list = this.radioBuildingBlocks[n].getResourceItems();
            }
            arrayList.addAll(list);
            if (!this.sectors[n].isInstalled() || this.loadedRadioBuildingBlocks[n] != null && this.radioBuildingBlocks[n] != null && this.loadedRadioBuildingBlocks[n].getNoOfSupportedRxBranches() != this.radioBuildingBlocks[n].getNoOfSupportedRxBranches()) {
                arrayList.add(this.sectors[n]);
            }
            if ((object = this.getReconfiguration(n + 1)) == null) continue;
            List list2 = object.getRisToInstall();
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private Integer getConfigurationGroupValue() throws BemException {
        Integer n = this.configGroupParameter.getValueAsInteger();
        int[] nArray = this.getUsedSectorsWithObif();
        if (nArray.length > 0) {
            int n2 = nArray[0];
            boolean bl = true;
            String string = this.radioBuildingBlocks[n2 - 1].getName();
            if (string.equals("RRB01")) {
                bl = false;
            }
            if (bl && n == 0) {
                n = this.ALL1_CPRI2;
            }
        }
        return n;
    }

    public List getRIsToUninstall() throws BemException {
        List<RuwSubrackRI> list = new ArrayList();
        list = super.getRIsToUninstall();
        boolean bl = false;
        for (int i = 1; i <= this.maxNoOfSectors; ++i) {
            Object object;
            Reconfiguration reconfiguration = this.getReconfiguration(i);
            if (reconfiguration != null && reconfiguration.getToRadioBuildingBlock().getName().equals(this.radioBuildingBlocks[i - 1].getName()) && this.rbs.getRbsStep().equals("STEP_EXPANSION")) {
                object = reconfiguration.getRisToUninstall();
                list.addAll((Collection<RuwSubrackRI>)object);
            }
            if (this.radioBuildingBlocks[i - 1] != null || (object = (RadioBuildingBlock)this.installedRadioBuildingBlocks.get(new Integer(i))) == null) continue;
            list.add((RuwSubrackRI)((Object)this.sectors[i - 1]));
            List list2 = object.getResourceItems();
            list.addAll(list2);
            boolean bl2 = false;
            boolean bl3 = false;
            int n = this.getBaseBandPoolData().getFirstSectorNoForSecondBBPool();
            for (int j = 0; j < this.maxNoOfSectors; ++j) {
                int n2;
                if (this.radioBuildingBlocks[j] == null) continue;
                String string = this.radioBuildingBlockParameters[j].getValue();
                if (string.equals("RB6") || string.equals("RB7") || string.equals("RB8") || string.equals("RB6B") || string.equals("RB7B") || string.equals("RB8B")) {
                    n = 1;
                }
                bl2 = true;
                if (j < n - 1 || (n2 = this.radioBuildingBlocks[j].getNoOfCarriers()) <= 1) continue;
                bl3 = true;
                break;
            }
            if (!(bl2 || bl || this.mainRemoteRbs() && !this.isRadioIfTypeRuif(0) && !this.isRadioIfTypeXcu(0))) {
                list.addAll(this.getRadioInterfaceRIs(0));
                List list3 = this.getRaxAndTxRIsForBBpool(0);
                list.addAll(list3);
                this.setRemoveSwallocation(list3);
                if (this.ruwSubrack != null) {
                    list.add(this.ruwSubrack);
                }
                if (this.ruSubrack != null) {
                    list.add((RuwSubrackRI)((Object)this.ruSubrack));
                }
                if (this.ruwSubrack1 != null) {
                    list.add((RuwSubrackRI)((Object)this.ruwSubrack1));
                }
                if (this.fuSubrack != null) {
                    list.add((RuwSubrackRI)((Object)this.fuSubrack));
                }
                bl = true;
            }
            if (bl3 || !this.isRadioIfTypeRuif(0) && !this.isRadioIfTypeXcu(0) || this.isRadioIfTypeObif(1)) continue;
            list.addAll(this.getRadioInterfaceRIs(1));
            List list4 = this.getRaxAndTxRIsForBBpool(1);
            list.addAll(list4);
            this.setRemoveSwallocation(list4);
        }
        return list;
    }

    private Reconfiguration getReconfiguration(int n) throws BemException {
        String string = this.radioBuildingBlockParameters[n - 1].getLoadedValue();
        if (string.equals(this.NO_CONF) || string.equals("##UNDEFINED")) {
            return null;
        }
        String string2 = this.radioBuildingBlockParameters[n - 1].getValue();
        if (string2.equals(this.NO_CONF)) {
            return null;
        }
        SectorCapability sectorCapability = this.sectorCapabilityMgr.getSectorCapability(n);
        Reconfiguration reconfiguration = sectorCapability.getReconfiguration(this.loadedRadioBuildingBlocks[n - 1], this.radioBuildingBlocks[n - 1]);
        if (reconfiguration == null && !string.equals(this.NO_CONF) && !string.equals(string2)) {
            throw new BemException("The type of reconfiguration is not supported. ");
        }
        return reconfiguration;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        String string;
        String string2;
        int n;
        Object object;
        EnumeratedRange enumeratedRange = this.getRadioIfTypeRange();
        List list = enumeratedRange.getRangeValues();
        for (int i = 0; i < this.maxNumberOfBaseBandPools; ++i) {
            object = this.radioIfTypeParameters[i].getValue();
            String string3 = serviceValue.getValue(this.radioIfTypeServiceNames[i]);
            if (string3 == null || ((String)object).equals(string3) || !list.contains(string3)) continue;
            this.radioIfTypeParameters[i].setValue(string3);
        }
        String string4 = this.radioIfTypeParameters[0].getValue();
        object = new ArrayList();
        if (this.rbs.getRbsStep().equals("STEP_CABINET")) {
            object.add("carrierAllocationMode");
        }
        if (this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1)) {
            for (int i = 0; i < this.maxNoOfSectors; ++i) {
                object.add(this.createSectorServiceNames[i]);
                object.add(this.createSectorServiceNames[i]);
                object.add(this.radioBuildingBlockServiceNames[i]);
                object.add(this.configGroupServiceNames[i]);
                object.add(this.primaryPortIdServiceNames[i]);
                object.add(this.sectorSequenceServiceNames[i]);
                this.setDefaultValues(serviceValue, string4, i);
            }
        }
        if (this.isRadioIfTypeRuif(0) || this.isRadioIfTypeXcu(0)) {
            int n2 = this.rbsWithRuifAndObif() ? 6 : this.maxNoOfSectors;
            for (n = 0; n < this.maxNoOfSectors; ++n) {
                object.add(this.radioBuildingBlockServiceNames[n]);
                object.add(this.createSectorServiceNames[n]);
                object.add(this.rfCableSetServiceNames[n]);
                object.add(this.digitalCableSetServiceNames[n]);
                if (n >= n2) continue;
                this.notSupportedIgnoreRestrictions[n] = new ParameterRestriction("Not supported", 1);
                this.configGroupParameters[n].addRestriction(this.notSupportedIgnoreRestrictions[n]);
                this.primaryPortIdParameters[n].addRestriction(this.notSupportedIgnoreRestrictions[n]);
                this.sectorSequenceParameters[n].addRestriction(this.notSupportedIgnoreRestrictions[n]);
            }
        }
        String string5 = null;
        for (n = 1; n <= this.maxNoOfSectors; ++n) {
            string2 = MessageFormat.format("S{0}_", new Integer(n));
            string = string2 + "carrierAllocationMode";
            String string6 = serviceValue.getValue(string);
            if (string6 == null) continue;
            if (string5 == null) {
                string5 = string6;
                continue;
            }
            if (string6.equals(string5)) continue;
            throw new BemException("More then one carrier allocation mode specified.");
        }
        if (string5 != null) {
            this.carrierAllocationMode.setValue(string5);
        }
        super.setCustomerParametersFromSV(object.toArray(new String[0]), serviceValue);
        for (n = 1; n <= this.maxNoOfSectors; ++n) {
            string2 = MessageFormat.format("S{0}_", new Integer(n));
            string = string2 + "deleteSector";
            if (serviceValue.getAttribute(string) == null) continue;
            if (this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1)) {
                this.createSectorParameters[n - 1].setValue(this.VALUE_NO);
                this.radioBuildingBlockParameters[n - 1].setValue(this.NO_CONF);
                this.primaryPortIdParameters[n - 1].setValue(this.NO_CONF);
                this.sectorSequenceParameters[n - 1].setValue(this.NO_CONF);
                this.updateCreateSectorRestrictions(n);
                this.updateConfigurationGroupRestrictions(n);
                this.updateSectorSequenceRestrictions(n);
                this.updatePrimaryPortIdRestrictions(n);
            }
            if (!this.isRadioIfTypeRuif(0) && !this.isRadioIfTypeXcu(0)) continue;
            this.createSectorParameters[n - 1].setValue(this.VALUE_NO);
            this.radioBuildingBlockParameters[n - 1].setValue(this.NO_CONF);
            this.rfCableSetParameters[n - 1].setValue(FU_IN_CDU_SHELF);
            this.digitalCableSetParameters[n - 1].setValue(INTERNAL);
        }
        if (this.useCreateSectorParameter()) {
            this.handleAddCarriersForMainRemote(serviceValue, this.maxNoOfSectors, this.maxNoOfCarriers);
        }
        super.setCustomerParameters(serviceValue);
    }

    private void setDefaultValues(ServiceValue serviceValue, String string, int n) {
        String string2 = MessageFormat.format("S{0}_", new Integer(n + 1));
        String string3 = this.NO_CONF;
        String string4 = this.ALL1;
        String string5 = serviceValue.getValue(string2 + "radioBuildingBlock");
        if (string5 != null) {
            string3 = string5;
        }
        if ((string5 = serviceValue.getValue(string2 + "configurationGroup")) != null) {
            string4 = string5;
        }
        if (!((string5 = serviceValue.getValue(string2 + "primaryPortId")) != null || this.radioBuildingBlockParameters[n] == null || string3.equals(this.NO_CONF) || !string4.equals(this.ALL1) || string.equals(this.RUIF) && n < 6)) {
            int n2;
            if (string3.equals("RRB05") || string3.startsWith("RRB06")) {
                n2 = n + 1;
                if (n > 0) {
                    ++n2;
                }
                if (n > 1) {
                    n2 += 2;
                }
            } else {
                n2 = n + 1;
                if (n > 2 && n < 6) {
                    ++n2;
                } else if (n > 5 && n < 9) {
                    n2 -= 6;
                } else if (n > 8) {
                    n2 -= 5;
                }
            }
            String string6 = this.getPortIdString(new Integer(n2));
            this.primaryPortIdParameters[n].setValue(string6);
        }
        if ((string5 = serviceValue.getValue(string2 + "sectorSequenceNumber")) == null && this.radioBuildingBlockParameters[n] != null && this.radioBuildingBlockParameters[n].getValue() != this.NO_CONF && this.configGroupParameter.getValue().equals(this.ALL1)) {
            this.sectorSequenceParameters[n].setValue("1");
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void checkConsistency() throws BemException {
        Object object;
        super.checkConsistency();
        this.updateRbbPreconditionReconfRestrictions();
        this.updateDeleteSectorRestrictions();
        this.updateSectorParameters();
        if (!this.isRadioIfTypeXcu(1)) {
            this.radioIfTypeParameters[1].removeRestriction(this.notSupportedIgnoreRestriction);
        }
        if (this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1)) {
            int n;
            Object object2;
            object = this.rbs.getCellAndCarrierProvider();
            if ("STEP_EXPANSION".equals(this.rbs.getRbsStep()) && !this.configGroupParameter.getValue().equals("") && !this.configGroupParameter.getValue().equals(this.configGroupParameter.getLoadedValue())) {
                object2 = this.getUsedSectorsWithObif();
                for (n = 0; n < ((Object)object2).length; ++n) {
                    Object object3 = object2[n];
                    object.requestUninitiateSector((int)object3, this.rbs.getConfigItem("RadioEquipmentCI"));
                    object.requestInitiateSector((int)object3, this.rbs.getConfigItem("RadioEquipmentCI"));
                }
            }
            if (!"STEP_OAM".equals(this.rbs.getRbsStep())) {
                this.checkCreateSector();
            }
            if (this.obif.isInstalled()) {
                object2 = this.configGroupParameter.getValueAsInteger();
                n = (Integer)object2;
                this.updateRbbRanges();
                this.updatePortIdRange(n);
                this.updateSectorSequenceNumberRange(n);
            }
        }
        this.checkRadioBuildingBlocks();
        super.checkConsistency();
        object = this.getEquippedSectors();
        this.checkSectors((int[])object);
        this.checkBaseBandPoolSettings((int[])object);
        this.checkAdvancedConfigurations((int[])object);
        this.checkAsymmetricConfigurations();
        this.checkAllocatedResources((int[])object);
    }

    private void checkAdvancedConfigurations(int[] nArray) throws BemException {
        if (this.carrierAllocationMode.getValue().equals("Advanced") && nArray[nArray.length - 1] <= 3 && this.getNumberOfDuwSlots() == 1) {
            throw new BemException("Can't configure advanced configuration when only using sectors in one baseband pool.");
        }
    }

    private void updateRbbRanges() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            this.updateRbbRestrictions(i);
        }
    }

    private void checkSectors(int[] nArray) throws BemException {
        String string;
        boolean bl = true;
        int n = this.maxNoOfSectors;
        if (this.mainRemoteRbs() && "STEP_CABINET".equals(string = this.rbs.getRbsStep())) {
            if (this.isRadioIfTypeRuif(0) && this.isRadioIfTypeObif(1)) {
                if (this.maxNoOfSectors > 6) {
                    n = 6;
                }
            } else if (this.isRadioIfTypeObif(0)) {
                bl = false;
            }
        }
        if (bl || this.obif.isInstalled()) {
            this.checkSectors(nArray, n);
        } else if (this.ruif[0] != null && this.ruif[0].isInstalled()) {
            this.checkSectors(nArray, n);
        }
    }

    private void checkSectors(int[] nArray, int n) throws BemException {
        int n2 = this.installedRadioBuildingBlocks.size();
        if (nArray.length == 0 && n2 == 0) {
            throw new BemException(NO_CONFIGURED_SECTORS_ERROR_MESSAGE);
        }
        if (nArray.length > 0) {
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = nArray[i];
                if (n3 > n) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new BemException(NO_CONFIGURED_SECTORS_OBIF_MACRO_CABINET_ERROR_MESSAGE);
            }
        }
    }

    private void checkBaseBandPoolSettings(int[] nArray) throws BemException {
        if (this.maxNoOfSectors > 6) {
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n <= 6) continue;
                bl = true;
                break;
            }
            if (!(!bl || this.isRadioIfTypeRuif(0) && this.isRadioIfTypeObif(1))) {
                throw new BemException(BASE_BAND_POOL_OBIF_MACRO_ERROR_MESSAGE);
            }
        }
    }

    protected boolean isRb4UsedWithDualRadioInterfaceBoard(int[] nArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < nArray.length; ++i) {
            bl4 = nArray[nArray.length - 1] > 3;
            String string = this.radioBuildingBlocks[nArray[i] - 1].getName();
            if (string.equals("RB4b") || string.equals("RB4")) {
                bl2 = true;
                continue;
            }
            if (!string.equals("RB4Bb") && !string.equals("RB4B")) continue;
            bl3 = true;
        }
        if ((bl2 || bl3) && bl4 && !this.carrierAllocationMode.getValue().equals("Advanced")) {
            bl = true;
        }
        return bl;
    }

    public boolean isUniniteSectorNeeded(int n) {
        boolean bl = false;
        if (this.loadedRadioBuildingBlocks[n - 1] != null && this.rbs.getRbsStep().equals("STEP_EXPANSION")) {
            if (this.rbbNeedUiniteSector.isEmpty()) {
                this.rbbNeedUiniteSector.add("RB4");
                this.rbbNeedUiniteSector.add("RB3");
                this.rbbNeedUiniteSector.add("RRB02");
            }
            if (this.rbbNeedUiniteSector.contains(this.loadedRadioBuildingBlocks[n - 1].getConfiguredRbbName())) {
                bl = true;
            }
        }
        return bl;
    }

    private void rb4ToRb4b(int[] nArray) {
        boolean bl = this.isRb4UsedWithDualRadioInterfaceBoard(nArray);
        if (bl && !this.carrierAllocationMode.getValue().equals("Advanced")) {
            RadioBuildingBlock radioBuildingBlock = null;
            for (int i = 0; i < nArray.length; ++i) {
                SectorCapability sectorCapability;
                if (this.radioBuildingBlocks[nArray[i] - 1].getName().equals("RB4")) {
                    sectorCapability = this.sectorCapabilityMgr.getSectorCapability(nArray[i]);
                    radioBuildingBlock = sectorCapability.getConfigurationByName("RB4b");
                    if (radioBuildingBlock == null) continue;
                    this.radioBuildingBlocks[nArray[i] - 1] = radioBuildingBlock;
                    continue;
                }
                if (!this.radioBuildingBlocks[nArray[i] - 1].getName().equals("RB4B")) continue;
                sectorCapability = this.sectorCapabilityMgr.getSectorCapability(nArray[i]);
                this.radioBuildingBlocks[nArray[i] - 1] = radioBuildingBlock = sectorCapability.getConfigurationByName("RB4Bb");
            }
        }
    }

    private void checkAsymmetricConfigurations() throws BemException {
        int n;
        String[] stringArray = new String[]{"RRB01", "RB8", "RB8B"};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        for (n = 0; n < this.maxNoOfSectors; ++n) {
            if (this.radioBuildingBlocks[n] == null) continue;
            String string = this.radioBuildingBlocks[n].getName();
            for (int i = 0; i < n; ++i) {
                String string2;
                if (this.radioBuildingBlocks[i] == null || string.equals(string2 = this.radioBuildingBlocks[i].getName()) || !arrayList.contains(string2) && !arrayList.contains(string)) continue;
                throw new BemException("Asymmetric configuration of sectors whith " + string2 + ",\n" + "and " + string + " not allowed");
            }
        }
        if (this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1)) {
            this.checkForExceptions();
        }
    }

    private void checkForExceptions() throws BemException {
        String string = this.configGroupParameter.getValue();
        if (!string.equals(this.ALL1) && !string.equals("")) {
            this.updatePortAndSequence();
            for (int i = 0; i < this.portAndSequence.length; ++i) {
                int[] nArray = this.portAndSequence[i];
                if (nArray.length <= 0) continue;
                for (int j = 0; j < nArray.length - 1; ++j) {
                    RadioBuildingBlock radioBuildingBlock = this.radioBuildingBlocks[nArray[j] - 1];
                    RadioBuildingBlock radioBuildingBlock2 = this.radioBuildingBlocks[nArray[j + 1] - 1];
                    boolean bl = j == nArray.length - 2;
                    this.allowedChain(radioBuildingBlock, radioBuildingBlock2, bl);
                }
            }
        }
    }

    private void allowedChain(RadioBuildingBlock radioBuildingBlock, RadioBuildingBlock radioBuildingBlock2, boolean bl) throws BemException {
        String[] stringArray = new String[]{"RRB03", "RRB02B", "RRB05"};
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        String[] stringArray2 = new String[]{"RRB02", "RRB04", "RRB06", "RRB06C", "RRB06D"};
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(stringArray2));
        if (radioBuildingBlock.getName().equals(radioBuildingBlock2.getName()) && arrayList2.contains(radioBuildingBlock.getName())) {
            throw new BemException(radioBuildingBlock.getName() + " is only allowed last in chain or \n" + "alone for a primary port id");
        }
        if (!radioBuildingBlock.getName().equals(radioBuildingBlock2.getName())) {
            if (radioBuildingBlock2.getName().equals("RRB03") && radioBuildingBlock.getName().equals("RRB04") || radioBuildingBlock2.getName().equals("RRB02B") && radioBuildingBlock.getName().equals("RRB02") || radioBuildingBlock2.getName().equals("RRB05") && radioBuildingBlock.getName().equals("RRB06") || radioBuildingBlock2.getName().equals("RRB05") && radioBuildingBlock.getName().equals("RRB06C") || radioBuildingBlock2.getName().equals("RRB05") && radioBuildingBlock.getName().equals("RRB06D") || radioBuildingBlock.getName().equals("RRB02B") && radioBuildingBlock2.getName().equals("RRB02") || radioBuildingBlock.getName().equals("RRB03") && radioBuildingBlock2.getName().equals("RRB04") || radioBuildingBlock.getName().equals("RRB05") && radioBuildingBlock2.getName().equals("RRB06") || radioBuildingBlock.getName().equals("RRB05") && radioBuildingBlock2.getName().equals("RRB06C") || radioBuildingBlock.getName().equals("RRB05") && radioBuildingBlock2.getName().equals("RRB06D")) {
                if (!bl && !arrayList.contains(radioBuildingBlock.getName())) {
                    throw new BemException(radioBuildingBlock.getName() + " only allowed last in chain of " + radioBuildingBlock2.getName());
                }
                if (!bl && !arrayList.contains(radioBuildingBlock2.getName())) {
                    throw new BemException(radioBuildingBlock2.getName() + " only allowed last in chain of " + radioBuildingBlock.getName());
                }
            } else if (!arrayList.contains(radioBuildingBlock.getName()) || !arrayList.contains(radioBuildingBlock2.getName())) {
                throw new BemException("Asymmetric configuration of sectors whith " + radioBuildingBlock.getName() + ",\n" + "and " + radioBuildingBlock2.getName() + " not allowed");
            }
        }
    }

    private void updateRbbPreconditionReconfRestrictions() throws BemException {
        for (int i = 1; i <= this.maxNoOfSectors; ++i) {
            Reconfiguration reconfiguration;
            this.resetRbbPreconditionReconfRestrictions(i);
            if (this.radioBuildingBlocks[i - 1] == null || (reconfiguration = this.getReconfiguration(i)) == null) continue;
            boolean bl = reconfiguration.isPreconditionsMet();
            if (!bl) {
                RadioBuildingBlock[] radioBuildingBlockArray = new RadioBuildingBlock[]{reconfiguration.getToRadioBuildingBlock()};
                EnumeratedRange enumeratedRange = this.getRadioBuildingBlockRange(radioBuildingBlockArray, i, false);
                String string = reconfiguration.getFailReasons();
                this.rbbPreconditionReconfRestriction[i - 1] = new ParameterRestriction(PRECONDITIONS_NOT_MET_RESTRICTION + string, enumeratedRange, false);
                this.radioBuildingBlockParameters[i - 1].addRestriction(this.rbbPreconditionReconfRestriction[i - 1]);
                continue;
            }
            reconfiguration.ciRequests();
        }
    }

    private void updateDeleteSectorRestrictions() throws BemException {
        CellAndCarrierProvider cellAndCarrierProvider = null;
        try {
            cellAndCarrierProvider = this.rbs.getCellAndCarrierProvider();
        }
        catch (Exception exception) {
            throw new BemException("getCellAndCarrierProvider", "CellAndCarrierCI", (Throwable)exception);
        }
        for (int i = 1; i <= this.maxNoOfSectors; ++i) {
            EnumeratedRange enumeratedRange;
            this.resetDeleteSectorRestrictions(i);
            RadioBuildingBlock radioBuildingBlock = (RadioBuildingBlock)this.installedRadioBuildingBlocks.get(new Integer(i));
            if (radioBuildingBlock == null) continue;
            boolean bl = cellAndCarrierProvider.areCellsOffline(i);
            if (!bl) {
                if (this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1) && i > 6) {
                    enumeratedRange = new EnumeratedRange(new String[]{"NO"});
                    this.deleteSectorRestriction[i - 1] = new ParameterRestriction(NOT_POSSIBLE_TO_DELETE_SECTOR + i + ". " + "All cells in sector must be offline", enumeratedRange, false);
                    this.createSectorParameters[i - 1].addRestriction(this.deleteSectorRestriction[i - 1]);
                    continue;
                }
                enumeratedRange = new EnumeratedRange(new String[]{this.NO_CONF});
                this.deleteSectorRestriction[i - 1] = new ParameterRestriction(NOT_POSSIBLE_TO_DELETE_SECTOR + i + ". " + "All cells in sector must be offline", enumeratedRange, false);
                this.radioBuildingBlockParameters[i - 1].addRestriction(this.deleteSectorRestriction[i - 1]);
                continue;
            }
            if (!this.isRadioIfTypeObif(0) && (!this.isRadioIfTypeObif(1) || i <= 6) || this.okToDelete(i)) continue;
            enumeratedRange = new EnumeratedRange(new String[]{"NO"});
            this.deleteSectorRestriction[i - 1] = new ParameterRestriction(NOT_POSSIBLE_TO_DELETE_SECTOR + i + ". " + "\nDeletion of sectors in a cascading chain are only permitted att the end of the chain", enumeratedRange, false);
            this.createSectorParameters[i - 1].addRestriction(this.deleteSectorRestriction[i - 1]);
            if (this.createSectorRestriction[i - 1] == null) continue;
            this.createSectorRestriction[i - 1].setActive(false);
        }
    }

    private boolean sectorToBeDeleted(int n) {
        String string = this.createSectorParameters[n - 1].getValue();
        RadioBuildingBlock radioBuildingBlock = this.radioBuildingBlocks[n - 1];
        return string != null && string.equals(this.VALUE_NO) && radioBuildingBlock == null;
    }

    private boolean okToDelete(int n) {
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < this.installedPortAndSequence.size(); ++i) {
            String string = this.getPortIdString(new Integer(i + 1));
            int[] nArray = (int[])this.installedPortAndSequence.get(string);
            if (nArray.length > 0) {
                if (n == nArray[nArray.length - 1]) {
                    bl = true;
                    break;
                }
                block1: for (int j = 0; j < nArray.length; ++j) {
                    if (n != nArray[j]) continue;
                    bl2 = true;
                    for (int k = j + 1; k < nArray.length; ++k) {
                        int n2 = nArray[k];
                        if (this.sectorToBeDeleted(n2)) continue;
                        bl = false;
                        continue block1;
                    }
                }
            }
            if (bl2) break;
        }
        return bl;
    }

    private void checkRadioBuildingBlocks() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            String string = this.radioBuildingBlockParameters[i].getValue();
            if (string.equals(this.NO_CONF) || this.radioBuildingBlockParameters[i] != null) continue;
            throw new BemException("Sector " + (i + 1) + ": Invalid value for Radio Building Block");
        }
    }

    private void checkCreateSector() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            String string = this.createSectorParameters[i].getValue();
            if (string.equals(this.VALUE_NO) || this.radioBuildingBlocks[i] != null) continue;
            throw new BemException("Sector " + (i + 1) + ": Invalid value for create sector: createSector=YES but no Radio Building Block is selected");
        }
    }

    private void checkAllocatedResources(int[] nArray) throws BemException {
        boolean bl;
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl = nArray.length > 3;
        if ((this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1)) && this.obif.isInstalled()) {
            this.updatePortAndSequence();
            this.checkPortAndSequence();
            this.setReservedConnectors();
        }
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n3;
            int n4;
            if (this.radioBuildingBlocks[i] == null) continue;
            if (bl && this.radioBuildingBlocks[i].getNoOfCarriers() > 2) {
                throw new BemException("Only possible to configure max 2 carriers/sector if\n more than 3 sectors are used");
            }
            n2 += this.radioBuildingBlocks[i].getNoOfRuws();
            if ((n += this.radioBuildingBlocks[i].getNoOfRus()) > 6) {
                throw new BemException("The total number of configured RU can not exceed 6, is = " + n);
            }
            if (n2 > 6) {
                throw new BemException("The total number of configured RUW can not exceed 6, is = " + n2);
            }
            boolean bl3 = this.installedRadioBuildingBlocks.containsValue(this.radioBuildingBlocks[i]);
            if (bl3) continue;
            Set set = this.installedRadioBuildingBlocks.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                RadioBuildingBlock radioBuildingBlock;
                Integer n5 = (Integer)iterator.next();
                if (n5 == i + 1 || this.radioBuildingBlocks[i] == (radioBuildingBlock = (RadioBuildingBlock)this.installedRadioBuildingBlocks.get(n5)) || radioBuildingBlock == null || this.getReconfiguration(n5) != null || (n4 = (int)(this.usesSameResources(n3 = i + 1, n5, this.radioBuildingBlocks[i], radioBuildingBlock) ? 1 : 0)) == 0) continue;
                throw new BemException("Resources for sector " + this.radioBuildingBlocks[i].getSectorNo() + " are already allocated to the existing sector " + radioBuildingBlock.getSectorNo());
            }
            for (int j = 0; j < i; ++j) {
                boolean bl4;
                boolean bl5;
                if (this.radioBuildingBlocks[j] == null || (bl5 = this.installedRadioBuildingBlocks.containsValue(this.radioBuildingBlocks[j])) || !(bl4 = this.usesSameResources(n3 = i + 1, n4 = j + 1, this.radioBuildingBlocks[i], this.radioBuildingBlocks[j]))) continue;
                throw new BemException("Resources for sector " + this.radioBuildingBlocks[i].getSectorNo() + " are already allocated to the planned sector " + this.radioBuildingBlocks[j].getSectorNo());
            }
        }
    }

    private void setReservedConnectors() {
        ReservedConnectorRI[] reservedConnectorRIArray = new ReservedConnectorRI[6];
        String string = MimOpticalInterfaceLink.MOTYPENAME;
        String string2 = "objectAConnector";
        int[] nArray = this.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            ReservedConnectorRI reservedConnectorRI = null;
            ReservedConnectorRI reservedConnectorRI2 = null;
            ReservedConnectorRI reservedConnectorRI3 = null;
            ReservedConnectorRI reservedConnectorRI4 = null;
            ReservedConnectorRI reservedConnectorRI5 = null;
            ReservedConnectorRI reservedConnectorRI6 = null;
            int n = nArray[i];
            String string3 = this.primaryPortIdParameters[n - 1].getValue();
            if (string3 == "") continue;
            int n2 = this.getPortIdInt(string3);
            switch (n2) {
                case 1: {
                    reservedConnectorRI = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 1, string, string2);
                    break;
                }
                case 2: {
                    reservedConnectorRI2 = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 2, string, string2);
                    break;
                }
                case 3: {
                    reservedConnectorRI3 = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 3, string, string2);
                    break;
                }
                case 5: {
                    reservedConnectorRI4 = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 5, string, string2);
                    break;
                }
                case 6: {
                    reservedConnectorRI5 = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 6, string, string2);
                    break;
                }
                case 7: {
                    reservedConnectorRI6 = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 7, string, string2);
                }
            }
            reservedConnectorRIArray[0] = reservedConnectorRI;
            reservedConnectorRIArray[1] = reservedConnectorRI2;
            reservedConnectorRIArray[2] = reservedConnectorRI3;
            reservedConnectorRIArray[3] = reservedConnectorRI4;
            reservedConnectorRIArray[4] = reservedConnectorRI5;
            reservedConnectorRIArray[5] = reservedConnectorRI6;
            this.radioBuildingBlocks[n - 1].setRadioIfConnectors(n, reservedConnectorRIArray);
        }
    }

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        ConfigurationCheckReport configurationCheckReport = new ConfigurationCheckReport();
        configurationCheckReport.addReportEntry(this.checkSectorConfiguration());
        return configurationCheckReport;
    }

    private List checkSectorConfiguration() throws BemException {
        ArrayList<ReportEntry> arrayList = new ArrayList<ReportEntry>();
        int[] nArray = this.getEquippedSectors();
        if (nArray.length == 0) {
            arrayList.add(new ReportEntry("Stopping", "", "", "", "Cannot find any equipped sector."));
            return arrayList;
        }
        return arrayList;
    }

    private void checkPortAndSequence() throws BemException {
        block13: {
            String string;
            int n;
            String string2;
            block12: {
                String string3;
                int n2;
                string2 = this.configGroupParameter.getValue();
                if (string2.equals("")) {
                    return;
                }
                int[] nArray = this.getEquippedSectors();
                for (n = 0; n < nArray.length; ++n) {
                    n2 = nArray[n];
                    if (this.rbsWithRuifAndObif() && n2 <= 6) continue;
                    string3 = this.primaryPortIdParameters[n2 - 1].getValue();
                    string = this.sectorSequenceParameters[n2 - 1].getValue();
                    if (string3.equals(this.NO_CONF)) {
                        throw new BemException("primaryPortId must be defined");
                    }
                    if (!string.equals(this.NO_CONF)) continue;
                    throw new BemException("sectorSequenceNumber must be defined");
                }
                if (!string2.equals(this.ALL1)) break block12;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    int n3 = nArray[n2];
                    string = this.sectorSequenceParameters[n3 - 1].getValue();
                    string3 = this.primaryPortIdParameters[n3 - 1].getValue();
                    if (!string.equals(this.NO_CONF) && Integer.valueOf(string) != 1) {
                        throw new BemException("sectorSequenceNumber can only be = 1 if configurationGroup = ALL1");
                    }
                    String string4 = this.radioBuildingBlocks[n3 - 1].getName();
                    if (!string4.equals("RRB01") && !string4.startsWith("RRB02") && string3.equals("F")) {
                        throw new BemException("Primary Port Id F cannot be used\n for radio building block " + string4 + "\n" + " because " + string4 + " uses two ports");
                    }
                    if (!string3.equals(this.NO_CONF) && arrayList.contains(string3)) {
                        throw new BemException("PrimaryPortId must be different for all sectors\n if configurationGroup = ALL1");
                    }
                    if (string3.equals(this.NO_CONF)) continue;
                    arrayList.add(string3);
                }
                break block13;
            }
            for (n = 0; n < this.portAndSequence.length && this.portAndSequence[n] != null; ++n) {
                int[] nArray = this.portAndSequence[n];
                String string5 = this.getPortIdString(new Integer(n + 1));
                this.checkNumberOfRusPerPort(string5, nArray);
                for (int i = 0; i < nArray.length - 1; ++i) {
                    int n4 = nArray[i];
                    String string6 = this.sectorSequenceParameters[n4 - 1].getValue();
                    for (int j = 0; j < nArray.length - 1 && i != j; ++j) {
                        int n5 = nArray[j];
                        string = this.sectorSequenceParameters[n5 - 1].getValue();
                        if (!string.equals(string6)) continue;
                        throw new BemException("sectorSequenceNumber must be\n different for all sectors with the same \nprimaryPortId. Sectors" + n4 + " and " + n5 + " have the same \n" + " sequence number: " + string + " and primary port Id: " + string5 + "." + "Addition of a sector in a cascading chain are only permitted att the end of the chain");
                    }
                }
            }
            if (!string2.equals(this.AB3)) break block13;
            for (n = 1; n < this.portAndSequence.length; ++n) {
                int[] nArray = this.portAndSequence[n];
                if (nArray.length <= 0) continue;
                for (int i = 0; i < nArray.length; ++i) {
                    String string7 = this.radioBuildingBlocks[nArray[i] - 1].getName();
                    if (string7.equals("RRB02") || string7.equals("RRB02B")) continue;
                    throw new BemException("Only primary port id A can be used\n for the combination of radio building block \n" + string7 + " and configuration group AB3, \n" + " because " + string7 + " uses two ports, A and B.");
                }
            }
        }
    }

    private void checkNumberOfRusPerPort(String string, int[] nArray) throws BemException {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (this.radioBuildingBlocks[n2 - 1] == null) continue;
            n += this.radioBuildingBlocks[n2 - 1].getNoOfRruAndRruwPerPort();
        }
        Integer n3 = this.configGroupParameter.getValueAsInteger();
        switch (n3) {
            case 0: {
                if (n <= true) break;
                throw new BemException("Max one RRU/RRUW per BU-port. \nIs = " + Integer.toString(n) + " for port " + string);
            }
            case 1: {
                if (n <= 2) break;
                throw new BemException("Max two RRU/RRUW per BU-port.  \nIs = " + Integer.toString(n) + " for port " + string);
            }
            case 2: {
                if (n <= 3) break;
                throw new BemException("Max three RRU/RRUW per BU-port.  \nIs = " + Integer.toString(n) + " for port " + string);
            }
            case 3: {
                if (n <= 6) break;
                throw new BemException("Max 6 RRU/RRUW per BU-port.  \nIs = " + Integer.toString(n) + " for port " + string);
            }
        }
    }

    private boolean usesSameResources(int n, int n2, RadioBuildingBlock radioBuildingBlock, RadioBuildingBlock radioBuildingBlock2) throws BemException {
        List list = radioBuildingBlock.getAllocatedResources();
        List list2 = radioBuildingBlock2.getAllocatedResources();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Iterator iterator2 = list2.iterator();
            if (!(e instanceof ReservedConnectorRI)) continue;
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (!(e2 instanceof ReservedConnectorRI)) continue;
                ReservedConnectorRI reservedConnectorRI = (ReservedConnectorRI)e;
                ReservedConnectorRI reservedConnectorRI2 = (ReservedConnectorRI)e2;
                if ((this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1)) && this.primaryPortIdParameters[n - 1].getValue().equals(this.primaryPortIdParameters[n2 - 1].getValue()) || !reservedConnectorRI.equals(reservedConnectorRI2)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract void createRadioBuildingBlocks() throws BemException;

    protected abstract void createSubracks() throws BemException;

    protected abstract void createRadioInterfaceBoard();

    protected abstract RbsCableSets getRbsCableSets();

    protected int getMaxNoOfSectors() {
        return this.maxNoOfSectors;
    }

    protected abstract EnumeratedRange getRadioIfTypeRange();

    public boolean mainRemoteRbs() {
        EnumeratedRange enumeratedRange = this.getRadioIfTypeRange();
        List list = enumeratedRange.getRangeValues();
        return list.contains(this.OBIF);
    }

    public boolean rbsWithRuifAndObif() {
        if (this.radioIfTypeParameters != null) {
            return this.isRadioIfTypeRuif(0) && this.isRadioIfTypeObif(1) && this.maxNoOfSectors > 6;
        }
        return false;
    }

    private void createCustomerParameters() throws BemException {
        this.radioBuildingBlockParameters = new RadioBuildingBlockParameter[this.maxNoOfSectors];
        this.createSectorParameters = new YesNoCustomerParameter[this.maxNoOfSectors];
        this.rfCableSetParameters = new RfCableSetParameter[this.maxNoOfSectors];
        this.digitalCableSetParameters = new DigitalCableSetParameter[this.maxNoOfSectors];
        this.configGroupParameters = new ConfigurationGroupParameter[this.maxNoOfSectors];
        this.primaryPortIdParameters = new PrimaryPortIdParameter[this.maxNoOfSectors];
        this.sectorSequenceParameters = new SectorSequenceNumberParameter[this.maxNoOfSectors];
        this.portAndSequence = new int[6][];
        this.carrierAllocationMode = new CarrierAllocationModeParameter("carrierAllocationMode", this.rbs);
        this.carrierAllocationMode.addCustomerParameterListener(new CarrierAllocationModeListener());
        this.rbbPreconditionReconfRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.deleteSectorRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.createSectorRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.supportedPortIdRangeRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.supportedSectorSequenceRangeRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.supportedConfGroupRangeRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.notSupportedIgnoreRestrictions = new ParameterRestriction[this.maxNoOfSectors];
        this.notSupportedIgnoreRestriction = new ParameterRestriction("Not supported", 1);
        this.createBaseBandPoolParameters();
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            SectorCapability sectorCapability = this.sectorCapabilityMgr.getSectorCapability(i + 1);
            RadioBuildingBlock[] radioBuildingBlockArray = sectorCapability.getConfigurations();
            EnumeratedRange enumeratedRange = this.getRadioBuildingBlockRange(radioBuildingBlockArray, true, i + 1);
            this.radioBuildingBlockParameters[i] = new RadioBuildingBlockParameter(this.radioBuildingBlockServiceNames[i], enumeratedRange);
            this.addParameter(this.radioBuildingBlockParameters[i]);
            this.createSectorParameters[i] = new YesNoCustomerParameter(this.createSectorServiceNames[i]);
            this.addParameter(this.createSectorParameters[i]);
            EnumeratedRange enumeratedRange2 = this.getConfigurationGroupRange(true);
            this.configGroupParameters[i] = new ConfigurationGroupParameter(this.configGroupServiceNames[i], enumeratedRange2);
            this.addParameter(this.configGroupParameters[i]);
            EnumeratedRange enumeratedRange3 = this.getPrimaryPortIdRange(this.maxNoOfSectors, true);
            this.primaryPortIdParameters[i] = new PrimaryPortIdParameter(this.primaryPortIdServiceNames[i], enumeratedRange3);
            this.addParameter(this.primaryPortIdParameters[i]);
            EnumeratedRange enumeratedRange4 = this.getSectorSequenceRange(this.maxNoOfSectors, true);
            this.sectorSequenceParameters[i] = new SectorSequenceNumberParameter(this.sectorSequenceServiceNames[i], enumeratedRange4);
            this.addParameter(this.sectorSequenceParameters[i]);
            EnumeratedRange enumeratedRange5 = this.getRfCableRange();
            this.rfCableSetParameters[i] = new RfCableSetParameter(this.rfCableSetServiceNames[i], enumeratedRange5);
            this.addParameter(this.rfCableSetParameters[i]);
            EnumeratedRange enumeratedRange6 = this.getDigitalCableRange();
            this.digitalCableSetParameters[i] = new DigitalCableSetParameter(this.digitalCableSetServiceNames[i], enumeratedRange6);
            this.addParameter(this.digitalCableSetParameters[i]);
        }
        this.addParameter(this.carrierAllocationMode);
        this.createConfGroupParameter();
    }

    protected RadioBuildingBlockParameter getRadioBuildingBlockParameter(int n) {
        if (n <= this.radioBuildingBlockParameters.length) {
            return this.radioBuildingBlockParameters[n - 1];
        }
        return null;
    }

    private void updateCableRestrictions() throws BemException {
        this.rfCableRestriction = new ParameterRestriction("Not supported", 1);
        this.digitalCableRestriction = new ParameterRestriction("Not supported", 1);
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            if (!this.isRadioIfTypeObif(0) && !this.isRadioIfTypeObif(1) && (!this.isRadioIfTypeRuif(0) && !this.isRadioIfTypeXcu(0) || this.cableSet)) continue;
            this.rfCableSetParameters[i].addRestriction(this.rfCableRestriction);
            this.digitalCableSetParameters[i].addRestriction(this.digitalCableRestriction);
        }
    }

    private void createBaseBandPoolParameters() throws BemException {
        this.radioIfTypeParameters = new RadioIfTypeParameter[this.maxNumberOfBaseBandPools];
        this.poolNumberParameters = new IntegerParameter[this.maxNumberOfBaseBandPools];
        EnumeratedRange enumeratedRange = this.getRadioIfTypeRange();
        IntegerRange integerRange = new IntegerRange(0, Integer.MAX_VALUE);
        List list = enumeratedRange.getRangeValues();
        for (int i = 0; i < this.maxNumberOfBaseBandPools; ++i) {
            if (i < 1 && this.maxNoOfSectors > 6 && !this.rbs.isPantherHybridRbs()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("RUIF");
                EnumeratedRange enumeratedRange2 = new EnumeratedRange(arrayList);
                this.radioIfTypeParameters[i] = new RadioIfTypeParameter(enumeratedRange2, this.radioIfTypeServiceNames[i]);
            } else {
                this.radioIfTypeParameters[i] = this.rbs.isPantherHybridRbs() && i > 0 ? new RadioIfTypeParameter(enumeratedRange, this.radioIfTypeServiceNames[i], this.DUI_O) : new RadioIfTypeParameter(enumeratedRange, this.radioIfTypeServiceNames[i]);
            }
            this.poolNumberParameters[i] = new IntegerParameter(this.poolNumberServiceNames[i], integerRange);
        }
        if (list.size() == 1) {
            String string = (String)list.get(0);
            this.radioIfTypeParameters[0].setValue(string);
            this.radioIfTypeParameters[0].setDefaultValue(string);
        }
        this.addParameter(this.radioIfTypeParameters[0]);
        this.addParameter(this.poolNumberParameters[0]);
        if (this.maxNoOfSectors > 6 || this.rbs.isPantherHybridRbs() || this.rbs.isChoiceOfRadioIfTypeSupported() && DuwUtil.hasDualDuws()) {
            this.addParameter(this.radioIfTypeParameters[1]);
            this.addParameter(this.poolNumberParameters[1]);
        }
    }

    private void createConfGroupParameter() throws BemException {
        EnumeratedRange enumeratedRange = this.getConfigurationGroupRange(false);
        this.configGroupParameter = new ConfigurationGroupParameter("configurationGroup", enumeratedRange);
        this.configGroupParameter.setValue(this.ALL1);
        this.addParameter(this.configGroupParameter);
    }

    private void initiateCustomerParameters() throws BemException {
        this.setDefaultValues();
        this.addParameterListeners();
    }

    private void setDefaultValues() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            this.createSectorParameters[i].setDefaultValue(this.VALUE_NO);
            this.radioBuildingBlockParameters[i].setDefaultValue(this.NO_CONF);
        }
    }

    private void addParameterListeners() {
        int n;
        for (n = 0; n < this.maxNoOfSectors; ++n) {
            this.createSectorParameters[n].addCustomerParameterListener(new CreateSectorListener(n));
            this.radioBuildingBlockParameters[n].addCustomerParameterListener(new RadioBuildingBlockListener(n));
            this.configGroupParameters[n].addCustomerParameterListener(new ConfGroupParameterListener(n));
        }
        for (n = 0; n < this.radioIfTypeParameters.length; ++n) {
            this.radioIfTypeParameters[n].addCustomerParameterListener(new RadioIfTypeListener());
        }
        this.configGroupParameter.addCustomerParameterListener(new ConfigurationGroupListener());
    }

    private void updateRestrictions() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            this.notSupportedIgnoreRestrictions[i] = new ParameterRestriction("Not supported", 1);
            if (!this.mainRemoteRbs() || !this.isRadioIfTypeObif(0) && !this.isRadioIfTypeObif(1) || this.rbsWithRuifAndObif() && i < 6) {
                this.configGroupParameters[i].addRestriction(this.notSupportedIgnoreRestrictions[i]);
                this.primaryPortIdParameters[i].addRestriction(this.notSupportedIgnoreRestrictions[i]);
                this.sectorSequenceParameters[i].addRestriction(this.notSupportedIgnoreRestrictions[i]);
            }
            this.updateRbbRestrictions(i);
        }
        if (!this.rbsWithRuifAndObif() && !this.mainRemoteRbs()) {
            this.configGroupParameter.addRestriction(this.notSupportedIgnoreRestriction);
        } else {
            Integer n = this.configGroupParameter.getValueAsInteger();
            int n2 = n;
            this.updateSectorSequenceNumberRange(n2);
        }
        if (!this.rbs.isChoiceOfRadioIfTypeSupported()) {
            this.radioIfTypeParameters[0].addRestriction(this.notSupportedIgnoreRestriction);
            this.radioIfTypeParameters[1].addRestriction(this.notSupportedIgnoreRestriction);
        } else if (!(this.ruif[1] != null && this.ruif[1].isInstalled() || this.ruif[0] == null || !this.ruif[0].isInstalled() || this.obif != null && this.obif.isInstalled())) {
            this.radioIfTypeParameters[1].addRestriction(this.notSupportedIgnoreRestriction);
        }
    }

    private void createSectors() throws BemException {
        this.sectors = new SectorRI[this.maxNoOfSectors];
        AntennaSystemProvider antennaSystemProvider = null;
        try {
            antennaSystemProvider = this.rbs.getAntennaSystemProvider();
        }
        catch (Exception exception) {
            throw new BemException("getAntennaSystemProvider", "AntennaSystemCI", (Throwable)exception);
        }
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = i + 1;
            this.sectors[i] = new SectorRI(this.rbs, antennaSystemProvider.getSectorLdn(n), n);
        }
    }

    private void updateCreateSector(int n) throws BemException {
        this.updateConfigurationType(n);
    }

    private void updateSectorParameters() throws BemException {
        if (this.isRadioIfTypeRuif(1) && this.maxNoOfSectors > 6) {
            for (int i = 7; i <= this.maxNoOfSectors; ++i) {
                this.resetSectorParameters(i);
            }
        }
    }

    private void resetSectorParameters(int n) {
        this.createSectorParameters[n - 1].setValue(this.VALUE_NO);
        this.radioBuildingBlockParameters[n - 1].setValue(this.NO_CONF);
    }

    private void updateConfGroupParameters() throws BemException {
        String string = this.configGroupParameter.getValue();
        Integer n = this.configGroupParameter.getValueAsInteger();
        int n2 = n;
        this.updateRbbRanges();
        this.updatePortIdRange(n2);
        this.updateSectorSequenceNumberRange(n2);
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            this.configGroupParameters[i].setValue(string);
        }
    }

    private void updateConfigurationGroup(int n) throws BemException {
        String string = this.configGroupParameters[n].getValue();
        String string2 = this.configGroupParameter.getValue();
        if (!string2.equals(string) && !string.equals(this.NO_CONF)) {
            this.configGroupParameter.setValue(string);
        }
    }

    private void updateConfGroupRange() {
        if (this.maxNoOfSectors > 6) {
            for (int i = 1; i <= this.maxNoOfSectors; ++i) {
                this.resetSupportedConfGroupRangeRestriction(i);
                EnumeratedRange enumeratedRange = this.getConfigurationGroupRange(false);
                this.supportedConfGroupRangeRestriction[i - 1] = new ParameterRestriction(RECONFIGURATION_NOT_SUPPORTED_RESTRICTION, enumeratedRange, true);
                this.configGroupParameters[i - 1].addRestriction(this.supportedConfGroupRangeRestriction[i - 1]);
            }
            this.configGroupParameter.removeRestriction(this.supportedConfGroupRangeRestriction[this.maxNoOfSectors - 1]);
            this.configGroupParameter.addRestriction(this.supportedConfGroupRangeRestriction[this.maxNoOfSectors - 1]);
        }
    }

    private void resetSupportedConfGroupRangeRestriction(int n) {
        if (this.supportedConfGroupRangeRestriction[n - 1] != null) {
            this.configGroupParameters[n - 1].removeRestriction(this.supportedConfGroupRangeRestriction[n - 1]);
            this.supportedConfGroupRangeRestriction[n - 1] = null;
        }
    }

    private void updateRadioIfType() throws BemException {
        if (this.isRadioIfTypeRuif(0) && this.isRadioIfTypeObif(1)) {
            this.updateConfGroupRange();
        }
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            this.updateConfigurationType(i);
        }
        this.updateRbbRanges();
    }

    private void updateRadioBuildingBlock(int n) throws BemException {
        String string = this.configGroupParameters[n].getValue();
        if (string.equals(this.ALL1) && this.radioBuildingBlockParameters[n].getValue() != "") {
            this.sectorSequenceParameters[n].setValue("1");
        } else if (this.radioBuildingBlockParameters[n].getValue().equals("") || !string.equals(this.ALL1)) {
            this.sectorSequenceParameters[n].setValue("");
        }
        this.updateConfigurationType(n);
        this.updateRbbRestrictions(n);
    }

    private void updateOil() throws BemException {
        this.updatePortAndSequence();
        for (int i = 0; i < this.portAndSequence.length && this.portAndSequence[i] != null; ++i) {
            RadioBuildingBlock radioBuildingBlock;
            int[] nArray = this.portAndSequence[i];
            if (nArray.length > 0) {
                int n = nArray[0];
                radioBuildingBlock = this.radioBuildingBlocks[n - 1];
                String string = this.primaryPortIdParameters[n - 1].getValue();
                int n2 = this.getPortIdInt(string);
                radioBuildingBlock.updatePrimaryConnector(n, new Integer(n2));
            }
            for (int j = 0; j < nArray.length - 1 && nArray.length > 1; ++j) {
                int n = nArray[j];
                radioBuildingBlock = this.radioBuildingBlocks[n - 1];
                String string = radioBuildingBlock.getObjARefForCascade();
                String string2 = radioBuildingBlock.getObjBRefForCascade();
                Integer n3 = radioBuildingBlock.getObjAConnForCascade();
                Integer n4 = radioBuildingBlock.getObjBConnForCascade();
                int n5 = nArray[j + 1];
                RadioBuildingBlock radioBuildingBlock2 = this.radioBuildingBlocks[n5 - 1];
                radioBuildingBlock2.updateOil(n5, string, string2, n3, n4);
            }
        }
    }

    private void updateConfigurationType(int n) throws BemException {
        boolean bl = true;
        String string = this.NO_CONF;
        RadioBuildingBlock radioBuildingBlock = null;
        SectorCapability sectorCapability = this.sectorCapabilityMgr.getSectorCapability(++n);
        String string2 = this.getBBPoolRadioInterfaceType(0);
        RadioBuildingBlockParameter radioBuildingBlockParameter = this.radioBuildingBlockParameters[n - 1];
        string = radioBuildingBlockParameter.getValue();
        if (this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1) || n > 6) {
            if (this.obif.isInstalled()) {
                if (string != this.NO_CONF) {
                    this.createSectorParameters[n - 1].setLoadedValue(this.VALUE_YES);
                } else if (string == this.NO_CONF && !this.sectors[n - 1].isInstalled()) {
                    this.createSectorParameters[n - 1].setLoadedValue(this.VALUE_NO);
                }
                radioBuildingBlock = bl ? this.getRbbByAllocationMode(sectorCapability.getConfigurationsByNameAndRIFType(string, this.OBIF), this.carrierAllocationMode.getValue()) : null;
            } else {
                YesNoCustomerParameter yesNoCustomerParameter = this.createSectorParameters[n - 1];
                bl = yesNoCustomerParameter.getBooleanValue();
                if (bl) {
                    if (!this.radioBuildingBlockParameters[n - 1].getValue().equals(this.NO_CONF)) {
                        string = this.radioBuildingBlockParameters[n - 1].getValue();
                        radioBuildingBlock = this.getRbbByAllocationMode(sectorCapability.getConfigurationsByName(string), this.carrierAllocationMode.getValue());
                    } else {
                        radioBuildingBlock = sectorCapability.getConfigurationByName("RRB01");
                        if (radioBuildingBlock == null) {
                            radioBuildingBlock = sectorCapability.getConfigurationByName("RRB02B");
                        }
                    }
                }
            }
        }
        if ((this.isRadioIfTypeRuif(0) || this.isRadioIfTypeXcu(0)) && n < 7) {
            if (string != this.NO_CONF) {
                this.createSectorParameters[n - 1].setLoadedValue(this.VALUE_YES);
            } else if (string == this.NO_CONF && !this.sectors[n - 1].isInstalled()) {
                this.createSectorParameters[n - 1].setLoadedValue(this.VALUE_NO);
            }
            radioBuildingBlock = bl ? this.getRbbByAllocationMode(sectorCapability.getConfigurationsByNameAndRIFType(string, string2), this.carrierAllocationMode.getValue()) : null;
        }
        if (radioBuildingBlock == null) {
            if ((this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1)) && (!bl || string.equals(this.NO_CONF))) {
                this.radioBuildingBlocks[n - 1] = radioBuildingBlock;
                this.notifyRadioEquipmentListeners(n);
            }
            if ((this.isRadioIfTypeRuif(0) || this.isRadioIfTypeXcu(0)) && string.equals(this.NO_CONF)) {
                this.radioBuildingBlocks[n - 1] = radioBuildingBlock;
                this.notifyRadioEquipmentListeners(n);
            }
        } else {
            this.radioBuildingBlocks[n - 1] = radioBuildingBlock;
            this.notifyRadioEquipmentListeners(n);
        }
        this.rb3ToRb3b(this.getEquippedSectors());
        this.rb4ToRb4b(this.getEquippedSectors());
    }

    public void rb3ToRb3b(int[] nArray) {
        if (this.radioBuildingBlocks != null && this.radioBuildingBlocks.length > 3 && this.radioBuildingBlocks[3] != null && this.radioBuildingBlocks[3] instanceof RB3) {
            for (int i = 0; i < nArray.length; ++i) {
                if (!(this.radioBuildingBlocks[nArray[i] - 1] instanceof RB3)) continue;
                RadioBuildingBlock radioBuildingBlock = null;
                SectorCapability sectorCapability = this.sectorCapabilityMgr.getSectorCapability(nArray[i]);
                this.radioBuildingBlocks[nArray[i] - 1] = radioBuildingBlock = sectorCapability.getConfigurationByName("RB3b");
            }
        }
    }

    protected void updateLoadedValues() throws BemException {
        this.updateBaseBandPoolLoadedValues();
        this.updateRbbLoadedValues();
        this.updateConfigurationGroupLoadedValues();
        if (this.obif != null && this.obif.isInstalled()) {
            this.updateLoadedPortAndSequence(this.radioBuildingBlocks);
        }
    }

    private void updateRbbLoadedValues() throws BemException {
        List[] listArray = this.getRbbCandidates();
        List[] listArray2 = this.getInstalledRbbCandidates(listArray);
        this.carrierAllocationMode.setLoadedValue(this.deduceCarrierAllocationMode(listArray2));
        this.loadedRadioBuildingBlocks = this.getRbbByAllocationMode(listArray2, this.carrierAllocationMode.getValue());
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            RadioBuildingBlock radioBuildingBlock = this.loadedRadioBuildingBlocks[i];
            if (radioBuildingBlock != null) {
                this.installedRadioBuildingBlocks.put(new Integer(i + 1), radioBuildingBlock);
                this.createSectorParameters[i].setLoadedValue(this.VALUE_YES);
                this.radioBuildingBlockParameters[i].setLoadedValue(radioBuildingBlock.getName());
                this.updateRbbRestrictions(i);
                continue;
            }
            if (this.hasObifCandidate(listArray[i]) && this.obif.isInstalled()) {
                this.createSectorParameters[i].setLoadedValue(this.VALUE_YES);
            } else {
                this.createSectorParameters[i].setLoadedValue(this.VALUE_NO);
            }
            this.radioBuildingBlockParameters[i].setLoadedValue(this.NO_CONF);
        }
    }

    private List[] getRbbCandidates() {
        List[] listArray = new List[this.maxNoOfSectors];
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            SectorCapability sectorCapability = this.sectorCapabilityMgr.getSectorCapability(i + 1);
            listArray[i] = Arrays.asList(sectorCapability.getConfigurations());
        }
        return listArray;
    }

    private boolean hasObifCandidate(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RadioBuildingBlock radioBuildingBlock = (RadioBuildingBlock)iterator.next();
            RadioInterfaceBoard[] radioInterfaceBoardArray = radioBuildingBlock.getRadioInterfaceBoards();
            for (int i = 0; i < radioInterfaceBoardArray.length; ++i) {
                if (!radioInterfaceBoardArray[i].getType().equals(this.OBIF)) continue;
                return true;
            }
        }
        return false;
    }

    private void updateBaseBandPoolLoadedValues() throws BemException {
        if (this.obif != null && this.obif.isInstalled()) {
            if (this.ruif[0] != null && this.ruif[0].isInstalled()) {
                this.radioIfTypeParameters[1].setLoadedValue(this.OBIF);
                this.poolNumberParameters[1].setLoadedValue("2");
            } else {
                this.radioIfTypeParameters[0].setLoadedValue(this.OBIF);
                this.poolNumberParameters[0].setLoadedValue("1");
            }
        } else if (this.rbs.isChoiceOfRadioIfTypeSupported() && DuwUtil.hasDuw()) {
            this.radioIfTypeParameters[0].setLoadedValue(this.DUI_E);
            this.poolNumberParameters[0].setLoadedValue("1");
            if (this.rbs.isPantherHybridRbs()) {
                this.radioIfTypeParameters[1].setLoadedValue(this.DUI_O);
                this.poolNumberParameters[1].setLoadedValue("2");
            } else {
                this.radioIfTypeParameters[1].setLoadedValue(this.DUI_E);
                this.poolNumberParameters[1].setLoadedValue("2");
            }
        }
        for (int i = 0; i < this.maxNumberOfBaseBandPools; ++i) {
            if (this.ruif[i] == null || !this.ruif[i].isInstalled()) continue;
            this.poolNumberParameters[i].setLoadedValue(String.valueOf(i + 1));
            this.radioIfTypeParameters[i].setLoadedValue(this.RUIF);
        }
    }

    private void updateConfigurationGroupLoadedValues() throws BemException {
        if (this.obif != null && this.obif.isInstalled()) {
            try {
                MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
                BemMo bemMo = moHandlerImpl.getMo(this.obif.getLdn());
                Integer n = (Integer)moHandlerImpl.getAttribute(bemMo, "configurationGroup");
                String string = this.getConfGroupString(n);
                this.configGroupParameter.setLoadedValue(string);
                for (int i = 0; i < this.maxNoOfSectors; ++i) {
                    this.configGroupParameters[i].setLoadedValue(string);
                }
            }
            catch (Exception exception) {
                throw new BemException(this.getClass().getName(), "updateLoadedValues()", null, "Get configurationGroup attribute", exception);
            }
        }
    }

    private List getRbbsByAllocationMode(List list, String string) {
        ArrayList<RadioBuildingBlock> arrayList = new ArrayList<RadioBuildingBlock>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RadioBuildingBlock radioBuildingBlock = (RadioBuildingBlock)iterator.next();
            if (!radioBuildingBlock.getCarrierAllocationMode().equals(string)) continue;
            arrayList.add(radioBuildingBlock);
        }
        return arrayList;
    }

    private RadioBuildingBlock getRbbByAllocationMode(List list, String string) throws BemException {
        List list2 = this.getRbbsByAllocationMode(list, string);
        if (list2.size() > 1) {
            throw new BemException("Ambiguous choice of Rbb, more than one candidate applies.");
        }
        if (list2.size() == 0) {
            return null;
        }
        return (RadioBuildingBlock)list2.get(0);
    }

    private RadioBuildingBlock[] getRbbByAllocationMode(List[] listArray, String string) throws BemException {
        RadioBuildingBlock[] radioBuildingBlockArray = new RadioBuildingBlock[this.maxNoOfSectors];
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            radioBuildingBlockArray[i] = this.getRbbByAllocationMode(listArray[i], string);
        }
        return radioBuildingBlockArray;
    }

    private String deduceCarrierAllocationMode(List[] listArray) {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            Iterator iterator = listArray[i].iterator();
            HashSet<String> hashSet = new HashSet<String>();
            while (iterator.hasNext()) {
                RadioBuildingBlock radioBuildingBlock = (RadioBuildingBlock)iterator.next();
                hashSet.add(radioBuildingBlock.getCarrierAllocationMode());
            }
            if (!hashSet.contains("Advanced") || hashSet.contains("Basic")) continue;
            return "Advanced";
        }
        return "Basic";
    }

    private List[] getInstalledRbbCandidates(List[] listArray) throws BemException {
        List[] listArray2 = new List[listArray.length];
        for (int i = 0; i < listArray2.length; ++i) {
            listArray2[i] = new ArrayList();
            Iterator iterator = listArray[i].iterator();
            while (iterator.hasNext()) {
                RadioBuildingBlock radioBuildingBlock = (RadioBuildingBlock)iterator.next();
                if (!radioBuildingBlock.isInstalled()) continue;
                listArray2[i].add(radioBuildingBlock);
            }
        }
        return listArray2;
    }

    private void updateLoadedPortAndSequence(RadioBuildingBlock[] radioBuildingBlockArray) throws BemException {
        String string;
        Integer n;
        HashMap<Integer, RadioBuildingBlock> hashMap = new HashMap<Integer, RadioBuildingBlock>();
        int n2 = 1;
        int[] nArray = this.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            String string2 = radioBuildingBlockArray[n3 - 1].getPrevious();
            if (!string2.endsWith(MimPlugInUnit.MOTYPENAME + "=1")) continue;
            this.sectorSequenceParameters[n3 - 1].setLoadedValue("1");
            n = radioBuildingBlockArray[n3 - 1].getPrimaryPortId();
            string = this.getPortIdString(n);
            this.primaryPortIdParameters[n3 - 1].setLoadedValue(string);
            hashMap.put(new Integer(n3), radioBuildingBlockArray[n3 - 1]);
        }
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            string = this.primaryPortIdParameters[n - 1].getLoadedValue();
            n2 = 1;
            int n4 = this.findNextSector(n, radioBuildingBlockArray);
            while (n4 > -1) {
                this.sectorSequenceParameters[n4 - 1].setLoadedValue(String.valueOf(++n2));
                this.primaryPortIdParameters[n4 - 1].setLoadedValue(string);
                n4 = this.findNextSector(n4, radioBuildingBlockArray);
            }
        }
        this.updatePortAndSequence();
        for (int i = 0; i < this.portAndSequence.length; ++i) {
            int[] nArray2 = this.portAndSequence[i];
            String string3 = this.getPortIdString(new Integer(i + 1));
            this.installedPortAndSequence.put(string3, nArray2);
        }
    }

    private int findNextSector(int n, RadioBuildingBlock[] radioBuildingBlockArray) throws BemException {
        int n2 = -1;
        RadioBuildingBlock radioBuildingBlock = radioBuildingBlockArray[n - 1];
        if (radioBuildingBlock == null) {
            return n2;
        }
        int[] nArray = this.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n3 == n || radioBuildingBlockArray[n3 - 1] == null) continue;
            String string = radioBuildingBlock.getTerminationObject("A");
            String string2 = radioBuildingBlock.getTerminationObject("B");
            String string3 = radioBuildingBlockArray[n3 - 1].getPrevious();
            if (!string3.equals(string) && !string3.equals(string2)) continue;
            n2 = n3;
            break;
        }
        return n2;
    }

    private void updatePortAndSequence() throws BemException {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>(COMPARE);
        EnumeratedRange enumeratedRange = this.getPrimaryPortIdRange(this.maxNoOfSectors, false);
        List list = enumeratedRange.getRangeValues();
        int[] nArray = this.getEquippedSectors();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            for (int j = 0; j < nArray.length; ++j) {
                int n = nArray[j];
                String string2 = this.sectorSequenceParameters[n - 1].getValue();
                String string3 = this.primaryPortIdParameters[n - 1].getValue();
                if (string2.equals(this.NO_CONF) || string3.equals(this.NO_CONF)) continue;
                Integer n2 = Integer.valueOf(string2);
                if (!string.equals(string3)) continue;
                Integer n3 = (Integer)treeMap.get(n2);
                if (n3 != null && n3 != n) {
                    throw new BemException("sector sequence number must be different for all sectors\nwith the same primary port id. Sectors " + n + " and " + n3 + " have the same \n" + "sector sequence number = " + n2 + " and primary port id = " + string + ".\n" + "Addition of a sector in a cascading chain are only permitted att the end of the chain");
                }
                treeMap.put(n2, new Integer(n));
            }
            Integer[] integerArray = new Integer[treeMap.size()];
            treeMap.values().toArray(integerArray);
            this.portAndSequence[i] = BemUtil.convertIntegerArrayToIntArray(integerArray);
            treeMap.clear();
        }
    }

    private String getPortIdString(Integer n) {
        EnumeratedRange enumeratedRange = this.getPrimaryPortIdRange(this.maxNoOfSectors, false);
        List list = enumeratedRange.getRangeValues();
        int n2 = n < 4 ? n - 1 : n - 2;
        String string = (String)list.get(n2);
        return string;
    }

    private int getPortIdInt(String string) {
        int n;
        EnumeratedRange enumeratedRange = this.getPrimaryPortIdRange(this.maxNoOfSectors, false);
        List list = enumeratedRange.getRangeValues();
        for (n = 0; n < list.size(); ++n) {
            String string2 = (String)list.get(n);
            if (!string.equals(string2)) continue;
            if (n <= 2) break;
            ++n;
            break;
        }
        return n + 1;
    }

    private String getConfGroupString(Integer n) {
        String string = this.ALL1;
        int n2 = n;
        if (n2 == 0) {
            string = this.ALL1;
        } else if (n2 == 1) {
            string = this.ABC2;
        } else if (n2 == 2) {
            string = this.AB3;
        } else if (n2 == 3) {
            string = this.A6;
        }
        return string;
    }

    private void updateRbbRestrictions(int n) throws BemException {
        this.radioBuildingBlockParameters[n].removeAllRestrictions();
        if (this.loadedRadioBuildingBlocks != null && this.loadedRadioBuildingBlocks[n] != null) {
            SectorCapability sectorCapability = this.sectorCapabilityMgr.getSectorCapability(n + 1);
            List list = sectorCapability.getToReconfigurations(this.loadedRadioBuildingBlocks[n]);
            list.add(this.loadedRadioBuildingBlocks[n]);
            RadioBuildingBlock[] radioBuildingBlockArray = list.toArray(new RadioBuildingBlock[0]);
            EnumeratedRange enumeratedRange = this.getRadioBuildingBlockRange(radioBuildingBlockArray, n + 1, true);
            boolean bl = this.radioBuildingBlockParameters[n] == null || this.radioBuildingBlockParameters[n].getValue().equals(this.NO_CONF);
            ParameterRestriction parameterRestriction = new ParameterRestriction(RECONFIGURATION_NOT_SUPPORTED_RESTRICTION, enumeratedRange, true);
            ParameterRestriction parameterRestriction2 = new ParameterRestriction("Not supported", 1);
            parameterRestriction2.setActive(bl);
            this.radioBuildingBlockParameters[n].addRestriction(parameterRestriction2);
            this.radioBuildingBlockParameters[n].addRestriction(parameterRestriction);
        } else {
            SectorCapability sectorCapability = this.sectorCapabilityMgr.getSectorCapability(n + 1);
            String string = this.getSectorRadioInterfaceType(n);
            List list = sectorCapability.getConfigurationsByRIFType(string);
            List list2 = this.getRbbsByAllocationMode(list, this.carrierAllocationMode.getValue());
            EnumeratedRange enumeratedRange = this.getRadioBuildingBlockRange(list2.toArray(new RadioBuildingBlock[0]), n + 1, true);
            ParameterRestriction parameterRestriction = new ParameterRestriction(CONFIGURATION_NOT_SUPPORTED_RESTRICTION, enumeratedRange, true);
            this.radioBuildingBlockParameters[n].addRestriction(parameterRestriction);
        }
    }

    protected String getBBPoolRadioInterfaceType(int n) {
        return this.radioIfTypeParameters[n].getValue();
    }

    private String getSectorRadioInterfaceType(int n) {
        return n <= 5 ? this.getBBPoolRadioInterfaceType(0) : this.getBBPoolRadioInterfaceType(1);
    }

    private void resetRbbPreconditionReconfRestrictions(int n) {
        if (this.rbbPreconditionReconfRestriction[n - 1] != null) {
            this.radioBuildingBlockParameters[n - 1].removeRestriction(this.rbbPreconditionReconfRestriction[n - 1]);
            this.rbbPreconditionReconfRestriction[n - 1] = null;
        }
    }

    private void updateCreateSectorRestrictions(int n) throws BemException {
        this.createSectorRestriction[n - 1] = new ParameterRestriction("Not supported", 1);
        boolean bl = true;
        if (this.createSectorParameters[n - 1] != null && !this.createSectorParameters[n - 1].getValue().equals("NO")) {
            bl = false;
        }
        this.createSectorRestriction[n - 1].setActive(bl);
        this.createSectorParameters[n - 1].addRestriction(this.createSectorRestriction[n - 1]);
    }

    private void updateConfigurationGroupRestrictions(int n) throws BemException {
        ParameterRestriction parameterRestriction = new ParameterRestriction("Not supported", 1);
        boolean bl = true;
        if (this.configGroupParameters[n - 1] != null && !this.configGroupParameters[n - 1].getValue().equals(this.NO_CONF)) {
            bl = false;
        }
        parameterRestriction.setActive(bl);
        this.configGroupParameters[n - 1].addRestriction(parameterRestriction);
    }

    private void updatePortIdRange(int n) {
        for (int i = 1; i <= this.maxNoOfSectors; ++i) {
            this.resetSupportedPortIdRangeRestriction(i);
            int n2 = this.getNumberOfPorts(n);
            EnumeratedRange enumeratedRange = this.getPrimaryPortIdRange(n2, true);
            this.supportedPortIdRangeRestriction[i - 1] = new ParameterRestriction(PRIMARY_PORT_ID_NOT_SUPPORTED_RESTRICTION, enumeratedRange, true);
            this.primaryPortIdParameters[i - 1].addRestriction(this.supportedPortIdRangeRestriction[i - 1]);
        }
    }

    private void updatePrimaryPortIdRestrictions(int n) throws BemException {
        ParameterRestriction parameterRestriction = new ParameterRestriction("Not supported", 1);
        boolean bl = true;
        if (this.primaryPortIdParameters[n - 1] != null && !this.primaryPortIdParameters[n - 1].getValue().equals(this.NO_CONF)) {
            bl = false;
        }
        parameterRestriction.setActive(bl);
        this.primaryPortIdParameters[n - 1].addRestriction(parameterRestriction);
    }

    private void resetSupportedPortIdRangeRestriction(int n) {
        if (this.supportedPortIdRangeRestriction[n - 1] != null) {
            this.primaryPortIdParameters[n - 1].removeRestriction(this.supportedPortIdRangeRestriction[n - 1]);
            this.supportedPortIdRangeRestriction[n - 1] = null;
        }
    }

    private int getNumberOfPorts(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 6;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 1;
            }
        }
        return n2;
    }

    private void updateSectorSequenceNumberRange(int n) {
        for (int i = 1; i <= this.maxNoOfSectors; ++i) {
            this.resetSupportedSectorSequenceRangeRestriction(i);
            int n2 = this.getNumberOfSectorSequences(n);
            EnumeratedRange enumeratedRange = this.getSectorSequenceRange(n2, true);
            this.supportedSectorSequenceRangeRestriction[i - 1] = new ParameterRestriction(SECTOR_SEQUENCE_NOT_SUPPORTED_RESTRICTION, enumeratedRange, true);
            this.sectorSequenceParameters[i - 1].addRestriction(this.supportedSectorSequenceRangeRestriction[i - 1]);
        }
    }

    private void resetSupportedSectorSequenceRangeRestriction(int n) {
        if (this.supportedSectorSequenceRangeRestriction[n - 1] != null) {
            this.sectorSequenceParameters[n - 1].removeRestriction(this.supportedSectorSequenceRangeRestriction[n - 1]);
            this.supportedSectorSequenceRangeRestriction[n - 1] = null;
        }
    }

    private void updateSectorSequenceRestrictions(int n) throws BemException {
        ParameterRestriction parameterRestriction = new ParameterRestriction("Not supported", 1);
        boolean bl = true;
        if (this.sectorSequenceParameters[n - 1] != null && !this.sectorSequenceParameters[n - 1].getValue().equals(this.NO_CONF)) {
            bl = false;
        }
        parameterRestriction.setActive(bl);
        this.sectorSequenceParameters[n - 1].addRestriction(parameterRestriction);
    }

    private int getNumberOfSectorSequences(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 6;
            }
        }
        return n2;
    }

    private void updateCableParams() {
        Integer n = new Integer(0);
        boolean bl = false;
        Vector<RfCableRI> vector = new Vector<RfCableRI>();
        Vector<RfCableRI> vector2 = new Vector<RfCableRI>();
        for (int i = 0; i < this.sectors.length; ++i) {
            try {
                Object object;
                Object object2;
                Object object3;
                if (!this.sectors[i].isInstalled()) {
                    return;
                }
                n = (Integer)this.sectors[i].getAttribute("band");
                List list = new ArrayList();
                list = this.radioBuildingBlocks[i].getResourceItems();
                if (list != null) {
                    object3 = list.iterator();
                    while (object3.hasNext()) {
                        object2 = (ResourceItem)object3.next();
                        if (object2 instanceof RfCableRI) {
                            object = (RfCableRI)object2;
                            vector.add((RfCableRI)object);
                            continue;
                        }
                        if (!(object2 instanceof DigitalCableRI)) continue;
                        object = (DigitalCableRI)object2;
                        vector2.add((RfCableRI)object);
                    }
                }
                object3 = new CableSet9();
                bl = this.isMatch(n, (AbstractCableSet)object3, vector, vector2);
                if (bl) {
                    this.rfCableSetParameters[i].setLoadedValue(FU_IN_CDU_SHELF);
                    this.digitalCableSetParameters[i].setLoadedValue(INTERNAL);
                    continue;
                }
                object2 = new CableSet7();
                bl = this.isMatch(n, (AbstractCableSet)object2, vector, vector2);
                if (bl) {
                    this.rfCableSetParameters[i].setLoadedValue(FU_IN_BATTERY_SHELF);
                    this.digitalCableSetParameters[i].setLoadedValue(INTERNAL);
                    continue;
                }
                object = new CableSet8();
                bl = this.isMatch(n, (AbstractCableSet)object, vector, vector2);
                if (bl) {
                    this.rfCableSetParameters[i].setLoadedValue(FU_IN_BATTERY_SHELF);
                    this.digitalCableSetParameters[i].setLoadedValue(EXTERNAL);
                    continue;
                }
                CableSet10 cableSet10 = new CableSet10();
                bl = this.isMatch(n, cableSet10, vector, vector2);
                if (!bl) continue;
                this.rfCableSetParameters[i].setLoadedValue(FU_IN_CDU_SHELF);
                this.digitalCableSetParameters[i].setLoadedValue(EXTERNAL);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isMatch(int n, AbstractCableSet abstractCableSet, Vector vector, Vector vector2) throws BemException {
        Object object;
        boolean bl = false;
        String[] stringArray = new String[]{"electricalUlDelay", "ulAttenuation"};
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = null;
        NalNameValue[] nalNameValueArray = null;
        for (int i = 0; i < vector.size(); ++i) {
            bl = false;
            RfCableRI rfCableRI = (RfCableRI)vector.elementAt(i);
            String string = rfCableRI.getNameA((Integer)(object = (Integer)(objectArray2 = rfCableRI.getAttributes(new String[]{"objectAConnector"}))[0]));
            if (string == "RX_A1") {
                nalNameValueArray = abstractCableSet.getRxACableAttributes(n);
            } else if (string == "RX_B1") {
                nalNameValueArray = abstractCableSet.getRxBCableAttributes(n);
            } else if (string == "TX") {
                nalNameValueArray = abstractCableSet.getTxCableAttributes(n);
            }
            objectArray = rfCableRI.getAttributes(stringArray);
            if (!nalNameValueArray[2].getValue().equals(objectArray[0]) || !nalNameValueArray[3].getValue().equals(objectArray[1])) {
                return false;
            }
            bl = true;
        }
        String[] stringArray2 = new String[]{"electricalDelay"};
        object = (DigitalCableRI)vector2.elementAt(0);
        objectArray = ((DigitalCableRI)object).getAttributes(stringArray2);
        nalNameValueArray = abstractCableSet.getData1CableAttributes(n);
        bl = nalNameValueArray[0].getValue().equals(objectArray[0]);
        return bl;
    }

    private void resetDeleteSectorRestrictions(int n) {
        if (this.deleteSectorRestriction[n - 1] != null) {
            if (this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1) && n > 6) {
                this.createSectorParameters[n - 1].removeRestriction(this.deleteSectorRestriction[n - 1]);
            } else if ((this.isRadioIfTypeRuif(0) || this.isRadioIfTypeXcu(0)) && n < 6) {
                this.radioBuildingBlockParameters[n - 1].removeRestriction(this.deleteSectorRestriction[n - 1]);
            }
            this.deleteSectorRestriction[n - 1] = null;
        }
    }

    private void updateLoadedSectors() throws BemException {
        this.noOfExistingSectors = 0;
        for (int i = 0; i < this.sectors.length; ++i) {
            boolean bl = this.sectors[i].isInstalled();
            if (!bl) {
                String string = this.createSectorParameters[i].getLoadedValue();
                if (!string.equals(this.VALUE_NO)) {
                    this.createSectorParameters[i].setLoadedValue(this.VALUE_NO);
                }
                this.notSupportedIgnoreRestrictions[i] = new ParameterRestriction("Not supported", 1);
                this.configGroupParameters[i].addRestriction(this.notSupportedIgnoreRestrictions[i]);
                String string2 = this.radioBuildingBlockParameters[i].getLoadedValue();
                if (string2.equals(this.NO_CONF) || string2.equals("##UNDEFINED")) continue;
                this.radioBuildingBlockParameters[i].setLoadedValue(this.NO_CONF);
                this.installedRadioBuildingBlocks.remove(new Integer(i + 1));
                this.radioBuildingBlocks[i] = null;
                continue;
            }
            ++this.noOfExistingSectors;
            this.installedRadioBuildingBlocks.put(new Integer(i + 1), this.radioBuildingBlocks[i]);
        }
    }

    public int getNumberOfExistingSectors() {
        return this.noOfExistingSectors;
    }

    public int[] getEquippedSectors() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            if (this.radioBuildingBlocks == null || this.radioBuildingBlocks[i] == null) continue;
            arrayList.add(new Integer(i + 1));
        }
        Integer[] integerArray = arrayList.toArray(new Integer[0]);
        int[] nArray = BemUtil.convertIntegerArrayToIntArray(integerArray);
        return nArray;
    }

    private int[] getUsedSectorsWithObif() throws BemException {
        CellAndCarrierProvider cellAndCarrierProvider = this.rbs.getCellAndCarrierProvider();
        String string = this.getBBPoolRadioInterfaceType(0);
        String string2 = this.getBBPoolRadioInterfaceType(1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 1; i <= this.maxNoOfSectors; ++i) {
            if (this.radioBuildingBlocks[i - 1] == null || !cellAndCarrierProvider.isSectorInUse(i)) continue;
            if (i <= 6 && string.equals(this.OBIF)) {
                arrayList.add(new Integer(i));
                continue;
            }
            if (i <= 6 || !string2.equals(this.OBIF)) continue;
            arrayList.add(new Integer(i));
        }
        Integer[] integerArray = arrayList.toArray(new Integer[0]);
        int[] nArray = BemUtil.convertIntegerArrayToIntArray(integerArray);
        return nArray;
    }

    public int[] getExistingSectors() throws BemException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.sectors.length; ++i) {
            if (this.sectors[i] == null || !this.sectors[i].isInstalled()) continue;
            arrayList.add(new Integer(i + 1));
        }
        Integer[] integerArray = arrayList.toArray(new Integer[0]);
        int[] nArray = BemUtil.convertIntegerArrayToIntArray(integerArray);
        return nArray;
    }

    public int getMaxNumberOfCarriers(int n) {
        int n2 = 0;
        RadioBuildingBlock radioBuildingBlock = this.radioBuildingBlocks[n - 1];
        if (radioBuildingBlock != null) {
            n2 = radioBuildingBlock.getNoOfCarriers();
        }
        return n2;
    }

    public int getNumberOfSupportedTxBranches(int n) {
        int n2 = 0;
        int n3 = n - 1;
        if (this.radioBuildingBlocks[n3] != null) {
            n2 = this.radioBuildingBlocks[n3].getNoOfSupportedTxBranches();
        } else if (this.loadedRadioBuildingBlocks[n3] != null && this.rbs.getRbsStep().equals("STEP_EXPANSION")) {
            n2 = this.loadedRadioBuildingBlocks[n3].getNoOfSupportedTxBranches();
        }
        return n2;
    }

    public int getLoadedNumberOfSupportedTxBranches(int n) {
        int n2 = 0;
        if (this.loadedRadioBuildingBlocks[n - 1] != null) {
            n2 = this.loadedRadioBuildingBlocks[n - 1].getNoOfSupportedTxBranches();
        }
        return n2;
    }

    public Integer getTerminationConnector(int n, String string) throws BemException {
        Integer n2 = null;
        if (string.equalsIgnoreCase("DL") || string.equalsIgnoreCase("UL")) {
            n2 = this.getOilTerminationConnector(n, string);
        } else if (this.radioBuildingBlocks[n - 1] != null) {
            n2 = this.radioBuildingBlocks[n - 1].getTerminationConnector(string);
        }
        return n2;
    }

    public String getTerminationObject(int n, String string) throws BemException {
        String string2 = null;
        if (this.radioBuildingBlocks[n - 1] != null) {
            string2 = this.radioBuildingBlocks[n - 1].getTerminationObject(string);
        }
        return string2;
    }

    public void setBand(int n, int n2) throws BemException {
        AbstractCableSet abstractCableSet = null;
        int n3 = this.rfCableSetParameters[n - 1].getAccessLevel();
        if (n3 == 1) {
            if (this.cableSets != null) {
                abstractCableSet = this.cableSets.getCableSet(this.radioBuildingBlocks[n - 1].getName());
            }
        } else {
            String string = this.rfCableSetParameters[n - 1].getValue();
            String string2 = this.digitalCableSetParameters[n - 1].getValue();
            abstractCableSet = this.cableSets.getCableSet(string, string2);
        }
        this.radioBuildingBlocks[n - 1].updateCableCharacteristics(abstractCableSet, n2);
    }

    protected void addSectorCapability(int n, SectorCapability sectorCapability) {
        this.sectorCapabilityMgr.addSectorCapability(n, sectorCapability);
    }

    protected SectorCapability getSectorCapability(int n) {
        return this.sectorCapabilityMgr.getSectorCapability(n);
    }

    private EnumeratedRange getRadioBuildingBlockRange(RadioBuildingBlock[] radioBuildingBlockArray, boolean bl, int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (bl) {
            treeSet.add(this.NO_CONF);
        }
        for (int i = 0; i < radioBuildingBlockArray.length; ++i) {
            treeSet.add(radioBuildingBlockArray[i].getConfiguredRbbName());
        }
        String[] stringArray = new String[treeSet.size()];
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2] = (String)iterator.next();
            ++n2;
        }
        return new EnumeratedRange(stringArray);
    }

    private EnumeratedRange getRadioBuildingBlockRange(RadioBuildingBlock[] radioBuildingBlockArray, int n, boolean bl) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (bl) {
            treeSet.add(this.NO_CONF);
        }
        if (this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1) && n > 6) {
            if (this.isRadioIfTypeRuif(0) && this.isRadioIfTypeObif(1)) {
                for (int i = 0; i < radioBuildingBlockArray.length; ++i) {
                    String string = radioBuildingBlockArray[i].getName();
                    if (string.lastIndexOf("1") == -1 && string.lastIndexOf("2B") == -1 && string.lastIndexOf("3") == -1) continue;
                    treeSet.add(string);
                }
            } else {
                Integer n2 = this.configGroupParameter.getValueAsInteger();
                switch (n2) {
                    case 0: {
                        String string;
                        int n3;
                        for (n3 = 0; n3 < radioBuildingBlockArray.length; ++n3) {
                            string = radioBuildingBlockArray[n3].getName();
                            if (!string.startsWith("RRB01") && !string.startsWith("RRB02") && !string.startsWith("RRB05") && !string.startsWith("RRB06")) continue;
                            treeSet.add(string);
                        }
                        break;
                    }
                    case 1: {
                        String string;
                        int n3;
                        for (n3 = 0; n3 < radioBuildingBlockArray.length; ++n3) {
                            string = radioBuildingBlockArray[n3].getName();
                            if (string.lastIndexOf("2") == -1 && string.lastIndexOf("3") == -1 && string.lastIndexOf("4") == -1) continue;
                            treeSet.add(string);
                        }
                        break;
                    }
                    case 2: {
                        String string;
                        int n3;
                        for (n3 = 0; n3 < radioBuildingBlockArray.length; ++n3) {
                            string = radioBuildingBlockArray[n3].getName();
                            if (string.lastIndexOf("2") == -1 && string.lastIndexOf("5") == -1 && string.lastIndexOf("6") == -1) continue;
                            treeSet.add(string);
                        }
                        break;
                    }
                    case 3: {
                        String string;
                        int n3;
                        for (n3 = 0; n3 < radioBuildingBlockArray.length; ++n3) {
                            string = radioBuildingBlockArray[n3].getName();
                            if (string.lastIndexOf("2") == -1 && string.lastIndexOf("3") == -1) continue;
                            treeSet.add(string);
                        }
                        break;
                    }
                }
            }
        } else if (this.isRadioIfTypeRuif(0) && this.isRadioIfTypeObif(1) && n <= 6) {
            for (int i = 0; i < radioBuildingBlockArray.length; ++i) {
                String string = radioBuildingBlockArray[i].getName();
                if (!string.startsWith("RB1") && !string.startsWith("RB3")) continue;
                treeSet.add(string);
            }
        } else {
            for (int i = 0; i < radioBuildingBlockArray.length; ++i) {
                String string = radioBuildingBlockArray[i].getName();
                treeSet.add(string);
            }
        }
        String[] stringArray = new String[treeSet.size()];
        Iterator iterator = treeSet.iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            stringArray[n4] = (String)iterator.next();
            ++n4;
        }
        return new EnumeratedRange(stringArray);
    }

    private EnumeratedRange getPrimaryPortIdRange(int n, boolean bl) {
        String[] stringArray = new String[]{"A", "B", "C", "D", "E", "F", "A", "B", "C", "D", "E", "F"};
        TreeSet<String> treeSet = new TreeSet<String>();
        if (bl) {
            treeSet.add(this.NO_CONF);
        }
        for (int i = 0; i < n; ++i) {
            treeSet.add(stringArray[i]);
        }
        String[] stringArray2 = new String[treeSet.size()];
        Iterator iterator = treeSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray2[n2] = (String)iterator.next();
            ++n2;
        }
        return new EnumeratedRange(stringArray2);
    }

    private EnumeratedRange getSectorSequenceRange(int n, boolean bl) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n2 = 1;
        int n3 = n;
        int n4 = 0;
        if (bl) {
            n4 = 1;
        }
        for (int i = n2; i <= n3; ++i) {
            treeSet.add(new Integer(i));
        }
        String[] stringArray = new String[treeSet.size() + n4];
        Iterator iterator = treeSet.iterator();
        if (n4 == 1) {
            stringArray[0] = this.NO_CONF;
        }
        int n5 = n4;
        while (iterator.hasNext()) {
            stringArray[n5] = iterator.next().toString();
            ++n5;
        }
        return new EnumeratedRange(stringArray);
    }

    private EnumeratedRange getConfigurationGroupRange(boolean bl) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (bl) {
            treeSet.add(this.NO_CONF);
        }
        treeSet.add("ALL1");
        treeSet.add("ABC2");
        if (!this.rbsWithRuifAndObif()) {
            treeSet.add("AB3");
            treeSet.add("A6");
        }
        String[] stringArray = new String[treeSet.size()];
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return new EnumeratedRange(stringArray);
    }

    protected AtfProvider getAtfProvider() {
        int n;
        if (this.myAtfProvider != null) {
            return this.myAtfProvider;
        }
        this.myAtfProvider = new AtfProviderImpl();
        if (this.isRadioIfTypeObif(0) || this.isRadioIfTypeObif(1)) {
            for (n = 1; n <= this.maxNoOfSectors; ++n) {
                this.myAtfProvider.putAtfLdns(ALL_CONTROLLERS_OF_RRU_INDEXED_BY_SECTOR[n], this.obif.getPiuLdn());
                this.myAtfProvider.putAtfLdns(ALL_CONTROLLERS_OF_RET_INDEXED_BY_SECTOR[n], this.obif.getPiuLdn());
                this.myAtfProvider.putAtfLdns(AtfProvider.ALL_CONTROLLERS_OF_ASC_INDEXED_BY_SECTOR[n], this.obif.getPiuLdn());
                this.myAtfProvider.putAtfLdns(AtfProvider.ALL_CONTROLLERS_OF_ATMA_INDEXED_BY_SECTOR[n], this.obif.getPiuLdn());
            }
        }
        if (this.isRadioIfTypeRuif(0) || this.isRadioIfTypeXcu(0)) {
            if (this.ruSubrack != null || this.listOfRus != null) {
                int n2;
                RuRI[] ruRIArray = null;
                if (this.ruSubrack != null) {
                    ruRIArray = this.ruSubrack.getSubRIs();
                } else {
                    ruRIArray = new RuRI[this.listOfRus.size()];
                    for (n2 = 0; n2 < this.listOfRus.size(); ++n2) {
                        ruRIArray[n2] = (RuRI)this.listOfRus.get(n2);
                    }
                }
                for (n2 = 0; n2 < ruRIArray.length; ++n2) {
                    this.myAtfProvider.putAtfLdns(AtfProvider.ALL_CONTROLLERS_OF_FU_INDEXED_BY_POSITION[n2 + 1], ruRIArray[n2].getAuxPiuLdn());
                }
            }
            for (n = 1; n <= this.maxNoOfSectors; ++n) {
                String string;
                String string2;
                Object object;
                RadioBuildingBlock radioBuildingBlock;
                if (n > 6 && this.rbsWithRuifAndObif() || (radioBuildingBlock = this.radioBuildingBlocks[n - 1]) == null) continue;
                List list = radioBuildingBlock.getAtfRoleMapping();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    object = (RadioBuildingBlock.SlotToBBPools)iterator.next();
                    if (((RadioBuildingBlock.SlotToBBPools)object).bbPools.length == 1) {
                        string2 = this.getAtfPiuLdn(((RadioBuildingBlock.SlotToBBPools)object).bbPools[0]);
                        this.myAtfProvider.putAtfLdns("CONTROLLER_OF_RADIO_UNIT_POSITION_" + ((RadioBuildingBlock.SlotToBBPools)object).slotNumber, string2);
                        continue;
                    }
                    if (((RadioBuildingBlock.SlotToBBPools)object).bbPools.length != 2) continue;
                    string2 = this.getAtfPiuLdn(((RadioBuildingBlock.SlotToBBPools)object).bbPools[0]);
                    string = this.getAtfPiuLdn(((RadioBuildingBlock.SlotToBBPools)object).bbPools[1]);
                    this.myAtfProvider.putAtfLdns("CONTROLLER_OF_RADIO_UNIT_POSITION_" + ((RadioBuildingBlock.SlotToBBPools)object).slotNumber, string2, string);
                }
                object = ((RadioBuildingBlock.SlotToBBPools)list.get((int)0)).bbPools;
                if (((Object)object).length == 1) {
                    string2 = this.getAtfPiuLdn((int)object[0]);
                    this.myAtfProvider.putAtfLdns(AtfProvider.ALL_CONTROLLERS_OF_ASC_INDEXED_BY_SECTOR[n], string2);
                    this.myAtfProvider.putAtfLdns(AtfProvider.ALL_CONTROLLERS_OF_RET_INDEXED_BY_SECTOR[n], string2);
                    this.myAtfProvider.putAtfLdns(AtfProvider.ALL_CONTROLLERS_OF_ATMA_INDEXED_BY_SECTOR[n], string2);
                    continue;
                }
                if (((Object)object).length != 2) continue;
                string2 = this.getAtfPiuLdn((int)object[0]);
                string = this.getAtfPiuLdn((int)object[1]);
                this.myAtfProvider.putAtfLdns(AtfProvider.ALL_CONTROLLERS_OF_ASC_INDEXED_BY_SECTOR[n], string2, string);
                this.myAtfProvider.putAtfLdns(AtfProvider.ALL_CONTROLLERS_OF_RET_INDEXED_BY_SECTOR[n], string2, string);
                this.myAtfProvider.putAtfLdns(AtfProvider.ALL_CONTROLLERS_OF_ATMA_INDEXED_BY_SECTOR[n], string2, string);
            }
        }
        return this.myAtfProvider;
    }

    private EnumeratedRange getRfCableRange() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("FU_In_Battery_Shelf");
        arrayList.add("FU_In_CDU_Shelf");
        EnumeratedRange enumeratedRange = new EnumeratedRange(arrayList);
        return enumeratedRange;
    }

    private EnumeratedRange getDigitalCableRange() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Internal");
        arrayList.add("External");
        EnumeratedRange enumeratedRange = new EnumeratedRange(arrayList);
        return enumeratedRange;
    }

    private void initMoi() {
        MoInstance moInstance = this.rbs.getEquipmentMoi();
        this.hubSubrackMoi = new HubSubrackMoi(moInstance);
    }

    public int getNumberOfDuwSlots() {
        HashSet<RadioInterfaceBoard> hashSet = new HashSet<RadioInterfaceBoard>();
        for (int i = 0; i < this.radioBuildingBlocks.length; ++i) {
            if (this.radioBuildingBlocks[i] == null) continue;
            hashSet.addAll(Arrays.asList(this.radioBuildingBlocks[i].getRadioInterfaceBoards()));
        }
        return hashSet.size();
    }

    public int getMinNumberOfCarriers(int n) {
        int n2 = n - 1;
        return this.radioBuildingBlocks[n2].minNumberOfCarriers();
    }

    protected AbstractRadioBuildingBlock getRadioBuildingBlock(int n) {
        return (AbstractRadioBuildingBlock)this.installedRadioBuildingBlocks.get(new Integer(n));
    }

    public EquippedSectorRadioInfo[] getEquippedSectorsRadioInfo() {
        throw new RuntimeException("Only implemented for DUW");
    }

    public String getConfigurationGroup() {
        String string = this.configGroupParameter.getValue();
        return string;
    }

    public List getRruwMois() {
        ArrayList<MoInstance[]> arrayList = new ArrayList<MoInstance[]>();
        int[] nArray = this.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            MoInstance[] moInstanceArray = this.getRruwMois(n);
            arrayList.add(moInstanceArray);
        }
        return arrayList;
    }

    public MoInstance[] getRruwMois(int n) {
        MoInstance[] moInstanceArray = this.radioBuildingBlocks[n - 1].getRruwMois();
        return moInstanceArray;
    }

    protected SectorRI[] getSectors() {
        return this.sectors;
    }

    private boolean isRadioIfTypeRuif(int n) {
        return this.getBBPoolRadioInterfaceType(n).equals(this.RUIF);
    }

    private boolean isRadioIfTypeObif(int n) {
        return this.getBBPoolRadioInterfaceType(n).equals(this.OBIF);
    }

    private boolean isRadioIfTypeXcu(int n) {
        return this.getBBPoolRadioInterfaceType(n).equals(this.XCU);
    }

    protected List getRadioInterfaceRIs(int n) {
        ArrayList<AbstractDeviceBoardRI> arrayList = new ArrayList<AbstractDeviceBoardRI>();
        if (this.isRadioIfTypeRuif(n)) {
            arrayList.add(this.ruif[n]);
        } else if (this.isRadioIfTypeObif(n)) {
            arrayList.add(this.obif);
        }
        return arrayList;
    }

    protected ResourceItem getRadioInterfaceBoardRI(String string, int n) {
        AbstractDeviceBoardRI abstractDeviceBoardRI = null;
        if (string.equals(this.RUIF)) {
            abstractDeviceBoardRI = this.ruif[n];
        } else if (string.equals(this.OBIF)) {
            abstractDeviceBoardRI = this.obif;
        }
        return abstractDeviceBoardRI;
    }

    protected String getAtfPiuLdn(int n) {
        return this.ruif[n].getPiuLdn();
    }

    public boolean eulSupportInTwoBaseBandPools() {
        boolean bl = false;
        if (this.rbsWithRuifAndObif()) {
            bl = true;
        } else {
            int[] nArray = this.getEquippedSectors();
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (!this.radioBuildingBlocks[n - 1].isEulInTwoBaseBandPoolsSupported()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public int[] getCarriersInSector(int n, int n2) throws BemException {
        int n3 = n2 - 1;
        int[] nArray = new int[]{};
        if (this.radioBuildingBlocks[n3] != null) {
            int n4 = this.radioBuildingBlocks[n3].getNoOfCarriers();
            if (this.radioBuildingBlocks[n3].isDualRadioInterfaceBoardNeeded()) {
                nArray = this.radioBuildingBlocks[n3].getCarriersInBasebandPool(n);
            } else {
                boolean bl = false;
                int[] nArray2 = this.getEquippedSectors(n);
                for (n3 = 0; n3 < nArray2.length; ++n3) {
                    if (nArray2[n3] != n2) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    nArray = new int[n4];
                    for (int i = 0; i < n4; ++i) {
                        nArray[i] = i + 1;
                    }
                }
            }
        }
        return nArray;
    }

    public boolean isCarrierLocatedInBbp(int n, int n2, int n3) throws BemException {
        int[] nArray = this.getCarriersInSector(n - 1, n2);
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n3) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isDualRadioInterfaceBoardNeeded(int n) {
        return this.radioBuildingBlocks[n - 1].isDualRadioInterfaceBoardNeeded();
    }

    public boolean isSectorRemote(int n) {
        RadioBuildingBlock radioBuildingBlock;
        return n > 0 && n <= this.radioBuildingBlocks.length && (radioBuildingBlock = this.radioBuildingBlocks[n - 1]) != null && radioBuildingBlock.getNoOfRrusAndRruws() > 0;
    }

    private Integer getOilTerminationConnector(int n, String string) {
        int n2 = 0;
        int[] nArray = null;
        nArray = string.equalsIgnoreCase("DL") ? new int[]{1, 2, 3, 5, 6, 7} : new int[]{1, 2, 3, 5, 6, 7};
        n2 = nArray[n - 1];
        return new Integer(n2);
    }

    public int[] getSupportedTxDivRange(int n) {
        if (n <= this.radioBuildingBlocks.length && this.radioBuildingBlocks[n - 1] != null) {
            return this.radioBuildingBlocks[n - 1].getSupportedTxDivRange();
        }
        return new int[]{1};
    }

    public String getRbConnectorLdn(int n, int n2) {
        return this.radioBuildingBlocks[n].getConnectorLdn(n2);
    }

    public String getCarrierAllocationMode() {
        return this.carrierAllocationMode.getValue();
    }

    public int getNumberOfSupportedRxBranches(int n) {
        int n2 = 0;
        int n3 = n - 1;
        if (this.radioBuildingBlocks[n3] != null) {
            n2 = this.radioBuildingBlocks[n3].getNoOfSupportedRxBranches();
        } else if (this.loadedRadioBuildingBlocks[n3] != null && this.rbs.getRbsStep().equals("STEP_EXPANSION")) {
            n2 = this.loadedRadioBuildingBlocks[n3].getNoOfSupportedRxBranches();
        }
        return n2;
    }

    public int getLoadedNumberOfSupportedRxBranches(int n) {
        int n2 = 0;
        if (this.loadedRadioBuildingBlocks[n - 1] != null) {
            n2 = this.loadedRadioBuildingBlocks[n - 1].getNoOfSupportedRxBranches();
        }
        return n2;
    }

    public int[] getNumberOfRxBranchesPerAntenna(int n) {
        int n2 = n - 1;
        if (this.radioBuildingBlocks[n2] != null) {
            return this.radioBuildingBlocks[n2].getNumberOfRxBranchesPerAntenna();
        }
        if (this.loadedRadioBuildingBlocks[n2] != null && this.rbs.getRbsStep().equals("STEP_EXPANSION")) {
            return this.loadedRadioBuildingBlocks[n2].getNumberOfRxBranchesPerAntenna();
        }
        return new int[]{2};
    }

    private class ConfGroupParameterListener
    implements CustomerParameterListener {
        int sector;

        public ConfGroupParameterListener(int n) {
            this.sector = n;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                int n = customerParameter.getAccessLevel();
                if (n == 0) {
                    return;
                }
                try {
                    GenericRadioEquipmentCI.this.updateConfigurationGroup(this.sector);
                }
                catch (BemException bemException) {
                    throw new RuntimeException(bemException.toString());
                }
            }
        }
    }

    private class ConfigurationGroupListener
    implements CustomerParameterListener {
        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                int n = customerParameter.getAccessLevel();
                if (n == 0) {
                    return;
                }
                try {
                    GenericRadioEquipmentCI.this.updateConfGroupParameters();
                }
                catch (BemException bemException) {
                    throw new RuntimeException(bemException.toString());
                }
            }
        }
    }

    private class RadioIfTypeListener
    implements CustomerParameterListener {
        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                int n = customerParameter.getAccessLevel();
                if (n == 0) {
                    return;
                }
                try {
                    GenericRadioEquipmentCI.this.updateRadioIfType();
                }
                catch (BemException bemException) {
                    throw new RuntimeException(bemException.toString());
                }
            }
        }
    }

    private class CreateSectorListener
    implements CustomerParameterListener {
        int sector;

        public CreateSectorListener(int n) {
            this.sector = n;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                int n = customerParameter.getAccessLevel();
                if (n == 0) {
                    return;
                }
                try {
                    GenericRadioEquipmentCI.this.updateCreateSector(this.sector);
                }
                catch (BemException bemException) {
                    throw new RuntimeException(bemException.toString());
                }
            }
        }
    }

    private class CarrierAllocationModeListener
    implements CustomerParameterListener {
        private CarrierAllocationModeListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            try {
                for (int i = 0; i < GenericRadioEquipmentCI.this.maxNoOfSectors; ++i) {
                    GenericRadioEquipmentCI.this.updateRadioBuildingBlock(i);
                }
            }
            catch (BemException bemException) {
                throw new RuntimeException("Error updating Rbb restriction ranges", bemException);
            }
        }
    }

    private class RadioBuildingBlockListener
    implements CustomerParameterListener {
        int sector;

        public RadioBuildingBlockListener(int n) {
            this.sector = n;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                int n = customerParameter.getAccessLevel();
                if (n == 0) {
                    return;
                }
                try {
                    GenericRadioEquipmentCI.this.updateRadioBuildingBlock(this.sector);
                }
                catch (BemException bemException) {
                    throw new RuntimeException(bemException.toString());
                }
            }
        }
    }
}

