/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AntennaSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.DefaultReconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.PossibleToUninitSector;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOpticalInterfaceLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRfCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class UninitSectorReconfiguration
extends DefaultReconfiguration {
    private Rbs rbs;
    private RadioBuildingBlock from;
    private RadioBuildingBlock to;
    private boolean antA = false;
    private boolean antB = false;
    private boolean antC = false;
    private boolean antD = false;
    public static final String ATTRNAME_RESERVEDBY = "reservedBy";
    private List rruwLdns = new ArrayList();

    public UninitSectorReconfiguration(Rbs rbs, RadioBuildingBlock radioBuildingBlock, RadioBuildingBlock radioBuildingBlock2, int n) {
        super(radioBuildingBlock, radioBuildingBlock2, n);
        this.rbs = rbs;
        this.from = radioBuildingBlock;
        this.to = radioBuildingBlock2;
        this.addPrecondition(new PossibleToUninitSector(rbs));
    }

    private List getRisToUninstall(String string) throws BemException {
        ArrayList<Object> arrayList;
        block16: {
            Object object;
            Iterator iterator;
            Object object2;
            BemMo[] bemMoArray;
            String string2;
            block15: {
                ResourceItem resourceItem;
                Object object3;
                arrayList = new ArrayList<Object>();
                MoHandler moHandler = this.rbs.getMoHandler();
                ResourceItem resourceItem2 = this.from.getRi(string, "");
                arrayList.add(resourceItem2);
                string2 = resourceItem2.getDisplayName();
                bemMoArray = new BemMo[]{};
                BemMo bemMo = moHandler.getMo(string);
                if (string2.startsWith("FU")) {
                    try {
                        bemMoArray = (BemMo[])moHandler.getAttribute(bemMo, ATTRNAME_RESERVEDBY);
                    }
                    catch (MoHandlerException moHandlerException) {
                        throw new BemException(moHandlerException.toString());
                    }
                    object2 = this.from.getConnectedCables(string, bemMoArray, MimRfCable.MOTYPENAME);
                    iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object3 = (ResourceItem)iterator.next();
                        arrayList.add(object3);
                    }
                }
                if (string2.startsWith("FU")) {
                    try {
                        object3 = (BemMo)moHandler.getAttribute(bemMo, "plugInUnitRef1");
                    }
                    catch (MoHandlerException moHandlerException) {
                        throw new BemException(moHandlerException.toString());
                    }
                    object2 = object3.getDN();
                    object = this.from.getRi((String)object2, MimRuDeviceGroup.MOTYPENAME);
                    arrayList.add(object);
                    string2 = object.getDisplayName();
                } else {
                    object2 = bemMo.getDN();
                    if (resourceItem2.getDisplayName().startsWith("RRUW")) {
                        this.rruwLdns.add(resourceItem2.getLdn());
                        if (this.uninitAlmDeviceRIs()) {
                            object = this.rbs.getAlarmConfigurationProvider();
                            object.requestUnInitAlarms(this.getSector(), this.rruwLdns, this.rbs.getConfigItem("RadioEquipmentCI"));
                        }
                    }
                }
                try {
                    object = moHandler.getMo((String)object2);
                    bemMoArray = (BemMo[])moHandler.getAttribute((BemMo)object, ATTRNAME_RESERVEDBY);
                }
                catch (MoHandlerException moHandlerException) {
                    throw new BemException(moHandlerException.toString());
                }
                object = "";
                if (!string2.startsWith("RU")) break block15;
                object = MimDigitalCable.MOTYPENAME;
                List list = this.from.getConnectedCables((String)object2, bemMoArray, (String)object);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    resourceItem = (ResourceItem)iterator.next();
                    arrayList.add(resourceItem);
                }
                object = MimRfCable.MOTYPENAME;
                list = this.from.getConnectedCables((String)object2, bemMoArray, (String)object);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    resourceItem = (ResourceItem)iterator.next();
                    arrayList.add(resourceItem);
                }
                break block16;
            }
            if (!string2.startsWith("RRU") && !string2.startsWith("RRUW")) break block16;
            object = MimOpticalInterfaceLink.MOTYPENAME;
            List list = this.from.getConnectedCables((String)object2, bemMoArray, (String)object);
            iterator = list.iterator();
            while (iterator.hasNext()) {
                ResourceItem resourceItem = (ResourceItem)iterator.next();
                arrayList.add(resourceItem);
            }
        }
        return arrayList;
    }

    public List getRisToUninstall() throws BemException {
        ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>();
        AntennaSystemProvider antennaSystemProvider = this.rbs.getAntennaSystemProvider();
        int n = this.getSector();
        String string = null;
        CellAndCarrierProvider cellAndCarrierProvider = this.rbs.getCellAndCarrierProvider();
        cellAndCarrierProvider.requestUninitiateSector(this.getSector(), this.rbs.getConfigItem("RadioEquipmentCI"));
        if (this.uninitAntennaRIs()) {
            if (this.antA) {
                string = antennaSystemProvider.getConnectedToObjectARef(n, MimAntennaBranchDef.BRANCH_A);
            } else if (this.antB) {
                string = antennaSystemProvider.getConnectedToObjectARef(n, MimAntennaBranchDef.BRANCH_B);
            }
            if (string != null) {
                arrayList.addAll(this.getRisToUninstall(string));
            }
            string = null;
            if (this.antC) {
                string = antennaSystemProvider.getConnectedToObjectARef(n, MimAntennaBranchDef.BRANCH_C);
            } else if (this.antD) {
                string = antennaSystemProvider.getConnectedToObjectARef(n, MimAntennaBranchDef.BRANCH_D);
            }
            if (string != null) {
                arrayList.addAll(this.getRisToUninstall(string));
            }
        }
        cellAndCarrierProvider.requestInitiateSector(this.getSector(), this.rbs.getConfigItem("RadioEquipmentCI"));
        List list = this.to.getName().equals("RRB02B") && (this.from.getName().equals("RRB01") || this.from.getName().equals("RRB02")) ? this.from.getResourceItems() : super.getRisToUninstall();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ResourceItem resourceItem = (ResourceItem)iterator.next();
            if (arrayList.contains(resourceItem)) continue;
            arrayList.add(resourceItem);
        }
        return arrayList;
    }

    private boolean uninitAntennaRIs() {
        String string = this.from.getName();
        String string2 = this.to.getName();
        boolean bl = false;
        if (string.startsWith("RB3") && (string2.startsWith("RB6") || string2.startsWith("RB7") || string2.startsWith("RB8"))) {
            bl = true;
            this.antB = true;
        } else if (string.equals("RRB01") && (string2.equals("RRB02B") || string2.equals("RRB05") || string2.equals("RRB06") || string2.equals("RRB06C"))) {
            bl = true;
            this.antA = true;
            this.antB = true;
        } else if (string.equals("RRB02") && (string2.equals("RRB02B") || string2.equals("RRB06C") || string2.equals("RRB06") || string2.equals("RRB05"))) {
            bl = true;
            this.antA = true;
            this.antB = true;
        } else if (string.equals("RRB02B") && (string2.equals("RRB05") || string2.equals("RRB06D"))) {
            bl = true;
            this.antA = true;
            this.antB = true;
        } else if ((string.startsWith("RB1") || string.startsWith("RB3")) && string2.startsWith("RB2")) {
            bl = true;
            this.antA = true;
            this.antB = true;
        } else if ((string.startsWith("RB3") || string.startsWith("RB4")) && string2.startsWith("RB5")) {
            bl = true;
            this.antA = true;
            this.antB = true;
        } else if (string.startsWith("RB2") && string2.startsWith("RB5")) {
            bl = true;
            this.antA = true;
            this.antB = true;
            this.antC = true;
            this.antD = true;
        }
        return bl;
    }

    private boolean uninitAlmDeviceRIs() {
        String string = this.from.getName();
        String string2 = this.to.getName();
        boolean bl = false;
        if (string.equals("RRB02B") && (string2.equals("RRB05") || string2.equals("RRB06D"))) {
            bl = true;
        }
        return bl;
    }

    public void ciRequests() throws BemException {
        if (this.uninitAntennaRIs()) {
            AntennaSystemProvider antennaSystemProvider = this.rbs.getAntennaSystemProvider();
            boolean[] blArray = new boolean[]{this.antA, this.antB, this.antC, this.antD};
            String[] stringArray = new String[]{MimAntennaBranchDef.BRANCH_A, MimAntennaBranchDef.BRANCH_B, MimAntennaBranchDef.BRANCH_C, MimAntennaBranchDef.BRANCH_D};
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                antennaSystemProvider.requestUninitAntennaBranch(this.getSector(), stringArray[i], this.rbs.getConfigItem("RadioEquipmentCI"));
                antennaSystemProvider.requestUninitAntFeederCable(this.getSector(), stringArray[i], this.rbs.getConfigItem("RadioEquipmentCI"));
                antennaSystemProvider.requestInitAntennaBranch(this.getSector(), stringArray[i], this.rbs.getConfigItem("RadioEquipmentCI"));
                antennaSystemProvider.requestInitAntFeederCable(this.getSector(), stringArray[i], this.rbs.getConfigItem("RadioEquipmentCI"));
            }
        }
    }
}

