/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.serverconfig;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.serverconfig.ServerIpAdressRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.serverconfig.TimeSettingRI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class ServerConfigCI
extends AbstractConfigurationItem {
    public static final String name = "ServerConfigCI";
    private boolean isOpen = false;
    TimeSettingRI timeSettingRI;
    ServerIpAdressRI serverIpAddressRI;

    public ServerConfigCI(Rbs rbs) {
        super(rbs);
    }

    public boolean open() throws BemException {
        boolean bl = true;
        if (this.isOpen) {
            throw new BemException("ServerConfigCI.open(): Already open");
        }
        this.timeSettingRI = new TimeSettingRI(this.rbs, this);
        this.serverIpAddressRI = new ServerIpAdressRI(this.rbs, this);
        this.isOpen = true;
        return bl;
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        boolean bl = true;
        this.open();
        this.setCustomerParameters(serviceValue);
        this.checkConsistency();
        return bl;
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        this.serverIpAddressRI.checkConsistency();
    }

    public String getName() {
        return name;
    }

    public ArrayList getNeededRIs() throws BemException {
        ArrayList arrayList = this.getRIsToBeInstalled();
        return arrayList;
    }

    public ArrayList getRIsToBeInstalled() throws BemException {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        if (!this.isOpen) {
            throw new BemException("getRIsToBeInstalled : CI not open");
        }
        this.checkConsistency();
        if (this.timeSettingRI.shouldRiBeInstalled()) {
            arrayList.add(this.timeSettingRI);
        }
        if (this.serverIpAddressRI.shouldRiBeInstalled()) {
            arrayList.add(this.serverIpAddressRI);
        }
        return arrayList;
    }

    public List getRIsToUninstall() throws BemException {
        ArrayList arrayList = new ArrayList();
        if (!this.isOpen) {
            throw new BemException("getRIsToBeUnInstalled : CI not open");
        }
        return arrayList;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        String[] stringArray = super.getAllCustomerParameterNames();
        super.setCustomerParametersFromSV(stringArray, serviceValue);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public ConfigurationCheckReport checkConfiguration() {
        ConfigurationCheckReport configurationCheckReport = new ConfigurationCheckReport();
        return configurationCheckReport;
    }
}

