/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.api;

import java.util.ArrayList;
import java.util.Iterator;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;

public class Report {
    private Part report = new Part();

    public boolean hasData() {
        int n = this.report.getPartCount();
        return n > 0;
    }

    public int getAddedPartsCount() {
        int n = this.report.getPartCount();
        return n;
    }

    public void removePart(int n) {
        this.report.removePart(n);
    }

    public void addMainHeading(String string) {
        this.report.addPart(new MainHeading(string));
    }

    public void addHeading(String string) {
        this.report.addPart(new Heading(string));
    }

    public void addBlankRow() {
        BodyText bodyText = new BodyText("");
        this.report.addPart(bodyText);
    }

    public static Table newTable(String string) {
        Table table = new Table(string);
        return table;
    }

    public void addTable(Table table) {
        if (table != null) {
            this.report.addPart(table);
        }
    }

    public Table addTable(String string) {
        Table table = Report.newTable(string);
        this.addTable(table);
        return table;
    }

    public Table addTable() {
        Table table = Report.newTable(null);
        this.addTable(table);
        return table;
    }

    public void addReport(Report report) {
        if (report != null && report.getAddedPartsCount() != 0) {
            this.report.addPart(report.report);
        }
    }

    public String toString() {
        return this.report.toString();
    }

    public static class Table
    extends Part {
        private final String title;
        private final ArrayList rows = new ArrayList();
        private int columnTitleRowCount = 0;
        private TabbedText cashedArrays = null;

        Table(String string) {
            this.title = string;
        }

        Table() {
            this((String)null);
        }

        public void addRow(String[] stringArray) {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
            this.rows.add(stringArray2);
            this.cashedArrays = null;
        }

        public void addColumnTitles(String[] stringArray) {
            this.addRow(stringArray);
            this.columnTitleRowCount = this.getPartCount();
        }

        public boolean hasData() {
            int n = this.rows.size();
            boolean bl = n > this.columnTitleRowCount;
            return bl;
        }

        public void addRow(String string, String string2) {
            String[] stringArray = new String[]{string, string2};
            this.addRow(stringArray);
        }

        public void addRow(String string) {
            String[] stringArray = new String[]{string};
            this.addRow(stringArray);
        }

        public void addRow(String string, NalNameValue nalNameValue) {
            Object object;
            if (nalNameValue == null) {
                return;
            }
            if (string == null) {
                string = nalNameValue.getName();
            }
            String string2 = (object = nalNameValue.getValue()) == null ? "null" : object.toString();
            String[] stringArray = new String[]{string, string2};
            this.addRow(stringArray);
        }

        public void addRow(NalNameValue nalNameValue) {
            if (nalNameValue == null) {
                return;
            }
            this.addRow(nalNameValue.getName(), nalNameValue);
        }

        private TabbedText getTable() {
            if (this.cashedArrays == null) {
                int n = 0;
                int n2 = this.rows.size();
                String[][] stringArray = new String[n2][];
                stringArray = (String[][])this.rows.toArray((T[])stringArray);
                for (int i = 0; i < n2; ++i) {
                    String[] stringArray2 = stringArray[i];
                    if (n >= stringArray2.length) continue;
                    n = stringArray2.length;
                }
                this.cashedArrays = new TabbedText(stringArray, n, this.columnTitleRowCount);
            }
            return this.cashedArrays;
        }

        public void write(Writer writer) {
            if (this.title != null) {
                writer.writeHeading(this.title);
            }
            TabbedText tabbedText = this.getTable();
            writer.writeTabbedText(tabbedText);
        }
    }

    private static class BodyText
    extends Part {
        private final String line;

        BodyText(String string) {
            this.line = string;
        }

        public void write(Writer writer) {
            writer.writeBodyText(this.line);
        }
    }

    private static class MainHeading
    extends Heading {
        MainHeading(String string) {
            super(string);
        }

        public void write(Writer writer) {
            writer.writeMainHeading(this.title);
        }
    }

    private static class Heading
    extends Part {
        protected final String title;

        Heading(String string) {
            this.title = string;
        }

        public void write(Writer writer) {
            writer.writeHeading(this.title);
        }
    }

    private static class Part {
        protected Part parent = null;
        protected ArrayList children = new ArrayList();

        private Part() {
        }

        public Part addPart(Part part) {
            this.children.add(part);
            part.setParent(this);
            return this;
        }

        public void setParent(Part part) {
            this.parent = part;
        }

        public void removePart(int n) {
            this.children.remove(n);
        }

        public int getPartCount() {
            return this.children.size();
        }

        public Part getPart(int n) {
            Part part = (Part)this.children.get(n);
            return part;
        }

        public Iterator iterator() {
            return this.children.iterator();
        }

        public void write(Writer writer) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Part part = (Part)iterator.next();
                part.write(writer);
            }
        }

        public String toString() {
            ToStringWriter toStringWriter = new ToStringWriter();
            this.write(toStringWriter);
            return toStringWriter.toString();
        }
    }

    public static class TabbedText {
        public final String[][] cells;
        public final int columnCount;
        public final int rowCount;
        public final int columnTitleRowCount;

        TabbedText(String[][] stringArray, int n, int n2) {
            this.cells = stringArray;
            this.columnCount = n;
            this.columnTitleRowCount = n2;
            this.rowCount = stringArray.length;
        }

        public String getCell(int n, int n2) {
            if (n < this.rowCount && n2 < this.cells[n].length) {
                String string = this.cells[n][n2];
                return string;
            }
            return "";
        }
    }

    private static class ToStringWriter
    implements Writer {
        private static final int DEFAULT_COL_WIDTH = 32;
        private final StringBuffer buffer = new StringBuffer();

        private ToStringWriter() {
        }

        private void underline(int n, char c) {
            for (int i = 0; i < n; ++i) {
                this.buffer.append(c);
            }
            this.buffer.append('\n');
        }

        private void underline(String string, char c) {
            this.underline(string.length(), c);
        }

        public void writeMainHeading(String string) {
            this.buffer.append("\n\n").append(string).append('\n');
            this.underline(string, '=');
        }

        public void writeHeading(String string) {
            this.buffer.append('\n').append(string).append('\n');
            this.underline(string, '=');
        }

        public void writeBodyText(String string) {
            this.buffer.append(string).append('\n');
        }

        public void writeHorisontalLine(int n) {
            this.writeBodyText("------------------------------\n");
        }

        public void writeTabbedText(TabbedText tabbedText) {
            String string;
            int n;
            int n2;
            int n3;
            int[] nArray = new int[tabbedText.columnCount];
            int n4 = tabbedText.columnCount - 1;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = 0;
                for (n = 0; n < tabbedText.rowCount; ++n) {
                    string = tabbedText.getCell(n, n3);
                    if (string == null) {
                        string = "null";
                    }
                    int n5 = string.length();
                    if (n < tabbedText.columnTitleRowCount && n3 != tabbedText.columnCount - 1) {
                        n5 += 2;
                    }
                    if (n2 >= n5) continue;
                    n2 = n5;
                }
                nArray[n3] = n2;
                n4 += n2;
            }
            if (tabbedText.columnTitleRowCount > 0) {
                this.buffer.append('\n');
            } else if (tabbedText.columnCount == 2 && nArray[0] < 32 && n4 - nArray[0] < 48) {
                n3 = 32 - nArray[0];
                nArray[0] = nArray[0] + n3;
                n4 += n3;
            }
            for (n3 = 0; n3 < tabbedText.rowCount; ++n3) {
                for (n2 = 0; n2 < tabbedText.columnCount; ++n2) {
                    n = this.buffer.length() + nArray[n2] + 1;
                    string = tabbedText.getCell(n3, n2);
                    this.buffer.append(string);
                    if (n2 == tabbedText.columnCount - 1) break;
                    while (this.buffer.length() < n) {
                        this.buffer.append(' ');
                    }
                }
                this.buffer.append('\n');
                if (n3 != tabbedText.columnTitleRowCount - 1) continue;
                this.underline(n4, '-');
            }
        }

        public String toString() {
            String string = this.buffer.toString();
            return string;
        }
    }

    public static interface Writer {
        public void writeMainHeading(String var1);

        public void writeHeading(String var1);

        public void writeHorisontalLine(int var1);

        public void writeBodyText(String var1);

        public void writeTabbedText(TabbedText var1);
    }
}

