/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.autointegration.AutoIntegrationCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.autointegration.FinalizeRbsConfigurationCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.IpOamCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CellAndCarrierManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.EthernetSwitchCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.IpOverAtmCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.IpOverGigabitEthernetCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iprouting.IpRoutingCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.IubCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync.NetworkSyncCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AlarmConfigurationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AntennaSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.HsdpaResourcesProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.ReconnectDialogProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.serverconfig.ServerConfigCI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.phase.Phase;
import se.ericsson.wcdma.rbs.bem.common.config.phase.PhaseOrder;
import se.ericsson.wcdma.rbs.bem.common.config.phase.uninstall.UninstallPhaseOrder;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.MoiRefs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsData;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsSteps;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.BemRuntimeException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPiuType;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRepertoire;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwAllocation;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.TransactionHelper;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.ExceptionUtil;

public abstract class AbstractRbs
extends Observable
implements Rbs {
    private PhaseOrder installationPhaseOrder = null;
    private UninstallPhaseOrder unInstallationPhaseOrder = null;
    private final MoHandler moHandler;
    private final String rbsStep;
    private HashMap[] configItems = new HashMap[]{new HashMap(0), new HashMap(0)};
    private List[] ciNamesInOpenOrder = new ArrayList[]{new ArrayList(), new ArrayList()};
    private HashMap customerParameters = new HashMap();
    private ArrayList[] atfProviderList = new ArrayList[]{new ArrayList(), new ArrayList()};
    private RadioEquipmentProvider[] radioEquipmentProvider = new RadioEquipmentProvider[2];
    private CellAndCarrierProvider[] cellAndCarrierProvider = new CellAndCarrierProvider[2];
    private AntennaSystemProvider[] antennaSystemProvider = new AntennaSystemProvider[2];
    private HsdpaResourcesProvider[] hsdpaResourcesProvider = new HsdpaResourcesProvider[2];
    private EtmBoardProvider etmBoardProvider = null;
    private AlarmConfigurationProvider alarmConfigurationProvider = null;
    private ReconnectDialogProvider userInteractionProvider = null;
    private final MoiRefs moiRefs;
    private int maxNumberOfCells = 8;
    private int maxNumberOfXalms = 32;
    private int maxNumberOfXalmsForRruw = 2;
    private int maxNumberOfOutPorts = 4;
    private int maxNumberOfSequences = 6;
    private ArrayList customerParameterList = new ArrayList();
    private final HashMap allPiuTypes = new HashMap();
    private HashMap allRepertoires;
    private HashMap allSwAllocations;
    private RbsData rbsData = null;
    private static final String PREFIX_DESCRIPTION = "Currently handling ";
    private static final String INSTALLING_RBS = "Install - Updating RBS with chosen configuration data";
    private boolean areCIsOpen = false;
    private boolean isInstallationStopped = false;
    private final ArrayList[] separatelyRegisteredProviders = new ArrayList[]{new ArrayList(), new ArrayList()};
    private boolean writeRbsConfigPhase = false;
    private boolean positionChangeFlag = false;
    private boolean isAiOngoing = false;
    private ArrayList cabinetNumberList;
    private String[] cabinetTypeParams;
    private HashMap resourceItems = new HashMap();

    public AbstractRbs(MoHandler moHandler, String string) {
        this.moHandler = moHandler;
        this.rbsStep = string;
        this.moiRefs = new MoiRefs();
        this.installationPhaseOrder = new PhaseOrder(null);
        this.unInstallationPhaseOrder = new UninstallPhaseOrder();
        this.createMandatoryConfigurationItems();
        new CellAndCarrierManager(this);
        this.createAllConfigurationItems();
    }

    protected abstract void createAllConfigurationItems();

    public MoHandler getMoHandler() {
        return this.moHandler;
    }

    public void setCabinetTypeParams(String[] stringArray) {
        this.cabinetTypeParams = stringArray;
    }

    public String[] getCabinetTypeParams() {
        return this.cabinetTypeParams;
    }

    public List getCabinetNumberList() {
        return this.cabinetNumberList;
    }

    public ArrayList setCabinetNumberList(ArrayList arrayList) {
        this.cabinetNumberList = arrayList;
        return this.cabinetNumberList;
    }

    public int getNoOfCabinets() {
        return this.cabinetNumberList.size();
    }

    public String getPrimaryAtfLdn(String string) throws BemException {
        return this.getPrimaryAtfLdn(string, 0);
    }

    public String getPrimaryAtfLdn(String string, int n) throws BemException {
        Iterator iterator = this.atfProviderList[n].iterator();
        while (iterator.hasNext()) {
            AtfProvider atfProvider = (AtfProvider)iterator.next();
            if (!atfProvider.isAtfRoleSupported(string, n)) continue;
            return atfProvider.getPrimaryAtfLdn(string, n);
        }
        throw new BemException("ATF Role " + string + " is not supported by this RBS");
    }

    public String getSecondaryAtfLdn(String string) throws BemException {
        return this.getSecondaryAtfLdn(string, 0);
    }

    public String getSecondaryAtfLdn(String string, int n) throws BemException {
        Iterator iterator = this.atfProviderList[n].iterator();
        while (iterator.hasNext()) {
            AtfProvider atfProvider = (AtfProvider)iterator.next();
            if (!atfProvider.isAtfRoleSupported(string, n)) continue;
            return atfProvider.getSecondaryAtfLdn(string, n);
        }
        throw new BemException("ATF Role " + string + " is not supported by this RBS");
    }

    public boolean isAtfRoleSupported(String string) {
        return this.isAtfRoleSupported(string, 0);
    }

    public boolean isAtfRoleSupported(String string, int n) {
        Iterator iterator = this.atfProviderList[n].iterator();
        while (iterator.hasNext()) {
            AtfProvider atfProvider = (AtfProvider)iterator.next();
            if (!atfProvider.isAtfRoleSupported(string, n)) continue;
            return true;
        }
        return false;
    }

    public void registerAtfProvider(AtfProvider atfProvider) {
        this.registerAtfProvider(atfProvider, 0);
    }

    public void registerAtfProvider(AtfProvider atfProvider, int n) {
        this.atfProviderList[n].add(atfProvider);
    }

    public String getAtfReport() {
        return this.getAtfReport(0);
    }

    public String getAtfReport(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.atfProviderList[n].iterator();
        while (iterator.hasNext()) {
            AtfProvider atfProvider = (AtfProvider)iterator.next();
            String string = atfProvider.getAtfReport();
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    public String getRbsStep() {
        return this.rbsStep;
    }

    public void registerConfigItem(ConfigurationItem configurationItem) {
        this.registerConfigItem(configurationItem, 0);
    }

    public void registerConfigItem(ConfigurationItem configurationItem, int n) {
        Nal.getLog().nalTraceEnter(this.getClass(), "registerConfigItem() for duwSlotNumber " + String.valueOf(n + 1));
        String string = configurationItem.getName();
        this.configItems[n].put(string, configurationItem);
        if (configurationItem instanceof AtfProvider) {
            AtfProvider atfProvider = (AtfProvider)((Object)configurationItem);
            this.registerAtfProvider(atfProvider, n);
        }
    }

    public void openConfigurationItem(String string) throws BemException {
        this.openConfigurationItem(string, 0);
    }

    public void openConfigurationItem(String string, int n) throws BemException {
        Nal.getLog().nalTraceEnter(this.getClass(), "openConfigurationItem(" + string + ")");
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        exceptionProperties.setProperty("Problem", "Failed to prepare for configuration (Open failed for CI=" + string);
        exceptionProperties.prependProperty("Function", "Prepare for configuration (Open CI=" + string + ")", " - ");
        exceptionProperties.setProperty("ConfigItem (CI)", string);
        exceptionProperties.setProperty("Failing Method", "AbstractRbs.openConfigurationItem() for duwSlotNumber " + String.valueOf(n + 1));
        exceptionProperties.setProperty("RbsType", this);
        ConfigurationItem configurationItem = (ConfigurationItem)this.configItems[n].get(string);
        if (configurationItem == null) {
            throw new BemException("AbstractRbs.open(): can not find a ci with name=" + string);
        }
        try {
            this.reportProgress("Opening " + configurationItem.getName());
            Nal.getLog().nalTrace(7, this.getClass(), "openConfigurationItem() - Opening " + configurationItem.getName());
            configurationItem.open();
            this.ciNamesInOpenOrder[n].add(configurationItem.getName());
        }
        catch (BemException bemException) {
            String string2 = bemException.getAdditionalInfo();
            string2 = string2 + " .Failed in openConfigurationItem().";
            bemException.setAdditionalInfo(string2);
            throw bemException;
        }
        catch (Exception exception) {
            BemException bemException = new BemException("Failed in openConfigurationItem()", exceptionProperties, (Throwable)exception);
            throw bemException;
        }
        this.areCIsOpen = true;
        Nal.getLog().nalTraceReturn(this.getClass(), "openConfigurationItem()");
    }

    public void openConfigurationItems(String[] stringArray) throws BemException {
        this.openConfigurationItems(stringArray, 0);
    }

    public void openConfigurationItems(String[] stringArray, int n) throws BemException {
        Nal.getLog().nalTraceEnter(this.getClass(), "openConfigurationItems()");
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        exceptionProperties.setProperty("Failing Method", "AbstractRbs.openConfigurationItems()");
        exceptionProperties.setProperty("RbsType", this);
        Collection collection = this.configItems[n].values();
        if (collection == null) {
            throw new BemException("AbstractRbs.openConfigurationItems(): No Configuration items registred");
        }
        String string = "";
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                exceptionProperties.setProperty("ConfigItem (CI)", string);
                if (!this.isConfigurationItemSupported(string)) continue;
                Nal.getLog().nalTrace(7, this.getClass(), "openConfigurationItems() - opening " + string);
                this.openConfigurationItem(string);
                this.ciNamesInOpenOrder[n].add(string);
            }
        }
        catch (Exception exception) {
            throw new BemException("Failed in openConfigurationItems()", exceptionProperties, (Throwable)exception);
        }
        Nal.getLog().nalTraceReturn(this.getClass(), "openConfigurationItems()");
        this.areCIsOpen = true;
    }

    public void openConfigurationItems(ServiceValue serviceValue) throws BemException {
        this.openConfigurationItems(serviceValue, 0);
    }

    public void openConfigurationItems(ServiceValue serviceValue, int n) throws BemException {
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        exceptionProperties.setProperty("Failing Method", "AbstractRbs.openConfigurationItems()");
        exceptionProperties.setProperty("Failing Method  - Params", serviceValue);
        exceptionProperties.setProperty("RbsType", this);
        Set set = this.configItems[n].keySet();
        Iterator iterator = set.iterator();
        String string = "";
        try {
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                ConfigurationItem configurationItem = (ConfigurationItem)this.configItems[n].get(string);
                exceptionProperties.setProperty("ConfigItem (CI)", configurationItem);
                configurationItem.open(serviceValue);
            }
        }
        catch (Exception exception) {
            throw new BemException("Failed in openConfigurationItems", exceptionProperties, (Throwable)exception);
        }
        this.areCIsOpen = true;
    }

    public void setCustomerParameter(String string, String string2) throws BemException {
        CustomerParameter customerParameter = (CustomerParameter)this.customerParameters.get(string);
        if (customerParameter == null) {
            throw new BemException("setCustomerParameter(): A customer parameter is not found with name=" + string);
        }
        customerParameter.setValue(string2);
    }

    public String getCustomerParameter(String string) throws BemException {
        CustomerParameter customerParameter = (CustomerParameter)this.customerParameters.get(string);
        if (customerParameter == null) {
            throw new BemException("getCustomerParameter(): A customer parameter is not found with name=" + string);
        }
        String string2 = customerParameter.getValue();
        return string2;
    }

    public CustomerParameter getCustomerParameterObject(String string) throws BemException {
        CustomerParameter customerParameter = (CustomerParameter)this.customerParameters.get(string);
        if (customerParameter == null) {
            throw new BemException("getCustomerParameterObject(): A customer parameter is not found with name=" + string);
        }
        return customerParameter;
    }

    public CustomerParameter[] getCustomerParameterObjects() throws BemException {
        CustomerParameter[] customerParameterArray = null;
        Collection collection = this.customerParameters.values();
        if (collection == null) {
            throw new BemException("getCustomerParameterObjects(): No customer parameter registred");
        }
        customerParameterArray = collection.toArray(new CustomerParameter[0]);
        return customerParameterArray;
    }

    public CustomerParameter[] getCustomerParameterObjectsWithPseudo(String string) throws BemException {
        ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>();
        CustomerParameter[] customerParameterArray = null;
        Collection collection = this.customerParameters.values();
        if (collection == null) {
            throw new BemException("getCustomerParameterObjects(): No customer parameter registred");
        }
        customerParameterArray = collection.toArray(new CustomerParameter[0]);
        for (int i = 0; i < customerParameterArray.length; ++i) {
            if (customerParameterArray[i].getName().indexOf(string) == -1) continue;
            arrayList.add(customerParameterArray[i]);
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new CustomerParameter[0]);
    }

    public ArrayList getCustomerParameterInRegisteredOrder() {
        return this.customerParameterList;
    }

    public void listAllRegisteredCustomerParameters() {
        this.listAllRegisteredCustomerParameters(null);
    }

    public void listAllRegisteredCustomerParameters(String string) {
        ArrayList arrayList = this.getCustomerParameterInRegisteredOrder();
        System.out.println("===================================");
        System.out.println("* Customer Parameter list *");
        System.out.println("===================================");
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (string != null && !string2.startsWith(string)) continue;
            CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)this.customerParameters.get(string2);
            String string3 = customerParameterImpl.getValue();
            String string4 = customerParameterImpl.getAccessLevelString();
            System.out.print("Name=" + string2);
            System.out.print("   Value=" + string3);
            System.out.print("   AccessLevel=" + string4);
            System.out.println("\n");
        }
        System.out.println("===================================");
    }

    public CustomerParameterServer getCustomerParameterServerObject(String string) throws BemException {
        Object v = this.customerParameters.get(string);
        if (v == null) {
            throw new BemException("getCustomerParameterServerObject(): A customer parameter is not found with name=" + string);
        }
        CustomerParameterImpl customerParameterImpl = null;
        if (!(v instanceof CustomerParameterServer)) {
            throw new BemException("getCustomerParameterServerObject(): The customer parameter requested is not a instance of getCustomerParameterServer, name=" + string);
        }
        customerParameterImpl = (CustomerParameterImpl)v;
        return customerParameterImpl;
    }

    public void registerCustomerParameter(CustomerParameter customerParameter) {
        String string = customerParameter.getName();
        if (this.customerParameters.containsKey(string)) {
            RuntimeException runtimeException = new RuntimeException("AbstractRbs.registerCustomerParameter().\nAn attempt is done to register a customerParameter with \nname=" + string + " which is already registered.");
            Nal.getFactory().getLog().nalTraceError(this.getClass(), "registerCustomerParameter()", runtimeException);
            throw runtimeException;
        }
        this.customerParameters.put(string, customerParameter);
        this.customerParameterList.add(string);
    }

    public void unRegisterCustomerParameter(CustomerParameter customerParameter) {
        String string = customerParameter.getName();
        if (!this.customerParameters.containsKey(string)) {
            RuntimeException runtimeException = new RuntimeException("AbstractRbs.registerCustomerParameter().\nAn attempt is done to un register a customerParameter with \nname=" + string + " which is not registered.");
            Nal.getFactory().getLog().nalTraceError(this.getClass(), "unRegisterCustomerParameter()", runtimeException);
            throw runtimeException;
        }
        this.customerParameters.remove(string);
        this.customerParameterList.remove(string);
    }

    public ConfigurationItem getConfigItem(String string) {
        return this.getConfigItem(string, 0);
    }

    public ConfigurationItem getConfigItem(String string, int n) {
        ConfigurationItem configurationItem = (ConfigurationItem)this.configItems[n].get(string);
        return configurationItem;
    }

    public HashMap getConfigItems() {
        return this.getConfigItems(0);
    }

    public HashMap getConfigItems(int n) {
        return this.configItems[n];
    }

    public Phase[] getInstallationPhases() {
        Phase[] phaseArray = this.installationPhaseOrder.getAllInstallationPhases();
        return phaseArray;
    }

    public void setInstallationPhaseOrder(PhaseOrder phaseOrder) {
        this.installationPhaseOrder = phaseOrder;
    }

    public Phase[] getUninstallationPhases() {
        Phase[] phaseArray = this.unInstallationPhaseOrder.getAllUnInstallationPhases();
        return phaseArray;
    }

    public void setUninstallationPhaseOrder(UninstallPhaseOrder uninstallPhaseOrder) {
        this.unInstallationPhaseOrder = uninstallPhaseOrder;
    }

    public ArrayList getRIsToInstall() throws BemException {
        return this.getRIsToInstall(0);
    }

    public ArrayList getRIsToInstall(int n) throws BemException {
        Object object;
        Collection collection;
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        exceptionProperties.setProperty("Failing Method", "AbstractRbs.getRIsToInstall()");
        exceptionProperties.setProperty("RbsType", this);
        ArrayList arrayList = new ArrayList();
        if (n == 0) {
            collection = this.resourceItems.values();
            arrayList.addAll(collection);
        }
        collection = new ArrayList(this.configItems[n].keySet());
        int n2 = ((ArrayList)collection).size();
        for (int i = 0; i < n2; ++i) {
            object = (String)((ArrayList)collection).get(i);
            exceptionProperties.setProperty("ConfigItem (CI)", object);
            ConfigurationItem configurationItem = (ConfigurationItem)this.configItems[n].get(object);
            String string = configurationItem.getName();
            this.reportProgress("Analyzing configuration item - " + string + "of duwSlotNumber" + String.valueOf(n + 1));
            if (!configurationItem.isOpen()) continue;
            try {
                ArrayList arrayList2 = configurationItem.getNeededRIs();
                if (arrayList2 == null) continue;
                arrayList.addAll(arrayList2);
                continue;
            }
            catch (BemException bemException) {
                throw bemException;
            }
            catch (Exception exception) {
                BemException bemException = new BemException("Failed in getRIsToInstall()", exceptionProperties, (Throwable)exception);
                throw bemException;
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (AbstractResourceItem)iterator.next();
            ((AbstractResourceItem)object).setDuwSlot(n);
        }
        return arrayList;
    }

    public List getRIsToUninstall() throws BemException {
        return this.getRIsToUninstall(0);
    }

    public List getRIsToUninstall(int n) throws BemException {
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        exceptionProperties.setProperty("Failing Method", "AbstractRbs.getRIsToUninstall()");
        exceptionProperties.setProperty("RbsType", this);
        ArrayList arrayList = new ArrayList();
        Set set = this.configItems[n].keySet();
        Iterator iterator = set.iterator();
        ConfigurationItem configurationItem = null;
        List list = null;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            exceptionProperties.setProperty("ConfigItem (CI)", string);
            ConfigurationItem configurationItem2 = (ConfigurationItem)this.configItems[n].get(string);
            if (!configurationItem2.isOpen()) continue;
            String string2 = configurationItem2.getName();
            try {
                if (!string2.equals("CellAndCarrierCI")) {
                    list = configurationItem2.getRIsToUninstall();
                } else {
                    configurationItem = configurationItem2;
                }
                if (list == null) continue;
                arrayList.addAll(list);
                list = null;
            }
            catch (Exception exception) {
                BemException bemException = new BemException("Failed in getRIsToUninstall()", exceptionProperties, (Throwable)exception);
                throw bemException;
            }
        }
        if (configurationItem != null && (list = configurationItem.getRIsToUninstall()) != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        this.setCustomerParameters(serviceValue, 0);
    }

    public void setCustomerParameters(ServiceValue serviceValue, int n) throws OutOfRangeException, CustomerParameterException, BemException {
        String string = "";
        Iterator iterator = this.ciNamesInOpenOrder[n].iterator();
        while (iterator.hasNext()) {
            try {
                string = (String)iterator.next();
                ConfigurationItem configurationItem = (ConfigurationItem)this.configItems[n].get(string);
                if (!configurationItem.isOpen()) continue;
                configurationItem.setCustomerParameters(serviceValue);
            }
            catch (OutOfRangeException outOfRangeException) {
                throw outOfRangeException;
            }
            catch (CustomerParameterException customerParameterException) {
                throw customerParameterException;
            }
            catch (BemException bemException) {
                throw bemException;
            }
            catch (Exception exception) {
                throw new BemException("Calling setCustomerParameters() for CI=" + string, exception.toString(), "", "", exception);
            }
        }
    }

    public HashMap getAllConfigItems() {
        return this.getAllConfigItems(0);
    }

    public HashMap getAllConfigItems(int n) {
        return this.configItems[n];
    }

    public void registerRI(ResourceItem resourceItem) {
        this.resourceItems.put(resourceItem.getName(), resourceItem);
    }

    public ResourceItem getRegisteredRI(String string) throws BemException {
        boolean bl = this.resourceItems.containsKey(string);
        if (bl) {
            ResourceItem resourceItem = (ResourceItem)this.resourceItems.get(string);
            return resourceItem;
        }
        throw new BemException("getRegisteredRI(), the RI is not registered");
    }

    public void checkConsistency() throws BemException {
        this.checkConsistency(0);
    }

    public void checkConsistency(int n) throws BemException {
        Iterator iterator = this.configItems[n].values().iterator();
        while (iterator.hasNext()) {
            ConfigurationItem configurationItem = (ConfigurationItem)iterator.next();
            String string = configurationItem.getName();
            if (!configurationItem.isOpen()) continue;
            try {
                configurationItem.checkConsistency();
            }
            catch (BemException bemException) {
                String string2 = "ConsistencyCheck failed for CI=" + string + ". ";
                String string3 = bemException.getAction();
                if (string3 == null) {
                    string3 = "";
                }
                string2 = string2 + string3;
                bemException.setProperty("Failing action", string2);
                throw bemException;
            }
            catch (Exception exception) {
                BemException bemException = new BemException("ConsistencyCheck failed for CI=" + string, "", (Throwable)exception);
                bemException.setProperty("ConfigItem (CI)", string);
                bemException.setProperty("Failing action", "checkConsistency()");
                throw new BemException("Calling checkConsistency() for CI=" + string, "", (Throwable)exception);
            }
        }
    }

    public void checkConsistency(String string) throws BemException {
        this.checkConsistency(string, 0);
    }

    public void checkConsistency(String string, int n) throws BemException {
        ConfigurationItem configurationItem = (ConfigurationItem)this.configItems[n].get(string);
        if (configurationItem.isOpen()) {
            configurationItem.checkConsistency();
        }
    }

    public void checkConsistency(String string, List list) throws CustomerParameterException, BemException {
        this.checkConsistency(string, list, 0);
    }

    public void checkConsistency(String string, List list, int n) throws BemException, CustomerParameterException {
        ConfigurationItem configurationItem = this.getConfigItem(string, n);
        if (configurationItem.isOpen()) {
            configurationItem.checkConsistency(list);
        }
    }

    public boolean isParameterSupported(String string) {
        return this.customerParameters.containsKey(string);
    }

    public boolean isConfigurationItemSupported(String string) {
        return this.isConfigurationItemSupported(string, 0);
    }

    public boolean isConfigurationItemSupported(String string, int n) {
        return this.configItems[n].containsKey(string);
    }

    public void setRadioEquipmentProvider(RadioEquipmentProvider radioEquipmentProvider) {
        this.setRadioEquipmentProvider(radioEquipmentProvider, 0);
    }

    public void setRadioEquipmentProvider(RadioEquipmentProvider radioEquipmentProvider, int n) {
        this.radioEquipmentProvider[n] = radioEquipmentProvider;
    }

    public RadioEquipmentProvider getRadioEquipmentProvider() throws BemException {
        return this.getRadioEquipmentProvider(0);
    }

    public RadioEquipmentProvider getRadioEquipmentProvider(int n) throws BemException {
        RadioEquipmentProvider radioEquipmentProvider = null;
        if (this.radioEquipmentProvider != null && this.radioEquipmentProvider[n] != null) {
            radioEquipmentProvider = this.radioEquipmentProvider[n];
        } else {
            ConfigurationItem configurationItem = this.getConfigItem("RadioEquipmentCI", n);
            if (configurationItem != null && !configurationItem.isOpen()) {
                configurationItem.open();
                this.ciNamesInOpenOrder[n].add("RadioEquipmentCI");
            }
            radioEquipmentProvider = (RadioEquipmentProvider)this.getProvider(RadioEquipmentProvider.class, n);
        }
        return radioEquipmentProvider;
    }

    public void setHsdpaResourcesProvider(HsdpaResourcesProvider hsdpaResourcesProvider) {
        this.setHsdpaResourcesProvider(hsdpaResourcesProvider, 0);
    }

    public void setHsdpaResourcesProvider(HsdpaResourcesProvider hsdpaResourcesProvider, int n) {
        this.hsdpaResourcesProvider[n] = hsdpaResourcesProvider;
    }

    public HsdpaResourcesProvider getHsdpaResourcesProvider() throws BemException {
        return this.getHsdpaResourcesProvider(0);
    }

    public HsdpaResourcesProvider getHsdpaResourcesProvider(int n) throws BemException {
        HsdpaResourcesProvider hsdpaResourcesProvider = null;
        if (this.hsdpaResourcesProvider != null && this.hsdpaResourcesProvider[n] != null) {
            hsdpaResourcesProvider = this.hsdpaResourcesProvider[n];
        } else {
            ConfigurationItem configurationItem = this.getConfigItem("RadioEquipmentCI", n);
            if (configurationItem != null) {
                if (!configurationItem.isOpen()) {
                    configurationItem.open();
                }
                hsdpaResourcesProvider = (HsdpaResourcesProvider)((Object)configurationItem);
            }
        }
        return hsdpaResourcesProvider;
    }

    public void setEtmBoardProvider(EtmBoardProvider etmBoardProvider) {
        this.etmBoardProvider = etmBoardProvider;
    }

    public EtmBoardProvider getEtmBoardProvider() throws BemException {
        EtmBoardProvider etmBoardProvider = null;
        if (this.etmBoardProvider != null) {
            etmBoardProvider = this.etmBoardProvider;
        } else {
            ConfigurationItem configurationItem = this.getConfigItem("EtmBoardCI");
            if (configurationItem != null) {
                if (!configurationItem.isOpen()) {
                    configurationItem.open();
                }
                etmBoardProvider = (EtmBoardProvider)((Object)configurationItem);
            }
        }
        return etmBoardProvider;
    }

    public void setAntennaSystemProvider(AntennaSystemProvider antennaSystemProvider) {
        this.setAntennaSystemProvider(antennaSystemProvider, 0);
    }

    public void setAntennaSystemProvider(AntennaSystemProvider antennaSystemProvider, int n) {
        this.antennaSystemProvider[n] = antennaSystemProvider;
    }

    public AntennaSystemProvider getAntennaSystemProvider() throws BemException {
        return this.getAntennaSystemProvider(0);
    }

    public AntennaSystemProvider getAntennaSystemProvider(int n) throws BemException {
        AntennaSystemProvider antennaSystemProvider = null;
        if (this.antennaSystemProvider != null && this.antennaSystemProvider[n] != null) {
            antennaSystemProvider = this.antennaSystemProvider[n];
        } else {
            antennaSystemProvider = (AntennaSystemProvider)((Object)this.getConfigItem("AntennaSystemCI", n));
            if (antennaSystemProvider != null) {
                antennaSystemProvider.openProvider();
            }
        }
        return antennaSystemProvider;
    }

    public void setCellAndCarrierProvider(CellAndCarrierProvider cellAndCarrierProvider) {
        this.setCellAndCarrierProvider(cellAndCarrierProvider, 0);
    }

    public void setCellAndCarrierProvider(CellAndCarrierProvider cellAndCarrierProvider, int n) {
        this.cellAndCarrierProvider[n] = cellAndCarrierProvider;
    }

    public CellAndCarrierProvider getCellAndCarrierProvider() throws BemException {
        return this.getCellAndCarrierProvider(0);
    }

    public CellAndCarrierProvider getCellAndCarrierProvider(int n) throws BemException {
        CellAndCarrierProvider cellAndCarrierProvider = null;
        if (this.cellAndCarrierProvider != null && this.cellAndCarrierProvider[n] != null) {
            cellAndCarrierProvider = this.cellAndCarrierProvider[n];
        } else {
            ConfigurationItem configurationItem = this.getConfigItem("CellAndCarrierCI", n);
            if (configurationItem != null) {
                if (!configurationItem.isOpen()) {
                    configurationItem.open();
                }
                cellAndCarrierProvider = (CellAndCarrierProvider)((Object)configurationItem);
            }
        }
        return cellAndCarrierProvider;
    }

    public void setReconnectDialogProvider(ReconnectDialogProvider reconnectDialogProvider) {
        this.userInteractionProvider = reconnectDialogProvider;
    }

    public ReconnectDialogProvider getReconnectDialogProvider() {
        return this.userInteractionProvider;
    }

    public MoInstance getRootMoi() {
        return this.moiRefs.getRootMoi();
    }

    public MoInstance getEquipmentMoi() {
        return this.moiRefs.getEquipmentMoi();
    }

    public MoiRefs getMoiRefs() {
        return this.moiRefs;
    }

    public MoInstance getNodeBFunctionMoi() {
        return this.moiRefs.getNodeBFunctionMoi();
    }

    public MoInstance getRbsConfigurationMoi() {
        return this.moiRefs.getRbsConfigurationMoi();
    }

    public String[] getConfigurationCheckReport() throws BemException {
        return this.getConfigurationCheckReport(0);
    }

    public String[] getConfigurationCheckReport(int n) throws BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        HashMap hashMap = this.getAllConfigItems(n);
        Collection collection = hashMap.values();
        Iterator iterator = collection.iterator();
        String string = "";
        try {
            while (iterator.hasNext()) {
                ConfigurationItem configurationItem = (ConfigurationItem)iterator.next();
                string = configurationItem.getName();
                ConfigurationCheckReport configurationCheckReport = configurationItem.checkConfiguration();
                if (configurationCheckReport == null) continue;
                List list = configurationCheckReport.getAllReportEntries("Stopping");
                arrayList2.addAll(list);
                list = configurationCheckReport.getAllReportEntries("Error");
                arrayList3.addAll(list);
                list = configurationCheckReport.getAllReportEntries("Warning");
                arrayList4.addAll(list);
            }
        }
        catch (BemException bemException) {
            bemException.setTheFunction("AbstractRbs.getConfigurationCheckReport() for CI: " + string);
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException("AbstractRbs.getConfigurationCheckReport() for CI: " + string, "", null, "", exception);
        }
        if (arrayList2.size() > 0) {
            arrayList.add("There are errors in the current configuration which will require a site visit.");
            arrayList.add("It is not possible to retrieve valid values from the node");
            arrayList.add("It is needed to physically move equipment before using Element Manager tools to reconfigure the node");
            arrayList.add("The following errors have been found:");
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList.add(arrayList2.get(i).toString());
            }
        }
        if (arrayList3.size() > 0) {
            arrayList.add("There are errors in the current configuration which will require a site visit.");
            arrayList.add("It is needed to physically move equipment before using Element Manager tools to reconfigure the node");
            arrayList.add("The following errors have been found:");
            for (int i = 0; i < arrayList3.size(); ++i) {
                arrayList.add(arrayList3.get(i).toString());
            }
        }
        if (arrayList4.size() > 0) {
            arrayList.add(" ");
            arrayList.add("Current configuration does not follow configuration guidelines.");
            arrayList.add("It is not possible to determine if it is an MO configuration problem or a physical configuration problem");
            arrayList.add("It is recommended to go to the site and check that the RBS physical configuration (cables) follows Ericsson guidelines");
            arrayList.add("The following inconsistencies have been found:");
            for (int i = 0; i < arrayList4.size(); ++i) {
                arrayList.add(arrayList4.get(i).toString());
            }
        }
        String[] stringArray = null;
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(new String[0]);
        }
        return stringArray;
    }

    public int getMaxNumberOfCells() {
        return this.maxNumberOfCells;
    }

    public int getMaxNumberOfSequences() {
        return this.maxNumberOfSequences;
    }

    protected void setMaxNumberOfCells(int n) {
        this.maxNumberOfCells = n;
    }

    public int getMaxNumberOfXalms() {
        return this.maxNumberOfXalms;
    }

    public int getMaxNumberOfXalmsForRruw() {
        return this.maxNumberOfXalmsForRruw;
    }

    protected void setMaxNumberOfXalms(int n) {
        this.maxNumberOfXalms = n;
    }

    public int getMaxNumberOfOutPorts() {
        return this.maxNumberOfOutPorts;
    }

    protected void setMaxNumberOfOutPorts(int n) {
        this.maxNumberOfOutPorts = n;
    }

    public abstract String getSlotsForCbu();

    public String getSlotsForDuw() {
        return "";
    }

    public void reportProgress(String string) {
        this.setChanged();
        this.notifyObservers(string);
    }

    public HashMap getAllPiuTypes() throws BemException {
        if (this.allPiuTypes.size() == 0) {
            MoInstance moInstance = this.getMoiRefs().getSwManagementMoi();
            String string = moInstance.getLdn();
            BemMo bemMo = this.moHandler.getMo(string);
            BemMo[] bemMoArray = bemMo.getChildren(1, MimPiuType.MOTYPENAME, "");
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo2 = bemMoArray[i];
                NalStruct nalStruct = (NalStruct)bemMo2.getAttribute("productData");
                this.allPiuTypes.put(bemMo2.getDN(), nalStruct);
            }
        }
        return this.allPiuTypes;
    }

    public ArrayList getCustomerParameterPseudoName(String string) throws BemException {
        CustomerParameter[] customerParameterArray = this.getCustomerParameterObjects();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < customerParameterArray.length; ++i) {
            String string2 = customerParameterArray[i].getName();
            if (string2 == null || !string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public void setRbsData(RbsData rbsData) {
        this.rbsData = rbsData;
    }

    public RbsData getRbsData() throws BemException {
        if (this.rbsData == null) {
            throw new BemException("AbstractRbs.getRbsData() no rbsData object is set for this Rbs instance.\nProbably the CabinetBasicCI is not open");
        }
        return this.rbsData;
    }

    public int getHubSubrackNoOfSlots() throws BemException {
        if (this.rbsData == null) {
            throw new BemException("AbstractRbs.getHubSubrackNoOfSlots() no rbsData object is set for this Rbs instance.\nProbably the CabinetBasicCI is not open");
        }
        return this.rbsData.getNoOfSlots();
    }

    public boolean isChoiceOfRadioIfTypeSupported() {
        return false;
    }

    public boolean isPantherHybridRbs() {
        return false;
    }

    private void createMandatoryConfigurationItems() {
        IpOverAtmCI ipOverAtmCI = new IpOverAtmCI(this);
        this.registerConfigItem(ipOverAtmCI);
        ServerConfigCI serverConfigCI = new ServerConfigCI(this);
        this.registerConfigItem(serverConfigCI);
        NetworkSyncCI networkSyncCI = new NetworkSyncCI(this);
        this.registerConfigItem(networkSyncCI);
        IpRoutingCI ipRoutingCI = new IpRoutingCI(this);
        this.registerConfigItem(ipRoutingCI);
        IpOverGigabitEthernetCI ipOverGigabitEthernetCI = new IpOverGigabitEthernetCI(this);
        this.registerConfigItem(ipOverGigabitEthernetCI);
        EthernetSwitchCI ethernetSwitchCI = new EthernetSwitchCI(this);
        this.registerConfigItem(ethernetSwitchCI);
        IpOamCI ipOamCI = new IpOamCI(this);
        this.registerConfigItem(ipOamCI);
        AutoIntegrationCI autoIntegrationCI = new AutoIntegrationCI(this);
        this.registerConfigItem(autoIntegrationCI);
        IubCI iubCI = new IubCI(this);
        this.registerConfigItem(iubCI);
        FinalizeRbsConfigurationCI finalizeRbsConfigurationCI = new FinalizeRbsConfigurationCI(this);
        this.registerConfigItem(finalizeRbsConfigurationCI);
    }

    public void installAllCIs(boolean bl, Observer observer) {
        String string = "";
        this.addObserver(observer);
        this.isInstallationStopped = false;
        TransactionHelper transactionHelper = TransactionHelper.getInstance(this.moHandler);
        this.moHandler.setUseLargeTransactions(bl);
        transactionHelper.addObserver(observer);
        try {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i <= 1; ++i) {
                arrayList.addAll(this.getRIsToInstall(i));
            }
            string = "Starting installation";
            Phase[] phaseArray = this.getInstallationPhases();
            Nal.getLog().nalTrace(6, this.getClass(), "Found " + phaseArray.length + " phases");
            for (int i = 0; i < phaseArray.length && !this.isInstallationStopped; ++i) {
                boolean bl2;
                try {
                    bl2 = transactionHelper.setPhase(phaseArray[i].getName());
                }
                catch (MoHandlerException moHandlerException) {
                    if (ExceptionUtil.isCausedByCorbaConnectionLost(moHandlerException)) {
                        bl2 = true;
                        Nal.getLog().nalTrace(6, this.getClass(), "Connection lost during commit of transaction (timing related, expected behaviour when changing nodeInterfaceName).");
                    }
                    throw moHandlerException;
                }
                if (bl2) continue;
                String string2 = phaseArray[i].getName();
                String string3 = this.removePhaseFromName(string2);
                this.setRbsConfigPhase(string2);
                Nal.getLog().nalTrace(5, this.getClass(), "installAllCIs() - phase:  " + string3);
                string = PREFIX_DESCRIPTION + string3;
                this.reportProgress(string);
                String string4 = string;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ResourceItem resourceItem = (ResourceItem)iterator.next();
                    if (resourceItem == null) continue;
                    string = string4 + " " + resourceItem.getDisplayName();
                    Nal.getLog().nalTrace(7, this.getClass(), "installAllCIs() - " + string2 + " - installing " + resourceItem.getDisplayName());
                    if ("StartUseLargeTransactionPhase".equals(string2) && !bl) {
                        this.moHandler.setUseLargeTransactions(true);
                    }
                    resourceItem.install(string2);
                    if ("EndUseLargeTransactionPhase".equals(string2) && !bl) {
                        this.moHandler.setUseLargeTransactions(false);
                    }
                    if (!this.isInstallationStopped) continue;
                }
            }
            string = INSTALLING_RBS;
            this.reportProgress(string);
        }
        catch (Exception exception) {
            String string5 = "commit failed, rollback to previous configuration.";
            String string6 = "Operation failed";
            if (bl) {
                try {
                    transactionHelper.rollbackAlloperations(exception);
                }
                catch (Exception exception2) {
                    BemException bemException;
                    if (exception2 instanceof BemException && "ROLLBACK_TRANSACTION".equals((bemException = (BemException)exception2).getAction())) {
                        string6 = bemException.getAction();
                    }
                }
            } else {
                string5 = "Commit or Rollback failed, reverting to Cancel CV.";
                string6 = "ROLLBACK_TRANSACTION";
            }
            Nal.getFactory().getLog().nalTraceError(this.getClass(), "registerCustomerParameter() " + string5, exception);
            BemRuntimeException bemRuntimeException = new BemRuntimeException("Installing data on node" + string5 + ", action=" + string6, exception);
            throw bemRuntimeException;
        }
        finally {
            this.moHandler.setUseLargeTransactions(false);
        }
    }

    private void setRbsConfigPhase(String string) {
        if (this.writeRbsConfigPhase) {
            try {
                BemMo bemMo = this.moHandler.getMo(this.getRbsConfigurationMoi().getLdn());
                NalTransaction nalTransaction = Nal.getFactory().createTransaction(0);
                bemMo.setAttribute("rbsConfigPhase", string, nalTransaction);
                nalTransaction.commit();
            }
            catch (Throwable throwable) {
                Nal.getFactory().getLog().nalTraceError(this.getClass(), "Could not set the rbsConfigPhase", throwable);
            }
        }
    }

    public void setWriteRbsConfigPhase(boolean bl) {
        this.writeRbsConfigPhase = bl;
    }

    public void stopInstallation() {
        this.isInstallationStopped = true;
    }

    private String removePhaseFromName(String string) {
        String string2 = "Phase";
        if (string.endsWith(string2)) {
            int n = string.lastIndexOf(string2);
            return string.substring(0, n);
        }
        return string;
    }

    public boolean areCIsOpen() {
        return this.areCIsOpen;
    }

    public int getNoOfInstallationPhases() {
        return this.getInstallationPhases().length;
    }

    public int getNoOfCIs() {
        return this.configItems[0].size() + this.configItems[1].size();
    }

    public AlarmConfigurationProvider getAlarmConfigurationProvider() throws BemException {
        AlarmConfigurationProvider alarmConfigurationProvider = null;
        if (this.alarmConfigurationProvider != null) {
            alarmConfigurationProvider = this.alarmConfigurationProvider;
        } else {
            ConfigurationItem configurationItem = this.getConfigItem("AlarmCI");
            if (configurationItem != null) {
                if (!configurationItem.isOpen()) {
                    configurationItem.open();
                }
                alarmConfigurationProvider = (AlarmConfigurationProvider)((Object)configurationItem);
            }
        }
        return alarmConfigurationProvider;
    }

    public Object getProvider(Class clazz) {
        return this.getProvider(clazz, 0);
    }

    public Object getProvider(Class clazz, int n) {
        Object object = null;
        Object[] objectArray = this.separatelyRegisteredProviders[n].toArray();
        object = this.getMatchingProvider(objectArray, clazz);
        if (object == null) {
            Collection collection = this.configItems[n].values();
            Object[] objectArray2 = collection.toArray();
            object = this.getMatchingProvider(objectArray2, clazz);
        }
        return object;
    }

    private Object getMatchingProvider(Object[] objectArray, Class clazz) {
        Object object = null;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (!clazz.isAssignableFrom(object2.getClass())) continue;
            object = object2;
            break;
        }
        return object;
    }

    public void registerProvider(Object object) {
        this.registerProvider(object, 0);
    }

    public void registerProvider(Object object, int n) {
        this.separatelyRegisteredProviders[n].add(object);
    }

    public String getRepertoireLdn(String string) throws BemException {
        Object object;
        if (this.allRepertoires == null) {
            this.allRepertoires = new HashMap();
            object = this.moHandler.getMo(this.moiRefs.getSwManagementMoi().getLdn());
            BemMo[] bemMoArray = object.getChildren(1, MimRepertoire.MOTYPENAME, "");
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo = bemMoArray[i];
                String string2 = (String)bemMo.getAttribute("name");
                this.allRepertoires.put(string2, bemMo.getDN());
            }
        }
        object = (String)this.allRepertoires.get(string);
        return object;
    }

    public String getSwAllocationLdn(String string) throws BemException {
        Object object;
        if (this.allSwAllocations == null) {
            this.allSwAllocations = new HashMap();
            object = this.moHandler.getMo(this.moiRefs.getSwManagementMoi().getLdn());
            BemMo[] bemMoArray = object.getChildren(1, MimSwAllocation.MOTYPENAME, "");
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo = bemMoArray[i];
                String string2 = (String)bemMo.getAttribute("role");
                this.allSwAllocations.put(string2, bemMo.getDN());
            }
        }
        object = (String)this.allSwAllocations.get(string);
        return object;
    }

    public boolean getPositionChangeFlag() {
        return this.positionChangeFlag;
    }

    public void setPositionFlag(boolean bl) {
        this.positionChangeFlag = bl;
    }

    public String toString() {
        String string = this.getRbsType();
        return string;
    }

    public void setAiOngoing(boolean bl) {
        this.isAiOngoing = bl;
    }

    public boolean isAiOngoing() {
        return RbsSteps.isIntegrateStep(this.getRbsStep()) || this.isAiOngoing;
    }

    public boolean isCabinetWiz() {
        return "STEP_CABINET".equals(this.getRbsStep());
    }

    public boolean isSiteWiz() {
        return "STEP_SITE".equals(this.getRbsStep());
    }

    public boolean isModifyWiz() {
        return "STEP_EXPANSION".equals(this.getRbsStep());
    }

    public boolean isOamWiz() {
        return "STEP_OAM".equals(this.getRbsStep());
    }

    public boolean isAntennaSystemProviderOpen(int n) {
        AntennaSystemProvider antennaSystemProvider = null;
        antennaSystemProvider = this.antennaSystemProvider != null && this.antennaSystemProvider[n] != null ? this.antennaSystemProvider[n] : (AntennaSystemProvider)((Object)this.getConfigItem("AntennaSystemCI", n));
        if (antennaSystemProvider != null) {
            return antennaSystemProvider.isProviderOpen();
        }
        return false;
    }

    public void removePhasesOnNscAi() {
        this.installationPhaseOrder.removePhase("RollbackCVCreationPhase");
        this.installationPhaseOrder.removePhase("RollbackCVSettingPhase");
        this.installationPhaseOrder.removePhase("RollbackCVDeletionPhase");
        if (!"STEP_INT_SITE".equals(this.rbsStep)) {
            this.installationPhaseOrder.removePhase("ConfigurationVersionCreationPhase");
        }
    }
}

