/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3101.configitem;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.AbstractRbs3RadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.Configuration1Branched;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.Configuration1High;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.Configuration1Normal;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.Configuration2Branched;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.Configuration2Low;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.Configuration2Normal;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.ConfigurationCableData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.ConfigurationData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.SectorCapability;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.SectorCapabilityManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration1BranchedTo1Normal;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration1BranchedTo2Branched;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration1BranchedTo2Normal;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration1NormalTo1Branched;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration1NormalTo1High;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration1NormalTo2Branched;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration1NormalTo2Low;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration1NormalTo2Normal;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration2BranchedTo2Normal;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration2LowTo2Normal;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration2NormalTo2Branched;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.BbSubrackFanRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.McpaFanRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.McpaSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.RfSubrackFanRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3101.configitem.ConfigurationData3101;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3101.rbs.Rbs3101;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGammaCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHiPowTxCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIntJumperCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimInterSubTimingCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIntraCabTimingCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimLoPowTxCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRaxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTrxRfCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.RfSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;

public class RadioEquipment3101CI
extends AbstractRbs3RadioEquipmentCI {
    private static final int BBIF_SLOT1 = 6;
    private static final int BBIF_SLOT2 = 7;
    private static final int RFIF_SLOT1 = 2;
    private static final int RFIF_SLOT2 = 3;
    private static final int TRX_SLOT1 = 4;
    private static final int TRX_SLOT2 = 5;
    private static final int AIU_SLOT = 6;
    private static final int MCPA_SLOT1 = 1;
    private static final int MCPA_SLOT2 = 2;
    private static final String MCPA_CABINET_POSITION = "2";
    private static final String MCPA_SUBRACK_POSITION = "2A1";
    private static final int MCPA_SUBRACK_NO_SLOTS = 6;
    private static final boolean IS_FAN_VARIABLE = false;

    public RadioEquipment3101CI(Rbs rbs) {
        super(rbs);
        if (Rbs3101.isRbs2()) {
            this.setBoardPositions(MimRaxDeviceGroup.MOTYPENAME, new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "22", "23", "24", "25"});
            this.setBoardPositions(MimTxDeviceGroup.MOTYPENAME, new String[]{"26", "27"});
        } else {
            this.setBoardPositions(MimRaxDeviceGroup.MOTYPENAME, new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16"});
            this.setBoardPositions(MimTxDeviceGroup.MOTYPENAME, new String[]{"17", "18"});
        }
    }

    protected void createConfigurations() throws BemException {
        int n = this.getRbs().getMaxNumberOfSectors();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 1; i <= n; ++i) {
            ConfigurationData configurationData = this.getConfigurationData(n2, n3, n4);
            ConfigurationCableData configurationCableData = this.getConfigurationCableData();
            Configuration1Normal configuration1Normal = new Configuration1Normal(this.getRbs(), i, configurationData, configurationCableData);
            Configuration2Normal configuration2Normal = new Configuration2Normal(this.getRbs(), i, configurationData, configurationCableData);
            Configuration2Low configuration2Low = new Configuration2Low(this.getRbs(), i, configurationData, configurationCableData);
            Configuration1High configuration1High = new Configuration1High(this.getRbs(), i, configurationData, configurationCableData);
            Configuration1Branched configuration1Branched = new Configuration1Branched(this.getRbs(), i, configurationData, configurationCableData);
            Configuration2Branched configuration2Branched = new Configuration2Branched(this.getRbs(), i, configurationData, configurationCableData);
            Reconfiguration1NormalTo1High reconfiguration1NormalTo1High = new Reconfiguration1NormalTo1High(this.getRbs(), configuration1Normal, configuration1High, i);
            Reconfiguration2LowTo2Normal reconfiguration2LowTo2Normal = new Reconfiguration2LowTo2Normal(this.getRbs(), configuration2Low, configuration2Normal, i);
            Reconfiguration1NormalTo2Normal reconfiguration1NormalTo2Normal = new Reconfiguration1NormalTo2Normal(this.getRbs(), configuration1Normal, configuration2Normal, i);
            Reconfiguration1NormalTo2Low reconfiguration1NormalTo2Low = new Reconfiguration1NormalTo2Low(this.getRbs(), configuration1Normal, configuration2Low, i);
            Reconfiguration1NormalTo1Branched reconfiguration1NormalTo1Branched = new Reconfiguration1NormalTo1Branched(this.getRbs(), configuration1Normal, configuration1Branched, i);
            Reconfiguration1NormalTo2Branched reconfiguration1NormalTo2Branched = new Reconfiguration1NormalTo2Branched(this.getRbs(), configuration1Normal, configuration2Branched, i);
            Reconfiguration2NormalTo2Branched reconfiguration2NormalTo2Branched = new Reconfiguration2NormalTo2Branched(this.getRbs(), configuration2Normal, configuration2Branched, i);
            Reconfiguration1BranchedTo2Normal reconfiguration1BranchedTo2Normal = new Reconfiguration1BranchedTo2Normal(this.getRbs(), configuration1Branched, configuration2Normal, i);
            Reconfiguration1BranchedTo1Normal reconfiguration1BranchedTo1Normal = new Reconfiguration1BranchedTo1Normal(this.getRbs(), configuration1Branched, configuration1Normal, i);
            Reconfiguration2BranchedTo2Normal reconfiguration2BranchedTo2Normal = new Reconfiguration2BranchedTo2Normal(this.getRbs(), configuration2Branched, configuration2Normal, i);
            Reconfiguration1BranchedTo2Branched reconfiguration1BranchedTo2Branched = new Reconfiguration1BranchedTo2Branched(this.getRbs(), configuration1Branched, configuration2Branched, i);
            SectorCapability sectorCapability = new SectorCapability();
            sectorCapability.addConfiguration(configuration1Normal, new Reconfiguration[]{reconfiguration1NormalTo1High, reconfiguration1NormalTo2Low, reconfiguration1NormalTo2Normal, reconfiguration1NormalTo1Branched, reconfiguration1NormalTo2Branched});
            sectorCapability.addConfiguration(configuration2Normal, new Reconfiguration[]{reconfiguration2NormalTo2Branched});
            sectorCapability.addConfiguration(configuration2Low, new Reconfiguration[]{reconfiguration2LowTo2Normal});
            sectorCapability.addConfiguration(configuration1High);
            sectorCapability.addConfiguration(configuration1Branched, new Reconfiguration[]{reconfiguration1BranchedTo2Normal, reconfiguration1BranchedTo1Normal, reconfiguration1BranchedTo2Branched});
            sectorCapability.addConfiguration(configuration2Branched, new Reconfiguration[]{reconfiguration2BranchedTo2Normal});
            this.addSectorCapability(i, sectorCapability);
            n2 += 3;
            n3 += 3;
            n4 += 2;
        }
    }

    protected ConfigurationData getConfigurationData(int n, int n2, int n3) throws BemException {
        HubSubrackMoi hubSubrackMoi = new HubSubrackMoi(this.getRbs().getEquipmentMoi());
        RfSubrackMoi rfSubrackMoi = new RfSubrackMoi();
        McpaSubrackRI mcpaSubrackRI = new McpaSubrackRI(this.getRbs(), 6, MCPA_CABINET_POSITION, MCPA_SUBRACK_POSITION, this.getRbs().getEquipmentMoi());
        McpaFanRI mcpaFanRI = new McpaFanRI(this.getRbs(), mcpaSubrackRI.getMoi(), false);
        BbSubrackFanRI bbSubrackFanRI = new BbSubrackFanRI(this.getRbs(), hubSubrackMoi, false);
        RfSubrackFanRI rfSubrackFanRI = new RfSubrackFanRI(this.getRbs(), rfSubrackMoi, false);
        return new ConfigurationData3101(6, 7, 2, 3, 4 + n, 5 + n, 6 + n2, 1 + n3, 2 + n3, hubSubrackMoi, rfSubrackMoi, rfSubrackMoi, rfSubrackMoi, mcpaSubrackRI, mcpaFanRI, bbSubrackFanRI, rfSubrackFanRI);
    }

    private ConfigurationCableData getConfigurationCableData() {
        ConfigurationCableData configurationCableData = new ConfigurationCableData();
        configurationCableData.addDelayAndAttenuationAttributes(MimGammaCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalDelay", new Integer(37))});
        configurationCableData.addDelayAndAttenuationAttributes(MimInterSubTimingCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalDlDelay", new Integer(37))});
        configurationCableData.addDelayAndAttenuationAttributes(MimIntraCabTimingCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalUlDelay", new Integer(37))});
        configurationCableData.addDelayAndAttenuationAttributes(MimTrxRfCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalDlDelay", new Integer(20)), Nal.getFactory().getNameValue("dlAttenuation", new Integer(6))});
        configurationCableData.addDelayAndAttenuationAttributes(MimIntJumperCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalUlDelay", new Integer(67)), Nal.getFactory().getNameValue("electricalDlDelay", new Integer(66)), Nal.getFactory().getNameValue("dlAttenuation", new Integer(4)), Nal.getFactory().getNameValue("ulAttenuation", new Integer(4))});
        configurationCableData.addDelayAndAttenuationAttributes(MimLoPowTxCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalDlDelay", new Integer(27)), Nal.getFactory().getNameValue("dlAttenuation", new Integer(2))});
        configurationCableData.addDelayAndAttenuationAttributes(MimHiPowTxCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalDlDelay", new Integer(17)), Nal.getFactory().getNameValue("dlAttenuation", new Integer(2))});
        configurationCableData.addDelayAndAttenuationAttributes(MimHiPowTxCable.MOTYPENAME, "HIGH", new NalNameValue[]{Nal.getFactory().getNameValue("electricalDlDelay", new Integer(11)), Nal.getFactory().getNameValue("dlAttenuation", new Integer(1))});
        return configurationCableData;
    }

    public Integer getTerminationConnector(int n, String string) throws BemException {
        Integer[] integerArray;
        if (string.equalsIgnoreCase(MimAntennaBranchDef.BRANCH_A)) {
            integerArray = new Integer[]{new Integer(14), new Integer(13), new Integer(12)};
        } else if (string.equalsIgnoreCase(MimAntennaBranchDef.BRANCH_B)) {
            integerArray = new Integer[]{new Integer(11), new Integer(10), new Integer(9)};
        } else {
            throw new BemException(this.getClass().getName() + " getTerminationConnector(): Antenna branch " + string + " not supported");
        }
        return integerArray[n - 1];
    }

    protected SectorCapabilityManager getSectorCapabilityManager() {
        return super.getSectorCapabilityManager();
    }

    public int getMaxNumberOfSupportedCarrierTxBranches(int n) {
        return 2;
    }
}

