/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3964.configitem;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FuSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuifRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet3;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.RbsCableSets;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.GenericRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB1;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB4;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.SectorCapability;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.Reconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.UninitSectorReconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRaxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRuifDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;

public class RadioEquipment3964CI
extends GenericRadioEquipmentCI {
    private static final int MAX_NO_OF_SECTORS = 3;
    private static final int MAX_NO_OF_RUS = 3;
    private static final int MAX_NO_OF_CARRIERS = 2;
    private EnumeratedRange radioIfTypeRange;
    private ReservedConnectorRI a;
    private ReservedConnectorRI b;
    private ReservedConnectorRI c;
    private ReservedConnectorRI d;
    private ReservedConnectorRI e;
    private ReservedConnectorRI f;

    public RadioEquipment3964CI(Rbs rbs) {
        super(rbs, 3, 3, 2, false);
        this.setBoardPositions(MimTxDeviceGroup.MOTYPENAME, new String[]{"10", "11"});
        this.setBoardPositions(MimRuifDeviceGroup.MOTYPENAME, new String[]{"12"});
        this.setBoardPositions(MimRaxDeviceGroup.MOTYPENAME, new String[]{"4", "5", "6", "7", "8", "9"});
    }

    public boolean open() throws BemException {
        this.initiateCPRanges();
        return super.open();
    }

    protected void createRadioBuildingBlocks() throws BemException {
        int n = this.getMaxNoOfSectors();
        this.radioBuildingBlocks = new RadioBuildingBlock[n];
        this.createReservedConnectors();
        for (int i = 1; i <= n; ++i) {
            SectorCapability sectorCapability = new SectorCapability();
            int n2 = i;
            RuRI ruRI = this.ruSubrack.getSlot(n2);
            FuRI fuRI = this.fuSubrack.getSlot(n2);
            RB1 rB1 = new RB1(this.rbs, i, fuRI, ruRI, this.ruif[0], 60, 0, 0, 0, 0);
            RB4 rB4 = new RB4(this.rbs, i, fuRI, ruRI, this.ruif[0], 60, 0, 0, 0, 0);
            rB1.setRadioIfConnectors(this.a, this.b, this.c, this.d, this.e, this.f);
            rB4.setRadioIfConnectors(this.a, this.b, this.c, this.d, this.e, this.f);
            Reconfiguration[] reconfigurationArray = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB1, rB4, i)};
            sectorCapability.addConfiguration(rB1, reconfigurationArray);
            sectorCapability.addConfiguration(rB4);
            this.addSectorCapability(i, sectorCapability);
        }
    }

    protected void createSubracks() throws BemException {
        this.ruSubrack = new RuSubrackRI(this.rbs, 3, "1", "1A2", 1);
        this.fuSubrack = new FuSubrackRI(this.rbs, 3, "1", "1B2", 1);
    }

    protected void createRadioInterfaceBoard() {
        this.ruif[0] = new RuifRI(this.rbs, 12, this.hubSubrackMoi);
    }

    protected RbsCableSets getRbsCableSets() {
        RbsCableSets rbsCableSets = new RbsCableSets();
        rbsCableSets.addCableSet("RB1", new CableSet3());
        rbsCableSets.addCableSet("RB4", new CableSet3());
        return rbsCableSets;
    }

    private void createReservedConnectors() {
        String string = MimDigitalCable.MOTYPENAME;
        String string2 = "objectAConnector";
        this.a = new ReservedConnectorRI(this.rbs, this.ruif[0].getPiuLdn(), 1, string, string2);
        this.b = new ReservedConnectorRI(this.rbs, this.ruif[0].getPiuLdn(), 2, string, string2);
        this.c = new ReservedConnectorRI(this.rbs, this.ruif[0].getPiuLdn(), 3, string, string2);
        this.d = new ReservedConnectorRI(this.rbs, this.ruif[0].getPiuLdn(), 4, string, string2);
        this.e = new ReservedConnectorRI(this.rbs, this.ruif[0].getPiuLdn(), 5, string, string2);
        this.f = new ReservedConnectorRI(this.rbs, this.ruif[0].getPiuLdn(), 6, string, string2);
    }

    private void initiateCPRanges() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("RUIF");
        this.radioIfTypeRange = new EnumeratedRange(arrayList);
    }

    protected EnumeratedRange getRadioIfTypeRange() {
        return this.radioIfTypeRange;
    }
}

