/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortInfo;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledHwUnitRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcBus;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcPort;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.LdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public abstract class AbstractHwUnitWithEcPortRI
extends AbstractDbControlledHwUnitRI
implements ResourceItem {
    protected String ecPort_hubPosition = MimEcPort.DEFAULT_HUBPOSITION;
    protected String ecPort_ldn;
    private boolean IgnoreEcportInfo = false;
    private static final String[] myInstallationPhases = new String[]{"HwUnitDbControlledCreationPhase", "HwUnitReconfigureProgramPreparePhase", "UnlockAllUnitsPhase", "HwUnitDbControlledDeletionPhase", "LockPhase", "UnlockPhase"};
    private String ecBusNo4MulCab = "1";

    public AbstractHwUnitWithEcPortRI(String string, Rbs rbs, String string2, String string3) {
        super(string, rbs, string2, string3, myInstallationPhases);
    }

    public AbstractHwUnitWithEcPortRI(String string, Rbs rbs, String string2, String string3, String[] stringArray) {
        super(string, rbs, string2, string3, stringArray);
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            super.install(string);
            if (string.equals("HwUnitDbControlledCreationPhase")) {
                EcPortInfo[] ecPortInfoArray;
                SingleChildMoi singleChildMoi = new SingleChildMoi(new LdnMoi(this.getLdn()), MimEcPort.MOTYPENAME, "1");
                this.ecPort_ldn = singleChildMoi.getLdn();
                EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
                int n = Integer.valueOf(this.getUnitNumber());
                Integer n2 = MimEcPort.DEFAULT_CASCADINGORDER;
                if (!this.isIgnoreEcportInfo() && (ecPortInfoArray = ecPortCustomerParameterProvider.getEcPortCustomerParameters()) != null && ecPortInfoArray.length > 0) {
                    n2 = this.getCascadingOrderFromEcPort(ecPortInfoArray, n);
                }
                this.createEcPort(this.ecPort_ldn, this.ecPort_hubPosition, n2);
            }
        }
    }

    private Integer getCascadingOrderFromEcPort(EcPortInfo[] ecPortInfoArray, int n) throws BemException {
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            EcPortInfo ecPortInfo = ecPortInfoArray[i];
            Integer n2 = ecPortInfo.getCascadingOrderValueMom();
            if (n2 != n) continue;
            return n2;
        }
        return MimEcPort.DEFAULT_CASCADINGORDER;
    }

    protected void createEcPort(String string, String string2, Integer n) throws BemException {
        BemMo bemMo = this.getMo(string);
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        MoInstance moInstance = this.rbs.getMoiRefs().getEquipmentMoi();
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimEcBus.MOTYPENAME, String.valueOf(this.getEcBusNo4MulCab()));
        String string3 = fixedRdnMoi.getLdn();
        BemMo bemMo2 = this.rbs.getMoHandler().getMo(string3);
        if (!bemMo2.isExisting()) {
            return;
        }
        NalNameValue nalNameValue = Nal.getFactory().getNameValue("ecBusRef", bemMo2);
        NalNameValue nalNameValue2 = Nal.getFactory().getNameValue("hubPosition", string2);
        NalNameValue nalNameValue3 = Nal.getFactory().getNameValue("cascadingOrder", n);
        vector.add(nalNameValue);
        vector.add(nalNameValue2);
        vector.add(nalNameValue3);
        if (!this.isExisting(bemMo)) {
            super.createMoIfNotExisting(string, vector);
        } else {
            this.setAttributes(bemMo, vector);
        }
    }

    public void uninstall(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            if (string.equals("HwUnitDbControlledDeletionPhase")) {
                this.deleteMoIfExisting(this.ecPort_ldn);
            }
            super.uninstall(string);
        }
    }

    public void setHubPosition(String string) {
        this.ecPort_hubPosition = string;
    }

    public String getHubPosition() {
        return this.ecPort_hubPosition;
    }

    public String getEcBusNo4MulCab() {
        return this.ecBusNo4MulCab;
    }

    public void setEcBusNo4MulCab(String string) {
        this.ecBusNo4MulCab = string;
    }

    private boolean isIgnoreEcportInfo() {
        return this.IgnoreEcportInfo;
    }

    public void setIgnoreEcportInfo(boolean bl) {
        this.IgnoreEcportInfo = bl;
    }
}

