/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.ifc;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class NalCmException
extends RuntimeException {
    private static final String DEFAULT_TAG = "";
    private static final String DEFAULT_INFO = "";
    protected static final String[] DEFAULT_VARIABLES = new String[0];
    private static final String TAG_INDICATOR = " TAG :\"";
    protected static final String VARIABLES_INDICATOR = " VARIABLES :";
    private static final String INDENTION = "   ";
    private static final String EQUAL_TAG = " = ";
    private static final String DOLLAR_TAG = "$";
    private static final String COMMA_TAG = ", ";
    private static final String QUOTE_TAG = "\"";
    private static final String VARIABLES_TAG = "VARIABLES";
    private static final String VARIABLE_NAME_BEGIN_MARK = "\"$";
    private final String tag;
    private final String info;
    private final String[] variables;
    private final String detailMessage;

    public NalCmException(String string) {
        this(string, null);
    }

    public NalCmException(Throwable throwable) {
        this(throwable == null ? null : throwable.toString(), throwable);
    }

    public NalCmException(String string, Throwable throwable) {
        super(string, throwable);
        if (throwable == null) {
            this.tag = "";
            this.info = "";
            this.variables = DEFAULT_VARIABLES;
            this.detailMessage = string;
        } else {
            this.info = this.extractCauseInfo(throwable);
            this.tag = this.extractCauseTag(throwable, this.info);
            this.variables = this.extractCauseVariables(throwable, this.info);
            this.detailMessage = this.constructMessage(this.tag, this.variables, this.info);
        }
    }

    public String getCauseTag() {
        return this.tag;
    }

    public String[] getCauseVariables() {
        return this.variables;
    }

    private String extractCauseInfo(Throwable throwable) {
        String string = "";
        string = throwable.toString();
        return string;
    }

    private String extractCauseTag(Throwable throwable, String string) {
        String string2 = "";
        string2 = this.isSubString(TAG_INDICATOR, string) ? this.extractInfoTextTag(string) : this.extractExceptionName(throwable);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    protected String[] extractInfoTextVariables(String string) {
        String[] stringArray;
        int n = string.indexOf(VARIABLE_NAME_BEGIN_MARK);
        if (-1 == string.indexOf(VARIABLES_TAG) || -1 == n) {
            return DEFAULT_VARIABLES;
        }
        int n2 = string.lastIndexOf(QUOTE_TAG);
        if (n >= n2) {
            return DEFAULT_VARIABLES;
        }
        String string2 = string.substring(n, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, VARIABLE_NAME_BEGIN_MARK, true);
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        String string4 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (stringArray.equals(QUOTE_TAG) || stringArray.equals(COMMA_TAG)) continue;
            if (stringArray.equals(DOLLAR_TAG)) {
                string4 = stringBuffer.toString();
                stringBuffer = new StringBuffer();
                if (string3 == null) continue;
                arrayList.add(string3 + ": " + string4);
                string3 = null;
                string4 = null;
                continue;
            }
            if (stringArray.equals(EQUAL_TAG)) {
                string3 = stringBuffer.toString();
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append((String)stringArray);
        }
        if (string3 != null) {
            arrayList.add(string3 + ": " + stringBuffer.toString());
        }
        stringArray = DEFAULT_VARIABLES;
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    private String[] extractCauseVariables(Throwable throwable, String string) {
        String[] stringArray = DEFAULT_VARIABLES;
        if (this.isSubString(VARIABLES_INDICATOR, string)) {
            stringArray = this.extractInfoTextVariables(string);
        }
        if (stringArray == null) {
            stringArray = DEFAULT_VARIABLES;
        }
        return stringArray;
    }

    private String extractExceptionName(Throwable throwable) {
        Class<?> clazz = throwable.getClass();
        String string = clazz.getName();
        int n = string.lastIndexOf(".") + 1;
        return string.substring(n);
    }

    private String extractInfoTextTag(String string) {
        int n = string.indexOf(TAG_INDICATOR);
        if (n == -1) {
            return "";
        }
        int n2 = string.indexOf(QUOTE_TAG, (n += TAG_INDICATOR.length()) + 1);
        if (n2 <= n) {
            return "";
        }
        return string.substring(n, n2);
    }

    private boolean isSubString(String string, String string2) {
        boolean bl = true;
        int n = string2.indexOf(string);
        if (n == -1) {
            bl = false;
        }
        return bl;
    }

    private static void indentNewLines(StringBuffer stringBuffer) {
        for (int i = 0; i < stringBuffer.length() - 1; ++i) {
            if (stringBuffer.charAt(i) != '\n') continue;
            stringBuffer.insert(++i, INDENTION);
            i += INDENTION.length();
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
            stringBuffer.append('\n');
        }
    }

    private String constructMessage(String string, String[] stringArray, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("\n");
            stringBuffer.append(stringArray[i]);
        }
        if (string2 != null && string2.length() != 0) {
            stringBuffer.append("\n");
            stringBuffer.append(string2);
        }
        NalCmException.indentNewLines(stringBuffer);
        return stringBuffer.toString();
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.detailMessage;
    }
}

