/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.backend;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalBackend;

public abstract class NalLogBackend
extends NalBackend
implements NalLog {
    private static final Class THIS_CLASS = NalLogBackend.class;
    public static final String NEW_LINE = System.getProperty("line.separator", "\n\r");
    public static final char FIRST_NEW_LINE_CHAR = NEW_LINE.charAt(0);
    protected int traceLevel = NalLogBackend.getDefaultTraceLevel();
    private static long logCount = 1L;
    protected boolean lineNumberInfo = true;
    protected static final boolean logToStdOut = Boolean.getBoolean("nal.log.to.stdout");
    protected static final boolean logToFile = Boolean.getBoolean("nal.log.to.file");
    protected static final String logFileNamePrefix = "log_BEM";
    public static final Lev[] LEVEL = new Lev[]{new Lev(0, 0, "MIN_LOG_LEVEL", "Min"), new Lev(1, 1, "ERROR        ", "Error"), new Lev(2, 2, "WARNING      ", "Warning"), new Lev(3, 3, "NOTIFY       ", "Notify"), new Lev(4, 4, "PARAM        ", "Parameter"), new Lev(5, 5, "TRACE_FLOW   ", "Trace Flow"), new Lev(6, 6, "TRACE        ", "Trace"), new Lev(7, 7, "DEBUG        ", "Debug")};
    public static final Lev LEVEL_ENTER = new Lev(6, 6, "ENTER        ", "Enter");
    public static final Lev LEVEL_RETURN = new Lev(6, 6, "RETURN       ", "Return");
    public static final Lev LEVEL_UNDEF = new Lev(7, 7, "?UNDEF_LEV   ", "Level out of bounds");
    private static ByteArrayOutputStream exceptionStream = new ByteArrayOutputStream(0);
    private static PrintWriter exceptionWriter = new PrintWriter(exceptionStream, true);
    private final String name;

    protected NalLogBackend(String string) {
        this.name = string;
    }

    public Object getNative() {
        return null;
    }

    public void setTraceLevel(int n) {
        if (n == -1) {
            return;
        }
        this.traceLevel = n;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public boolean isTraced(int n) {
        return this.traceLevel >= n;
    }

    public void nalTrace(int n, Class clazz, String string) {
        this.log(LEVEL[n], clazz, string, null);
    }

    public void nalTrace(int n, Class clazz, String string, Throwable throwable) {
        this.log(LEVEL[n], clazz, string, throwable);
    }

    public void nalTraceError(Class clazz, String string, Throwable throwable) {
        this.log(LEVEL[1], clazz, string, throwable);
    }

    public void nalTraceError(Class clazz, String string) {
        this.log(LEVEL[1], clazz, string, null);
    }

    public void nalTraceEnter(Class clazz, String string) {
        this.log(LEVEL_ENTER, clazz, string, null);
    }

    public void nalTraceReturn(Class clazz, String string) {
        this.log(LEVEL_RETURN, clazz, string, null);
    }

    protected abstract void log(int var1, String var2);

    private void log(Lev lev, Class clazz, String string, Throwable throwable) {
        if (!this.isTraced(lev.VALUE)) {
            return;
        }
        String string2 = this.format(clazz, lev.LONG_PREFIX, string, throwable);
        this.log(lev.VALUE, string2);
    }

    protected String format(Class clazz, String string, String string2, Throwable throwable) {
        Serializable serializable;
        if (clazz == null) {
            serializable = new Error("PROGRAMMING ERROR! NalLog method called with Class parameter=null!");
            this.nalTraceError(THIS_CLASS, "The missing Class parameter will cause a crach on the the node!", (Throwable)serializable);
        }
        serializable = new StringBuffer();
        ((StringBuffer)serializable).append(logCount++).append(' ');
        ((StringBuffer)serializable).append(string);
        if (string2 != null) {
            ((StringBuffer)serializable).append(string2);
        }
        if (this.lineNumberInfo) {
            ((StringBuffer)serializable).append("  AT LINE: ").append(NalLogBackend.getAtLine());
        }
        if (throwable != null) {
            ((StringBuffer)serializable).append(NEW_LINE);
            ((StringBuffer)serializable).append("Exception: ");
            ((StringBuffer)serializable).append(NEW_LINE);
            ((StringBuffer)serializable).append(NalLogBackend.getStackTrace(throwable));
        }
        return ((StringBuffer)serializable).toString();
    }

    public static int getDefaultTraceLevel() {
        int n = NalLogBackend.getIntProperty("nal.log.level", 3, 0, 7);
        return n;
    }

    public static int getIntProperty(String string, int n, int n2, int n3) {
        String string2 = System.getProperty(string);
        try {
            int n4 = Integer.parseInt(string2);
            if (n4 < n2) {
                return n2;
            }
            if (n4 > n3) {
                return n3;
            }
            return n4;
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static String getAtLine() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        for (int i = 2; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string = stackTraceElement.getClassName();
            if (string.indexOf(".NalMo") != -1 || string.indexOf(".NalTrace") != -1 || string.indexOf(".BemMoImpl") != -1 || string.indexOf(".BemMoImpl") != -1 || string.indexOf(".MoHandlerImpl") != -1 || string.indexOf(".MOProxy") != -1 || string.indexOf("Log") != -1) continue;
            return stackTraceElement.toString();
        }
        if (stackTraceElementArray.length > 2) {
            return stackTraceElementArray[2].toString();
        }
        if (stackTraceElementArray.length > 0) {
            return stackTraceElementArray[stackTraceElementArray.length - 1].toString();
        }
        return "";
    }

    public static final String old_getAtLine() {
        Throwable throwable = new Throwable();
        String string = NalLogBackend.getStackTrace(throwable);
        int n = string.lastIndexOf(".MOProxy");
        if (n == -1) {
            n = string.lastIndexOf(".MoHandlerImpl");
        }
        if (n == -1) {
            n = string.lastIndexOf(".BemMoImpl");
        }
        if (n == -1) {
            n = string.lastIndexOf(".NalMo");
        }
        if (n == -1) {
            n = string.lastIndexOf(".NalTrace");
        }
        if (n == -1) {
            n = string.lastIndexOf("Log");
        }
        if (n == -1) {
            n = 0;
        }
        if ((n = string.indexOf("at ", n + 1)) == -1) {
            return null;
        }
        int n2 = string.indexOf(FIRST_NEW_LINE_CHAR, n + 1);
        String string2 = string.substring(n + 3, n2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = exceptionStream;
        synchronized (byteArrayOutputStream) {
            exceptionStream.reset();
            throwable.printStackTrace(exceptionWriter);
            return exceptionStream.toString();
        }
    }

    public static String junit_getLongPrefix(int n) {
        return NalLogBackend.getLev((int)n).LONG_PREFIX;
    }

    public static Lev getLev(int n) {
        Lev lev = LEVEL_UNDEF;
        if (n >= 0 && n <= LEVEL.length) {
            lev = LEVEL[n];
        }
        return lev;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        int n = this.getTraceLevel();
        Lev lev = NalLogBackend.getLev(n);
        String string = "NalLog{level=" + lev.PREFIX + ", type=" + this.getNalType() + ", name=" + this.getName() + "}";
        return string;
    }

    public static class Lev {
        public final int VALUE;
        public final String PREFIX;
        public final String LONG_PREFIX;
        public final String TITLE;
        public final String TEXT;

        private Lev(int n, int n2, String string, String string2) {
            this.VALUE = n;
            this.PREFIX = string.trim();
            this.LONG_PREFIX = string;
            this.TITLE = string2;
            this.TEXT = string2.toLowerCase();
            if (n != n2) {
                Error error = new Error("FATAL! value=" + n + " != valueConstant=" + n2 + " for level=" + this.PREFIX + "!");
                error.printStackTrace();
                throw error;
            }
        }

        public String toString() {
            return this.PREFIX;
        }
    }
}

