/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.log;

import java.util.Collection;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalBackendFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmNotificationConsumer;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmSubscription;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalMo;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNodeConnectionListener;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalProgress;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTypes;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalMoTransactionDefault;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalSimpleLog;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.log.NalCmNotificationConsumerLog;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.log.NalCmSubscriptionLog;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.log.NalTransactionLog;

public class NalFactoryLog
implements NalFactory,
NalBackendFactory {
    private static final NalLog log = Nal.newLog("se.ericsson.wcdma.rbs.bem");
    private final NalBackendFactory delegate;
    private static int ENTER_LOG_LEVEL = 6;
    final NalTypes IMPL;

    public NalFactoryLog(NalBackendFactory nalBackendFactory) {
        this.delegate = nalBackendFactory;
        this.IMPL = new NalTypes(NalMoTransactionDefault.class, nalBackendFactory.getImplTypes().NAME_VALUE_ARRAY, nalBackendFactory.getImplTypes().STRUCT_ARRAY, NalTransactionLog.class, NalCmException.class, NalCmNotificationConsumerLog.class, NalCmSubscriptionLog.class, NalSimpleLog.class);
    }

    public String getNalType() {
        String string = this.delegate.getNalType();
        return string;
    }

    public void connectToMib(String string) {
        log.nalTrace(ENTER_LOG_LEVEL, this.delegate.getClass(), "NalFactory.connectToMib(mib=" + string + ")");
        this.delegate.connectToMib(string);
    }

    public void disconnectFromMib() {
        log.nalTrace(ENTER_LOG_LEVEL, this.delegate.getClass(), "NalFactory.disconnectFromMib()");
        this.delegate.disconnectFromMib();
    }

    public synchronized void reconnectMib(String string, NalProgress nalProgress) {
        log.nalTrace(3, this.delegate.getClass(), "\n\n\nENTER NalFactory.reconnectMib(newAddress=" + string + ")" + "\n\n");
        this.delegate.reconnectMib(string, nalProgress);
    }

    public String getHost() {
        if (log.isTraced(ENTER_LOG_LEVEL)) {
            log.nalTraceEnter(this.delegate.getClass(), "NalFactory.getHost()");
        }
        return this.delegate.getHost();
    }

    public NalTransaction createNullTransaction() {
        return new NalTransactionLog(this.delegate.createNullTransaction());
    }

    public NalTransaction createTransaction() {
        return new NalTransactionLog(this.delegate.createTransaction());
    }

    public NalTransaction createTransaction(int n) {
        return new NalTransactionLog(this.delegate.createTransaction(n));
    }

    public NalMo getMo(String string) {
        return this.delegate.getMo(string);
    }

    public NalMo getRootMo() {
        return this.delegate.getRootMo();
    }

    public NalNameValue getNameValue(String string, Object object) {
        return this.delegate.getNameValue(string, object);
    }

    public NalStruct getStruct(NalNameValue[] nalNameValueArray) {
        return this.delegate.getStruct(nalNameValueArray);
    }

    public NalStruct getStruct(Collection collection) {
        return this.delegate.getStruct(collection);
    }

    public void sleep(long l) throws InterruptedException {
        if (log.isTraced(ENTER_LOG_LEVEL)) {
            log.nalTraceEnter(this.delegate.getClass(), "NalFactory.sleep( millis=" + l + ")");
        }
        this.delegate.sleep(l);
    }

    public long currentTimeMillis() {
        if (log.isTraced(ENTER_LOG_LEVEL)) {
            log.nalTraceEnter(this.delegate.getClass(), "NalFactory.currentTimeMillis()");
        }
        long l = this.delegate.currentTimeMillis();
        return l;
    }

    public String toString() {
        String string = this.delegate.toString();
        return string;
    }

    public NalLog getLog() {
        return this.delegate.getLog();
    }

    public NalTypes getNativeTypes() {
        return this.delegate.getNativeTypes();
    }

    public NalTypes getImplTypes() {
        return this.IMPL;
    }

    public NalMo wrapNativeMo(Object object) throws ClassCastException {
        NalMo nalMo = this.delegate.wrapNativeMo(object);
        return nalMo;
    }

    public NalNameValue wrapNativeNameValue(Object object) throws ClassCastException {
        return this.delegate.wrapNativeNameValue(object);
    }

    public NalStruct wrapNativeStruct(Object object) throws ClassCastException {
        return this.delegate.wrapNativeStruct(object);
    }

    public NalTransaction wrapNativeTransaction(Object object) throws ClassCastException {
        NalTransaction nalTransaction = this.delegate.wrapNativeTransaction(object);
        return new NalTransactionLog(nalTransaction);
    }

    public NalCmNotificationConsumer wrapNativeCmNotificationConsumer(Object object) throws ClassCastException {
        NalCmNotificationConsumer nalCmNotificationConsumer = this.delegate.wrapNativeCmNotificationConsumer(object);
        return new NalCmNotificationConsumerLog(nalCmNotificationConsumer);
    }

    public NalCmSubscription wrapNativeCmSubscription(Object object) throws ClassCastException {
        NalCmSubscription nalCmSubscription = this.delegate.wrapNativeCmSubscription(object);
        return new NalCmSubscriptionLog(nalCmSubscription);
    }

    public void addConnectionListener(NalNodeConnectionListener nalNodeConnectionListener) {
        this.delegate.addConnectionListener(nalNodeConnectionListener);
    }

    public void removeConnectionListener(NalNodeConnectionListener nalNodeConnectionListener) {
        this.delegate.removeConnectionListener(nalNodeConnectionListener);
    }
}

