/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import enea.ose.system.Signal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.equipment.EquipException;
import se.ericsson.cello.equipment.ExcludePiuAndProgramsFilter;
import se.ericsson.cello.equipment.FanMoInternal;
import se.ericsson.cello.equipment.GenericProgramBase;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.MoNotInPiuTypeException;
import se.ericsson.cello.equipment.PiuMoExtend;
import se.ericsson.cello.equipment.PlugNPlayListener;
import se.ericsson.cello.equipment.eqaccess.MO_HandlerFactoryAccess;
import se.ericsson.cello.equipment.eqaccess.PIU_MO_HandlerAccess;
import se.ericsson.cello.equipment.eqaccess.ProgramHandlerAccess;
import se.ericsson.cello.equipment.eqaccess.ProgramHandlerFactoryAccess;
import se.ericsson.cello.equipment.fropxy.OsaXpGetAttributesRsp;
import se.ericsson.cello.equipment.fropxy.OsaXpMgmntProxy;
import se.ericsson.cello.equipment.fropxy.OsaXpSetAttributesCfm;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.equipment.intma.PlugNPlayHelperAccess;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.MoTypeFilter;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Coordinator;

public class PiuMoExtendImpl
implements PiuMoExtend {
    private OsaXpMgmntProxy xpProxy = OsaXpMgmntProxy.instance();
    private static final int DEBUG_PRIO_LEVEL = 7;

    public void deleteOldProgram(Coordinator coordinator, ManagedObject managedObject, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws MoAccessException {
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)managedObject;
        if (piuTypeAccess == null) {
            UpgradeTrace.error(this.getClass(), (String)"deleteOldProgram(Coordinator c, ManagedObject mo, GenericUpgradeablePlugInUnit piu)", (String)("the PiuType is null for PlugInUnit: " + genericUpgradeablePlugInUnit));
            return;
        }
        Struct[] structArray = piuTypeAccess.getProgramConfiguration(coordinator);
        if (structArray == null) {
            UpgradeTrace.error(this.getClass(), (String)"deleteOldProgram(Coordinator c, ManagedObject mo, GenericUpgradeablePlugInUnit piu)", (String)("programConfiguration is null (not empty) for the PlugInUnit: " + genericUpgradeablePlugInUnit + " with PiuType: " + piuTypeAccess));
            return;
        }
        for (int i = 0; i < structArray.length; ++i) {
            String string;
            String string2 = piuTypeAccess.getProgramConfigurationTag(structArray[i]);
            String string3 = piuTypeAccess.getProgramConfigurationProgramMoTypeName(structArray[i]);
            String string4 = piuTypeAccess.getProgramConfigurationProgramsSubParentLDN(structArray[i]);
            String string5 = "".equalsIgnoreCase(string4) ? genericUpgradeablePlugInUnit.getLocalDistinguishedName() : genericUpgradeablePlugInUnit.getLocalDistinguishedName() + "," + string4;
            ManagedObject managedObject2 = MoRepository.instance().lookup(string5);
            if (managedObject2 == null) {
                string = "The subParentLdn defined in the PiuType is not registered in the MoRepository, subParent LDN: " + string5;
                UpgradeTrace.warning(this.getClass(), (String)"deleteOldProgram(Coordinator c, ManagedObject mo, GenericUpgradeablePlugInUnit piu)", (String)string);
                continue;
            }
            string = MoRepository.instance().select(managedObject2, 1, (MoFilter)new MoTypeFilter(string3));
            if (string == null) continue;
            while (string.hasMoreElements()) {
                GenericProgramBase genericProgramBase = (GenericProgramBase)string.nextMo();
                try {
                    if (genericProgramBase == null || genericProgramBase.getStartState(coordinator) != 0) continue;
                    this.debugTrace("deleteOldProgram(Coordinator c, ManagedObject mo, GenericUpgradeablePlugInUnit piu)", "Delete Program: " + (ManagedObject)genericProgramBase);
                    ((ManagedObject)genericProgramBase).delete(coordinator);
                }
                catch (MoAccessException moAccessException) {
                    UpgradeTrace.warning(this.getClass(), (String)"deleteOldProgram(Coordinator c, ManagedObject mo, GenericUpgradeablePlugInUnit piu)", (String)("delete of program failed for PlugInUnit: " + genericUpgradeablePlugInUnit + ", progRef: " + ((ManagedObject)genericProgramBase).getLocalDistinguishedName() + ", e: " + (Object)((Object)moAccessException)));
                    throw moAccessException;
                }
                catch (Exception exception) {
                    UpgradeTrace.error(this.getClass(), (String)"deleteOldProgram(Coordinator c, ManagedObject mo, GenericUpgradeablePlugInUnit piu)", (String)("delete of program failed for PlugInUnit: " + genericUpgradeablePlugInUnit + ", progRef: " + ((ManagedObject)genericProgramBase).getLocalDistinguishedName() + ", e: " + exception));
                    throw new SoftwareErrorException((Throwable)exception);
                }
            }
        }
    }

    public void createSubordinates(Coordinator coordinator, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, PlugNPlayListener plugNPlayListener) throws MoAccessException {
        Struct[] structArray;
        if (!(genericUpgradeablePlugInUnit instanceof FanMoInternal)) {
            structArray = ((PiuTypeAccess)genericUpgradeablePlugInUnit.getPiuType(coordinator)).getMoConfiguration(coordinator);
            if (structArray != null && structArray.length > 0) {
                this.createSpMo(coordinator, structArray, (PiuTypeAccess)genericUpgradeablePlugInUnit.getPiuType(coordinator), genericUpgradeablePlugInUnit);
            } else {
                this.debugTrace("createSubordinates(Coordinator c, GenericUpgradeablePlugInUnit piu, PlugNPlayListener pNpListener)", "No subordinates to configure, MoConfiguration is empty");
            }
            if (((PiuTypeAccess)genericUpgradeablePlugInUnit.getPiuType(coordinator)).getLmFilesInstallState(null) != 2) {
                Object object;
                if (plugNPlayListener == null) {
                    object = "The Piu Type MO is not installed, and the supplied PlugNPlayListener is null. Function is not able to complete and will return.";
                    UpgradeTrace.error(this.getClass(), (String)"createSubordinates(Coordinator c, GenericUpgradeablePlugInUnit piu, PlugNPlayListener pNpListener)", (String)object);
                }
                this.debugTrace("createSubordinates(Coordinator c, GenericUpgradeablePlugInUnit piu, PlugNPlayListener pNpListener)", "The Piu Type MO must be installed to be able to proceed with P&P.\n\tPiuTypeMo: " + genericUpgradeablePlugInUnit.getPiuType(coordinator) + "\n\tpiu: " + genericUpgradeablePlugInUnit + "\n\tLmFilesInstallState: " + ((PiuTypeAccess)genericUpgradeablePlugInUnit.getPiuType(coordinator)).getLmFilesInstallState(null));
                object = (PlugNPlayHelperAccess)ServiceLocatorFacade.getRepository().getService(PlugNPlayHelperAccess.class);
                object.supervisePiuType((PiuTypeAccess)genericUpgradeablePlugInUnit.getPiuType(coordinator), plugNPlayListener);
                return;
            }
        }
        if ((structArray = ((PiuTypeAccess)genericUpgradeablePlugInUnit.getPiuType(coordinator)).getProgramConfiguration(coordinator)) != null && structArray.length > 0) {
            ProgramHandlerFactoryAccess programHandlerFactoryAccess = (ProgramHandlerFactoryAccess)ServiceLocatorFacade.getRepository().getService(ProgramHandlerFactoryAccess.class);
            ProgramHandlerAccess programHandlerAccess = programHandlerFactoryAccess.getProgramHandlerAccess(genericUpgradeablePlugInUnit);
            programHandlerAccess.reconfigurePrograms(coordinator);
        } else {
            this.debugTrace("createSubordinates(Coordinator c, GenericUpgradeablePlugInUnit piu, PlugNPlayListener pNpListener)", "There is no subordinate to configure, programConfigList is empty");
        }
    }

    public void deleteSubordinates(Coordinator coordinator, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws MoAccessException {
        MoIterator moIterator = genericUpgradeablePlugInUnit.getChildren();
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                this.debugTrace("deleteSubordinates(Coordinator c, GenericUpgradeablePlugInUnit piu)", "Deleting MO: " + managedObject);
                managedObject.delete(coordinator);
            }
        }
    }

    public void updatePiuType(Coordinator coordinator, ManagedObject managedObject, ManagedObject managedObject2, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws MoAccessException {
        if (!(managedObject instanceof PiuTypeAccess) || !(managedObject2 instanceof PiuTypeAccess)) {
            String string = "updatePiuType: wrong parameter type, newPiuType and oldPiuType have to be of type PiuTypeMo. newPiuType: " + managedObject + ", oldPiuType: " + managedObject2;
            UpgradeTrace.error(this.getClass(), (String)"updatePiuType(Coordinator c, ManagedObject newPiuType, ManagedObject oldPiuType, GenericUpgradeablePlugInUnit piu)", (String)string);
            throw new IllegalArgumentException("In PiuMoExtendImpl, " + string);
        }
        this.debugTrace("updatePiuType(Coordinator c, ManagedObject newPiuType, ManagedObject oldPiuType, GenericUpgradeablePlugInUnit piu)", " New PiuType: " + managedObject + " configured PiuType: " + managedObject2);
        MO_HandlerFactoryAccess mO_HandlerFactoryAccess = (MO_HandlerFactoryAccess)ServiceLocatorFacade.getRepository().getService(MO_HandlerFactoryAccess.class);
        PIU_MO_HandlerAccess pIU_MO_HandlerAccess = mO_HandlerFactoryAccess.getPIU_MO_HandlerAccess();
        pIU_MO_HandlerAccess.updatePIU_Resource(genericUpgradeablePlugInUnit, (PiuTypeAccess)managedObject, coordinator);
        Struct[] structArray = ((PiuTypeAccess)managedObject).getMoConfiguration(coordinator);
        Struct[] structArray2 = ((PiuTypeAccess)managedObject2).getMoConfiguration(coordinator);
        if (structArray == null) {
            this.debugTrace("updatePiuType(Coordinator c, ManagedObject newPiuType, ManagedObject oldPiuType, GenericUpgradeablePlugInUnit piu)", "No subordinate in the new PiuType, delete the old");
            this.deleteSubordinates(coordinator, genericUpgradeablePlugInUnit);
        } else if (structArray2 == null) {
            this.debugTrace("updatePiuType(Coordinator c, ManagedObject newPiuType, ManagedObject oldPiuType, GenericUpgradeablePlugInUnit piu)", "No subordinate in the old PiuType, create the new");
            this.createSpMo(coordinator, structArray, (PiuTypeAccess)managedObject, genericUpgradeablePlugInUnit);
        } else {
            ManagedObject managedObject3;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            this.debugTrace("updatePiuType(Coordinator c, ManagedObject newPiuType, ManagedObject oldPiuType, GenericUpgradeablePlugInUnit piu)", "Register common part of the two piuTypes");
            Vector<Integer> vector = new Vector<Integer>();
            LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
            for (int i = 0; i < structArray2.length; ++i) {
                string5 = ((PiuTypeAccess)managedObject2).getMoConfigurationMoIdentity(structArray2[i]);
                string4 = ((PiuTypeAccess)managedObject2).getMoConfigurationHardwareMoTypeName(structArray2[i]);
                string3 = ((PiuTypeAccess)managedObject2).getMoConfigurationHardwaresSubParentLDN(structArray2[i]);
                string2 = "".equalsIgnoreCase(string3) ? genericUpgradeablePlugInUnit.getLocalDistinguishedName() : genericUpgradeablePlugInUnit.getLocalDistinguishedName() + "," + string3;
                string = string2 + "," + string4 + "=" + string5;
                managedObject3 = MoRepository.instance().lookup(string);
                boolean bl = false;
                for (int j = 0; !bl && j < structArray.length; ++j) {
                    String string6 = ((PiuTypeAccess)managedObject).getMoConfigurationHardwaresSubParentLDN(structArray[j]);
                    String string7 = ((PiuTypeAccess)managedObject).getMoConfigurationHardwareMoTypeName(structArray[j]);
                    String string8 = ((PiuTypeAccess)managedObject).getMoConfigurationMoIdentity(structArray[j]);
                    if (!string4.equals(string7) || !string6.equals(string3) || !string5.equals(string8) || managedObject3 == null) continue;
                    bl = true;
                    vector.addElement(new Integer(j));
                    this.debugTrace("updatePiuType(Coordinator c, ManagedObject newPiuType, ManagedObject oldPiuType, GenericUpgradeablePlugInUnit piu)", "Common part of the two PiuTypes, MO: " + managedObject3);
                    break;
                }
                if (bl) continue;
                if (managedObject3 != null) {
                    this.debugTrace("updatePiuType(Coordinator c, ManagedObject newPiuType, ManagedObject oldPiuType, GenericUpgradeablePlugInUnit piu)", "Adding MO: " + managedObject3 + ", specified in the old PiuType MoConfig to" + " the delete list since it should be removed from config.");
                    linkedList.addFirst(managedObject3);
                    continue;
                }
                this.debugTrace("updatePiuType(Coordinator c, ManagedObject newPiuType, ManagedObject oldPiuType, GenericUpgradeablePlugInUnit piu)", "Delete a MO from the old PiuType not part of the new PiuType. The MO never existed in current configuration and therefore the delete will be ignored, MO ldn: " + string);
            }
            Iterator iterator = linkedList.iterator();
            while (iterator != null && iterator.hasNext()) {
                string5 = (ManagedObject)iterator.next();
                string4 = string5.getChildren();
                while (string4 != null && string4.hasMoreElements()) {
                    string3 = string4.nextMo();
                    if (!(string3 instanceof GenericProgramBase)) continue;
                    this.debugTrace("updatePiuType(Coordinator c, ManagedObject newPiuType, ManagedObject oldPiuType, GenericUpgradeablePlugInUnit piu)", "Delete the Program: " + string3.getLocalDistinguishedName() + " from the old PiuType configuration.");
                    string3.delete(coordinator);
                }
                this.debugTrace("updatePiuType(Coordinator c, ManagedObject newPiuType, ManagedObject oldPiuType, GenericUpgradeablePlugInUnit piu)", "Delete MO: " + string5 + " from the old PiuType configuration.");
                string5.delete(coordinator);
            }
            for (int i = 0; i < structArray.length; ++i) {
                Object object;
                if (vector.contains(new Integer(i))) continue;
                string4 = ((PiuTypeAccess)managedObject).getMoConfigurationHardwaresSubParentLDN(structArray[i]);
                string3 = ((PiuTypeAccess)managedObject).getMoConfigurationHardwareMoTypeName(structArray[i]);
                string2 = ((PiuTypeAccess)managedObject).getMoConfigurationMoIdentity(structArray[i]);
                string = "".equalsIgnoreCase(string4) ? genericUpgradeablePlugInUnit.getLocalDistinguishedName() : genericUpgradeablePlugInUnit.getLocalDistinguishedName() + "," + string4;
                managedObject3 = MoRepository.instance().lookup(string);
                if (managedObject3 == null) {
                    object = "The subParentLdn defined in the PiuType is not registered in the MoRepository, subParent LDN: " + string;
                    UpgradeTrace.warning(this.getClass(), (String)"updatePiuType(Coordinator c, ManagedObject newPiuType, ManagedObject oldPiuType, GenericUpgradeablePlugInUnit piu)", (String)object);
                    continue;
                }
                object = MoFactoryMgr.instance().lookup(string3);
                if (object == null) {
                    String string9 = "The factory for motype: " + string3 + " is not registered in the MoFactoryMgr.";
                    UpgradeTrace.warning(this.getClass(), (String)"updatePiuType(Coordinator c, ManagedObject newPiuType, ManagedObject oldPiuType, GenericUpgradeablePlugInUnit piu)", (String)string9);
                    continue;
                }
                this.debugTrace("updatePiuType(Coordinator c, ManagedObject newPiuType, ManagedObject oldPiuType, GenericUpgradeablePlugInUnit piu)", "Create MO of type: " + string3);
                object.createMo(managedObject3, (AttrList)new AttrListImpl(0), string2, null, coordinator);
            }
        }
    }

    public void updateXpType(Coordinator coordinator, ManagedObject managedObject, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws MoAccessException {
        Struct struct = ((PiuTypeAccess)managedObject).getProductData(coordinator);
        int n = genericUpgradeablePlugInUnit.getResourceId(coordinator);
        OsaXpGetAttributesRsp osaXpGetAttributesRsp = this.xpProxy.sendOsaXpGetAttributesReq(coordinator.getTransactionID(), n);
        this.checkSignal((Signal)osaXpGetAttributesRsp);
        if (osaXpGetAttributesRsp.getResult() != 1) {
            throw new EquipException("Fan get attribute request rejected by XP FRO: " + this.xpProxy.getResultMsg(osaXpGetAttributesRsp.getResult()));
        }
        Object[] objectArray = struct.getValues();
        OsaXpSetAttributesCfm osaXpSetAttributesCfm = this.xpProxy.sendOsaXpSetAttributesReq(coordinator.getTransactionID(), n, osaXpGetAttributesRsp.getAdministrativeState(), (String)objectArray[0], (String)objectArray[1], (String)objectArray[2], (String)objectArray[4], osaXpGetAttributesRsp.getHdlcAddress(), osaXpGetAttributesRsp.getHighAirTempAlarmLimit(), osaXpGetAttributesRsp.getCriticalAirTempAlarmLimit());
        this.checkSignal((Signal)osaXpSetAttributesCfm);
        if (osaXpSetAttributesCfm.getResult() != 1) {
            throw new EquipException("Fan set attribute request rejected by XP FRO: " + this.xpProxy.getResultMsg(osaXpSetAttributesCfm.getResult()));
        }
    }

    private void createSpMo(Coordinator coordinator, Struct[] structArray, PiuTypeAccess piuTypeAccess, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws MoAccessException {
        for (int i = 0; i < structArray.length; ++i) {
            Object object;
            String string = piuTypeAccess.getMoConfigurationHardwaresSubParentLDN(structArray[i]);
            String string2 = piuTypeAccess.getMoConfigurationHardwareMoTypeName(structArray[i]);
            String string3 = piuTypeAccess.getMoConfigurationMoIdentity(structArray[i]);
            String string4 = "".equals(string) ? genericUpgradeablePlugInUnit.getLocalDistinguishedName() : genericUpgradeablePlugInUnit.getLocalDistinguishedName() + "," + string;
            ManagedObject managedObject = MoRepository.instance().lookup(string4);
            if (managedObject == null) {
                object = "The subParentLdn defined in the PiuType is not registered in the MoRepository, subParent LDN: " + string4;
                UpgradeTrace.warning(this.getClass(), (String)"createSpMo(Coordinator c, Struct[] moConfigList, PiuTypeAccess aPiuTypeMo, GenericUpgradeablePlugInUnit piu)", (String)object);
                continue;
            }
            object = MoFactoryMgr.instance().lookup(string2);
            if (object == null) {
                String string5 = "The factory for motype: " + string2 + " is not registered in the MoFactoryMgr.";
                UpgradeTrace.warning(this.getClass(), (String)"createSpMo(Coordinator c, Struct[] moConfigList, PiuTypeAccess aPiuTypeMo, GenericUpgradeablePlugInUnit piu)", (String)string5);
                continue;
            }
            this.debugTrace("createSpMo(Coordinator c, Struct[] moConfigList, PiuTypeAccess aPiuTypeMo, GenericUpgradeablePlugInUnit piu)", "Create MO of type: " + string2);
            object.createMo(managedObject, (AttrList)new AttrListImpl(0), string3, null, coordinator);
        }
    }

    public void updateMoConfiguration(Coordinator coordinator, ManagedObject managedObject, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws MoAccessException {
        if (!(managedObject instanceof PiuTypeAccess)) {
            String string = "updateMoConfiguration: wrong parameter type, piuType has to be of type PiuTypeMo. piuType: " + managedObject;
            MessageLog.traceError(this.getClass(), (String)string);
            throw new IllegalArgumentException("In PiuMoExtendImpl, " + string);
        }
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)managedObject;
        Struct[] structArray = piuTypeAccess.getMoConfiguration(coordinator);
        if (structArray == null) {
            this.debugTrace("updateMoConfiguration()", "No subordinates are specified in the PiuType, return.");
            return;
        }
        for (int i = 0; i < structArray.length; ++i) {
            String string;
            String string2 = piuTypeAccess.getMoConfigurationMoIdentity(structArray[i]);
            String string3 = piuTypeAccess.getMoConfigurationHardwareMoTypeName(structArray[i]);
            String string4 = piuTypeAccess.getMoConfigurationHardwaresSubParentLDN(structArray[i]);
            String string5 = "".equalsIgnoreCase(string4) ? genericUpgradeablePlugInUnit.getLocalDistinguishedName() : genericUpgradeablePlugInUnit.getLocalDistinguishedName() + "," + string4;
            ManagedObject managedObject2 = MoRepository.instance().lookup(string5);
            if (managedObject2 == null) {
                string = "The subParentLdn defined in the PiuType is not registered in the MoRepository, subParent LDN: " + string5;
                UpgradeTrace.warning(this.getClass(), (String)"updateMoConfiguration()", (String)string);
                continue;
            }
            string = string5 + "," + string3 + "=" + string2;
            ManagedObject managedObject3 = MoRepository.instance().lookup(string);
            if (managedObject3 == null) {
                this.debugTrace("updateMoConfiguration()", "Going to create MO: " + string3 + " under parent: " + managedObject2 + ", specified in PiuType but missing in configuration.");
                MoFactory moFactory = MoFactoryMgr.instance().lookup(string3);
                if (moFactory == null) {
                    String string6 = "The factory for motype: " + string3 + " is not registered in the MoFactoryMgr.";
                    UpgradeTrace.warning(this.getClass(), (String)"updateMoConfiguration()", (String)string6);
                    continue;
                }
                moFactory.createMo(managedObject2, (AttrList)new AttrListImpl(0), string2, null, coordinator);
                continue;
            }
            this.debugTrace("updateMoConfiguration()", "Ignore LDN: " + string + ". The MO already exist.");
        }
    }

    public void checkPiuTypeCompliance(Coordinator coordinator, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws MoAccessException {
        Object[] objectArray;
        String string;
        HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)genericUpgradeablePlugInUnit.getPiuType(coordinator);
        Struct[] structArray = piuTypeAccess.getMoConfiguration(coordinator);
        if (structArray == null) {
            this.debugTrace("checkPiuTypeCompliance()", " No subordinates are specified in this PiuType: " + genericUpgradeablePlugInUnit.getPiuType(coordinator));
        } else {
            for (int i = 0; i < structArray.length; ++i) {
                string = piuTypeAccess.getMoConfigurationMoIdentity(structArray[i]);
                objectArray = piuTypeAccess.getMoConfigurationHardwareMoTypeName(structArray[i]);
                String string2 = piuTypeAccess.getMoConfigurationHardwaresSubParentLDN(structArray[i]);
                String string3 = "".equalsIgnoreCase(string2) ? genericUpgradeablePlugInUnit.getLocalDistinguishedName() : genericUpgradeablePlugInUnit.getLocalDistinguishedName() + "," + string2;
                String string4 = string3 + "," + (String)objectArray + "=" + string;
                ManagedObject managedObject = MoRepository.instance().lookup(string4);
                if (managedObject == null) {
                    this.debugTrace("checkPiuTypeCompliance()", "LDN: " + string4 + ", defined in PiuType but do not exist in configuration, skip and continue with next element.");
                    continue;
                }
                this.debugTrace("checkPiuTypeCompliance()", "LDN: " + string4 + ", defined in PiuType is added to the list of elements.");
                hashSet.add(managedObject);
            }
        }
        MoIterator moIterator = MoRepository.instance().select((ManagedObject)genericUpgradeablePlugInUnit, -1, (MoFilter)new ExcludePiuAndProgramsFilter());
        if (hashSet == null && moIterator != null) {
            this.debugTrace("checkPiuTypeCompliance()", " No subordinates are specified in this PiuType: " + genericUpgradeablePlugInUnit.getPiuType(coordinator) + ", but a sub-structure is configured under this PIU.");
        } else if (moIterator != null) {
            this.debugTrace("checkPiuTypeCompliance()", "Looping configured PIU substructure.");
            while (moIterator.hasMoreElements()) {
                string = moIterator.nextMo();
                if (!hashSet.contains(string)) {
                    this.debugTrace("checkPiuTypeCompliance()", "LDN: " + string.getLocalDistinguishedName() + ", is not defined in PiuType: " + piuTypeAccess + " MO configuration.");
                    throw new MoNotInPiuTypeException("MO_NOT_IN_PIU_TYPE", string.getLocalDistinguishedName());
                }
                this.debugTrace("checkPiuTypeCompliance()", "LDN: " + string.getLocalDistinguishedName() + ".");
                if (!(string instanceof Reservable)) continue;
                try {
                    objectArray = (Object[])string.getAttribute("ReservedBy", coordinator);
                    if (objectArray == null || objectArray.length <= 0) continue;
                    this.debugTrace("checkPiuTypeCompliance()", "LDN: " + string.getLocalDistinguishedName() + " is reserved.");
                    throw new MoNotInPiuTypeException("MO_NOT_IN_PIU_TYPE", string.getLocalDistinguishedName());
                }
                catch (NoSuchAttributeException noSuchAttributeException) {
                    this.debugTrace("checkPiuTypeCompliance()", "LDN: " + string.getLocalDistinguishedName() + " is reservable, but has no reservedBy attribute. Skip and continue with next element.");
                }
            }
        }
    }

    private void checkSignal(Signal signal) throws EquipException {
        if (signal == null) {
            throw new EquipException("Resource fRo is not accessible.");
        }
    }

    private void debugTrace(String string, String string2) {
        this.debugTrace(string, string2, 72);
    }

    private void debugTrace(String string, String string2, int n) {
        UpgradeTrace.debug(this.getClass(), (int)n, (String)("method: " + string + "\n\tslogan: " + string2));
    }
}

