/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.common;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import se.ericsson.cello.emas.fm.common.BevelArrowIcon;

class SortButtonRenderer
extends JButton
implements TableCellRenderer {
    public static final int NONE = 0;
    public static final int DOWN = 1;
    public static final int UP = 2;
    int pushedColumn = -1;
    Hashtable state = new Hashtable();
    JButton downButton;
    JButton upButton;
    private int lastRenderedColumn = 0;
    private String[] toolTips = null;

    public SortButtonRenderer() {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setHorizontalTextPosition(2);
        this.downButton = new JButton();
        this.downButton.setMargin(new Insets(0, 0, 0, 0));
        this.downButton.setHorizontalTextPosition(2);
        this.downButton.setIcon(new BevelArrowIcon(1, false, true));
        this.downButton.setPressedIcon(new BevelArrowIcon(1, false, true));
        this.upButton = new JButton();
        this.upButton.setMargin(new Insets(0, 0, 0, 0));
        this.upButton.setHorizontalTextPosition(2);
        this.upButton.setIcon(new BevelArrowIcon(0, false, true));
        this.upButton.setPressedIcon(new BevelArrowIcon(0, false, true));
    }

    public void setColumnToolTips(String[] toolTips) {
        this.toolTips = toolTips;
    }

    public String getToolTipText(MouseEvent event) {
        if (this.toolTips != null && this.lastRenderedColumn < this.toolTips.length) {
            return this.toolTips[this.lastRenderedColumn];
        }
        return super.getToolTipText(event);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JButton button = this;
        this.lastRenderedColumn = column;
        Object obj = this.state.get(new Integer(column));
        if (obj != null) {
            button = (Integer)obj == 1 ? this.downButton : this.upButton;
        }
        button.setText(value == null ? "" : value.toString());
        boolean isPressed = column == this.pushedColumn;
        button.getModel().setPressed(isPressed);
        button.getModel().setArmed(isPressed);
        return button;
    }

    public void setPressedColumn(int col) {
        this.pushedColumn = col;
    }

    public boolean isSelectedColumn(int col) {
        if (col < 0) {
            return false;
        }
        return this.state.get(new Integer(col)) != null;
    }

    public void setSelectedColumn(int col) {
        if (col < 0) {
            return;
        }
        Integer value = null;
        Object obj = this.state.get(new Integer(col));
        value = obj == null ? new Integer(2) : ((Integer)obj == 1 ? new Integer(2) : new Integer(1));
        this.state.clear();
        this.state.put(new Integer(col), value);
    }

    public void pressedColumnMoved(int col) {
        int oldState = this.getState(this.pushedColumn);
        this.state.clear();
        this.state.put(new Integer(col), new Integer(oldState));
        this.setPressedColumn(col);
    }

    public int getState(int col) {
        Object obj = this.state.get(new Integer(col));
        int retValue = obj == null ? 0 : ((Integer)obj == 1 ? 1 : 2);
        return retValue;
    }
}

