/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.elv;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import se.ericsson.cello.emas.fm.common.AlarmSortedTable;
import se.ericsson.cello.emas.fm.common.AlarmSortedTableModel;
import se.ericsson.cello.emas.fm.common.DetailsController;
import se.ericsson.cello.emas.fm.common.DetailsView;
import se.ericsson.cello.emas.fm.common.ParseXML;
import se.ericsson.cello.emas.fm.common.RowDataInterface;
import se.ericsson.cello.emas.fm.common.SelectedObjectInterface;
import se.ericsson.cello.emas.fm.common.TimeFormatRenderer;
import se.ericsson.cello.emas.fm.common.TimeFormatter;
import se.ericsson.cello.emas.fm.elv.EventLogApplicationView;
import se.ericsson.cello.emas.fm.elv.EventLogRecord;
import se.ericsson.cello.support.gui.EmasFramework;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogController;
import se.ericsson.cello.support.gui.guilib.infra.Application;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.gui.guilib.infra.Printout;
import se.ericsson.cello.support.mgr.TimeConverter;

public class EventLogApplicationController
extends AbstractApplicationController
implements SelectedObjectInterface {
    private EventLogApplicationView alarmview;
    private EventLogApplicationController ac;
    DetailsController openedEventDetails = null;
    private int totalEvents = 0;
    private AlarmSortedTableModel myModelA;
    private PrintAction printAction = new PrintAction();
    private PrintPreviewAction printPreviewAction = new PrintPreviewAction();
    private PageLayoutAction pageLayoutAction = new PageLayoutAction();
    private Printout printout = null;
    private ExportAction exportAction = new ExportAction();
    Vector columnNamesA = new Vector();
    Menu1Listener menu1listener;
    Table1MouseLis mytable1MouseLis;
    EventDetails myaddinfo;
    Refresh myrefresh;
    private Vector lines = new Vector();
    private boolean runningRefresh = false;
    private boolean faultInRecord = false;

    protected void init() {
        this.ac = this;
        this.alarmview = (EventLogApplicationView)this.getView();
        String userid = this.getApplication().getUserId();
        this.alarmview.idValueLabel.setText(userid);
        this.getApplication().setTitle("ELV_APPLICATION_TITLE", null);
        this.alarmview.printMenuItem.addActionListener(this.printAction);
        this.alarmview.printPreviewMenuItem.addActionListener(this.printPreviewAction);
        this.alarmview.pageLayoutMenuItem.addActionListener(this.pageLayoutAction);
        this.alarmview.exportMenuItem.addActionListener(this.exportAction);
        this.columnNamesA.addElement("EVENT_TIME");
        this.columnNamesA.addElement("EVENT_EVENT_TYPE");
        this.columnNamesA.addElement("SPECIFIC_EVENT");
        this.myModelA = new AlarmSortedTableModel();
        this.myModelA.setColumnIdentifiers(this.columnNamesA);
        this.alarmview.jTable1.setModel(this.myModelA);
        this.menu1listener = new Menu1Listener();
        this.mytable1MouseLis = new Table1MouseLis();
        this.alarmview.jMenuEvent.addMenuListener(this.menu1listener);
        this.alarmview.jTable1.addMouseListener(this.mytable1MouseLis);
        try {
            TableColumn x = this.alarmview.jTable1.getColumn("EVENT_TIME");
            x.setCellRenderer(new TimeFormatRenderer());
        }
        catch (Exception exep) {
            Log.logError((String)"Error occured while setting cell renderer");
        }
        this.myaddinfo = new EventDetails();
        this.myrefresh = new Refresh();
        this.alarmview.jMenuItemDetails.addActionListener(this.myaddinfo);
        this.alarmview.jMenuItemRefresh.addActionListener(this.myrefresh);
        this.alarmview.popupmenuitemDetails.addActionListener(this.myaddinfo);
        this.processEventList();
        if (!this.runningRefresh && this.faultInRecord) {
            this.showMessageDialogForEventLogRecordFault();
        }
    }

    protected void beforeVisible() {
        this.alarmview.setHelpOnWindowKey();
    }

    protected void afterVisible() {
    }

    void processEventList() {
        this.setTheTime();
        this.parseFile("input");
        this.alarmview.TopLabel2.setText("[" + this.totalEvents + "]");
    }

    private void parseFile(String io) {
        URL xmlURL = null;
        try {
            String name = EmasSystemProperties.getProperty((String)"eventlogFile", (String)"/logfiles/event_log.xml");
            String debuggingOn = EmasSystemProperties.getProperty((String)"debugging", (String)"false");
            if (debuggingOn.equals("false")) {
                URL emasURL = EmasFramework.getEmasBaseUrl();
                xmlURL = new URL(emasURL.getProtocol(), emasURL.getHost(), emasURL.getPort(), name);
            } else {
                URL hostnameURL = new URL(EmasSystemProperties.getProperty((String)"hostAddress"));
                xmlURL = new URL(hostnameURL.getProtocol(), hostnameURL.getHost(), hostnameURL.getPort(), name);
            }
            Log.trace((String)("Get alarm log file from " + xmlURL));
            ParseXML parser = new ParseXML();
            Iterator iterator = parser.parse(new InputSource(xmlURL.openStream()), "RecordContent");
            while (iterator.hasNext()) {
                ++this.totalEvents;
                String content = (String)iterator.next();
                if (io.equals("input")) {
                    this.parseLineForReading(content);
                    continue;
                }
                if (io.equals("output")) {
                    this.parseLineForWriting(content);
                    continue;
                }
                Log.logError((String)"This shouldn't happen; error in parsing");
            }
        }
        catch (MalformedURLException me) {
            this.reportException(me, "ERROR_XML", null);
        }
        catch (FileNotFoundException fnfe) {
            this.reportException(fnfe, "ERROR_FNF", null);
        }
        catch (IOException ioe) {
            this.reportException(ioe, "ERROR_PARSE", null);
        }
        catch (ParserConfigurationException e) {
            this.reportException(e, "ERROR_PARSE", null);
        }
        catch (SAXException e) {
            this.reportException(e, "ERROR_PARSE", null);
        }
    }

    private void parseLineForReading(String in) {
        EventLogRecord lr = new EventLogRecord(in);
        if (lr.getErrorInRecord()) {
            this.addAlarmToTableA(lr);
        } else {
            this.faultInRecord = true;
        }
    }

    private void parseLineForWriting(String in) {
        EventLogRecord lr = new EventLogRecord(in);
        String line = lr.getLineForWriting();
        this.lines.addElement(line);
    }

    private void showMessageDialogForEventLogRecordFault() {
        this.showMessageDialog("ERROR_XML", null, "ERROR_TITLE", null, 0, null);
    }

    private void addAlarmToTableA(EventLogRecord logRecord) {
        this.myModelA.addRowNoUpdate(logRecord);
    }

    public void setUserID() {
        boolean correctUserID = false;
        do {
            Object userID;
            if ((userID = this.showInputDialog("USERIDDIALOG", null, "USERIDDIALOG_TITLE", null, -1, null, null, null)) != null) {
                String useridTemp = userID.toString();
                if (useridTemp.length() > 4 && useridTemp.length() <= 30) {
                    char[] useridArray = useridTemp.toCharArray();
                    for (int i = 0; i < useridTemp.length(); ++i) {
                        if (!(useridArray[i] >= 'a' && useridArray[i] <= 'z' || useridArray[i] >= 'A' && useridArray[i] <= 'Z' || useridArray[i] >= '0' && useridArray[i] <= '9')) {
                            correctUserID = false;
                            this.getApplication().setStatus("CORRECT_USERID_MSG", null);
                            break;
                        }
                        correctUserID = true;
                    }
                    if (!correctUserID) continue;
                    this.alarmview.idValueLabel.setText(useridTemp);
                    continue;
                }
                this.getApplication().setStatus("CORRECT_USERID_MSG", null);
                continue;
            }
            correctUserID = true;
        } while (!correctUserID);
        this.getApplication().setStatus("", null);
    }

    private void disableAlarmMenuItems() {
        this.alarmview.jMenuItemDetails.setEnabled(false);
    }

    public boolean canStop() {
        try {
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    public void setTheTime() {
        String timeString = new TimeConverter().getCurrentTime();
        this.alarmview.TopLabel4.setText(timeString);
    }

    public RowDataInterface getSelectedObject() {
        EventLogRecord tmpRecord = null;
        int selectedIndex = this.alarmview.jTable1.getOriginalRow(this.alarmview.jTable1.getSelectedRow());
        tmpRecord = (EventLogRecord)this.myModelA.getRow(selectedIndex);
        return tmpRecord;
    }

    public void disposeDetailWindow() {
        this.openedEventDetails = null;
    }

    public AbstractDialogController startDialog(boolean modal, String titleKey, Object[] titleArgs, Class dialogViewClass, Class dialogControllerClass) {
        this.getApplication().setCursor(Application.DEFAULT_CURSOR);
        return super.startDialog(modal, titleKey, titleArgs, dialogViewClass, dialogControllerClass, (Object[][])null);
    }

    public void stopApp() {
        this.viewClosing();
    }

    protected void viewClosing() {
        this.getApplicationManager().exitApplicationEMTApp();
    }

    private class Menu1Listener
    implements MenuListener {
        private Menu1Listener() {
        }

        public void menuSelected(MenuEvent e) {
            int[] numSelectedRowsTable = ((EventLogApplicationController)EventLogApplicationController.this).alarmview.jTable1.getSelectedRows();
            if (numSelectedRowsTable.length == 0) {
                EventLogApplicationController.this.disableAlarmMenuItems();
            } else if (((EventLogApplicationController)EventLogApplicationController.this).alarmview.jTable1.getSelectedRow() != -1) {
                if (numSelectedRowsTable.length == 1) {
                    ((EventLogApplicationController)EventLogApplicationController.this).alarmview.jMenuItemDetails.setEnabled(true);
                } else if (numSelectedRowsTable.length > 1) {
                    ((EventLogApplicationController)EventLogApplicationController.this).alarmview.jMenuItemDetails.setEnabled(false);
                }
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }

    private class Refresh
    implements ActionListener {
        private Refresh() {
        }

        public void actionPerformed(ActionEvent event) {
            EventLogApplicationController.this.runningRefresh = true;
            EventLogApplicationController.this.faultInRecord = false;
            EventLogApplicationController.this.getApplication().setStatus("STATUS_EVENTLOG_REBUILD", null);
            if (((EventLogApplicationController)EventLogApplicationController.this).alarmview.jTable1.getModel().getRowCount() != 0) {
                EventLogApplicationController.this.myModelA.removeAllRows();
            }
            EventLogApplicationController.this.totalEvents = 0;
            EventLogApplicationController.this.processEventList();
            EventLogApplicationController.this.getApplication().setStatus("", null);
            if (EventLogApplicationController.this.faultInRecord) {
                EventLogApplicationController.this.showMessageDialogForEventLogRecordFault();
            }
            EventLogApplicationController.this.alarmview.reSortTable();
        }
    }

    private class EventDetails
    implements ActionListener {
        private EventDetails() {
        }

        public void actionPerformed(ActionEvent event) {
            EventLogApplicationController.this.getApplication().setStatus("", null);
            if (EventLogApplicationController.this.openedEventDetails != null) {
                EventLogApplicationController.this.openedEventDetails.stopDialog();
            }
            EventLogApplicationController.this.openedEventDetails = (DetailsController)EventLogApplicationController.this.startDialog(false, "EVENT_DETAILS_TITLE", null, DetailsView.class, DetailsController.class);
        }
    }

    private class Table1MouseLis
    extends MouseAdapter {
        private Table1MouseLis() {
        }

        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 4) == 4) {
                Point p = e.getPoint();
                int row = ((EventLogApplicationController)EventLogApplicationController.this).alarmview.jTable1.rowAtPoint(p);
                int col = ((EventLogApplicationController)EventLogApplicationController.this).alarmview.jTable1.columnAtPoint(p);
                ((EventLogApplicationController)EventLogApplicationController.this).alarmview.jTable1.changeSelection(row, col, false, false);
                ((EventLogApplicationController)EventLogApplicationController.this).alarmview.popupmenuitemDetails.setEnabled(true);
                EventLogApplicationController.this.showPopupMenu(((EventLogApplicationController)EventLogApplicationController.this).alarmview.mypopupmenu, (Component)((Object)((EventLogApplicationController)EventLogApplicationController.this).alarmview.jTable1), (int)e.getPoint().getX(), (int)e.getPoint().getY());
            }
        }
    }

    private class ExportAction
    implements ActionListener {
        private ExportAction() {
        }

        public void actionPerformed(ActionEvent event) {
            JFileChooser fileChooser;
            int status;
            String defaultPath = System.getProperty("user.home");
            if (defaultPath == null) {
                Log.logError((String)"Error retrieving user home directory");
                defaultPath = "";
            }
            if ((status = (fileChooser = new JFileChooser(defaultPath)).showSaveDialog((Component)((Object)EventLogApplicationController.this.alarmview))) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    EventLogApplicationController.this.parseFile("output");
                    FileWriter filewriter = new FileWriter(file);
                    for (int i = 0; i < EventLogApplicationController.this.lines.size(); ++i) {
                        String writeLine = (String)EventLogApplicationController.this.lines.elementAt(i);
                        filewriter.write(writeLine, 0, writeLine.length());
                    }
                    filewriter.close();
                    EventLogApplicationController.this.lines = new Vector();
                    EventLogApplicationController.this.showMessageDialog("FILE_SAVED", null, "SAVED_TITLE", null, 1, null);
                }
                catch (IOException ioe) {
                    Log.logError((String)"Input/output exception while saving file");
                }
            }
        }
    }

    private class PrintPreviewAction
    implements ActionListener {
        private PrintPreviewAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Printout printout = new Printout((Component)((Object)new PrintableAlarmSortedTable(((EventLogApplicationController)EventLogApplicationController.this).alarmview.jTable1)), EventLogApplicationController.this.getApplication().getLanguageBundle().getString("EVENT_LOG"));
            printout.preview((AbstractController)EventLogApplicationController.this.ac, "PRINT_EVENT_LOG", 0);
        }
    }

    private class PageLayoutAction
    implements ActionListener {
        private PageLayoutAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EventLogApplicationController.this.printout == null) {
                EventLogApplicationController.this.printout = new Printout((Component)((Object)new PrintableAlarmSortedTable(((EventLogApplicationController)EventLogApplicationController.this).alarmview.jTable1)), EventLogApplicationController.this.getApplication().getLanguageBundle().getString("EVENT_LOG"));
            }
            EventLogApplicationController.this.printout.pageLayout();
            EventLogApplicationController.this.getApplication().bringToFront();
        }
    }

    private class PrintableAlarmSortedTable
    extends AlarmSortedTable {
        private static final long serialVersionUID = -2079301921655065813L;
        private AlarmSortedTable decoratedTable = null;

        public PrintableAlarmSortedTable(AlarmSortedTable table) {
            this.decoratedTable = table;
        }

        public TableColumnModel getColumnModel() {
            if (this.decoratedTable == null) {
                return super.getColumnModel();
            }
            return this.decoratedTable.getColumnModel();
        }

        public int getRowCount() {
            if (this.decoratedTable == null) {
                return super.getRowCount();
            }
            return this.decoratedTable.getRowCount();
        }

        public Object getValueAt(int row, int column) {
            if (this.decoratedTable == null) {
                return super.getValueAt(row, column);
            }
            Object obj = this.decoratedTable.getValueAt(row, column);
            if (obj == null) {
                return "";
            }
            if (this.decoratedTable.getColumnName(column).equals("EVENT_TIME")) {
                obj = TimeFormatter.setTimeFormat(obj);
            }
            return obj;
        }
    }

    private class PrintAction
    implements ActionListener {
        private PrintAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EventLogApplicationController.this.printout == null) {
                EventLogApplicationController.this.printout = new Printout((Component)((Object)new PrintableAlarmSortedTable(((EventLogApplicationController)EventLogApplicationController.this).alarmview.jTable1)), EventLogApplicationController.this.getApplication().getLanguageBundle().getString("EVENT_LOG"));
            }
            EventLogApplicationController.this.printout.print();
            EventLogApplicationController.this.getApplication().bringToFront();
        }
    }
}

