/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.wcdma.rbs.boam.mao.common.SystemConstant;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SystemConstantsMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public abstract class AbstractInitializeSystemConstantsAue
extends BoamSubAueBase {
    public AbstractInitializeSystemConstantsAue(Class subClass) {
        super(subClass);
    }

    protected void triggerFinish(List commands) throws Exception {
        this.traceEnter("triggerFinish(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        MoIterator moIter = FindMo.findMOs("SystemConstants");
        if (moIter == null || moIter.size() != 1) {
            this.traceError("Unable to find SystemConstantsMo");
            throw new Exception("Unable to find SystemConstantsMo");
        }
        SystemConstantsMo mo = (SystemConstantsMo)moIter.nextMo();
        SystemConstant[] systemConstantsToInitiate = this.getSystemConstants();
        SystemConstant[] systemConstants = mo.getSystemConstants(tw.getCoordinator());
        for (int i = 0; i < systemConstantsToInitiate.length; ++i) {
            if (!this.isSysConstExisting(systemConstantsToInitiate[i].getName(), systemConstants)) {
                mo.actionWriteConst(systemConstantsToInitiate[i].getName(), systemConstantsToInitiate[i].getValue(), tw.getCoordinator());
                this.trace("Successfully initiated SystemConstant " + systemConstantsToInitiate[i].getName() + " to value " + systemConstantsToInitiate[i].getValue());
                continue;
            }
            this.trace("SystemConstant " + systemConstantsToInitiate[i].getName() + " already defined, no need to initialize");
        }
        return true;
    }

    private boolean isSysConstExisting(String name, SystemConstant[] systemConstants) {
        for (int i = 0; i < systemConstants.length; ++i) {
            if (!systemConstants[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public abstract SystemConstant[] getSystemConstants();
}

