/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.lang.reflect.Method;
import java.util.List;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceGroupProxy;
import se.ericsson.wcdma.rbs.boam.main.BoamMain;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class CabinetParametersProfileWRNae53454Aue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "12/109 26-CRH 109 042/1-5";
    public static final String CABINET_PARAMETERS_PROFILE_STANDARD = "cabinetParametersProfileStandard";
    public static final String CABINET_PARAMETERS_PROFILE_EXTENDED = "cabinetParametersProfileExtended";
    private static final int LOW_VERSION = 7000000;
    private static final int HIGH_VERSION = 8013599;
    public static final int[] NEW_STANDARD_INDEXES = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37};
    public static final int[] NEW_STANDARD_VALUES = new int[]{115, 100, 45, 10, 5, 50, 30, 27, 2, 2, 1, 8, 9, 6, 7, 26, 45, 25, 53, 22, 50, 50};
    public static final int[] NEW_EXTENDED_INDEXES = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37};
    public static final int[] NEW_EXTENDED_VALUES = new int[]{100, 100, 35, 10, 5, 45, 30, 27, 8, 9, 6, 7, 26, 45, 25, 53, 22, 50, 50};
    private static final CabinetParametersProfileWRNae53454Aue INSTANCE = new CabinetParametersProfileWRNae53454Aue();

    private CabinetParametersProfileWRNae53454Aue() {
        super(CabinetParametersProfileWRNae53454Aue.class);
    }

    public static CabinetParametersProfileWRNae53454Aue instance() {
        return INSTANCE;
    }

    public int getLowVersion() {
        return 7000000;
    }

    public int getHighVersion() {
        return 8013599;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerRbsInitiate(List commands) throws Exception {
        this.traceEnter("triggerRbsInitiate(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        try {
            this.doExecute(tw.getCoordinator());
            return true;
        }
        catch (Exception e) {
            this.traceError("Exception caught, upgrade is not terminated immediately", e);
            return false;
        }
    }

    private void doExecute(Coordinator context) throws Exception {
        this.traceEnter("doExecute()");
        String MANAGED_ELEMENT = "ManagedElement";
        String PRODUCT_NAME = "productName";
        String RBS_6102 = "RBS6102";
        String CABINET = "Cabinet";
        int fromRevision = BoamMain.getBoamDataRev();
        if (fromRevision >= 7100000 && fromRevision < 8000000) {
            this.trace("From-revision is: " + fromRevision + ", no need to perform parameter update, nothing to do");
            return;
        }
        ManagedObject rootMo = MibMgr.instance().getMib().getRootMo();
        String productName = (String)rootMo.getAttribute("productName", context);
        if (!"RBS6102".equals(productName)) {
            this.trace("ManagedElement.productName is not RBS6102, nothing to do");
            return;
        }
        MoIterator cabIterator = FindMo.findMOs("Cabinet");
        if (cabIterator.size() == 0) {
            this.trace("no Cabinet instance, nothing to do");
            return;
        }
        ManagedObject cabinet = cabIterator.nextMo();
        this.fixEC(cabinet, context);
        this.fixBOAM(cabinet, context);
    }

    private void fixEC(ManagedObject cabinet, Coordinator context) throws Exception {
        int[] newValues;
        int[] indexes;
        this.traceEnter("fixEC()");
        String CLIMATE_SYSTEM = "climateSystem";
        String CABINET_PARAMETERS = "cabinetParameters";
        boolean CLIMATE_SYSTEM_EXTENDED = true;
        boolean CLIENT_ID = false;
        int climateSystem = (Integer)cabinet.getAttribute("climateSystem", context);
        int[] cabinetParameters = (int[])cabinet.getAttribute("cabinetParameters", context);
        int cabinetParametersLength = cabinetParameters.length;
        if (climateSystem == 1) {
            indexes = NEW_EXTENDED_INDEXES;
            newValues = NEW_EXTENDED_VALUES;
        } else {
            indexes = NEW_STANDARD_INDEXES;
            newValues = NEW_STANDARD_VALUES;
        }
        if (this.updateNeeded(cabinetParameters, indexes, newValues)) {
            int[] newParameters = new int[cabinetParametersLength];
            for (int i = 0; i < cabinetParametersLength; ++i) {
                newParameters[i] = cabinetParameters[i];
            }
            for (int j = 0; j < indexes.length; ++j) {
                if (indexes[j] >= cabinetParameters.length) {
                    this.traceError("Index of new parameter value too large: " + indexes[j]);
                    break;
                }
                newParameters[indexes[j]] = newValues[j];
            }
            EqcDeviceGroupProxy eqcDeviceGroupProxy = EqcDeviceGroupProxy.instance();
            try {
                Class[] argTypes = new Class[]{Integer.TYPE, new int[0].getClass(), Integer.TYPE};
                Method setMethod = EqcDeviceGroupProxy.class.getDeclaredMethod("setCabinetParameters", argTypes);
                Integer transId = new Integer(context.getTransactionID());
                Object[] args = new Object[]{new Integer(0), newParameters, transId};
                setMethod.invoke((Object)eqcDeviceGroupProxy, args);
            }
            catch (NoSuchMethodException e) {
                Class[] argTypes = new Class[]{Integer.TYPE, new int[0].getClass(), Coordinator.class};
                Method setMethod = EqcDeviceGroupProxy.class.getDeclaredMethod("setCabinetParameters", argTypes);
                Object[] args = new Object[]{new Integer(0), newParameters, context};
                setMethod.invoke((Object)eqcDeviceGroupProxy, args);
            }
        }
    }

    private void fixBOAM(ManagedObject cabinet, Coordinator context) throws MoDataConversionException, TransactionRequiredException, NoPermissionException {
        this.traceEnter("fixBOAM()");
        MoData cabinetMoData = ((BoamManagedObject)cabinet).getMyMoData();
        this.changeCabinetModata(cabinetMoData, CABINET_PARAMETERS_PROFILE_STANDARD, NEW_STANDARD_INDEXES, NEW_STANDARD_VALUES, context);
        this.changeCabinetModata(cabinetMoData, CABINET_PARAMETERS_PROFILE_EXTENDED, NEW_EXTENDED_INDEXES, NEW_EXTENDED_VALUES, context);
    }

    private boolean updateNeeded(int[] cabinetParameters, int[] indexes, int[] newValues) {
        this.traceEnter("updateNeeded()");
        for (int j = 0; j < indexes.length; ++j) {
            if (indexes[j] >= cabinetParameters.length) {
                this.traceError("Index of new parameter value too large: " + indexes[j]);
                return false;
            }
            if (newValues[j] == cabinetParameters[indexes[j]]) continue;
            return true;
        }
        return false;
    }

    private void changeCabinetModata(MoData moData, String attrName, int[] newIndexes, int[] newValues, Coordinator context) throws MoDataConversionException {
        this.traceEnter("changeCabinetMoData()");
        Attribute attr = moData.getAttribute(attrName);
        if (attr == null) {
            this.trace("Cabinet has no attribute named " + attrName);
        } else {
            if (!(attr instanceof SequenceAttribute)) {
                throw new MoDataConversionException("Cabinet." + attrName + " is not SequenceAttribute");
            }
            Attribute[] attrs = ((SequenceAttribute)attr).getValue(context);
            Attribute[] newAttrs = this.shallowCopy(attrs);
            for (int i = 0; i < newIndexes.length; ++i) {
                int index = newIndexes[i];
                if (index >= attrs.length) {
                    throw new MoDataConversionException("attempting to update array element " + index);
                }
                if (!(attrs[index] instanceof IntegerAttribute)) {
                    throw new MoDataConversionException("array element is not IntegerAttribute, index:" + index);
                }
                IntegerAttribute intAttr = (IntegerAttribute)attrs[index];
                newAttrs[index] = new IntegerAttribute(intAttr.getName(), intAttr.isAVCNotifier(), newValues[i]);
            }
            ((SequenceAttribute)attr).setValue(newAttrs);
        }
    }

    public Attribute[] shallowCopy(Attribute[] a) {
        this.traceEnter("shallowCopy()");
        return (Attribute[])a.clone();
    }
}

