/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueGetDeviceInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AlmDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AlmDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public class FixAlmDeviceAue
extends BoamSubAueBase
implements Command {
    private static final Class SELF = FixAlmDeviceAue.class;
    private static final int INVALID_FRO_ID = 0;
    private static final String AUX_DEVICE_FRO_ID = "auxDeviceFroId";
    private static final int MAX_NUM_DEVICES = 2;
    private static final int USED = 1;
    private static final int AVAILABLE = 0;
    private static final String DCI_REF = "12/10926-CRH109042/1-7";
    public static final int LOW_VERSION = 7000000;
    private static final int HIGH_VERSION = 11030099;
    private static final FixAlmDeviceAue instance = new FixAlmDeviceAue();

    private FixAlmDeviceAue() {
        super(FixAlmDeviceAue.class);
    }

    public static FixAlmDeviceAue instance() {
        return instance;
    }

    public String getDciReference() {
        return DCI_REF;
    }

    public int getLowVersion() {
        return 7000000;
    }

    public int getHighVersion() {
        return 11030099;
    }

    protected void triggerConvert(List commands) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)("triggerConvert() in " + SELF.getName()));
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        Coordinator context = tw.getCoordinator();
        ArrayList<Integer> almDeviceSetsToUpdate = new ArrayList<Integer>();
        MoIterator iter = FindMo.findMOs("AlmDeviceSet");
        block0: while (iter.hasMoreElements()) {
            ManagedObject almDeviceSet = iter.nextMo();
            MoIterator iterator = almDeviceSet.getChildren();
            while (iterator.hasMoreElements()) {
                ManagedObject almDevice = iterator.nextMo();
                if (((MaoHasFro)almDevice).getFroId(context) != 0) continue;
                almDeviceSetsToUpdate.add(new Integer(((MaoHasFro)almDeviceSet).getFroId(context)));
                continue block0;
            }
        }
        if (almDeviceSetsToUpdate.size() > 0) {
            MpswTaAueGetDeviceInfoT[] almDeviceInfo = AueProxy.instance().getDeviceFroIds(this.toIntArray(almDeviceSetsToUpdate));
            HashMap convertedAlmDevInfo = this.convertSignalInfo(almDeviceInfo);
            if (convertedAlmDevInfo.keySet().size() != almDeviceSetsToUpdate.size()) {
                throw new Exception("Inconsistent number of AlmDeviceSets between request and response");
            }
            this.updateAlmDevices(convertedAlmDevInfo, context);
        }
        return true;
    }

    private void updateAlmDevices(HashMap almDeviceInfo, Coordinator context) throws Exception {
        this.traceEnter("updateAlmDevices()");
        if (almDeviceInfo == null) {
            throw new Exception("Not possible to read almDeviceInfo from signal (null)");
        }
        Iterator iter = almDeviceInfo.keySet().iterator();
        while (iter.hasNext()) {
            Integer setFroId = (Integer)iter.next();
            AlmDeviceSetMo almDeviceSet = this.getAlmDeviceSet(setFroId, context);
            if (almDeviceSet != null) {
                int childNo = 0;
                int[] availablePositions = this.getAvailablePositions(almDeviceSet.getChildren().size());
                MoIterator iter2 = almDeviceSet.getChildren();
                while (iter2.hasMoreElements()) {
                    AlmDeviceMo almDevice = (AlmDeviceMo)iter2.nextMo();
                    int index = this.getIndexBasedOnRDN(almDevice);
                    if (index < 0 || index >= 2) {
                        index = childNo;
                        this.trace("Invalid RDN: " + almDevice.getNamingAttributeValue() + " ");
                    }
                    if (availablePositions[index] == 1) {
                        throw new Exception("AlmDevice MO at index " + index + " already updated");
                    }
                    this.updateFroId(almDevice, (Integer)((List)almDeviceInfo.get(setFroId)).get(index), context);
                    ++childNo;
                    availablePositions[index] = 1;
                }
                continue;
            }
            throw new Exception("Not possible to find AlmDeviceSet with froId = " + setFroId);
        }
    }

    private int[] getAvailablePositions(int devices) {
        int[] result = new int[devices];
        for (int i = 0; i < result.length; ++i) {
            result[i] = 0;
        }
        return result;
    }

    private void updateFroId(AlmDeviceMo almDevice, Integer froId, Coordinator context) throws Exception {
        this.traceEnter("updateFroId()");
        if (froId == 0) {
            throw new Exception("FroId = " + froId + " is not valid for MO " + almDevice.getFullDistinguishedName());
        }
        MoData moData = ((BoamManagedObject)almDevice).getMyMoData();
        if (moData == null) {
            throw new Exception("MoData for " + almDevice.getNamingAttributeValue() + " not found");
        }
        moData.handleTransaction(context, MoData.WRITE_ACCESS);
        IntegerAttribute attribute = (IntegerAttribute)moData.getAttribute(AUX_DEVICE_FRO_ID);
        if (attribute == null) {
            throw new NoSuchAttributeException(AUX_DEVICE_FRO_ID, "AlmDevice");
        }
        attribute.setValue(froId.intValue());
        this.trace("Updated froId for MO: " + almDevice.getFullDistinguishedName() + " to " + froId);
    }

    private int[] toIntArray(List items) {
        int[] array = new int[items.size()];
        int index = 0;
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            Integer element = (Integer)iter.next();
            array[index] = element;
            ++index;
        }
        return array;
    }

    private AlmDeviceSetMo getAlmDeviceSet(int setFroId, Coordinator context) throws Exception {
        MoIterator moIter = FindMo.findMOs("AlmDeviceSet");
        while (moIter.hasMoreElements()) {
            MaoHasFro almDeviceSet = (MaoHasFro)moIter.nextMo();
            if (almDeviceSet == null || almDeviceSet.getFroId(context) != setFroId) continue;
            return (AlmDeviceSetMo)almDeviceSet;
        }
        return null;
    }

    private int getIndexBasedOnRDN(AlmDeviceMo almDevice) {
        int result = 0;
        try {
            Integer index = new Integer(almDevice.getNamingAttributeValue());
            result = index - 1;
        }
        catch (NumberFormatException e) {
            this.trace("Not possible to convert RDN to int: " + almDevice.getNamingAttributeValue());
            result = -1;
        }
        return result;
    }

    private HashMap convertSignalInfo(MpswTaAueGetDeviceInfoT[] almDeviceInfo) {
        HashMap result = new HashMap();
        for (int i = 0; i < almDeviceInfo.length; ++i) {
            List<Integer> devFroIdList;
            Integer setFroId = new Integer(almDeviceInfo[i].setFroId);
            if (result.containsKey(setFroId)) {
                devFroIdList = (List)result.get(setFroId);
                devFroIdList.add(new Integer(almDeviceInfo[i].deviceFroId));
                continue;
            }
            devFroIdList = new ArrayList();
            devFroIdList.add(new Integer(almDeviceInfo[i].deviceFroId));
            result.put(setFroId, devFroIdList);
        }
        return result;
    }
}

