/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ObifDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public class FixConfGroupAue
extends BoamSubAueBase {
    private static final Class SELF = FixConfGroupAue.class;
    private static final FixConfGroupAue instance = new FixConfGroupAue();
    private static final String DCI_REF = "14/10926-CRH109042/1-1";
    public static final int LOW_VERSION = 7000000;
    private static final int HIGH_VERSION = 8051799;

    private FixConfGroupAue() {
        super(FixConfGroupAue.class);
    }

    protected void triggerConvert(List commands) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)("triggerConvert() in " + SELF.getName()));
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    public static FixConfGroupAue instance() {
        return instance;
    }

    public int getHighVersion() {
        return 8051799;
    }

    public int getLowVersion() {
        return 7000000;
    }

    public boolean execute(TransactionWrapper tw) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"execute()");
        Coordinator context = tw.getCoordinator();
        MoIterator rruMolist = FindMo.findMOs("RruDeviceGroup");
        if (!rruMolist.hasMoreElements()) {
            MessageLog.trace((int)9, (Class)SELF, (String)"Couldn't find any RRU!! Can't check if mapping is need for confiurationGroup!!");
            return true;
        }
        MoIterator obifMoList = FindMo.findMOs("ObifDeviceGroup");
        if (!obifMoList.hasMoreElements()) {
            MessageLog.trace((int)9, (Class)SELF, (String)"Couldn't find any ObifDeviceGroupMo!! Can't set confiurationGroup!!");
            return true;
        }
        if (this.isAuxPiuRRU11(context)) {
            return true;
        }
        int numberOfElements = obifMoList.size();
        int[] obifFroIds = new int[numberOfElements];
        for (int i = 0; i < numberOfElements; ++i) {
            ObifDeviceGroupMo obifDevGrp = (ObifDeviceGroupMo)obifMoList.nextElement();
            if (obifDevGrp == null) {
                throw new Exception("ObifDeviceGroup is null!");
            }
            obifFroIds[i] = ((MaoHasFro)obifDevGrp).getFroId(context);
            MessageLog.trace((int)9, (Class)SELF, (String)("Aue will set configurationGroup to 4 on MO: " + obifDevGrp.getFullDistinguishedName() + ", FroId:" + obifFroIds[i]));
        }
        AueProxy.instance().setObifConfigurationGroup(numberOfElements, obifFroIds);
        MessageLog.trace((int)9, (Class)SELF, (String)"Signal MpswTaAueSetObifConfGroupReqS successfully sent to TA AUE!");
        return true;
    }

    private boolean isAuxPiuRRU11(Coordinator c) throws MoAccessException, Exception {
        MessageLog.traceEnter((Class)SELF, (String)"\nisAuxPiuRRU11() ");
        String PNo1 = "KRC161007/1";
        String PNo2 = "KRC161007/2";
        String PNo3 = "KRC161068/1";
        MoIterator molist = FindMo.findMOs("RruDeviceGroup");
        while (molist.hasMoreElements()) {
            AuxPlugInUnitMo auxpiu = (AuxPlugInUnitMo)((ManagedObject)molist.nextElement()).getParent();
            int operState = auxpiu.getOperationalState(c);
            if (operState == 1) {
                PiuTypeMo piuType = (PiuTypeMo)auxpiu.getPiuType(c);
                if (piuType == null) {
                    throw new ValueOutOfRangeException("PiuType", "The RRU:" + auxpiu.getFullDistinguishedName() + " piuType ref is null!!");
                }
                String pNo = (String)piuType.getProductData(c).getValue("productNumber");
                if (pNo != null && ("KRC161007/1".equalsIgnoreCase(pNo) || "KRC161007/2".equalsIgnoreCase(pNo) || "KRC161068/1".equalsIgnoreCase(pNo))) {
                    MessageLog.info((Class)SELF, (String)("\nFound enabled RRU11 with product number : " + pNo + ", Aue Will terminate with nothing to do."));
                    return true;
                }
                MessageLog.trace((int)9, (Class)SELF, (String)("\nFound RRU product number other than RRU11 : " + pNo));
                continue;
            }
            MessageLog.trace((int)9, (Class)SELF, (String)("\nFound disabled RRU : " + auxpiu.getFullDistinguishedName()));
        }
        return false;
    }

    public String getDciReference() {
        return DCI_REF;
    }
}

