/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxPlugInUnitMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.AuxPlugInUnitUpgradeHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class PiuTypeConvertAue
extends BoamSubAueBase {
    private static final String GENERIC_PIU_TYPE_ID_RRUW = "RRUW-preInstalledSW";
    private static final String GENERIC_PIU_TYPE_ID_RRU = "RRU-preInstalledSW";
    private static final int LOW_VERSION = 13091600;
    private static final int HIGH_VERSION = 16010100;
    private static final PiuTypeConvertAue INSTANCE = new PiuTypeConvertAue();
    private ManagedObject piuType = null;

    private PiuTypeConvertAue() {
        super(PiuTypeConvertAue.class);
    }

    public static PiuTypeConvertAue instance() {
        return INSTANCE;
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        try {
            tw.getCoordinator();
            this.doExecute(tw.getCoordinator());
            return true;
        }
        catch (Exception e) {
            this.traceError("Exception caught, upgrade is not terminated immediately", e);
            return false;
        }
    }

    public String getDciReference() {
        return "14/109 26-CRH 109 0239-1";
    }

    public int getHighVersion() {
        return 16010100;
    }

    public int getLowVersion() {
        return 13091600;
    }

    protected void triggerRbsInitiate(List commands) throws Exception {
        this.traceEnter("triggerRbsInitiate()");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    private void doExecute(Coordinator context) throws Exception {
        this.traceEnter("doExecute()");
        MoIterator piuTypeIterator = FindMo.findMOs("PiuType");
        while (piuTypeIterator.hasMoreElements()) {
            ManagedObject mo = piuTypeIterator.nextMo();
            if (-1 == mo.getRelativeDistinguishedName().indexOf(GENERIC_PIU_TYPE_ID_RRUW)) continue;
            this.piuType = mo;
        }
        MoIterator moIter = BoamHelper.findMOs((String)"AuxPlugInUnit");
        while (moIter.hasMoreElements()) {
            AuxPlugInUnitMo aux = (AuxPlugInUnitMo)moIter.nextMo();
            if (!this.preCondition(aux, context)) continue;
            this.covertPiuType(aux, context);
        }
    }

    private boolean preCondition(AuxPlugInUnitMo aux, Coordinator context) throws MoAccessException {
        this.traceEnter("preCondition()");
        ManagedObject piu = aux.getPiuType(context);
        Struct curPidData = ((PiuTypeMo)piu).getProductData(context);
        String curPiuPNum = (String)curPidData.getValue("productNumber");
        if (AuxPlugInUnitUpgradeHelper.isGenericPiuType((PiuTypeMo)((PiuTypeMo)piu), (Coordinator)context)) {
            String hwProductName = aux.getProductName(context);
            String normalizedHwProductName = hwProductName.trim().toUpperCase(Locale.ENGLISH);
            if (curPiuPNum.equals(GENERIC_PIU_TYPE_ID_RRU) && (normalizedHwProductName.startsWith("RRUW") || normalizedHwProductName.startsWith("RRUS"))) {
                return null != this.piuType;
            }
        }
        return false;
    }

    private void covertPiuType(AuxPlugInUnitMo aux, Coordinator c) throws TransactionRequiredException, NoPermissionException {
        MessageLog.traceEnter(this.getClass(), (String)"covertPiuType() ");
        MoData myData = null;
        Class<?> owner = aux.getClass();
        try {
            Method method = owner.getMethod("getMyMoData", new Class[0]);
            myData = (MoData)method.invoke((Object)aux, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            myData = ((AuxPlugInUnitMoImpl)aux).getMyMoData();
        }
        catch (IllegalArgumentException e) {
            this.traceError("Exception caught in covertPiuType", e);
        }
        catch (IllegalAccessException e) {
            this.traceError("Exception caught in covertPiuType", e);
        }
        catch (InvocationTargetException e) {
            this.traceError("Exception caught in covertPiuType", e);
        }
        myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ReferenceAttribute refAttr = (ReferenceAttribute)myData.getAttribute("piuType");
        refAttr.setValue(this.piuType);
        if (aux instanceof AuxPlugInUnitMoImpl) {
            ((AuxPlugInUnitMoImpl)aux).sendAVC("piuType", (Object)this.piuType, c);
        }
    }
}

