/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.RepertoireMo;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.impl.RepertoireHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.IubMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class ReconfigureCppCbmRepertoiresAue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "9/109 26-CRH 109 0239-2";
    private static final int LOW_VERSION = 8000000;
    private static final int HIGH_VERSION = 13091299;
    private static final ReconfigureCppCbmRepertoiresAue INSTANCE = new ReconfigureCppCbmRepertoiresAue();
    private static final String CPP_BASIC_DU_NOIP_R6K = "CPP_Basic_DU_noIP_R6K";
    private static final String CPP_ATM_TRANSPORT_CBM3_STM1_R6K = "CPP_ATM_Transport_CBM3_STM1_R6K";
    private static final String CPP_ATM_TRANSPORT_STM1_R6K = "CPP_ATM_Transport_STM1_R6K";
    private static final String CPP_ATM_TRANSPORT_CBM3_NOSTM1_R6K = "CPP_ATM_Transport_CBM3_noSTM1_R6K";
    private static final String CPP_IP_TRANSPORT_CBM_R6K = "CPP_IP_Transport_CBM_R6K";
    private static final String CPP_BASIC_DU_NOSTM1_R6K = "CPP_Basic_DU_noSTM1_R6K";
    private static final String CPP_ATM_TRANSPORT_NOSTM1_R6K = "CPP_ATM_Transport_noSTM1_R6K";
    private static final String[] STM_GROUP = new String[]{"CPP_Basic_DU_noIP_R6K", "CPP_ATM_Transport_CBM3_STM1_R6K", "CPP_ATM_Transport_STM1_R6K"};
    private static final String[] NO_STM_GROUP = new String[]{"CPP_ATM_Transport_CBM3_noSTM1_R6K", "CPP_IP_Transport_CBM_R6K", "CPP_Basic_DU_noSTM1_R6K", "CPP_ATM_Transport_noSTM1_R6K"};
    private static final String RBS_DU_MAIN_ROLE = "RBS_DU_Main";
    private static final String RBS_DUW_MAIN_ROLE = "Main_DUW";
    private static final String OS155SPITTP = "Os155SpiTtp";

    private ReconfigureCppCbmRepertoiresAue() {
        super(ReconfigureCppCbmRepertoiresAue.class);
    }

    public int getLowVersion() {
        return 8000000;
    }

    public int getHighVersion() {
        return 13091299;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    public static ReconfigureCppCbmRepertoiresAue instance() {
        return INSTANCE;
    }

    protected void triggerRbsInitiate(List commands) throws Exception {
        this.traceEnter("triggerRbsInitiate(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("doExecute");
        Coordinator context = tw.getCoordinator();
        ManagedObject os155SpiTtpMo = BoamHelper.getFirstMatchingMo((String)OS155SPITTP);
        IubMo iubMo = (IubMo)BoamHelper.getFirstMatchingMo((String)"Iub");
        boolean isStmUsed = false;
        if (os155SpiTtpMo != null && iubMo == null) {
            isStmUsed = true;
        } else if (os155SpiTtpMo != null) {
            Struct ctrlPlaneTransportOption = iubMo.getControlPlaneTransportOption(context);
            if (ctrlPlaneTransportOption == null) {
                this.traceError("Iub.controlPlaneTransportOption is null");
                return false;
            }
            boolean isCtrlPlaneUseAtm = (Boolean)ctrlPlaneTransportOption.getValue("atm");
            boolean isCtrlPlaneUseIpV4 = (Boolean)ctrlPlaneTransportOption.getValue("ipV4");
            Struct userPlaneTransportOption = iubMo.getUserPlaneTransportOption(context);
            if (userPlaneTransportOption == null) {
                this.traceError("Iub.userPlaneTransportOption is null");
                return false;
            }
            boolean isUsrPlaneUseAtm = (Boolean)userPlaneTransportOption.getValue("atm");
            boolean isUsrPlaneUseIpV4 = (Boolean)userPlaneTransportOption.getValue("ipV4");
            if (isCtrlPlaneUseAtm && !isCtrlPlaneUseIpV4 && isUsrPlaneUseAtm && !isUsrPlaneUseIpV4) {
                isStmUsed = true;
            } else if (1 == (Integer)os155SpiTtpMo.getAttribute("administrativeState", context)) {
                this.traceError("Dual stack configuration with ATM over STM-1 is not supported.");
                return false;
            }
        }
        this.handleRepertoire(RBS_DU_MAIN_ROLE, isStmUsed, context);
        this.handleRepertoire(RBS_DUW_MAIN_ROLE, isStmUsed, context);
        return true;
    }

    private void handleRepertoire(String swAllocationRole, boolean useSTM, Coordinator context) throws MoAccessException {
        SwAllocationMo swAlloc = (SwAllocationMo)RepertoireHelper.getSwAllocationMo("SwAllocation", swAllocationRole, context);
        if (null == swAlloc) {
            this.trace("can not find SWAllocation " + swAllocationRole);
            return;
        }
        if (useSTM) {
            this.removeAndCheckRepertoire(swAlloc, NO_STM_GROUP, STM_GROUP, context);
        } else {
            this.removeAndCheckRepertoire(swAlloc, STM_GROUP, NO_STM_GROUP, context);
        }
    }

    private void removeAndCheckRepertoire(SwAllocationMo swAlloc, String[] removed, String[] checked, Coordinator context) throws MoAccessException {
        boolean[] existingFlag = new boolean[checked.length];
        ManagedObject[] reps = swAlloc.getRepertoireList(context);
        for (int i = 0; i < reps.length; ++i) {
            for (int j = 0; j < removed.length; ++j) {
                if (!((RepertoireMo)reps[i]).getName(context).equalsIgnoreCase(removed[j])) continue;
                swAlloc.actionDeleteRepertoire(reps[i], context);
            }
            for (int k = 0; k < checked.length; ++k) {
                if (!((RepertoireMo)reps[i]).getName(context).equalsIgnoreCase(checked[k])) continue;
                existingFlag[k] = true;
            }
        }
        for (int m = 0; m < existingFlag.length; ++m) {
            if (existingFlag[m]) continue;
            this.traceError(checked[m] + " should exist in " + swAlloc.getClass());
        }
    }
}

