/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.ReserveMoHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;

public class DC8051798To8051799
extends DataConverterBase {
    private static final int COMMON_SUPPORT_MAGIC_REV = 8010001;
    private static final DC8051798To8051799 INSTANCE = new DC8051798To8051799();
    private static final String AU_TYPE = "auType";
    private static final String AUX_PLUG_IN_UNIT_TYPE_NAME = "AuxPlugInUnit";
    private static final String PIU_TYPE = "piuType";
    private static final String PLUG_IN_UNIT_REF2 = "plugInUnitRef2";
    private static final String PLUG_IN_UNIT_REF1 = "plugInUnitRef1";
    private static final int PSU = 14;
    private static final int BFU = 15;
    private static final int SAU = 21;
    private static final int SCU = 22;
    private static final int SUP = 23;
    private static final String POWER_SUPPLY_SYSTEM_TYPE_NAME = "PowerSupplySystem";
    private static final String BATTERY_TYPE_NAME = "Battery";
    private static final String FAN_GROUP_TYPE_NAME = "FanGroup";
    private static final String CABINET_TYPENAME = "Cabinet";
    protected static final int fromConverterRev = 8051798;
    protected static final int toConverterRev = 8051799;
    private static final String AC_DEVICE_REF = "acDeviceRef";
    private static final String BF_DEVICE_REF = "bfDeviceRef";
    private static final String DEVICE_GROUP_TYPE_NAME = "DeviceGroup";
    private static final String ALM_DEVICE_TYPE_NAME = "AlmDevice";
    private static final String ALM_DEVICE_SET_TYPE_NAME = "AlmDeviceSet";
    private static final String OUT_DEVICE_TYPE_NAME = "OutDevice";
    private static final String OUT_DEVICE_SET_TYPE_NAME = "OutDeviceSet";
    private static final String BFU_DEVICE_GROUP_TYPE_NAME = "BfuDeviceGroup";
    private static final String BF_DEVICE_SET_TYPE_NAME = "BfDeviceSet";
    private static final String BF_DEVICE_TYPE_NAME = "BfDevice";
    private static final String PSU_DEVICE_GROUP_TYPE_NAME = "PsuDeviceGroup";
    private static final String PS_DEVICE_SET_TYPE_NAME = "PsDeviceSet";
    private static final String PS_DEVICE_TYPE_NAME = "PsDevice";
    private static final String HW_UNIT_TYPE_NAME = "HwUnit";
    private static final String RBS_SUBRACK_TYPE_NAME = "RbsSubrack";
    private static final String RBS_SLOT_TYPE_NAME = "RbsSlot";
    private static final String[] moTypeNamesToDelete = new String[]{"AlmDevice", "AlmDeviceSet", "OutDevice", "OutDeviceSet", "DeviceGroup"};
    private static final String UP_MO_TYPE_NAME = "UpgradePackage";
    private static final String[] upMoAttrNames = new String[]{"faultyPIUsLockedByUpgrade", "nonSupportedPIUsLockedByUpgrade", "faultyPIUsLockedBeforeUpgrade", "nonSupportedPIUsLockedBeforeUpgrade"};
    private Coordinator context;

    protected DC8051798To8051799() {
        super(8051798, 8051799);
    }

    public static DC8051798To8051799 instance() {
        return INSTANCE;
    }

    protected void initDC(Coordinator context) throws Exception {
        this.traceEnter("initDC()");
        this.context = context;
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC()");
        if (this.cabinetExist()) {
            this.deleteMoData(BATTERY_TYPE_NAME, new String[0], this.context);
            this.deleteMoData(POWER_SUPPLY_SYSTEM_TYPE_NAME, new String[]{AC_DEVICE_REF, BF_DEVICE_REF}, this.context);
            this.deleteMoData(CABINET_TYPENAME, new String[]{"auxPlugInUnitRef"}, this.context);
            this.deleteMoData(FAN_GROUP_TYPE_NAME, new String[]{"deviceGroupRef"}, this.context);
            for (int i = 0; i < moTypeNamesToDelete.length; ++i) {
                this.deleteMoDataBelowAuxPiu(moTypeNamesToDelete[i], "SAU", this.context);
                this.deleteMoDataBelowAuxPiu(moTypeNamesToDelete[i], "SCU", this.context);
                this.deleteMoDataBelowAuxPiu(moTypeNamesToDelete[i], "SUP", this.context);
                this.deleteMoDataBelowAuxPiu(moTypeNamesToDelete[i], "PSU", this.context);
                this.deleteMoDataBelowAuxPiu(moTypeNamesToDelete[i], "BFU", this.context);
            }
            this.deleteMoDataForMoType(BF_DEVICE_TYPE_NAME, this.context);
            this.deleteMoDataForMoType(BF_DEVICE_SET_TYPE_NAME, this.context);
            this.deleteMoDataForMoType(BFU_DEVICE_GROUP_TYPE_NAME, this.context);
            this.deleteMoDataForMoType(PS_DEVICE_TYPE_NAME, this.context);
            this.deleteMoDataForMoType(PS_DEVICE_SET_TYPE_NAME, this.context);
            this.deleteMoDataForMoType(PSU_DEVICE_GROUP_TYPE_NAME, this.context);
            this.deleteAuxPiuMoData(14, this.context);
            this.deleteAuxPiuMoData(15, this.context);
            this.deleteAuxPiuMoData(21, this.context);
            this.deleteAuxPiuMoData(22, this.context);
            this.deleteAuxPiuMoData(23, this.context);
            this.makeHwUnitsReservePiuTypes(this.context);
        }
    }

    private void deleteMoDataForMoType(String moTypeName, Coordinator context) throws Exception {
        this.info("Deleting MoData for: " + moTypeName);
        ArrayList<MoData> workingMoDataToDelete = new ArrayList<MoData>();
        Iterator iter = this.workingMoData.getMoData(moTypeName).iterator();
        while (iter.hasNext()) {
            MoData modata = (MoData)iter.next();
            if (modata.getRevision() == 8010001) continue;
            MoDataHelper.activateWriteAccess(context, modata);
            this.info("Deleting MoData for: " + moTypeName + " with revision: " + modata.getRevision() + " and ldn: " + modata.getLocalDistinguishedName());
            modata.delete(context);
            workingMoDataToDelete.add(modata);
        }
        Iterator i = workingMoDataToDelete.iterator();
        while (i.hasNext()) {
            MoData toDelete = (MoData)i.next();
            this.workingMoData.deleteMoData(toDelete);
        }
    }

    private void deleteMoDataBelowAuxPiu(String moTypeName, String auType, Coordinator context) throws Exception {
        this.info("Deleting device group MoData for: " + moTypeName + " under AuxPIU of auType: " + auType);
        ArrayList<MoData> workingMoDataToDelete = new ArrayList<MoData>();
        Iterator iter = this.workingMoData.getMoData(moTypeName).iterator();
        while (iter.hasNext()) {
            MoData devGroup = (MoData)iter.next();
            if (devGroup.getLocalDistinguishedName().indexOf("AuxPlugInUnit=" + auType) == -1 || devGroup.getRevision() == 8010001) continue;
            MoDataHelper.activateWriteAccess(context, devGroup);
            this.info("Deleting MoData under AuxPiu: " + auType + " with revision: " + devGroup.getRevision() + " and ldn: " + devGroup.getLocalDistinguishedName());
            devGroup.delete(context);
            workingMoDataToDelete.add(devGroup);
        }
        Iterator i = workingMoDataToDelete.iterator();
        while (i.hasNext()) {
            MoData toDelete = (MoData)i.next();
            this.workingMoData.deleteMoData(toDelete);
        }
    }

    private void deleteAuxPiuMoData(int auType, Coordinator c) throws Exception {
        String[] moRefAttrs = new String[]{PLUG_IN_UNIT_REF1, PLUG_IN_UNIT_REF2, PIU_TYPE};
        ArrayList<MoData> workingMoDataToDelete = new ArrayList<MoData>();
        Iterator iter = this.workingMoData.getMoData(AUX_PLUG_IN_UNIT_TYPE_NAME).iterator();
        while (iter.hasNext()) {
            MoData auxPiu = (MoData)iter.next();
            int auxPiuAuType = ((IntegerAttribute)auxPiu.getAttribute(AU_TYPE)).getValue(c);
            if (auxPiuAuType != auType || auxPiu.getRevision() == 8010001) continue;
            MoDataHelper.activateWriteAccess(this.context, auxPiu);
            this.info("Deleting AuxPlugInUnit MoData with revision: " + auxPiu.getRevision() + " and LDN: " + auxPiu.getLocalDistinguishedName());
            for (int i = 0; i < upMoAttrNames.length; ++i) {
                this.removeAuxPiuRefFromUPMo(auxPiu.getLocalDistinguishedName(), upMoAttrNames[i], this.context);
            }
            this.releaseRefAttributes(auxPiu, moRefAttrs);
            auxPiu.delete(c);
            workingMoDataToDelete.add(auxPiu);
            MoData parent = this.getParent(auxPiu);
            if (parent != null && (auxPiuAuType == 15 || auxPiuAuType == 14) && parent.getMoTypeName().equals(RBS_SLOT_TYPE_NAME) && !this.hasSiblings(auxPiu, parent)) {
                MoDataHelper.activateWriteAccess(this.context, parent);
                this.info("Deleting RbsSlot parent: " + parent.getLocalDistinguishedName());
                parent.delete(c);
                workingMoDataToDelete.add(parent);
                MoData grandParent = this.getParent(parent);
                if (grandParent != null && grandParent.getMoTypeName().equals(RBS_SUBRACK_TYPE_NAME) && !this.hasSiblings(parent, grandParent)) {
                    MoDataHelper.activateWriteAccess(this.context, grandParent);
                    this.info("Deleting RbsSubrack grandparent: " + grandParent.getLocalDistinguishedName());
                    grandParent.delete(c);
                    workingMoDataToDelete.add(grandParent);
                }
            }
            if (parent == null || !parent.getMoTypeName().equals(RBS_SUBRACK_TYPE_NAME) || this.hasSiblings(auxPiu, parent)) continue;
            MoDataHelper.activateWriteAccess(this.context, parent);
            this.info("Deleting RbsSubrack parent: " + parent.getLocalDistinguishedName());
            parent.delete(c);
            workingMoDataToDelete.add(parent);
        }
        Iterator i = workingMoDataToDelete.iterator();
        while (i.hasNext()) {
            MoData toDelete = (MoData)i.next();
            this.workingMoData.deleteMoData(toDelete);
        }
    }

    private void removeAuxPiuRefFromUPMo(String localDistinguishedName, String attrName, Coordinator context) throws MoDataConversionException {
        Iterator iter = this.workingMoData.getMoData(UP_MO_TYPE_NAME).iterator();
        while (iter.hasNext()) {
            MoData upMoData = (MoData)iter.next();
            MoDataHelper.activateWriteAccess(context, upMoData);
            Attribute attr = upMoData.getAttribute(attrName);
            if (attr == null || !(attr instanceof SequenceAttribute)) continue;
            SequenceAttribute auxPiuRefs = (SequenceAttribute)attr;
            ArrayList<ReferenceAttribute> refsToRemove = new ArrayList<ReferenceAttribute>();
            Enumeration e = auxPiuRefs.elements();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (!(o instanceof ReferenceAttribute)) continue;
                ReferenceAttribute ref = (ReferenceAttribute)o;
                this.info("Processing reference from: " + attrName + " with LDN: " + ref.getReferenceAsLDN() + " aux piu ldn: " + localDistinguishedName);
                if (!ref.getReferenceAsLDN().equals(localDistinguishedName)) continue;
                this.info("Adding ref attr with LDN: " + ref.getReferenceAsLDN() + " to remove list");
                refsToRemove.add(ref);
            }
            Iterator i = refsToRemove.iterator();
            while (i.hasNext()) {
                this.info("Removing attribute from remove list");
                auxPiuRefs.removeElement((Attribute)i.next());
            }
        }
    }

    private void deleteMoData(String moType, String[] moRefAttrs, Coordinator c) throws Exception {
        this.info("Deleting MoData for: " + moType);
        ArrayList<MoData> workingMoDataToDelete = new ArrayList<MoData>();
        Iterator iter = this.workingMoData.getMoData(moType).iterator();
        while (iter.hasNext()) {
            MoData modata = (MoData)iter.next();
            if (modata.getRevision() == 8010001) continue;
            this.info("Deleting MoData with revision: " + modata.getRevision() + " and LDN: " + modata.getLocalDistinguishedName());
            MoDataHelper.activateWriteAccess(this.context, modata);
            this.releaseRefAttributes(modata, moRefAttrs);
            modata.delete(c);
            workingMoDataToDelete.add(modata);
        }
        Iterator i = workingMoDataToDelete.iterator();
        while (i.hasNext()) {
            MoData toDelete = (MoData)i.next();
            this.workingMoData.deleteMoData(toDelete);
        }
    }

    private void releaseRefAttributes(MoData modata, String[] moRefAttrs) throws Exception {
        for (int i = 0; i < moRefAttrs.length; ++i) {
            ReferenceAttribute refAttr;
            String ldn;
            String attrName = moRefAttrs[i];
            Attribute attr = modata.getAttribute(attrName);
            if (attr == null || !(attr instanceof ReferenceAttribute) || (ldn = (refAttr = (ReferenceAttribute)attr).getReferenceAsLDN()) == null) continue;
            this.release(modata, ldn);
        }
    }

    private boolean cabinetExist() {
        Iterator iter = this.workingMoData.getMoData(CABINET_TYPENAME).iterator();
        while (iter.hasNext()) {
            MoData cab = (MoData)iter.next();
            if (cab.getRevision() == 8010001) continue;
            return true;
        }
        return false;
    }

    private void release(MoData reserverMoData, String reservedMoLdn) throws Exception {
        String reserverLdn = reserverMoData.getLocalDistinguishedName();
        String reservedMoTypeName = LDNHelper.getMoTypeName(reservedMoLdn);
        Collection reservedMoDatas = this.workingMoData.getMoData(reservedMoTypeName);
        Iterator it = reservedMoDatas.iterator();
        while (it.hasNext()) {
            ReserveMoHelper.release((MoData)it.next(), reserverLdn, this.context);
        }
    }

    private void makeHwUnitsReservePiuTypes(Coordinator context) throws Exception {
        Iterator iter = this.workingMoData.getMoData(HW_UNIT_TYPE_NAME).iterator();
        while (iter.hasNext()) {
            MoData hwUnitMoData = (MoData)iter.next();
            String hwUnitLdn = hwUnitMoData.getLocalDistinguishedName();
            Attribute attr = hwUnitMoData.getAttribute(PIU_TYPE);
            if (attr == null) {
                this.info("no piuType attribute in: " + hwUnitLdn);
                continue;
            }
            if (!(attr instanceof ReferenceAttribute)) {
                this.info("piuType attribute in " + hwUnitLdn + " is not a ReferenceAttribute");
                continue;
            }
            ReferenceAttribute piuTypeRef = (ReferenceAttribute)attr;
            boolean doneReserve = ReserveMoHelper.reserve(this.workingMoData, piuTypeRef, hwUnitLdn, context);
            this.info((doneReserve ? "reservation set up: " : "failed to set up reservation: ") + hwUnitLdn + " --> " + piuTypeRef.getReferenceAsLDN());
        }
    }

    private MoData getParent(MoData moData) throws Exception {
        String ldn = moData.getLocalDistinguishedName();
        String parentLdn = LDNHelper.getParentLdn(ldn, LDNHelper.getMoTypeName(ldn));
        if ("".equals(parentLdn)) {
            return null;
        }
        String parentMoTypeName = LDNHelper.getMoTypeName(parentLdn);
        Iterator iter = this.workingMoData.getMoData(parentMoTypeName).iterator();
        while (iter.hasNext()) {
            MoData x = (MoData)iter.next();
            if (!x.getLocalDistinguishedName().equals(parentLdn)) continue;
            return x;
        }
        return null;
    }

    private boolean hasSiblings(MoData child, MoData parent) {
        String childLdn = child.getLocalDistinguishedName();
        String parentLdn = parent.getLocalDistinguishedName();
        Iterator iter = this.workingMoData.getOriginalData().iterator();
        while (iter.hasNext()) {
            MoData moData = (MoData)iter.next();
            String ldn = moData.getLocalDistinguishedName();
            if (!ldn.startsWith(parentLdn) || ldn.length() <= parentLdn.length() || !ldn.substring(parentLdn.length()).startsWith(",") || ldn.startsWith(childLdn)) continue;
            this.info("first sibling of " + childLdn + " is: " + ldn);
            return true;
        }
        this.info("no siblings found for: " + childLdn);
        return false;
    }
}

