/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv.operations;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class AddExistReserveAttributeOp
implements Command {
    private final WorkingMoData workingMoData;
    private final String callerLdn;
    private final String callerMoTypeName;
    private final String reserveLdn;
    private final Coordinator context;

    public AddExistReserveAttributeOp(WorkingMoData workingMoData, Coordinator context, String callerLdn, String callerMoTypeName, String reserveLdn) {
        MessageLog.traceEnter(this.getClass(), (String)"Start AddExistReserveAttributeOp");
        this.workingMoData = workingMoData;
        this.context = context;
        this.callerLdn = callerLdn;
        this.callerMoTypeName = callerMoTypeName;
        this.reserveLdn = reserveLdn;
    }

    public void execute() throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)"execute()");
        Collection mos = this.workingMoData.getMoData(this.callerMoTypeName);
        if (mos.isEmpty()) {
            MessageLog.trace((int)9, this.getClass(), (String)(this.callerMoTypeName + " MO not found in Working Data."));
            return;
        }
        Iterator iter = mos.iterator();
        while (iter.hasNext()) {
            MoData tmpMoData = (MoData)iter.next();
            if (!this.callerLdn.equals(tmpMoData.getLocalDistinguishedName())) continue;
            MessageLog.trace((int)9, this.getClass(), (String)("Add persistentReservers in " + this.callerLdn + " with value " + this.reserveLdn));
            MoDataHelper.activateWriteAccess(this.context, tmpMoData);
            this.workingMoData.deleteMoData(tmpMoData);
            ReferenceAttribute ra = new ReferenceAttribute("persistentReservers", this.reserveLdn, false);
            MessageLog.trace((int)9, this.getClass(), (String)("New ReferenceAttribute ra " + ra.getReferenceAsLDN()));
            SequenceAttribute sa = (SequenceAttribute)tmpMoData.getAttribute("persistentReservers");
            MessageLog.trace((int)9, this.getClass(), (String)("Existing SequenceAttribute sa have" + sa.size() + " elements"));
            tmpMoData.deregisterAttribute((Attribute)sa);
            sa.addElement((Attribute)ra);
            MessageLog.trace((int)9, this.getClass(), (String)("New SequenceAttribute sa have" + sa.size() + " elements"));
            tmpMoData.registerPersistentAttr((Attribute)sa);
            MessageLog.trace((int)9, this.getClass(), (String)("New MoData has SequenceAttribute with " + ((SequenceAttribute)tmpMoData.getAttribute("persistentReservers")).size() + " elements"));
            this.workingMoData.addMoData(tmpMoData);
            break;
        }
    }
}

