/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv.operations;

import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.ReserveMoHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class HO29616Op
implements Command {
    private static final Class SELF = HO29616Op.class;
    public static final String BOAM_RESERVED_BY = "persistentReservers";
    public static final String CELLO_RESERVED_BY = "reservedBy";
    public static final String CELLO_RESERVED_BY_UC = "ReservedBy";
    public static final String CELLO_RESERVED_BY_PIU = "reservedByList";
    private final WorkingMoData workingMoData;
    private final Coordinator context;

    public HO29616Op(WorkingMoData workingMoData, Coordinator context) {
        this.workingMoData = workingMoData;
        this.context = context;
    }

    public void execute() throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"doDC()");
        Iterator rbsSynchronizationIter = this.workingMoData.getMoData("RbsSynchronization").iterator();
        while (rbsSynchronizationIter.hasNext()) {
            MoData rbsSynchronization = (MoData)rbsSynchronizationIter.next();
            String origrbsSynchronizationLDN = rbsSynchronization.getLocalDistinguishedName();
            MessageLog.trace((int)9, this.getClass(), (String)("Check rbsSynchronization " + rbsSynchronization.getLocalDistinguishedName()));
            ReferenceAttribute PlugInUnitRef1 = (ReferenceAttribute)rbsSynchronization.getAttribute("plugInUnitRef1");
            ReferenceAttribute PlugInUnitRef2 = (ReferenceAttribute)rbsSynchronization.getAttribute("plugInUnitRef2");
            this.checkReservation(PlugInUnitRef1, origrbsSynchronizationLDN);
            this.checkReservation(PlugInUnitRef2, origrbsSynchronizationLDN);
        }
    }

    public void checkReservation(ReferenceAttribute ObjectRefAttr, String LDN) throws Exception {
        if (ObjectRefAttr != null && ObjectRefAttr.getReferenceAsLDN() != null) {
            String refLdn = ObjectRefAttr.getReferenceAsLDN();
            MessageLog.trace((int)9, this.getClass(), (String)(" refLdn is " + refLdn));
            MoData toBeReservedMo = this.getMoDataByLdn(refLdn);
            if (toBeReservedMo != null) {
                Attribute reserverRbsSynchronization = toBeReservedMo.getAttribute(CELLO_RESERVED_BY);
                if (reserverRbsSynchronization == null) {
                    reserverRbsSynchronization = toBeReservedMo.getAttribute(CELLO_RESERVED_BY_PIU);
                }
                if (reserverRbsSynchronization == null) {
                    reserverRbsSynchronization = toBeReservedMo.getAttribute(CELLO_RESERVED_BY_UC);
                }
                if (reserverRbsSynchronization == null) {
                    reserverRbsSynchronization = toBeReservedMo.getAttribute(BOAM_RESERVED_BY);
                }
                if (reserverRbsSynchronization == null) {
                    MoDataHelper.registerSeqAttr(toBeReservedMo, null, BOAM_RESERVED_BY, false, new Attribute[]{new ReferenceAttribute("", LDN, false)});
                }
                if (reserverRbsSynchronization != null) {
                    String reserverLDN;
                    if (reserverRbsSynchronization instanceof SequenceAttribute) {
                        if (ReserveMoHelper.isReservedBy((SequenceAttribute)reserverRbsSynchronization, LDN, this.context)) {
                            MessageLog.trace((int)9, (Class)ReserveMoHelper.class, (String)("reservee is " + refLdn + ", the reserver:" + LDN + " is already in the reservedBy list. "));
                        } else {
                            toBeReservedMo.handleTransaction(this.context, MoData.WRITE_ACCESS);
                            MessageLog.trace((int)9, this.getClass(), (String)("reservee is " + refLdn + ", did not find LDN " + LDN + " in the reserver list, reserver list size is : " + ((SequenceAttribute)reserverRbsSynchronization).size()));
                            ReserveMoHelper.reserve(toBeReservedMo, LDN, this.context);
                            MessageLog.trace((int)9, this.getClass(), (String)(" new reserver list size is : " + ((SequenceAttribute)reserverRbsSynchronization).size()));
                        }
                    } else if (reserverRbsSynchronization instanceof ReferenceAttribute && !LDN.equals(reserverLDN = ((ReferenceAttribute)reserverRbsSynchronization).getReferenceAsLDN())) {
                        toBeReservedMo.handleTransaction(this.context, MoData.WRITE_ACCESS);
                        MessageLog.trace((int)9, this.getClass(), (String)" did not find the reserver, make explicit reservation... ");
                        ReserveMoHelper.reserve(toBeReservedMo, LDN, this.context);
                    }
                } else {
                    toBeReservedMo.handleTransaction(this.context, MoData.WRITE_ACCESS);
                    MessageLog.trace((int)9, this.getClass(), (String)" did not find the reserver in the list, make reservation... ");
                    ReserveMoHelper.reserve(toBeReservedMo, LDN, this.context);
                }
            } else {
                MessageLog.traceError(this.getClass(), (String)"did not find the corresponding MO according to LDN");
            }
        } else {
            MessageLog.info(this.getClass(), (String)" ref attribute is null, do nothing ");
        }
    }

    private MoData getMoDataByLdn(String moLdn) {
        MessageLog.traceEnter(this.getClass(), (String)"getMoDataByLdn()");
        Vector originalData = this.workingMoData.getOriginalData();
        MoData tmp = null;
        Iterator i = originalData.iterator();
        while (i.hasNext()) {
            tmp = (MoData)i.next();
            if (!tmp.getLocalDistinguishedName().equals(moLdn)) continue;
            return tmp;
        }
        return null;
    }
}

