/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.frodataconv;

import java.util.HashSet;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.frodataconv.ApcFroAttributes;
import se.ericsson.wcdma.rbs.boam.frodataconv.ColumnData;
import se.ericsson.wcdma.rbs.boam.frodataconv.CommonSupportSystemFroDataConverter;
import se.ericsson.wcdma.rbs.boam.mao.dmo.alarm.AlmDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AlmDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DatabaseMgr;

public class AlarmPortFroDataConverter
extends CommonSupportSystemFroDataConverter {
    private static final AlarmPortFroDataConverter INSTANCE = new AlarmPortFroDataConverter();
    private HashSet ldns = new HashSet();
    private ColumnData[] columnData = new ColumnData[]{new ColumnData("ldn", DatabaseMgr.getSql().varcharType(100)), new ColumnData("perceivedSeverity", "INTEGER"), new ColumnData("probableCause", "INTEGER"), new ColumnData("alarmSlogan", DatabaseMgr.getSql().varcharType(100)), new ColumnData("administrativeState", "INTEGER"), new ColumnData("normallyOpen", "INTEGER")};

    private AlarmPortFroDataConverter() {
        super("AlarmPortFroDataConverter");
    }

    public static AlarmPortFroDataConverter instance() {
        return INSTANCE;
    }

    protected ColumnData[] getColumnData() {
        return this.columnData;
    }

    protected String getTypeName() {
        return "AlmDevice";
    }

    protected Object[] getTableData(ManagedObject nextMo, Coordinator context) throws MoAccessException {
        String ldn;
        String auxPiuAttrValue;
        AlmDeviceMo almDeviceMo = (AlmDeviceMo)nextMo;
        ManagedObject mo = AlmDeviceMoImpl.getAncestor((ManagedObject)almDeviceMo, (String)"AuxPlugInUnit");
        if (!(mo instanceof AuxPlugInUnitMo)) {
            return null;
        }
        String hwUnitId = auxPiuAttrValue = AlarmPortFroDataConverter.getAuType(mo, context);
        if (auxPiuAttrValue == null) {
            return null;
        }
        if (auxPiuAttrValue.equalsIgnoreCase("SUP")) {
            hwUnitId = this.getSupHwUnitId(mo.getNamingAttributeValue());
        }
        if (!this.ldns.add(ldn = "ManagedElement=1,Equipment=1,HwUnit=" + hwUnitId + ",AlarmPort=" + almDeviceMo.getNamingAttributeValue())) {
            return null;
        }
        return new Object[]{new Integer(this.nextFroId()), ldn, new Integer(almDeviceMo.getPerceivedSeverity(context)), new Integer(almDeviceMo.getProbableCause(context)), almDeviceMo.getAlarmSlogan(context), new Integer(almDeviceMo.getAdministrativeState(context)), new Integer(almDeviceMo.getNormallyOpen(context) ? 1 : 0)};
    }

    protected void createNewMoData(MoData moData, String ldn, int froId, Coordinator c) throws MoAccessException {
        StringAttribute userLabel = (StringAttribute)moData.getAttribute("userLabel");
        MoData myNewData = new MoData(ldn, "AlarmPort", true, c);
        myNewData.handleTransaction(c, MoData.WRITE_ACCESS);
        myNewData.registerPersistentAttr((Attribute)userLabel);
        IntegerAttribute intAttr = new IntegerAttribute("froId", false);
        myNewData.registerPersistentAttr((Attribute)intAttr);
        intAttr.setValue(froId);
        myNewData.setRevision(8010001);
    }

    protected ApcFroAttributes[] getApcFroAttributesData() {
        int froType = this.getFroType();
        return new ApcFroAttributes[]{new ApcFroAttributes(froType, "perceivedSeverity", "S32"), new ApcFroAttributes(froType, "probableCause", "S32"), new ApcFroAttributes(froType, "alarmSlogan", "STRING"), new ApcFroAttributes(froType, "administrativeState", "S32"), new ApcFroAttributes(froType, "normallyOpen", "S32")};
    }

    protected String getNewTypeName() {
        return "AlarmPort";
    }
}

