/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.frodataconv;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.frodataconv.ApcFroAttributes;
import se.ericsson.wcdma.rbs.boam.frodataconv.ColumnData;
import se.ericsson.wcdma.rbs.boam.frodataconv.CommonSupportSystemFroDataConverter;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BatteryMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerSupplySystemMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DatabaseMgr;

public class BatteryBackupFroDataConverter
extends CommonSupportSystemFroDataConverter {
    private static BatteryBackupFroDataConverter _theOne = new BatteryBackupFroDataConverter();
    private static final int TEMP_COMP_VOLTAGE_SLOPE_DEF = -96;
    private static final String BATTERY_INSTALLATION_DATE_DEF = "00000000";
    private static final int BATTERY_TYPE_DEF = 1;
    private static final int BOOST_CHARGE_TIME_DEF = 5;
    private static final int BOOST_CHARGE_TRIGGER_VOLTAGE_DEF = -470;
    private static final int CHARGE_MAX_CURRENT_DEF = 125;
    private static final int CHARGING_MODE_DEF = 0;
    private static final int CHARGING_VOLTAGE_DEF = -545;
    private static final int EQUALIZE_CHARGE_CYCLIC_INTERVAL_DEF = 30;
    private static final int EQUALIZE_CHARGE_TIME_DEF = 4;
    private static final int INCREASED_CHARGE_VOLTAGE = -564;
    private static final int INTERMITTENT_CHARGE_CONNECT_TIME_DEF = 72;
    private static final int INTERMITTENT_CHARGE_CONNECT_VOLTAGE_DEF = -500;
    private static final int INTERMITTENT_CHARGE_DISCONNECT_TIME_DEF = 12;
    private static final int MINIMUM_BACKUP_TIME_DEF = 60;
    private static final int MINIMUM_STATE_OF_HEALTH_DEF = 70;
    private static final int NOMINAL_TEMP_DEF = 250;
    private static final int SHARED_BATTERY_DEF = 0;
    private static final int TEMP_COMP_MAX_VOLTAGE_DEF = -569;
    private static final int TEMP_COMP_MIN_VOLTAGE_DEF = -528;
    private static final int TEST_MODE_DEF = 0;
    private static final int TEST_START_DAY_DEF = 25;
    private static final int[] TEST_START_MONTHS_DEF = new int[]{3, 9};
    private static final String TEST_START_TIME_DEF = "01:00";
    private ColumnData[] columnData = new ColumnData[]{new ColumnData("ldn", DatabaseMgr.getSql().varcharType(100)), new ColumnData("tempCompVoltageSlope", "INTEGER"), new ColumnData("batteryDisconnectTemp", "INTEGER"), new ColumnData("batteryDisconnectTempCeaseOffset", "INTEGER"), new ColumnData("batteryInstallationDate", DatabaseMgr.getSql().varcharType(100)), new ColumnData("batteryType", "INTEGER"), new ColumnData("boostChargeTime", "INTEGER"), new ColumnData("boostChargeTriggerVoltage", "INTEGER"), new ColumnData("chargeMaxCurrent", "INTEGER"), new ColumnData("chargingMode", "INTEGER"), new ColumnData("chargingVoltage", "INTEGER"), new ColumnData("equalizeChargeCyclicInterval", "INTEGER"), new ColumnData("equalizeChargeTime", "INTEGER"), new ColumnData("increasedChargeVoltage", "INTEGER"), new ColumnData("intermittentChargeConnectTime", "INTEGER"), new ColumnData("intermittentChargeConnectVoltage", "INTEGER"), new ColumnData("intermittentChargeDisconnectTime", "INTEGER"), new ColumnData("minimumBackupTime", "INTEGER"), new ColumnData("minimumStateOfHealth", "INTEGER"), new ColumnData("nominalTemp", "INTEGER"), new ColumnData("sharedBattery", "INTEGER"), new ColumnData("tempCompMaxVoltage", "INTEGER"), new ColumnData("tempCompMinVoltage", "INTEGER"), new ColumnData("testMode", "INTEGER"), new ColumnData("testStartDay", "INTEGER"), new ColumnData("testStartMonths", DatabaseMgr.getSql().varcharType(100)), new ColumnData("testStartTime", DatabaseMgr.getSql().varcharType(100))};

    private BatteryBackupFroDataConverter() {
        super("BatteryBackupFroDataConverter");
    }

    public static BatteryBackupFroDataConverter instance() {
        return _theOne;
    }

    protected ColumnData[] getColumnData() {
        return this.columnData;
    }

    protected String getTypeName() {
        return "Battery";
    }

    protected Object[] getTableData(ManagedObject nextMo, Coordinator context) throws MoAccessException {
        BatteryMo batteryMo = (BatteryMo)nextMo;
        String ldn = "ManagedElement=1,EquipmentSupportFunction=1,BatteryBackup=" + batteryMo.getNamingAttributeValue();
        PowerSupplySystemMo powerSupplySystemMo = null;
        MoIterator moIter = FindMo.findMOs("PowerSupplySystem");
        if (moIter.hasMoreElements()) {
            powerSupplySystemMo = (PowerSupplySystemMo)moIter.nextMo();
        }
        if (powerSupplySystemMo == null) {
            this.info("Battery MO exists without PowerSupplySystem MO, conversion not possible");
            return null;
        }
        return new Object[]{new Integer(this.nextFroId()), ldn, new Integer(-96), new Integer(powerSupplySystemMo.getTemperatureDisconnect(context)), new Integer(powerSupplySystemMo.getTemperatureDisconnectCeaseOffset(context)), BATTERY_INSTALLATION_DATE_DEF, new Integer(1), new Integer(5), new Integer(-470), new Integer(125), new Integer(0), new Integer(-545), new Integer(30), new Integer(4), new Integer(-564), new Integer(72), new Integer(-500), new Integer(12), new Integer(60), new Integer(70), new Integer(250), new Integer(0), new Integer(-569), new Integer(-528), new Integer(0), new Integer(25), BatteryBackupFroDataConverter.convertIntArrayToString(TEST_START_MONTHS_DEF, "testStartMonths"), TEST_START_TIME_DEF};
    }

    protected void createNewMoData(MoData moData, String ldn, int froId, Coordinator c) throws MoAccessException {
        this.traceEnter("createNewMoData()");
        StringAttribute userLabel = (StringAttribute)moData.getAttribute("userLabel");
        MoData myNewData = new MoData(ldn, "BatteryBackup", true, c);
        myNewData.handleTransaction(c, MoData.WRITE_ACCESS);
        myNewData.registerPersistentAttr((Attribute)userLabel);
        IntegerAttribute intAttr = new IntegerAttribute("froId", false);
        myNewData.registerPersistentAttr((Attribute)intAttr);
        intAttr.setValue(froId);
        myNewData.setRevision(8010001);
    }

    protected ApcFroAttributes[] getApcFroAttributesData() {
        int froType = this.getFroType();
        return new ApcFroAttributes[]{new ApcFroAttributes(froType, "batteryDisconnectTemp", "S32"), new ApcFroAttributes(froType, "batteryDisconnectTempCeaseOffset", "S32"), new ApcFroAttributes(froType, "batteryInstallationDate", "STRING"), new ApcFroAttributes(froType, "batteryType", "S32"), new ApcFroAttributes(froType, "boostChargeTime", "S32"), new ApcFroAttributes(froType, "boostChargeTriggerVoltage", "S32"), new ApcFroAttributes(froType, "chargeMaxCurrent", "S32"), new ApcFroAttributes(froType, "chargingMode", "S32"), new ApcFroAttributes(froType, "chargingVoltage", "S32"), new ApcFroAttributes(froType, "equalizeChargeCyclicInterval", "S32"), new ApcFroAttributes(froType, "equalizeChargeTime", "S32"), new ApcFroAttributes(froType, "increasedChargeVoltage", "S32"), new ApcFroAttributes(froType, "intermittentChargeConnectTime", "S32"), new ApcFroAttributes(froType, "intermittentChargeConnectVoltage", "S32"), new ApcFroAttributes(froType, "intermittentChargeDisconnectTime", "S32"), new ApcFroAttributes(froType, "minimumBackupTime", "S32"), new ApcFroAttributes(froType, "minimumStateOfHealth", "S32"), new ApcFroAttributes(froType, "nominalTemp", "S32"), new ApcFroAttributes(froType, "sharedBattery", "S32"), new ApcFroAttributes(froType, "tempCompMaxVoltage", "S32"), new ApcFroAttributes(froType, "tempCompMinVoltage", "S32"), new ApcFroAttributes(froType, "testMode", "S32"), new ApcFroAttributes(froType, "testStartDay", "S32"), new ApcFroAttributes(froType, "testStartMonths", "array"), new ApcFroAttributes(froType, "testStartTime", "STRING"), new ApcFroAttributes(froType, "tempCompVoltageSlope", "S32")};
    }

    protected String getNewTypeName() {
        return "BatteryBackup";
    }
}

