/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.aue;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamUpgradeParticipator;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.FroDataConverter;

public class AueRepository {
    private static final Class SELF = AueRepository.class;
    private static final AueRepository INSTANCE = new AueRepository();
    private static final Object auesLock = new Object();
    private static final Object froDataConvertersLock = new Object();
    private final List aues = new ArrayList();
    private final List froDataConverters = new ArrayList();

    private AueRepository() {
    }

    public static AueRepository instance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerAue(BoamUpgradeParticipator aue) throws RuntimeException {
        Object object = auesLock;
        synchronized (object) {
            if (aue == null) {
                MessageLog.traceError((Class)SELF, (String)"registerAue(), Aue is null!!");
                throw new IllegalArgumentException();
            }
            if (this.aues.contains(aue)) {
                MessageLog.traceError((Class)SELF, (String)("registerAue(), Aue is already registered!!: " + aue.getAueName()));
                throw new IllegalStateException();
            }
            BoamUpgradeParticipator p = this.findIdenticallyNamed(this.aues, aue.getAueName());
            if (p != null) {
                MessageLog.traceError((Class)SELF, (String)("registerAue(), name " + aue.getAueName() + "already used by: " + p));
                throw new IllegalStateException();
            }
            this.aues.add(aue);
        }
    }

    private BoamUpgradeParticipator findIdenticallyNamed(List aues, String aueName) {
        Iterator it = aues.iterator();
        while (it.hasNext()) {
            BoamUpgradeParticipator p = (BoamUpgradeParticipator)it.next();
            if (!p.getAueName().equals(aueName)) continue;
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAllAues() {
        Object object = auesLock;
        synchronized (object) {
            this.aues.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllAues() {
        Object object = auesLock;
        synchronized (object) {
            return this.aues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerFroDataConverter(FroDataConverter dc) {
        Object object = froDataConvertersLock;
        synchronized (object) {
            if (this.froDataConverters.contains(dc)) {
                MessageLog.traceError((Class)SELF, (String)("registerAue(), Aue is already registered!!: " + dc.getAueName()));
            } else {
                this.froDataConverters.add(dc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAllFroDataConverters() {
        Object object = froDataConvertersLock;
        synchronized (object) {
            this.froDataConverters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllFroDataConverters() {
        Object object = froDataConvertersLock;
        synchronized (object) {
            return this.froDataConverters;
        }
    }

    public void _registerAue_onlyForTest(BoamUpgradeParticipator aue) throws MoAccessException {
        this.registerAue(aue);
    }

    public void _registerFroDataConverter_onlyForTest(FroDataConverter dc) {
        this.registerFroDataConverter(dc);
    }
}

