/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.command;

import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamAue;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamUpgradeParticipator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Macro;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MessageLogAue;

public abstract class CommandHandler {
    private static final int SLEEP_TIME = 100;

    public static void execute(Macro cmd, int tries) throws Exception {
        int count = tries;
        while (count > 0) {
            try {
                cmd.execute();
                return;
            }
            catch (Exception e) {
                if (--count == 0) {
                    throw e;
                }
                CommandHandler.sleep(100);
            }
        }
    }

    public static AueCommand createAueCommand(Command cmd, int tries) {
        return new AueCommand(cmd, tries);
    }

    public static void executeTheTasks(BoamAue boamAue, String triggerName, UpgradeMaster upgradeMaster, List commands) {
        try {
            ThreadCommand tc = new ThreadCommand(boamAue, triggerName, upgradeMaster, commands);
            new Thread(tc).start();
            MessageLog.traceEnter((Class)CommandHandler.class, (String)"executeTheTasks(),  tasks have been started on a separate thread");
        }
        catch (Exception e) {
            MessageLog.traceError((Class)CommandHandler.class, (String)"executeTheTasks(), should not happen, the ThreadCommand  could not start!!", (Throwable)e);
        }
    }

    public static void sleep(int sleepTime) {
        MessageLog.trace((int)9, (Class)ThreadCommand.class, (String)("sleep(), Putting thread to sleep for " + sleepTime + " ms"));
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            MessageLog.trace((int)9, (Class)ThreadCommand.class, (String)("Sleep interupted for thread " + Thread.currentThread().getName()));
        }
    }

    private static class ThreadCommand
    implements Runnable {
        private static final String NAME_PREFIX = "BoamAueCommandHandler";
        private final String triggerName;
        private final BoamAue boamAue;
        private final UpgradeMaster upgradeMaster;
        private final List commandList;

        private ThreadCommand(BoamAue boamAue, String triggerName, UpgradeMaster upgradeMaster, List commandList) {
            this.upgradeMaster = upgradeMaster;
            this.triggerName = triggerName;
            this.boamAue = boamAue;
            this.commandList = commandList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Iterator iter = this.commandList.iterator();
                while (iter.hasNext()) {
                    AueCommand aue = (AueCommand)iter.next();
                    String aueName = ((BoamUpgradeParticipator)((Object)aue.cmd)).getAueName();
                    Thread.currentThread().setName("BoamAueCommandHandler_" + this.triggerName + "_" + aueName);
                    MessageLog.info(this.getClass(), (String)("\nStart to execute sub-AUE " + aueName + ", trigger: " + this.triggerName));
                    aue.execute();
                    MessageLog.info(this.getClass(), (String)("End of execution, sub-AUE " + aueName + ", trigger: " + this.triggerName));
                }
                MessageLog.info(this.getClass(), (String)("All Aues executed successfully. Confirming trigger " + this.triggerName + " with success."));
                this.upgradeMaster.triggerConfirmed((UpgradeParticipator)this.boamAue, this.triggerName, true);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable e) {
                String info = "Execution failed due to exception. Confirming trigger " + this.triggerName + " with failure,\nThis thread will now die and upgrade will be interrupted!!  ";
                MessageLog.traceError(this.getClass(), (String)info, (Throwable)e);
                MessageLogAue.writeTraceToSystemLog(this.upgradeMaster, this.boamAue, this.triggerName, false, e);
            }
            finally {
                this.commandList.clear();
            }
        }
    }

    private static class AueCommand {
        private final Command cmd;
        private int tries;

        private AueCommand(Command cmd, int tries) {
            this.cmd = cmd;
            this.tries = tries;
            if (tries < 1) {
                throw new IllegalArgumentException();
            }
        }

        private void execute() throws Exception {
            while (this.tries > 0) {
                try {
                    this.cmd.execute();
                    this.tries = 0;
                    return;
                }
                catch (Exception e) {
                    --this.tries;
                    if (this.tries == 0) {
                        throw e;
                    }
                    CommandHandler.sleep(100);
                }
            }
        }
    }
}

