/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.BoamDataRevision;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.ConversionSequenceNotFoundException;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.Converter;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DCRevHandler;

public class DCSequence {
    private BoamDataRevision boamDataRev = null;
    private List sequence = null;

    public DCSequence(Converter[] converters, DCRevHandler revisionHandler) throws MoDataConversionException {
        this.boamDataRev = new BoamDataRevision(revisionHandler.getBoamFromRevision(), revisionHandler.getBoamToRevision());
        this.printListOfAvailableConverters(converters);
        this.sequence = this.createSequence(converters);
        if (this.sequence == null || this.sequence.size() == 0) {
            throw new ConversionSequenceNotFoundException("Unable to find conversion sequence between " + this.boamDataRev.getFromBoamDataRev() + " and " + this.boamDataRev.getToBoamDataRev() + ".");
        }
    }

    private void printListOfAvailableConverters(Converter[] converters) {
        if (converters == null || converters.length == 0) {
            MessageLog.info(this.getClass(), (String)"The Converters list is Empty!!");
        } else {
            MessageLog.info(this.getClass(), (String)"List available Converters:");
            Converter step = null;
            for (int i = 0; i < converters.length; ++i) {
                step = converters[i];
                MessageLog.info(this.getClass(), (String)(step.getClass().getName() + ", revision from: " + step.getFromRevision() + ", revision to: " + step.getToRevision()));
            }
        }
    }

    public void convert(WorkingMoData data) throws MoDataConversionException {
        MessageLog.info(this.getClass(), (String)"Executing upgrade sequence:");
        if (this.sequence.isEmpty()) {
            MessageLog.info(this.getClass(), (String)("From and to revisions are equal (" + this.boamDataRev.getFromBoamDataRev() + "), couldn't find conversion sequence!!"));
            return;
        }
        Converter step = null;
        ListIterator i = this.sequence.listIterator();
        while (i.hasNext()) {
            step = (Converter)i.next();
            MessageLog.info(this.getClass(), (String)("Converting data from " + step.getFromRevision() + " to " + step.getToRevision() + " using " + step.getClass().getName()));
            step.convert(data);
        }
        MessageLog.info(this.getClass(), (String)"Successfully executed conversion sequence.");
    }

    private List createSequence(Converter[] converters) {
        int i;
        MessageLog.traceEnter(this.getClass(), (String)"createSequence()");
        Converter dc = null;
        LinkedList sortedDclist = new LinkedList();
        LinkedList seqlist = new LinkedList();
        int startIndex = 10000;
        for (i = 0; i < converters.length; ++i) {
            dc = converters[i];
            if (dc != null) {
                sortedDclist = this.addToSortedDCList(sortedDclist, dc);
                continue;
            }
            MessageLog.trace((int)9, this.getClass(), (String)("The DC in the Sequence is null. index:" + i));
        }
        for (i = 0; i < sortedDclist.size(); ++i) {
            dc = (Converter)sortedDclist.get(i);
            if (dc == null || dc.getFromRevision() < this.boamDataRev.getFromBoamDataRev()) continue;
            startIndex = i;
            break;
        }
        sortedDclist = this.getDCCandidates(sortedDclist, startIndex);
        seqlist = this.getShortestPath(sortedDclist);
        return seqlist;
    }

    private LinkedList getShortestPath(LinkedList dcList) {
        LinkedList<Converter> tmpList = new LinkedList<Converter>();
        Converter dc = null;
        int pathRevPosition = this.boamDataRev.getFromBoamDataRev();
        dc = this.dcFound(dcList, pathRevPosition);
        while (dc != null) {
            pathRevPosition = dc.getToRevision();
            tmpList.addLast(dc);
            dc = this.dcFound(dcList, pathRevPosition);
        }
        return tmpList;
    }

    private Converter dcFound(LinkedList dcList, int pathRevPosition) {
        Converter dc = null;
        Converter dcToReturn = null;
        for (int i = 0; i < dcList.size(); ++i) {
            dc = (Converter)dcList.get(i);
            if (dc.getFromRevision() < pathRevPosition) continue;
            if (dcToReturn == null) {
                dcToReturn = dc;
                continue;
            }
            if (dcToReturn.getFromRevision() != dc.getFromRevision() || dc.getToRevision() <= dcToReturn.getToRevision()) continue;
            dcToReturn = dc;
        }
        return dcToReturn;
    }

    private LinkedList getDCCandidates(LinkedList dcList, int startIndex) {
        LinkedList<Converter> tmpList = new LinkedList<Converter>();
        Converter dc = null;
        for (int i = startIndex; i < dcList.size(); ++i) {
            dc = (Converter)dcList.get(i);
            if (dc.getToRevision() > this.boamDataRev.getToBoamDataRev()) continue;
            tmpList.addLast(dc);
        }
        return tmpList;
    }

    private LinkedList addToSortedDCList(LinkedList list, Converter dc) {
        LinkedList<Converter> tmpList = new LinkedList<Converter>();
        boolean dcAdded = false;
        if (list.isEmpty()) {
            tmpList.addLast(dc);
            return tmpList;
        }
        for (int i = 0; i < list.size(); ++i) {
            Converter tmpDC = (Converter)list.get(i);
            if (dc.getFromRevision() < tmpDC.getFromRevision() && !dcAdded) {
                tmpList.add(i, dc);
                dcAdded = true;
            }
            tmpList.addLast((Converter)list.get(i));
        }
        if (!dcAdded) {
            tmpList.addLast(dc);
        }
        return tmpList;
    }

    public String toString() {
        if (this.sequence == null) {
            return "< Corrupt DCSequence >";
        }
        Converter step = null;
        String result = "";
        ListIterator i = this.sequence.listIterator();
        while (i.hasNext()) {
            step = (Converter)i.next();
            result = result + step.getFromRevision() + " --> " + step.getToRevision() + "\t" + step.getClass().getName() + "\n";
        }
        return result;
    }
}

