/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv.operations;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class AddReferenceAttributeOp
implements Command {
    private final Coordinator context;
    private final WorkingMoData workingMoData;
    private final String moTypeName;
    private final int newRev;
    private final String attrName;
    private final String attrValue;
    private final boolean notification;

    public AddReferenceAttributeOp(WorkingMoData workingMoData, String moTypeName, int newRev, String attrName, String attrValue, boolean notification, Coordinator context) {
        this.workingMoData = workingMoData;
        this.moTypeName = moTypeName;
        this.newRev = newRev;
        this.attrName = attrName;
        this.attrValue = attrValue;
        this.notification = notification;
        this.context = context;
    }

    public void execute() throws Exception {
        MessageLog.traceEnter(this.getClass(), (String)"execute()");
        Collection mos = this.workingMoData.getMoData(this.moTypeName);
        if (mos.isEmpty()) {
            MessageLog.trace((int)9, this.getClass(), (String)(this.moTypeName + " MO not found in Working Data."));
            return;
        }
        Iterator iter = mos.iterator();
        while (iter.hasNext()) {
            MoData tmpMoData = (MoData)iter.next();
            MoDataHelper.activateWriteAccess(this.context, tmpMoData);
            ReferenceAttribute intAttr = (ReferenceAttribute)tmpMoData.getAttribute(this.attrName);
            if (intAttr == null) {
                MoDataHelper.registerRefAttr(tmpMoData, null, this.attrName, this.notification, this.attrValue);
                tmpMoData.setRevision(this.newRev);
                continue;
            }
            MessageLog.trace((int)9, this.getClass(), (String)(" The attribute allready exists in the MoData. Attr name: " + this.attrName + ", Mo:" + tmpMoData.getLocalDistinguishedName()));
        }
    }
}

