/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.ReserveMoHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class RemoveMoOp
implements Command {
    private static final Class self = RemoveMoOp.class;
    private final WorkingMoData workingMoData;
    private final Coordinator context;
    private final String moTypeName;
    private final String[] moRefAttributes;

    public RemoveMoOp(WorkingMoData workingMoData, Coordinator context, String moTypeName, String[] moRefAttributeNames) {
        this.workingMoData = workingMoData;
        this.context = context;
        this.moTypeName = moTypeName;
        if (moRefAttributeNames == null) {
            throw new IllegalArgumentException("MO reference attributes array must not be null");
        }
        this.moRefAttributes = moRefAttributeNames;
    }

    public void execute() throws Exception {
        MessageLog.traceEnter((Class)self, (String)"execute()");
        ArrayList doomed = new ArrayList(this.workingMoData.getMoData(this.moTypeName));
        Iterator it = doomed.iterator();
        while (it.hasNext()) {
            MoData moData = (MoData)it.next();
            MoDataHelper.activateWriteAccess(this.context, moData);
            for (int i = 0; i < this.moRefAttributes.length; ++i) {
                ReferenceAttribute refAttr;
                String ldn;
                String attrName = this.moRefAttributes[i];
                Attribute attr = moData.getAttribute(attrName);
                if (attr == null || !(attr instanceof ReferenceAttribute) || (ldn = (refAttr = (ReferenceAttribute)attr).getReferenceAsLDN()) == null) continue;
                this.release(moData, ldn);
            }
            MessageLog.trace((int)9, (Class)self, (String)("about to deregister MO " + moData.getLocalDistinguishedName()));
            this.workingMoData.deleteMoData(moData);
            MessageLog.trace((int)9, (Class)self, (String)("about to delete MO " + moData.getLocalDistinguishedName()));
            moData.delete(this.context);
        }
    }

    private void release(MoData reserverMoData, String reservedMoLdn) throws Exception {
        String reserverLdn = reserverMoData.getLocalDistinguishedName();
        String reservedMoTypeName = LDNHelper.getMoTypeName(reservedMoLdn);
        Collection reservedMoDatas = this.workingMoData.getMoData(reservedMoTypeName);
        Iterator it = reservedMoDatas.iterator();
        while (it.hasNext()) {
            ReserveMoHelper.release((MoData)it.next(), reserverLdn, this.context);
        }
    }
}

