/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.conv.operations;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Command;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public class UpdateIntegerAttributeOp
implements Command {
    private static final Class SELF = UpdateIntegerAttributeOp.class;
    private final WorkingMoData workingMoData;
    private final String moTypeName;
    private final int newRev;
    private final String attrName;
    private final int attrValue;
    private final Coordinator context;

    public UpdateIntegerAttributeOp(WorkingMoData workingMoData, String moTypeName, int newrev, String attrName, int attrValue, Coordinator context) {
        this.workingMoData = workingMoData;
        this.moTypeName = moTypeName;
        this.newRev = newrev;
        this.attrName = attrName;
        this.attrValue = attrValue;
        this.context = context;
    }

    public void execute() throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"execute()");
        Collection mos = this.workingMoData.getMoData(this.moTypeName);
        if (mos.isEmpty()) {
            MessageLog.trace((int)9, (Class)SELF, (String)("workingMoData does not contain any: " + this.moTypeName));
        } else {
            Iterator iter = mos.iterator();
            while (iter.hasNext()) {
                MoData moData = (MoData)iter.next();
                Attribute attr = moData.getAttribute(this.attrName);
                if (attr == null) {
                    throw new NoSuchAttributeException(this.attrName, this.moTypeName);
                }
                if (!(attr instanceof IntegerAttribute)) {
                    throw new WrongAttributeTypeException(this.attrName, this.moTypeName);
                }
                boolean notify = ((IntegerAttribute)attr).isAVCNotifier();
                MoDataHelper.activateWriteAccess(this.context, moData);
                MoDataHelper.deRegisterAttr(moData, attr);
                MoDataHelper.registerIntegerAttr(moData, null, this.attrName, notify, this.attrValue);
                moData.setRevision(this.newRev);
            }
        }
    }
}

