/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.Status;
import se.ericsson.wcdma.rbs.boam.upfwk.common.Const;
import se.ericsson.wcdma.rbs.boam.upfwk.data.Attribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.BooleanAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.DataCollectorStorage;
import se.ericsson.wcdma.rbs.boam.upfwk.data.FloatAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.IntegerAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.LongAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.ReferenceAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.SequenceAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.StringAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.StructAttribute;

public class CMoData
implements Serializable {
    public static final AccessType READ_ACCESS = new AccessType();
    public static final AccessType WRITE_ACCESS = new AccessType();
    private static int clLastPrimaryKey = 0;
    private static int[] clPrimaryKeyLock = new int[0];
    static final long serialVersionUID = 1L;
    private Vector persistentAttributes = null;
    private transient Vector transientAttributes = null;
    private String moType;
    private String moName;
    private transient Coordinator currentTransaction = null;
    private boolean isPersistent;
    private transient boolean isModified = false;
    private int revision;
    private int primaryKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMoData(String anLDName, String anMoTypeName, boolean isPersistent, Coordinator c) throws TransactionRequiredException {
        this.isPersistent = isPersistent;
        this.moType = anMoTypeName;
        this.moName = anLDName;
        int[] nArray = clPrimaryKeyLock;
        synchronized (clPrimaryKeyLock) {
            this.primaryKey = ++clLastPrimaryKey;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (isPersistent) {
                this.persistentAttributes = new Vector();
                if (c == null || c.getStatus() != Status.ACTIVE) {
                    throw new TransactionRequiredException();
                }
                try {
                    DataCollectorStorage database = DataCollectorStorage.instance();
                    database.createRow(c.getTransactionID(), this.primaryKey);
                }
                catch (DbAccessException e) {
                    Const.callAssert(false, "CMoData() could not get database :" + (Object)((Object)e));
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMoData(String data) {
        CMoDataStringHandler CMoDataString = new CMoDataStringHandler(data);
        this.moType = CMoDataString.nextSubstring();
        this.revision = Integer.parseInt(CMoDataString.nextSubstring());
        this.moName = CMoDataString.nextSubstring();
        this.primaryKey = Integer.parseInt(CMoDataString.nextSubstring());
        this.isPersistent = true;
        this.persistentAttributes = new Vector();
        CMoDataString.nextSubstring();
        String attrName = CMoDataString.nextSubstring();
        while (attrName != null && !attrName.equals("")) {
            String attrData = CMoDataString.nextSubstring();
            char id = attrData.charAt(0);
            if (id == 's') {
                this.registerPersistentAttr(new StringAttribute(attrName, attrData));
            } else if (id == 'i') {
                this.registerPersistentAttr(new IntegerAttribute(attrName, attrData));
            } else if (id == 'l') {
                this.registerPersistentAttr(new LongAttribute(attrName, attrData));
            } else if (id == 'b') {
                this.registerPersistentAttr(new BooleanAttribute(attrName, attrData));
            } else if (id == 'f') {
                this.registerPersistentAttr(new FloatAttribute(attrName, attrData));
            } else if (id == 'r') {
                this.registerPersistentAttr(new ReferenceAttribute(attrName, attrData));
            } else if (id == 'q') {
                this.registerPersistentAttr(new SequenceAttribute(attrName, attrData));
            } else if (id == 't') {
                this.registerPersistentAttr(new StructAttribute(attrName, attrData));
            }
            attrName = CMoDataString.nextSubstring();
        }
        int[] nArray = clPrimaryKeyLock;
        synchronized (clPrimaryKeyLock) {
            if (this.primaryKey > clLastPrimaryKey) {
                clLastPrimaryKey = this.primaryKey;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public Attribute getAttribute(String name) {
        Attribute a;
        Enumeration e;
        if (this.transientAttributes != null) {
            e = this.transientAttributes.elements();
            while (e.hasMoreElements()) {
                a = (Attribute)e.nextElement();
                if (!a.getName().equals(name)) continue;
                return a;
            }
        }
        if (this.persistentAttributes != null) {
            e = this.persistentAttributes.elements();
            while (e.hasMoreElements()) {
                a = (Attribute)e.nextElement();
                if (!a.getName().equals(name)) continue;
                return a;
            }
        }
        return null;
    }

    public Enumeration getAllPersistentAttributes() {
        if (this.persistentAttributes != null) {
            Enumeration e = this.persistentAttributes.elements();
            return e;
        }
        return null;
    }

    public String getLocalDistinguishedName() {
        return this.moName;
    }

    public String getMoTypeName() {
        return this.moType;
    }

    public void registerTransientAttr(Attribute anAttr) {
        Const.callAssert(this.getAttribute(anAttr.getName()) == null, "CMoData.registerTransientAttr() Attribute already  registered, attrname :" + anAttr.getName());
        if (this.transientAttributes == null) {
            this.transientAttributes = new Vector();
        }
        this.transientAttributes.addElement(anAttr);
    }

    public void registerPersistentAttr(Attribute anAttr) {
        Const.callAssert(this.getAttribute(anAttr.getName()) == null, "CMoData.registerPersistentAttr() Attribute already  registered, attrname :" + anAttr.getName());
        Const.callAssert(this.isPersistent, "CMoData.registerAttribute() Only transient attributescan be added since this object is transient");
        this.persistentAttributes.addElement(anAttr);
    }

    public void deregisterAttribute(Attribute anAttr) {
        Const.callAssert(this.getAttribute(anAttr.getName()), "CMoData.deregisterAttribute No such attribute registered");
        if (this.transientAttributes != null) {
            this.transientAttributes.removeElement(anAttr);
        }
        if (this.persistentAttributes != null) {
            this.persistentAttributes.removeElement(anAttr);
        }
    }

    public void deregisterAttribute(String name) {
        Attribute attr = this.getAttribute(name);
        if (attr != null) {
            this.deregisterAttribute(attr);
        }
    }

    private synchronized void commit() {
        Attribute a;
        Enumeration e;
        Const.callAssert(this.currentTransaction != null);
        Vector<Attribute> modifiedAttrs = new Vector<Attribute>();
        if (this.transientAttributes != null) {
            e = this.transientAttributes.elements();
            while (e.hasMoreElements()) {
                a = (Attribute)e.nextElement();
                if (a.isAVCNotifier() && a.isModified()) {
                    modifiedAttrs.addElement(a);
                }
                a.commit();
            }
        }
        if (this.persistentAttributes != null) {
            e = this.persistentAttributes.elements();
            while (e.hasMoreElements()) {
                a = (Attribute)e.nextElement();
                if (a.isAVCNotifier() && a.isModified()) {
                    modifiedAttrs.addElement(a);
                }
                a.commit();
            }
        }
        this.currentTransaction = null;
        this.notifyAll();
    }

    private synchronized boolean prepare() {
        Const.callAssert(this.currentTransaction, "prepare, no tx active");
        if (this.isPersistent && this.isModified) {
            try {
                String stringToWrite = this.buildString();
                ByteArrayOutputStream arr = new ByteArrayOutputStream(stringToWrite.length());
                ObjectOutputStream out = new ObjectOutputStream(arr);
                out.writeObject(stringToWrite);
                out.flush();
                DataCollectorStorage database = DataCollectorStorage.instance();
                database.updateRow(this.currentTransaction.getTransactionID(), this.primaryKey, arr.toByteArray());
                out.close();
            }
            catch (IOException e) {
                Const.callAssert(false, "CMoData.prepare exception :" + e);
                return false;
            }
            catch (DbAccessException e) {
                Const.callAssert(false, "Modata.prepare exception :" + (Object)((Object)e));
                return false;
            }
        }
        return true;
    }

    private String buildString() {
        StringBuffer stringData = new StringBuffer(200);
        stringData.append(this.getCMoDataAttributes());
        this.persistentAttributes.trimToSize();
        Enumeration data = this.persistentAttributes.elements();
        while (data.hasMoreElements()) {
            Attribute attr = (Attribute)data.nextElement();
            stringData.append(attr.buildString() + "^");
        }
        return stringData.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws ClassNotFoundException, NotActiveException, IOException {
        in.defaultReadObject();
        int[] nArray = clPrimaryKeyLock;
        synchronized (clPrimaryKeyLock) {
            if (this.primaryKey > clLastPrimaryKey) {
                clLastPrimaryKey = this.primaryKey;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private synchronized void rollback() {
        Attribute a;
        Enumeration e;
        Const.callAssert(this.currentTransaction, "rollback, no tx active");
        if (this.transientAttributes != null) {
            e = this.transientAttributes.elements();
            while (e.hasMoreElements()) {
                a = (Attribute)e.nextElement();
                a.rollback();
            }
        }
        if (this.persistentAttributes != null) {
            e = this.persistentAttributes.elements();
            while (e.hasMoreElements()) {
                a = (Attribute)e.nextElement();
                a.rollback();
            }
        }
        this.currentTransaction = null;
        this.notifyAll();
    }

    public void delete(Coordinator c) throws TransactionRequiredException {
        if (this.isPersistent) {
            if (c == null || c.getStatus() != Status.ACTIVE) {
                throw new TransactionRequiredException();
            }
            try {
                DataCollectorStorage database = DataCollectorStorage.instance();
                database.deleteRow(c.getTransactionID(), this.primaryKey);
                this.isModified = false;
            }
            catch (DbAccessException e) {
                MessageLog.traceError(this.getClass(), (String)"DB Access exception: ", (Throwable)e);
                Const.callAssert(false, "CMoData.delete exception :" + (Object)((Object)e));
            }
        }
    }

    public synchronized void handleTransaction(Coordinator context, AccessType accessType) throws TransactionRequiredException {
        if (context == null) {
            if (accessType == READ_ACCESS) {
                return;
            }
            throw new TransactionRequiredException();
        }
        if (context.getStatus() != Status.ACTIVE) {
            throw new TransactionRequiredException();
        }
        if (this.currentTransaction == null || !this.currentTransaction.isSameTransaction(context)) {
            try {
                while (this.currentTransaction != null) {
                    this.wait(1000L);
                }
                this.startTransaction(context);
            }
            catch (InterruptedException e) {
                Const.callAssert(false, "CMoData Unexpected exception :" + e);
            }
        }
        if (accessType == WRITE_ACCESS) {
            this.isModified = true;
        }
    }

    public synchronized void handleTransactionNonBlocking(Coordinator context, AccessType accessType) throws ResourceLockedException, TransactionRequiredException {
        if (context == null) {
            if (accessType == READ_ACCESS) {
                return;
            }
            throw new TransactionRequiredException();
        }
        if (context.getStatus() != Status.ACTIVE) {
            throw new TransactionRequiredException();
        }
        if (this.currentTransaction == null) {
            this.startTransaction(context);
        } else if (!this.currentTransaction.isSameTransaction(context)) {
            throw new ResourceLockedException(this.moName);
        }
        if (accessType == WRITE_ACCESS) {
            this.isModified = true;
        }
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    private void startTransaction(Coordinator c) throws TransactionRequiredException {
        Attribute a;
        Enumeration attr;
        Const.callAssert(this.currentTransaction == null, "Already started");
        try {
            c.registerResource((Resource)new CMoDataTxResource(this));
        }
        catch (InactiveTransactionException e) {
            throw new TransactionRequiredException();
        }
        this.currentTransaction = c;
        this.isModified = false;
        if (this.transientAttributes != null) {
            attr = this.transientAttributes.elements();
            while (attr.hasMoreElements()) {
                a = (Attribute)attr.nextElement();
                a.startTransaction();
            }
        }
        if (this.persistentAttributes != null) {
            attr = this.persistentAttributes.elements();
            while (attr.hasMoreElements()) {
                a = (Attribute)attr.nextElement();
                a.startTransaction();
            }
        }
    }

    private String getCMoDataAttributes() {
        return this.moType + "^" + String.valueOf(this.revision) + "^" + this.moName + "^" + String.valueOf(this.primaryKey) + "^" + String.valueOf(clLastPrimaryKey) + "^";
    }

    private class CMoDataStringHandler {
        private String str;
        private int index = 0;
        private boolean eos = false;

        CMoDataStringHandler(String data) {
            this.str = data;
        }

        public String nextSubstring() {
            if (this.eos) {
                return null;
            }
            int tmpIndex = this.str.indexOf(94, this.index) + 1;
            if (tmpIndex == 0) {
                this.eos = true;
                return this.str.substring(this.index);
            }
            int readFrom = this.index;
            this.index = tmpIndex;
            if (readFrom == this.index) {
                return "";
            }
            return this.str.substring(readFrom, this.index - 1);
        }
    }

    private static class CMoDataTxResource
    implements Resource {
        private CMoData delegate;

        public CMoDataTxResource(CMoData CMoData2) {
            this.delegate = CMoData2;
        }

        public void commit() {
            this.delegate.commit();
        }

        public boolean prepare() {
            return this.delegate.prepare();
        }

        public void rollback() {
            this.delegate.rollback();
        }
    }

    public static class AccessType {
        AccessType() {
        }
    }
}

