/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.data;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Vector;
import se.ericsson.cello.support.debug.MessageLog;

public class DumpDataStorage {
    private static DumpDataStorage theInstance = null;
    private static final String TABLE_NAME = "MoDataFile";
    private static String FILE_PATH_PREFIX_OUT = System.getProperty("MODUMP_FILE_PREFIX_OUT", "/c/");
    private static String FILE_PATH_SUFFIX_OUT = System.getProperty("MODUMP_FILE_SUFFIX_OUT", ".dump");
    private static String FILE_PATH_PREFIX_IN = System.getProperty("MODUMP_FILE_PREFIX_IN", "/tmp/");
    private static String FILE_PATH_SUFFIX_IN = System.getProperty("MODUMP_FILE_SUFFIX_IN", ".dat");
    private String moDataFilePath = "MoDataFile";
    private Vector moDataTable;
    private Vector moCollectedDataTable;

    private DumpDataStorage() {
    }

    public static synchronized DumpDataStorage instance() {
        if (theInstance == null) {
            theInstance = new DumpDataStorage();
        }
        return theInstance;
    }

    public static synchronized void setFileOut(String path, String suffix) {
        FILE_PATH_PREFIX_OUT = path;
        FILE_PATH_SUFFIX_OUT = suffix;
    }

    public static synchronized void setFileIn(String path, String suffix) {
        FILE_PATH_PREFIX_IN = path;
        FILE_PATH_SUFFIX_IN = suffix;
    }

    public void save() {
        try {
            FileOutputStream fileOut = new FileOutputStream(FILE_PATH_PREFIX_OUT + this.moDataFilePath + FILE_PATH_SUFFIX_OUT);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            if (this.moCollectedDataTable != null) {
                HashMap<String, Vector> dumpObjectsMap = new HashMap<String, Vector>();
                dumpObjectsMap.put("moData", this.moDataTable);
                dumpObjectsMap.put("moCollectedData", this.moCollectedDataTable);
                out.writeObject(dumpObjectsMap);
            } else {
                out.writeObject(this.moDataTable);
            }
            out.close();
            MessageLog.info(this.getClass(), (String)("save(), MoData dump is saved successfully!! File: " + FILE_PATH_PREFIX_OUT + this.moDataFilePath + FILE_PATH_SUFFIX_OUT));
        }
        catch (Exception e) {
            MessageLog.info(this.getClass(), (String)"save(), MoData dump saving failed!!");
        }
    }

    public void load() {
        try {
            FileInputStream fileIn = new FileInputStream(FILE_PATH_PREFIX_IN + this.moDataFilePath + FILE_PATH_SUFFIX_IN);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            Object obj = in.readObject();
            in.close();
            if (obj instanceof Vector) {
                this.moDataTable = (Vector)obj;
                this.moCollectedDataTable = null;
            }
            if (obj instanceof HashMap) {
                HashMap dumpObjectsMap = (HashMap)obj;
                this.moDataTable = (Vector)dumpObjectsMap.get("moData");
                this.moCollectedDataTable = (Vector)dumpObjectsMap.get("moCollectedData");
            }
            MessageLog.info(this.getClass(), (String)("load(), Mo dump recovery done successfully!! file: " + FILE_PATH_PREFIX_IN + this.moDataFilePath + FILE_PATH_SUFFIX_IN));
        }
        catch (Exception e) {
            MessageLog.info(this.getClass(), (String)"load(), Mo dump recovery failed!!");
        }
    }

    public void setMoData(Vector moDataList, Vector moCollectedDataList) {
        this.moDataTable = moDataList;
        this.moCollectedDataTable = moCollectedDataList;
    }

    public Vector getMoCollectedData() {
        return this.moCollectedDataTable;
    }

    public Vector getMoData() {
        return this.moDataTable;
    }
}

