/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.Const;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.DataCollectorStorage;

public class RecoveryHandler {
    private static boolean isRecoveryDone = false;
    private static Vector mos = null;
    private static final Class SELF = RecoveryHandler.class;

    public static Vector getCollectedMoData() {
        if (!isRecoveryDone) {
            isRecoveryDone = true;
            RecoveryHandler.recover();
        }
        return mos;
    }

    private static Vector recover() {
        DataCollectorStorage moStorage = null;
        int[] primaryKeys = null;
        byte[] byteArray = null;
        ByteArrayInputStream inStream = null;
        ObjectInputStream objIn = null;
        Object obj = null;
        CMoData moData = null;
        try {
            moStorage = DataCollectorStorage.instance();
            moStorage.connectToDatabase();
            primaryKeys = moStorage.retrieveAllPrimaryKeys();
            Const.callAssert(primaryKeys, "RecoveryHandler.getCollectedMoData primaryKeys");
            mos = new Vector(primaryKeys.length);
            for (int i = 0; i < primaryKeys.length; ++i) {
                byteArray = moStorage.retrieveRow(primaryKeys[i]);
                inStream = new ByteArrayInputStream(byteArray);
                objIn = new ObjectInputStream(inStream);
                obj = objIn.readObject();
                moData = obj instanceof String ? new CMoData((String)obj) : (CMoData)obj;
                mos.addElement(moData);
            }
            moStorage.disconnectFromDatabase();
        }
        catch (DbAccessException e) {
            Const.callAssert(false, "RecoveryHandler getCollectedMoData() exception :" + (Object)((Object)e));
        }
        catch (OptionalDataException e) {
            Const.callAssert(false, "RecoveryHandler getCollectedMoData() exception :" + e);
        }
        catch (ClassNotFoundException e) {
            Const.callAssert(false, "RecoveryHandler getCollectedMoData() exception :" + e);
        }
        catch (StreamCorruptedException e) {
            Const.callAssert(false, "RecoveryHandler getCollectedMoData() exception :" + e);
        }
        catch (IOException e) {
            Const.callAssert(false, "RecoveryHandler getCollectedMoData() exception :" + e);
        }
        return mos;
    }

    public static void forceRecovery() {
        isRecoveryDone = false;
    }

    public static void cleanCMoData(Coordinator context) throws TransactionRequiredException {
        Vector cMoDataList = RecoveryHandler.getCollectedMoData();
        Iterator iter = cMoDataList.iterator();
        while (iter.hasNext()) {
            CMoData cMoData = (CMoData)iter.next();
            MessageLog.trace((int)9, (Class)SELF, (String)("Deleting CMoData: " + cMoData.getLocalDistinguishedName()));
            cMoData.handleTransaction(context, CMoData.WRITE_ACCESS);
            cMoData.delete(context);
        }
        RecoveryHandler.forceRecovery();
    }
}

