/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.data;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.Const;
import se.ericsson.wcdma.rbs.boam.upfwk.data.Attribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.BooleanAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.FloatAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.IntegerAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.LongAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.SequenceAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.StringAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.StructImpl;

public class StructAttribute
extends Attribute
implements Serializable {
    private static final long serialVersionUID = 7822254650840246643L;
    private Vector myValue = new Vector();
    private transient Vector myValueBackup = null;

    public StructAttribute(String name, boolean isAttrValueChangeNotifier) {
        super(name, isAttrValueChangeNotifier);
    }

    public StructAttribute(String name, String attrData) {
        super(name, attrData.charAt(1));
        StructStringHandler structString = new StructStringHandler(attrData.substring(2));
        int noOfAttributes = Integer.parseInt(structString.nextSubstring());
        String attributeName = structString.nextSubstring();
        for (int i = 0; i < noOfAttributes; ++i) {
            String attributeData = structString.nextSubstring();
            char id = attributeData.charAt(0);
            if (id == 's') {
                this.addElement(new StringAttribute(attributeName, attributeData));
            } else if (id == 'i') {
                this.addElement(new IntegerAttribute(attributeName, attributeData));
            } else if (id == 'l') {
                this.addElement(new LongAttribute(attributeName, attributeData));
            } else if (id == 'b') {
                this.addElement(new BooleanAttribute(attributeName, attributeData));
            } else if (id == 'f') {
                this.addElement(new FloatAttribute(attributeName, attributeData));
            } else if (id != 'r') {
                if (id == 'q') {
                    this.addElement(new SequenceAttribute(attributeName, attributeData));
                } else if (id == 't') {
                    attributeData = attributeData + '\u00a4' + structString.nextSubstringForStruct();
                    this.addElement(new StructAttribute(attributeName, attributeData));
                }
            }
            attributeName = structString.nextSubstring();
        }
    }

    public synchronized Attribute[] getElements(Coordinator c) {
        if (c == null && this.myValueBackup != null) {
            Object[] arr = new Attribute[this.myValueBackup.size()];
            this.myValueBackup.copyInto(arr);
            return arr;
        }
        Object[] arr = new Attribute[this.myValue.size()];
        this.myValue.copyInto(arr);
        return arr;
    }

    Attribute getElement(String name, Coordinator c) {
        if (c == null && this.myValueBackup != null) {
            return this.lookup(name, this.myValueBackup);
        }
        return this.lookup(name, this.myValue);
    }

    private Attribute lookup(String name, Vector attrs) {
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute a = (Attribute)attrs.elementAt(i);
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public synchronized void addElement(Attribute a) {
        Const.callAssert(this.getElement(a.getName(), null) == null, "Element already registered");
        this.myValue.addElement(a);
    }

    public synchronized boolean removeElement(Attribute a) {
        return this.myValue.removeElement(a);
    }

    public synchronized boolean isEmpty() {
        return this.myValue.isEmpty();
    }

    public synchronized Enumeration elements() {
        return this.myValue.elements();
    }

    public synchronized int size() {
        return this.myValue.size();
    }

    synchronized void startTransaction() {
        this.myValueBackup = (Vector)this.myValue.clone();
        Enumeration e = this.myValue.elements();
        while (e.hasMoreElements()) {
            Attribute attr = (Attribute)e.nextElement();
            attr.startTransaction();
        }
    }

    synchronized void commit() {
        this.myValueBackup = null;
    }

    synchronized void rollback() {
        this.myValue = this.myValueBackup;
        this.myValueBackup = null;
        if (this.myValue == null) {
            this.myValue = new Vector();
        }
        Enumeration e = this.myValue.elements();
        while (e.hasMoreElements()) {
            Attribute attr = (Attribute)e.nextElement();
            attr.rollback();
        }
    }

    Object getValueAsObject(Coordinator c) {
        Vector value = c == null && this.myValueBackup != null ? this.myValueBackup : this.myValue;
        String[] elementNames = new String[value.size()];
        Object[] elementValues = new Object[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            Attribute a = (Attribute)value.elementAt(i);
            elementNames[i] = a.getName();
            elementValues[i] = a.getValueAsObject(c);
        }
        return new StructImpl(elementNames, elementValues);
    }

    boolean isModified() {
        Enumeration e = this.myValue.elements();
        while (e.hasMoreElements()) {
            Attribute attr = (Attribute)e.nextElement();
            if (!attr.isModified()) continue;
            return true;
        }
        return false;
    }

    public String buildString() {
        StringBuffer sb = new StringBuffer(64);
        if (this.isAVCNotifier()) {
            sb.append("T");
        } else {
            sb.append("F");
        }
        sb.append(this.size());
        sb.append("\u00a4");
        for (int i = 0; i < this.myValue.size(); ++i) {
            Attribute a = (Attribute)this.myValue.elementAt(i);
            sb.append(a.buildString());
            sb.append("\u00a4");
        }
        return this.getName() + "^t" + sb.toString().replace('^', '\u00a4');
    }

    private class StructStringHandler {
        private String str;
        private int index = 0;
        private boolean eos = false;

        StructStringHandler(String data) {
            this.str = data;
        }

        public String nextSubstring() {
            if (this.eos) {
                return null;
            }
            int tmpIndex = this.str.indexOf(164, this.index) + 1;
            if (tmpIndex == 0) {
                this.eos = true;
                return this.str.substring(this.index);
            }
            int readFrom = this.index;
            this.index = tmpIndex;
            if (readFrom == this.index) {
                return "";
            }
            return this.str.substring(readFrom, this.index - 1);
        }

        public String nextSubstringForStruct() {
            if (this.eos) {
                return null;
            }
            int tmpIndex = this.str.indexOf("\u00a4\u00a4", this.index) + 2;
            if (tmpIndex == 1) {
                this.eos = true;
                return this.str.substring(this.index);
            }
            int readFrom = this.index;
            this.index = tmpIndex;
            if (readFrom == this.index) {
                return "";
            }
            return this.str.substring(readFrom, this.index - 1);
        }
    }
}

