/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.database.polyhedra;

import com.polyhedra.sql.BatchUpdateException;
import com.polyhedra.sql.Connection;
import com.polyhedra.sql.SQLException;
import com.polyhedra.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DbAccessException;
import se.ericsson.wcdma.rbs.boam.upfwk.database.ResultSet;
import se.ericsson.wcdma.rbs.boam.upfwk.database.Sql;
import se.ericsson.wcdma.rbs.boam.upfwk.database.polyhedra.DbConnector;

public class Database
implements se.ericsson.wcdma.rbs.boam.upfwk.database.Database {
    Connection _connection;
    SqlBatch _pendingUpdates = new SqlBatch();

    public Database() throws DbAccessException {
        try {
            this._connection = DbConnector.instance().getConnection();
        }
        catch (SQLException e) {
            throw new DbAccessException((Exception)((Object)e));
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() throws DbAccessException {
        if (this._pendingUpdates.size() == 0) {
            return;
        }
        MessageLog.traceEnter(this.getClass(), (String)"commit()");
        Statement stmt = null;
        stmt = this._connection.createStatement();
        Iterator i = this._pendingUpdates.iterator();
        while (i.hasNext()) {
            String sql = (String)i.next();
            MessageLog.trace((int)9, this.getClass(), (String)("execute sql statement :" + sql));
            stmt.execute(sql);
        }
        Object var5_6 = null;
        this._pendingUpdates.clear();
        if (stmt == null) return;
        try {
            stmt.close();
            return;
        }
        catch (SQLException e) {
            MessageLog.trace((int)9, this.getClass(), (String)("unexpected exception :" + (Object)((Object)e)));
        }
        return;
        {
            catch (BatchUpdateException e) {
                throw new DbAccessException((Exception)((Object)e.getNextException()));
            }
            catch (SQLException e) {
                throw new DbAccessException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this._pendingUpdates.clear();
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                MessageLog.trace((int)9, this.getClass(), (String)("unexpected exception :" + (Object)((Object)e)));
            }
            throw throwable;
        }
    }

    public void executeSql(Sql.Modification sql) throws DbAccessException {
        this._pendingUpdates.addModification(sql);
        if (this._pendingUpdates.isCommitNeeded()) {
            this.commit();
        } else if (sql instanceof Sql.CreateTable) {
            this.commit();
        } else if (sql instanceof Sql.DropTable) {
            this.commit();
        }
    }

    public ResultSet executeQuery(Sql.Select sql) throws DbAccessException {
        return this.executeQuery(sql, false, false);
    }

    public ResultSet executeQuery(Sql.Select sql, boolean isScrollable, boolean isUpdateable) throws DbAccessException {
        try {
            this.commit();
            int scroll = isScrollable ? 1005 : 1003;
            int update = isUpdateable ? 1008 : 1007;
            Statement stmt = this._connection.createStatement(scroll, update);
            String sqlString = ((Object)sql).toString();
            MessageLog.trace((int)9, this.getClass(), (String)("executeQuery :" + sqlString));
            com.polyhedra.sql.ResultSet resSet = stmt.executeQuery(sqlString);
            return new se.ericsson.wcdma.rbs.boam.upfwk.database.polyhedra.ResultSet(resSet);
        }
        catch (SQLException e) {
            throw new DbAccessException((Exception)((Object)e));
        }
    }

    public String getPrimaryKey(String table) throws DbAccessException {
        return "theclientsuniqueid";
    }

    public ResultSet getTables() throws DbAccessException {
        try {
            this.commit();
            String[] types = new String[]{"TABLE"};
            com.polyhedra.sql.ResultSet tables = this._connection.getMetaData().getTables(null, null, "%", types);
            return new se.ericsson.wcdma.rbs.boam.upfwk.database.polyhedra.ResultSet(tables);
        }
        catch (SQLException e) {
            throw new DbAccessException((Exception)((Object)e));
        }
    }

    public boolean tableExists(String table) throws DbAccessException {
        try {
            this.commit();
            com.polyhedra.sql.ResultSet tables = this._connection.getMetaData().getTables(null, null, table, null);
            boolean res = tables.next();
            tables.close();
            return res;
        }
        catch (SQLException e) {
            throw new DbAccessException((Exception)((Object)e));
        }
    }

    class SqlBatch
    extends LinkedList {
        private static final long serialVersionUID = 8884331515698661031L;
        int _totSize = 0;

        SqlBatch() {
        }

        public void addModification(Sql.Modification sql) throws DbAccessException {
            String str = ((Object)sql).toString();
            this.add(str);
            this._totSize += str.length();
        }

        public boolean isCommitNeeded() {
            return this._totSize > 5120;
        }

        public void clear() {
            super.clear();
            this._totSize = 0;
        }
    }
}

