/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.frodata;

import se.ericsson.wcdma.rbs.boam.upfwk.database.Database;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DatabaseMgr;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DbAccessException;
import se.ericsson.wcdma.rbs.boam.upfwk.database.ResultSet;
import se.ericsson.wcdma.rbs.boam.upfwk.database.ResultSetMetaData;
import se.ericsson.wcdma.rbs.boam.upfwk.database.Sql;

public class TableCopier {
    protected String _t1;
    protected String _t2;
    protected Database _db;
    protected Sql _sql;

    public TableCopier(String t1, String t2) throws DbAccessException {
        this._t1 = t1;
        this._t2 = t2;
        this._db = DatabaseMgr.getDatabase();
        this._sql = DatabaseMgr.getSql();
    }

    protected int getColumnNumber(String name, ResultSetMetaData md) throws DbAccessException {
        int cols = md.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            if (!md.getColumnName(i).equals(name)) continue;
            return i;
        }
        throw new DbAccessException(new TableCopyException("Column not found  :" + name));
    }

    private void createT2(ResultSetMetaData t1MetaData) throws DbAccessException {
        String t1primaryKey = this._db.getPrimaryKey(this._t1);
        Sql.CreateTable create = this._sql.createTable(this._t2);
        int t1Cols = t1MetaData.getColumnCount();
        for (int i = 1; i <= t1Cols; ++i) {
            String t2ColName = this.getT2ColumnName(t1MetaData.getColumnName(i));
            String t2ColType = this.getT2ColumnType(t1MetaData.getColumnSqlTypeName(i));
            if (t2ColName.equals(t1primaryKey)) {
                create.addPrimaryKey(t2ColName, t2ColType);
                continue;
            }
            if (!t1MetaData.isColumnNullable(i)) {
                create.addColumn(t2ColName, t2ColType, "NOT NULL");
                continue;
            }
            create.addColumn(t2ColName, t2ColType);
        }
        this.addNewColumns(create);
        this._db.executeSql(create);
    }

    public void convert() throws DbAccessException {
        if (!this._db.tableExists(this._t1)) {
            throw new DbAccessException(new TableCopyException("Table does not exist :" + this._t1));
        }
        if (this._db.tableExists(this._t2)) {
            throw new DbAccessException(new TableCopyException("Table already created :" + this._t2));
        }
        ResultSet t1 = this._db.executeQuery(this._sql.selectAll(this._t1));
        ResultSetMetaData t1MetaData = t1.getMetaData();
        this.createT2(t1MetaData);
        int t1Cols = t1MetaData.getColumnCount();
        while (t1.next()) {
            Sql.Insert insert = this._sql.insert(this._t2);
            for (int i = 1; i <= t1Cols; ++i) {
                Object t1Value = t1.getObject(i);
                insert.addValue(this.getT2Value(i, t1Value));
            }
            this.addNewValues(insert);
            this._db.executeSql(insert);
        }
        this._db.commit();
        t1.close();
    }

    protected String getT2PrimaryKey(String t1PrimKey) throws DbAccessException {
        return t1PrimKey;
    }

    protected void addNewColumns(Sql.CreateTable create) throws DbAccessException {
    }

    protected String getT2PrimaryKeyDataType(String t1PrimaryKeyDataType) throws DbAccessException {
        return t1PrimaryKeyDataType;
    }

    protected String getT2ColumnName(String t1ColName) throws DbAccessException {
        return t1ColName;
    }

    protected String getT2ColumnType(String t1ColType) throws DbAccessException {
        return t1ColType;
    }

    protected Object getT2Value(int t1Col, Object t1Value) throws DbAccessException {
        return t1Value;
    }

    protected void addNewValues(Sql.Insert insert) throws DbAccessException {
    }

    private static class TableCopyException
    extends Exception {
        private static final long serialVersionUID = 1530411194592640287L;
        private String _msg;

        TableCopyException(String msg) {
            this._msg = msg;
        }

        public String toString() {
            return "Merge of table failed." + this._msg;
        }
    }
}

