/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe;

import java.awt.BorderLayout;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.nex.DestroyableEmbeddable;
import se.ericsson.cello.swe.LdnMvcContainer;
import se.ericsson.cello.swe.SweLog;
import se.ericsson.cello.swe.UpLdnMvcContainerImpl;
import se.ericsson.cello.swe.service.Configuration;
import se.ericsson.cello.swe.service.ConfigurationFactory;
import se.ericsson.cello.swe.service.SweToolServiceFactory;
import se.ericsson.cello.swe.service.SweToolServices;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationListenerInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationServiceInterface;

public class UpSweEmbeddable
implements DestroyableEmbeddable {
    private LauncherInterface myLauncher;
    private static String myHost = null;
    private int myNrOfRunCalls = 0;
    private SweToolServices myToolServices = null;
    private NodeServices myNodeServices = null;
    private Configuration myConfigurationHandler = null;
    private Properties myParameters = null;
    private Launchable myNexLaunchable = null;
    private JPanel myComponent = null;
    private LdnMvcContainer myLdnMvcContainer = null;
    private UpAddDeleteListener myUpAddDeleteListener = null;
    private final String upTypeAdd = "se.ericsson.cello.emas.sm.UP_CREATED";
    private final String upTypeDelete = "se.ericsson.cello.emas.sm.UP_DELETED";
    private final String moTypeAdd = "se.ericsson.cello.emt.moadd.MO_ADDED";
    private final String moTypeDelete = "se.ericsson.cello.nex.MO_DELETED";
    private static final String NEX_UP_TABNAME = "UP";

    public JComponent getComponent() {
        if (null == this.myComponent) {
            this.myComponent = new JPanel();
            this.myComponent.setLayout(new BorderLayout());
            this.myComponent.setName(NEX_UP_TABNAME);
        }
        return this.myComponent;
    }

    public String getName() {
        return "   UP   ";
    }

    public void init(Properties nexProps, Launchable nex, LauncherInterface theLauncher) {
        try {
            ++this.myNrOfRunCalls;
            SweLog.logger().log(Level.INFO, "myNrOfRunCalls=" + this.myNrOfRunCalls);
            this.myLauncher = theLauncher;
            myHost = nexProps.getProperty("HOST", "Host is not defined");
            this.myParameters = nexProps;
            this.myNexLaunchable = nex;
            this.myConfigurationHandler = ConfigurationFactory.createConfiguration(myHost, this.myParameters);
            this.myToolServices = SweToolServiceFactory.createToolServices(nex, this.myLauncher, this.myConfigurationHandler, null);
            this.myNodeServices = this.myToolServices.getNodeServices();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.getComponent();
        this.fillComponent();
        if (this.myLauncher instanceof EmNotificationServiceInterface) {
            SweLog.logger().log(Level.INFO, "Create an UP listener");
            this.myUpAddDeleteListener = new UpAddDeleteListener();
            EmNotificationServiceInterface ensi = (EmNotificationServiceInterface)this.myLauncher;
            ensi.addEmNotificationListener((EmNotificationListenerInterface)this.myUpAddDeleteListener);
        } else {
            SweLog.logger().log(Level.INFO, "Did not create an UP listener, launcher is not a notification service");
        }
    }

    public void setLDNs(String[] LDNs) {
        this.myToolServices.sendEmNotification("UP table updated", GuiTestEventTypes.UP_PANEL_UPDATED, null, null);
    }

    private void fillComponent() {
        String ldn = "ManagedElement=1,SwManagement=1";
        this.myComponent.removeAll();
        SweLog.logger().log(Level.INFO, " myParameters " + this.myParameters);
        if (System.getProperty("se.ericsson.cello.swe.debug", "NotDefined").equalsIgnoreCase("true")) {
            this.myParameters.put("SWE_UP_HYPER_TOOL_KEYS", "NEX;MOPROPERTIES;MOSEARCH;UPPROPERTIES");
            this.myParameters.put("MOPROPERTIES_NAME", "Mo Properties");
            this.myParameters.put("MOSEARCH_NAME", "Mo Search");
            this.myParameters.put("UPPROPERTIES_NAME", "UP Properties");
            this.myParameters.put("MOPROPERTIES_CONFIG", "/cello/emas/mopropcfg.xml");
            this.myParameters.put("MOSEARCH_CONFIG", "/cello/emas/mosearchcfg.xml");
            this.myParameters.put("UPPROPERTIES_CONFIG", "/cello/emas/upcfg.xml");
        }
        this.myLdnMvcContainer = new UpLdnMvcContainerImpl(ldn, this.myNodeServices, this.myConfigurationHandler, this.myNexLaunchable, this.myLauncher);
        this.myComponent.add(this.myLdnMvcContainer.getComponent());
        this.myLdnMvcContainer.doStart();
        this.myComponent.revalidate();
    }

    public void onLdnMvcContainerExit(LdnMvcContainer aContainer) {
    }

    public void destroy() {
        if (this.myLauncher instanceof EmNotificationServiceInterface) {
            if (this.myUpAddDeleteListener != null) {
                EmNotificationServiceInterface ensi = (EmNotificationServiceInterface)this.myLauncher;
                ensi.removeEmNotificationListener((EmNotificationListenerInterface)this.myUpAddDeleteListener);
                this.myUpAddDeleteListener = null;
                SweLog.logger().log(Level.INFO, "Removed the UP listener");
            } else {
                SweLog.logger().log(Level.WARNING, "Expected to find an active notification listener, but it is not active");
            }
        } else {
            SweLog.logger().log(Level.INFO, "Did not remove the UP listener, launcher is not a notification service");
        }
        SweToolServiceFactory.destroy();
        this.myLdnMvcContainer.doStop();
    }

    private class UpAddDeleteListener
    implements EmNotificationListenerInterface {
        public void notificationFromEM(EmEventInterface event) {
            String messageType = event.getType();
            Object objectUserData = event.getUserData();
            String userData = null;
            if (objectUserData != null) {
                userData = objectUserData.toString();
            }
            SweLog.logger().log(Level.FINE, "NotificationFromEM, userData=" + userData);
            String id = this.findUpgradePackageId(userData);
            if (messageType.equals("se.ericsson.cello.emas.sm.UP_CREATED") || messageType.equals("se.ericsson.cello.emas.sm.UP_DELETED") || messageType.equals("se.ericsson.cello.emt.moadd.MO_ADDED") && id != null || messageType.equals("se.ericsson.cello.nex.MO_DELETED") && id != null) {
                UpSweEmbeddable.this.myLdnMvcContainer.refresh(id);
            }
        }

        private String findUpgradePackageId(Object userData) {
            String moLeaf;
            int positionEqual;
            int positionUP;
            String stringLdn;
            int positionLastComma;
            String result = null;
            if (userData instanceof String && (positionLastComma = (stringLdn = (String)userData).lastIndexOf(44)) > -1 && (positionUP = stringLdn.indexOf("UpgradePackage=", positionLastComma)) > -1 && (positionEqual = (moLeaf = stringLdn.substring(positionUP)).indexOf(61)) > -1) {
                try {
                    result = moLeaf.substring(positionEqual + 1);
                }
                catch (Exception e) {
                    SweLog.logger().log(Level.INFO, "Strange format of the LDN " + stringLdn);
                }
            }
            return result;
        }
    }
}

