/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.util.ObjectUtil;
import org.omg.CONV_FRAME.CodeSetComponentHelper;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHelper;

public class TaggedComponentList
implements Cloneable {
    private TaggedComponent[] components;

    public TaggedComponentList(InputStream in) {
        this.components = TaggedComponentSeqHelper.read(in);
    }

    public TaggedComponentList(byte[] data) {
        CDRInputStream in = new CDRInputStream(data);
        in.openEncapsulatedArray();
        this.components = TaggedComponentSeqHelper.read(in);
    }

    public TaggedComponentList() {
        this.components = new TaggedComponent[0];
    }

    public int size() {
        return this.components.length;
    }

    public boolean isEmpty() {
        return this.components.length == 0;
    }

    public TaggedComponent get(int index) {
        return this.components[index];
    }

    public Object clone() throws CloneNotSupportedException {
        TaggedComponentList result = (TaggedComponentList)super.clone();
        result.components = new TaggedComponent[this.components.length];
        for (int i2 = 0; i2 < this.components.length; ++i2) {
            result.components[i2] = new TaggedComponent(this.components[i2].tag, new byte[this.components[i2].component_data.length]);
            System.arraycopy(this.components[i2].component_data, 0, result.components[i2].component_data, 0, this.components[i2].component_data.length);
        }
        return result;
    }

    public TaggedComponent[] asArray() {
        return this.components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponent(int tag, Object data, Class helper) {
        try {
            Method writeMethod = helper.getMethod("write", OutputStream.class, data.getClass());
            CDROutputStream out = new CDROutputStream();
            try {
                out.beginEncapsulatedArray();
                writeMethod.invoke(null, out, data);
                this.addComponent(tag, out.getBufferCopy());
            }
            finally {
                out.close();
            }
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Helper " + helper.getName() + " has no appropriate write() method.");
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Cannot access write() method of helper " + helper.getName());
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Exception while marshaling component data: " + ex.getTargetException());
        }
    }

    public void addComponent(int tag, byte[] data) {
        this.addComponent(new TaggedComponent(tag, data));
    }

    public void addComponent(TaggedComponent component) {
        TaggedComponent[] newComponents = new TaggedComponent[this.components.length + 1];
        System.arraycopy(this.components, 0, newComponents, 0, this.components.length);
        newComponents[this.components.length] = component;
        this.components = newComponents;
    }

    public void addAll(TaggedComponentList other) {
        TaggedComponent[] newComponents = new TaggedComponent[this.components.length + other.components.length];
        System.arraycopy(this.components, 0, newComponents, 0, this.components.length);
        System.arraycopy(other.components, 0, newComponents, this.components.length, other.components.length);
        this.components = newComponents;
    }

    public Object getComponent(int tag, Class helper) {
        for (int i2 = 0; i2 < this.components.length; ++i2) {
            if (this.components[i2].tag != tag) continue;
            return this.getComponentData(this.components[i2].component_data, helper);
        }
        return null;
    }

    public List getComponents(Configuration configuration, int tag, Class helper) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i2 = 0; i2 < this.components.length; ++i2) {
            if (this.components[i2].tag != tag) continue;
            Object element = this.getComponentData(this.components[i2].component_data, helper);
            if (element instanceof Configurable) {
                try {
                    ((Configurable)element).configure(configuration);
                }
                catch (ConfigurationException e2) {
                    throw new INTERNAL("ConfigurationException: " + e2.toString());
                }
            }
            result.add(element);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getComponentData(byte[] data, Class helper) {
        Object result;
        block10: {
            result = null;
            CDRInputStream in = new CDRInputStream(data);
            try {
                in.openEncapsulatedArray();
                if (helper == CodeSetComponentInfoHelper.class) {
                    result = new CodeSetComponentInfo();
                    ((CodeSetComponentInfo)result).ForCharData = CodeSetComponentHelper.read(in);
                    ((CodeSetComponentInfo)result).ForWcharData = CodeSetComponentHelper.read(in);
                    break block10;
                }
                if (helper == ParsedIOR.LongHelper.class) {
                    result = ObjectUtil.newInteger(in.read_long());
                    break block10;
                }
                if (helper == ParsedIOR.StringHelper.class) {
                    result = in.read_string();
                    break block10;
                }
                try {
                    Method readMethod = helper.getMethod("read", InputStream.class);
                    result = readMethod.invoke(null, in);
                }
                catch (NoSuchMethodException ex) {
                    throw new RuntimeException("Helper " + helper.getName() + " has no appropriate read() method.");
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("Cannot access read() method of helper " + helper.getName());
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException("Exception while reading component data: " + ex.getTargetException());
                }
            }
            finally {
                in.close();
            }
        }
        return result;
    }
}

